% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{wk_chunk_map_feature}
\alias{wk_chunk_map_feature}
\title{Operate on handleables by chunk}
\usage{
wk_chunk_map_feature(
  handleables,
  fun,
  vector_args = NULL,
  args = NULL,
  input_handler_factory = wk_writer,
  output_template = NULL,
  strategy = wk_chunk_strategy_feature(chunk_size = 10000)
)
}
\arguments{
\item{handleables}{A single handleable or a \code{list()} of handleables
recycleable along a common length.}

\item{fun}{A function called like
\code{fun(!!! transformed_handleables, !!! vector_args, !!! args)} for each chunk.
For \code{\link[=wk_chunk_map_feature]{wk_chunk_map_feature()}} this must be length-stable (i.e., return
a value whose size is the recycled length of handleables and vector_args
for that chunk).}

\item{vector_args}{Vectorized arguments to \code{fun}.}

\item{args}{Non-vectorized arguments to \code{fun}.}

\item{input_handler_factory}{A function of \code{handleable} applied to
handleable inputs. The default, \code{\link[=wk_writer]{wk_writer()}}, will result in \code{fun}
getting called with a clone of the handleables for each chunk. Another
useful pattern is to return a single type of handler so that all
\code{handleables} have a common type.}

\item{output_template}{A vector whose subset-assign method will
get called for every chunk or \code{NULL} to ignore the output of \code{fun}.}

\item{strategy}{A function of \code{handleables} and \code{n_features}
such as that returned by \code{\link[=wk_chunk_strategy_feature]{wk_chunk_strategy_feature()}}.}
}
\value{
\code{output_template} of the recycled common length of \code{handleables}
and \code{vector_args} filled with values generated by \code{fun}.
}
\description{
It is often impractical, inefficient, or impossible to perform
an operation on a vector of geometries with all the geometries loaded
into memory at the same time. These functions generalize the pattern of
split-apply-combine to one or more handlers recycled along a common
length. These functions are designed for developers rather than users
and should be considered experimental.
}
\examples{
# apply a transformation or calculate a value using the data frame version
# of the geometries (but without resolving all of them at once)
wk_chunk_map_feature(
  wk_linestring(xy(1:10, 1:10), rep(1:5, each = 2)),
  function(features) {
    coords <- wk_coords(features)
    vapply(split(coords, coords$feature_id), nrow, integer(1))
  },
  output_template = integer()
)

}
