// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Snmp.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.devsettings {
  public class Snmp_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("devsettings.Snmp:1.0.1", null);

    public Snmp_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Snmp_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Snmp_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Snmp_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public class Configuration : ICloneable {
      public object Clone() {
        Configuration copy = new Configuration();
        copy.v2enable = this.v2enable;
        copy.v3enable = this.v3enable;
        copy.readComm = this.readComm;
        copy.writeComm = this.writeComm;
        copy.sysContact = this.sysContact;
        copy.sysName = this.sysName;
        copy.sysLocation = this.sysLocation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["v2enable"] = this.v2enable;
        json["v3enable"] = this.v3enable;
        json["readComm"] = this.readComm;
        json["writeComm"] = this.writeComm;
        json["sysContact"] = this.sysContact;
        json["sysName"] = this.sysName;
        json["sysLocation"] = this.sysLocation;
        return json;
      }

      public static Configuration Decode(LightJson.JsonObject json, Agent agent) {
        Configuration inst = new Configuration();
        inst.v2enable = (bool)json["v2enable"];
        inst.v3enable = (bool)json["v3enable"];
        inst.readComm = (string)json["readComm"];
        inst.writeComm = (string)json["writeComm"];
        inst.sysContact = (string)json["sysContact"];
        inst.sysName = (string)json["sysName"];
        inst.sysLocation = (string)json["sysLocation"];
        return inst;
      }

      public bool v2enable = false;
      public bool v3enable = false;
      public string readComm = "";
      public string writeComm = "";
      public string sysContact = "";
      public string sysName = "";
      public string sysLocation = "";
    }

    public class GetConfigurationResult {
      public Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration _ret_;
    }

    public GetConfigurationResult getConfiguration() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConfiguration", _parameters);
      var _ret = new GetConfigurationResult();
      _ret._ret_ = Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConfiguration(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConfiguration", _parameters,
        _result => {
          try {
            var _ret = new GetConfigurationResult();
            _ret._ret_ = Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetConfigurationResult {
      public int _ret_;
    }

    public SetConfigurationResult setConfiguration(Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cfg"] = cfg.Encode();

      var _result = RpcCall("setConfiguration", _parameters);
      var _ret = new SetConfigurationResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setConfiguration(Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setConfiguration(cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setConfiguration(Com.Raritan.Idl.devsettings.Snmp_1_0_1.Configuration cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cfg"] = cfg.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setConfiguration", _parameters,
        _result => {
          try {
            var _ret = new SetConfigurationResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
