# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Firmware.idl.

use strict;

package Raritan::RPC::firmware::Firmware_2_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "firmware.Firmware:2.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::firmware::Firmware_2_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub reboot($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'reboot', $args);
}

sub factoryReset($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'factoryReset', $args);
}

sub hardFactoryReset($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'hardFactoryReset', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub manufacturingReset($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'manufacturingReset', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getVersion($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getVersion', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::firmware::UpdateHistoryEntry;

sub getUpdateHistory($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getUpdateHistory', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::firmware::UpdateHistoryEntry::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::firmware::ImageStatus;

sub getImageStatus($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getImageStatus', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::firmware::ImageStatus::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub discardImage($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'discardImage', $args);
}

use Raritan::RPC::firmware::ImageInfo_1_0_1;

sub getImageInfo($$) {
    my ($self, $info) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getImageInfo', $args);
    $$info = Raritan::RPC::firmware::ImageInfo_1_0_1::decode($agent, $rsp->{'info'});
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}


sub startUpdate($$) {
    my ($self, $flags) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'flags'} = [];
    for (my $i0 = 0; $i0 <= $#{$flags}; $i0++) {
        $args->{'flags'}->[$i0] = 1 * $flags->[$i0];
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'startUpdate', $args);
}

Raritan::RPC::Registry::registerProxyClass('firmware.Firmware', 2, 0, 2, 'Raritan::RPC::firmware::Firmware_2_0_2');
1;
