# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "PeripheralDeviceSlot.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# enumeration
class PortType(Enumeration):
    idlType = "peripheral.PortType:4.0.0"
    values = ["ONBOARD", "DEV_PORT", "ONEWIRE_HUB_PORT", "ONEWIRE_CHAIN_POS", "REMOTE_HUB_PORT", "WIRELESS_BRIDGE", "WIRELESS_DEVICE", "UNSPECIFIED", "GATEWAY_SENSOR"]

PortType.ONBOARD = PortType(0)
PortType.DEV_PORT = PortType(1)
PortType.ONEWIRE_HUB_PORT = PortType(2)
PortType.ONEWIRE_CHAIN_POS = PortType(3)
PortType.REMOTE_HUB_PORT = PortType(4)
PortType.WIRELESS_BRIDGE = PortType(5)
PortType.WIRELESS_DEVICE = PortType(6)
PortType.UNSPECIFIED = PortType(7)
PortType.GATEWAY_SENSOR = PortType(8)
PortType._fallback = PortType.UNSPECIFIED

# structure
class PosElement(Structure):
    idlType = "peripheral.PosElement:4.0.0"
    elements = ["portType", "port"]

    def __init__(self, portType=None, port=""):
        if portType is None:
            portType = raritan.rpc.peripheral.PortType.ONBOARD
        typecheck.is_enum(portType, raritan.rpc.peripheral.PortType, AssertionError)
        typecheck.is_string(port, AssertionError)

        self.portType = portType
        self.port = port

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            portType = raritan.rpc.peripheral.PortType.decode(json['portType']),
            port = json['port'],
        )
        return obj

    def encode(self):
        json = {}
        json['portType'] = raritan.rpc.peripheral.PortType.encode(self.portType)
        json['port'] = self.port
        return json

# structure
class DeviceID(Structure):
    idlType = "peripheral.DeviceID:6.0.0"
    elements = ["serial", "type", "isActuator", "channel"]

    def __init__(self, serial="", type=None, isActuator=False, channel=0):
        if type is None:
            type = raritan.rpc.sensors.Sensor.TypeSpec()
        typecheck.is_string(serial, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.serial = serial
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            serial = json['serial'],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['serial'] = self.serial
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# structure
class Address(Structure):
    idlType = "peripheral.Address:9.0.0"
    elements = ["position", "type", "isActuator", "channel"]

    def __init__(self, position=[], type=None, isActuator=False, channel=0):
        if type is None:
            type = raritan.rpc.sensors.Sensor.TypeSpec()
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.position = position
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# value object
class Device(ValueObject):
    idlType = "peripheral.Device:7.0.1"

    def __init__(self, deviceID=None, position=[], packageClass="", device=None):
        if deviceID is None:
            deviceID = raritan.rpc.peripheral.DeviceID()
        typecheck.is_struct(deviceID, raritan.rpc.peripheral.DeviceID, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_string(packageClass, AssertionError)
        typecheck.is_interface(device, raritan.rpc.sensors.Sensor, AssertionError)

        self.deviceID = deviceID
        self.position = position
        self.packageClass = packageClass
        self.device = device

    def encode(self):
        json = {}
        json['deviceID'] = raritan.rpc.peripheral.DeviceID.encode(self.deviceID)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['packageClass'] = self.packageClass
        json['device'] = Interface.encode(self.device)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            deviceID = raritan.rpc.peripheral.DeviceID.decode(json['deviceID'], agent),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            packageClass = json['packageClass'],
            device = Interface.decode(json['device'], agent),
        )
        return obj

    def listElements(self):
        elements = ["deviceID", "position", "packageClass", "device"]
        return elements

# interface
class DeviceSlot(Interface):
    idlType = "peripheral.DeviceSlot:5.0.1"

    ERR_INVALID_PARAMS = 1

    ERR_NOT_SUPPORTED = 2

    CHANNEL_INVALID = -1

    # structure
    class Location(Structure):
        idlType = "peripheral.DeviceSlot_5_0_1.Location:1.0.0"
        elements = ["x", "y", "z"]

        def __init__(self, x="", y="", z=""):
            typecheck.is_string(x, AssertionError)
            typecheck.is_string(y, AssertionError)
            typecheck.is_string(z, AssertionError)

            self.x = x
            self.y = y
            self.z = z

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                x = json['x'],
                y = json['y'],
                z = json['z'],
            )
            return obj

        def encode(self):
            json = {}
            json['x'] = self.x
            json['y'] = self.y
            json['z'] = self.z
            return json

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceSlot_5_0_1.Settings:1.0.0"
        elements = ["name", "description", "location", "useDefaultThresholds", "properties"]

        def __init__(self, name="", description="", location=None, useDefaultThresholds=False, properties={}):
            if location is None:
                location = raritan.rpc.peripheral.DeviceSlot.Location()
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(description, AssertionError)
            typecheck.is_struct(location, raritan.rpc.peripheral.DeviceSlot.Location, AssertionError)
            typecheck.is_bool(useDefaultThresholds, AssertionError)

            self.name = name
            self.description = description
            self.location = location
            self.useDefaultThresholds = useDefaultThresholds
            self.properties = properties

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                description = json['description'],
                location = raritan.rpc.peripheral.DeviceSlot.Location.decode(json['location'], agent),
                useDefaultThresholds = json['useDefaultThresholds'],
                properties = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['properties']]),
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['description'] = self.description
            json['location'] = raritan.rpc.peripheral.DeviceSlot.Location.encode(self.location)
            json['useDefaultThresholds'] = self.useDefaultThresholds
            json['properties'] = [dict(
                key = k,
                value = v)
                for k, v in self.properties.items()]
            return json

    # value object
    class DeviceChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceSlot_5_0_1.DeviceChangedEvent:1.0.0"

        def __init__(self, oldDevice=None, newDevice=None, source=None):
            super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).__init__(source)
            if oldDevice is None:
                oldDevice = raritan.rpc.peripheral.Device()
            if newDevice is None:
                newDevice = raritan.rpc.peripheral.Device()
            typecheck.is_valobj(oldDevice, raritan.rpc.peripheral.Device, AssertionError)
            typecheck.is_valobj(newDevice, raritan.rpc.peripheral.Device, AssertionError)

            self.oldDevice = oldDevice
            self.newDevice = newDevice

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).encode()
            json['oldDevice'] = ValueObject.encode(self.oldDevice)
            json['newDevice'] = ValueObject.encode(self.newDevice)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldDevice = ValueObject.decode(json['oldDevice'], agent),
                newDevice = ValueObject.decode(json['newDevice'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldDevice", "newDevice"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceSlot_5_0_1.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.peripheral.DeviceSlot.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.peripheral.DeviceSlot.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).listElements()
            return elements

    class _getDevice(Interface.Method):
        name = 'getDevice'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = ValueObject.decode(rsp['_ret_'], agent)
            typecheck.is_valobj(_ret_, raritan.rpc.peripheral.Device, DecodeException)
            return _ret_

    class _assign(Interface.Method):
        name = 'assign'

        @staticmethod
        def encode(devid):
            typecheck.is_struct(devid, raritan.rpc.peripheral.DeviceID, AssertionError)
            args = {}
            args['devid'] = raritan.rpc.peripheral.DeviceID.encode(devid)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _assignAddress(Interface.Method):
        name = 'assignAddress'

        @staticmethod
        def encode(packageClass, address):
            typecheck.is_string(packageClass, AssertionError)
            typecheck.is_struct(address, raritan.rpc.peripheral.Address, AssertionError)
            args = {}
            args['packageClass'] = packageClass
            args['address'] = raritan.rpc.peripheral.Address.encode(address)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _unassign(Interface.Method):
        name = 'unassign'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceSlot.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceSlot.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DeviceSlot, self).__init__(target, agent)
        self.getDevice = DeviceSlot._getDevice(self)
        self.assign = DeviceSlot._assign(self)
        self.assignAddress = DeviceSlot._assignAddress(self)
        self.unassign = DeviceSlot._unassign(self)
        self.getSettings = DeviceSlot._getSettings(self)
        self.setSettings = DeviceSlot._setSettings(self)

#
# Section generated by IdlC from "ModbusCfg.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.peripheral


# interface
class ModbusCfg(Interface):
    idlType = "peripheral.ModbusCfg:1.0.0"

    # structure
    class SerialSettings(Structure):
        idlType = "peripheral.ModbusCfg.SerialSettings:1.0.0"
        elements = ["baud", "parity", "dataBits", "stopBits"]

        def __init__(self, baud=0, parity=None, dataBits=0, stopBits=0):
            if parity is None:
                parity = raritan.rpc.peripheral.ModbusCfg.SerialSettings.Parity.NONE
            typecheck.is_int(baud, AssertionError)
            typecheck.is_enum(parity, raritan.rpc.peripheral.ModbusCfg.SerialSettings.Parity, AssertionError)
            typecheck.is_int(dataBits, AssertionError)
            typecheck.is_int(stopBits, AssertionError)

            self.baud = baud
            self.parity = parity
            self.dataBits = dataBits
            self.stopBits = stopBits

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                baud = json['baud'],
                parity = raritan.rpc.peripheral.ModbusCfg.SerialSettings.Parity.decode(json['parity']),
                dataBits = json['dataBits'],
                stopBits = json['stopBits'],
            )
            return obj

        def encode(self):
            json = {}
            json['baud'] = self.baud
            json['parity'] = raritan.rpc.peripheral.ModbusCfg.SerialSettings.Parity.encode(self.parity)
            json['dataBits'] = self.dataBits
            json['stopBits'] = self.stopBits
            return json

        # enumeration
        class Parity(Enumeration):
            idlType = "peripheral.ModbusCfg.SerialSettings.Parity:1.0.0"
            values = ["NONE", "EVEN", "ODD"]

        Parity.NONE = Parity(0)
        Parity.EVEN = Parity(1)
        Parity.ODD = Parity(2)

    # enumeration
    class ModbusFunction(Enumeration):
        idlType = "peripheral.ModbusCfg.ModbusFunction:1.0.0"
        values = ["COIL", "DISCRETE_INPUT", "HOLDING_REGISTER", "INPUT_REGISTER"]

    ModbusFunction.COIL = ModbusFunction(0)
    ModbusFunction.DISCRETE_INPUT = ModbusFunction(1)
    ModbusFunction.HOLDING_REGISTER = ModbusFunction(2)
    ModbusFunction.INPUT_REGISTER = ModbusFunction(3)

    EXCEPTION_ILLEGAL_FUNCTION = 1

    EXCEPTION_ILLEGAL_DATA_ADDRESS = 2

    EXCEPTION_ILLEGAL_DATA_VALUE = 3

    EXCEPTION_SLAVE_OR_SERVER_FAILURE = 4

    EXCEPTION_ACKNOWLEDGE = 5

    EXCEPTION_SLAVE_OR_SERVER_BUSY = 6

    EXCEPTION_NEGATIVE_ACKNOWLEDGE = 7

    EXCEPTION_MEMORY_PARITY = 8

    EXCEPTION_GATEWAY_PATH = 10

    EXCEPTION_GATEWAY_TARGET = 11

    # enumeration
    class SpecificModbusErrors(Enumeration):
        idlType = "peripheral.ModbusCfg.SpecificModbusErrors:1.0.0"
        values = ["ERROR_BADCRC", "ERROR_BADDATA", "ERROR_BADEXC", "ERROR_UNKEXC", "ERROR_MDATA", "ERROR_OTHER"]

    SpecificModbusErrors.ERROR_BADCRC = SpecificModbusErrors(0)
    SpecificModbusErrors.ERROR_BADDATA = SpecificModbusErrors(1)
    SpecificModbusErrors.ERROR_BADEXC = SpecificModbusErrors(2)
    SpecificModbusErrors.ERROR_UNKEXC = SpecificModbusErrors(3)
    SpecificModbusErrors.ERROR_MDATA = SpecificModbusErrors(4)
    SpecificModbusErrors.ERROR_OTHER = SpecificModbusErrors(5)

#
# Section generated by IdlC from "GatewaySensorManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# interface
class GatewaySensorManager(Interface):
    idlType = "peripheral.GatewaySensorManager:2.0.0"

    # value object
    class SensorClass(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SensorClass:1.0.0"

        def __init__(self, classId=""):
            typecheck.is_string(classId, AssertionError)

            self.classId = classId

        def encode(self):
            json = {}
            json['classId'] = self.classId
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                classId = json['classId'],
            )
            return obj

        def listElements(self):
            elements = ["classId"]
            return elements

    # value object
    class NumericSensorClass(SensorClass):
        idlType = "peripheral.GatewaySensorManager_2_0_0.NumericSensorClass:1.0.0"

        def __init__(self, metadata=None, defaultThresholds=None, preferCommonThresholds=False, classId=""):
            super(raritan.rpc.peripheral.GatewaySensorManager.NumericSensorClass, self).__init__(classId)
            if metadata is None:
                metadata = raritan.rpc.sensors.NumericSensor.MetaData()
            if defaultThresholds is None:
                defaultThresholds = raritan.rpc.sensors.NumericSensor.Thresholds()
            typecheck.is_struct(metadata, raritan.rpc.sensors.NumericSensor.MetaData, AssertionError)
            typecheck.is_struct(defaultThresholds, raritan.rpc.sensors.NumericSensor.Thresholds, AssertionError)
            typecheck.is_bool(preferCommonThresholds, AssertionError)

            self.metadata = metadata
            self.defaultThresholds = defaultThresholds
            self.preferCommonThresholds = preferCommonThresholds

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.NumericSensorClass, self).encode()
            json['metadata'] = raritan.rpc.sensors.NumericSensor.MetaData.encode(self.metadata)
            json['defaultThresholds'] = raritan.rpc.sensors.NumericSensor.Thresholds.encode(self.defaultThresholds)
            json['preferCommonThresholds'] = self.preferCommonThresholds
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                metadata = raritan.rpc.sensors.NumericSensor.MetaData.decode(json['metadata'], agent),
                defaultThresholds = raritan.rpc.sensors.NumericSensor.Thresholds.decode(json['defaultThresholds'], agent),
                preferCommonThresholds = json['preferCommonThresholds'],
                # for peripheral.GatewaySensorManager_2_0_0.SensorClass
                classId = json['classId'],
            )
            return obj

        def listElements(self):
            elements = ["metadata", "defaultThresholds", "preferCommonThresholds"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.NumericSensorClass, self).listElements()
            return elements

    # value object
    class StateSensorClass(SensorClass):
        idlType = "peripheral.GatewaySensorManager_2_0_0.StateSensorClass:1.0.0"

        def __init__(self, type=None, classId=""):
            super(raritan.rpc.peripheral.GatewaySensorManager.StateSensorClass, self).__init__(classId)
            if type is None:
                type = raritan.rpc.sensors.Sensor.TypeSpec()
            typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)

            self.type = type

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.StateSensorClass, self).encode()
            json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                # for peripheral.GatewaySensorManager_2_0_0.SensorClass
                classId = json['classId'],
            )
            return obj

        def listElements(self):
            elements = ["type"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.StateSensorClass, self).listElements()
            return elements

    # value object
    class SwitchSensorClass(StateSensorClass):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SwitchSensorClass:1.0.0"

        def __init__(self, type=None, classId=""):
            super(raritan.rpc.peripheral.GatewaySensorManager.SwitchSensorClass, self).__init__(type, classId)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.SwitchSensorClass, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.StateSensorClass
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                # for peripheral.GatewaySensorManager_2_0_0.SensorClass
                classId = json['classId'],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.SwitchSensorClass, self).listElements()
            return elements

    # value object
    class RemoteDevice(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteDevice:1.0.0"

        def __init__(self, deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            typecheck.is_string(deviceId, AssertionError)
            typecheck.is_bool(disabled, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_int(timeoutMs, AssertionError)
            typecheck.is_int(retry, AssertionError)

            self.deviceId = deviceId
            self.disabled = disabled
            self.name = name
            self.timeoutMs = timeoutMs
            self.retry = retry

        def encode(self):
            json = {}
            json['deviceId'] = self.deviceId
            json['disabled'] = self.disabled
            json['name'] = self.name
            json['timeoutMs'] = self.timeoutMs
            json['retry'] = self.retry
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["deviceId", "disabled", "name", "timeoutMs", "retry"]
            return elements

    MODBUS_VENDOR_NAME = 0

    MODBUS_PRODUCT_CODE = 1

    MODBUS_REVISION = 2

    MODBUS_VENDOR_URL = 3

    MODBUS_PRODUCT_NAME = 5

    MODBUS_MODEL_NAME = 6

    MODBUS_APP_NAME = 7

    # value object
    class RemoteModbusDevice(RemoteDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteModbusDevice:1.0.0"

        def __init__(self, detectionIdentifiers={}, unitId=0, deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusDevice, self).__init__(deviceId, disabled, name, timeoutMs, retry)
            typecheck.is_int(unitId, AssertionError)

            self.detectionIdentifiers = detectionIdentifiers
            self.unitId = unitId

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusDevice, self).encode()
            json['detectionIdentifiers'] = [dict(
                key = k,
                value = v)
                for k, v in self.detectionIdentifiers.items()]
            json['unitId'] = self.unitId
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                detectionIdentifiers = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['detectionIdentifiers']]),
                unitId = json['unitId'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["detectionIdentifiers", "unitId"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusDevice, self).listElements()
            return elements

    # value object
    class RemoteModbusRTUDevice(RemoteModbusDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteModbusRTUDevice:1.0.0"

        def __init__(self, busInterface="", busSettings=None, interframeDelayDeciChars=0, detectionIdentifiers={}, unitId=0, deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusRTUDevice, self).__init__(detectionIdentifiers, unitId, deviceId, disabled, name, timeoutMs, retry)
            if busSettings is None:
                busSettings = raritan.rpc.peripheral.ModbusCfg.SerialSettings()
            typecheck.is_string(busInterface, AssertionError)
            typecheck.is_struct(busSettings, raritan.rpc.peripheral.ModbusCfg.SerialSettings, AssertionError)
            typecheck.is_int(interframeDelayDeciChars, AssertionError)

            self.busInterface = busInterface
            self.busSettings = busSettings
            self.interframeDelayDeciChars = interframeDelayDeciChars

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusRTUDevice, self).encode()
            json['busInterface'] = self.busInterface
            json['busSettings'] = raritan.rpc.peripheral.ModbusCfg.SerialSettings.encode(self.busSettings)
            json['interframeDelayDeciChars'] = self.interframeDelayDeciChars
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                busInterface = json['busInterface'],
                busSettings = raritan.rpc.peripheral.ModbusCfg.SerialSettings.decode(json['busSettings'], agent),
                interframeDelayDeciChars = json['interframeDelayDeciChars'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteModbusDevice
                detectionIdentifiers = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['detectionIdentifiers']]),
                unitId = json['unitId'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["busInterface", "busSettings", "interframeDelayDeciChars"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusRTUDevice, self).listElements()
            return elements

    # value object
    class RemoteModbusTCPDevice(RemoteModbusDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteModbusTCPDevice:1.0.0"

        def __init__(self, ipAddress="", tcpPort=0, detectionIdentifiers={}, unitId=0, deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusTCPDevice, self).__init__(detectionIdentifiers, unitId, deviceId, disabled, name, timeoutMs, retry)
            typecheck.is_string(ipAddress, AssertionError)
            typecheck.is_int(tcpPort, AssertionError)

            self.ipAddress = ipAddress
            self.tcpPort = tcpPort

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusTCPDevice, self).encode()
            json['ipAddress'] = self.ipAddress
            json['tcpPort'] = self.tcpPort
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ipAddress = json['ipAddress'],
                tcpPort = json['tcpPort'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteModbusDevice
                detectionIdentifiers = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['detectionIdentifiers']]),
                unitId = json['unitId'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["ipAddress", "tcpPort"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteModbusTCPDevice, self).listElements()
            return elements

    # value object
    class RemoteSnmpDevice(RemoteDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteSnmpDevice:1.0.0"

        def __init__(self, host="", deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpDevice, self).__init__(deviceId, disabled, name, timeoutMs, retry)
            typecheck.is_string(host, AssertionError)

            self.host = host

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpDevice, self).encode()
            json['host'] = self.host
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                host = json['host'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["host"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpDevice, self).listElements()
            return elements

    # value object
    class RemoteSnmpV1V2Device(RemoteSnmpDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteSnmpV1V2Device:1.0.0"

        def __init__(self, community="", host="", deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV1V2Device, self).__init__(host, deviceId, disabled, name, timeoutMs, retry)
            typecheck.is_string(community, AssertionError)

            self.community = community

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV1V2Device, self).encode()
            json['community'] = self.community
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                community = json['community'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteSnmpDevice
                host = json['host'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["community"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV1V2Device, self).listElements()
            return elements

    # enumeration
    class SnmpSecurityLevel(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SnmpSecurityLevel:1.0.0"
        values = ["NO_AUTH_NO_PRIV", "AUTH_NO_PRIV", "AUTH_PRIV"]

    SnmpSecurityLevel.NO_AUTH_NO_PRIV = SnmpSecurityLevel(0)
    SnmpSecurityLevel.AUTH_NO_PRIV = SnmpSecurityLevel(1)
    SnmpSecurityLevel.AUTH_PRIV = SnmpSecurityLevel(2)

    # enumeration
    class SnmpAuthProtocol(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SnmpAuthProtocol:1.0.0"
        values = ["MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"]

    SnmpAuthProtocol.MD5 = SnmpAuthProtocol(0)
    SnmpAuthProtocol.SHA1 = SnmpAuthProtocol(1)
    SnmpAuthProtocol.SHA224 = SnmpAuthProtocol(2)
    SnmpAuthProtocol.SHA256 = SnmpAuthProtocol(3)
    SnmpAuthProtocol.SHA384 = SnmpAuthProtocol(4)
    SnmpAuthProtocol.SHA512 = SnmpAuthProtocol(5)

    # enumeration
    class SnmpPrivProtocol(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SnmpPrivProtocol:1.0.0"
        values = ["DES", "AES128", "AES192", "AES256", "AES192_3DES", "AES256_3DES"]

    SnmpPrivProtocol.DES = SnmpPrivProtocol(0)
    SnmpPrivProtocol.AES128 = SnmpPrivProtocol(1)
    SnmpPrivProtocol.AES192 = SnmpPrivProtocol(2)
    SnmpPrivProtocol.AES256 = SnmpPrivProtocol(3)
    SnmpPrivProtocol.AES192_3DES = SnmpPrivProtocol(4)
    SnmpPrivProtocol.AES256_3DES = SnmpPrivProtocol(5)

    # value object
    class RemoteSnmpV3Device(RemoteSnmpDevice):
        idlType = "peripheral.GatewaySensorManager_2_0_0.RemoteSnmpV3Device:1.0.0"

        def __init__(self, user="", level=None, authProtocol=None, authPassphrase="", privacyProtocol=None, privacyPassphrase="", host="", deviceId="", disabled=False, name="", timeoutMs=0, retry=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV3Device, self).__init__(host, deviceId, disabled, name, timeoutMs, retry)
            if level is None:
                level = raritan.rpc.peripheral.GatewaySensorManager.SnmpSecurityLevel.NO_AUTH_NO_PRIV
            if authProtocol is None:
                authProtocol = raritan.rpc.peripheral.GatewaySensorManager.SnmpAuthProtocol.MD5
            if privacyProtocol is None:
                privacyProtocol = raritan.rpc.peripheral.GatewaySensorManager.SnmpPrivProtocol.DES
            typecheck.is_string(user, AssertionError)
            typecheck.is_enum(level, raritan.rpc.peripheral.GatewaySensorManager.SnmpSecurityLevel, AssertionError)
            typecheck.is_enum(authProtocol, raritan.rpc.peripheral.GatewaySensorManager.SnmpAuthProtocol, AssertionError)
            typecheck.is_string(authPassphrase, AssertionError)
            typecheck.is_enum(privacyProtocol, raritan.rpc.peripheral.GatewaySensorManager.SnmpPrivProtocol, AssertionError)
            typecheck.is_string(privacyPassphrase, AssertionError)

            self.user = user
            self.level = level
            self.authProtocol = authProtocol
            self.authPassphrase = authPassphrase
            self.privacyProtocol = privacyProtocol
            self.privacyPassphrase = privacyPassphrase

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV3Device, self).encode()
            json['user'] = self.user
            json['level'] = raritan.rpc.peripheral.GatewaySensorManager.SnmpSecurityLevel.encode(self.level)
            json['authProtocol'] = raritan.rpc.peripheral.GatewaySensorManager.SnmpAuthProtocol.encode(self.authProtocol)
            json['authPassphrase'] = self.authPassphrase
            json['privacyProtocol'] = raritan.rpc.peripheral.GatewaySensorManager.SnmpPrivProtocol.encode(self.privacyProtocol)
            json['privacyPassphrase'] = self.privacyPassphrase
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                user = json['user'],
                level = raritan.rpc.peripheral.GatewaySensorManager.SnmpSecurityLevel.decode(json['level']),
                authProtocol = raritan.rpc.peripheral.GatewaySensorManager.SnmpAuthProtocol.decode(json['authProtocol']),
                authPassphrase = json['authPassphrase'],
                privacyProtocol = raritan.rpc.peripheral.GatewaySensorManager.SnmpPrivProtocol.decode(json['privacyProtocol']),
                privacyPassphrase = json['privacyPassphrase'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteSnmpDevice
                host = json['host'],
                # for peripheral.GatewaySensorManager_2_0_0.RemoteDevice
                deviceId = json['deviceId'],
                disabled = json['disabled'],
                name = json['name'],
                timeoutMs = json['timeoutMs'],
                retry = json['retry'],
            )
            return obj

        def listElements(self):
            elements = ["user", "level", "authProtocol", "authPassphrase", "privacyProtocol", "privacyPassphrase"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.RemoteSnmpV3Device, self).listElements()
            return elements

    # enumeration
    class EncodingType(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.EncodingType:1.0.0"
        values = ["BOOL", "INT", "UINT", "IEEE754"]

    EncodingType.BOOL = EncodingType(0)
    EncodingType.INT = EncodingType(1)
    EncodingType.UINT = EncodingType(2)
    EncodingType.IEEE754 = EncodingType(3)

    # enumeration
    class Interpretation(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.Interpretation:1.0.0"
        values = ["DEFAULT", "REJECT_DEVICE", "REJECT_SENSOR", "IGNORE", "UNAVAILABLE", "NUMERIC_INVALID", "STATE_ON", "STATE_OFF"]

    Interpretation.DEFAULT = Interpretation(0)
    Interpretation.REJECT_DEVICE = Interpretation(1)
    Interpretation.REJECT_SENSOR = Interpretation(2)
    Interpretation.IGNORE = Interpretation(3)
    Interpretation.UNAVAILABLE = Interpretation(4)
    Interpretation.NUMERIC_INVALID = Interpretation(5)
    Interpretation.STATE_ON = Interpretation(6)
    Interpretation.STATE_OFF = Interpretation(7)

    # value object
    class InterpretationRule(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRule:1.0.0"

        def __init__(self, interpretation=None, ignoreTimeout=0):
            if interpretation is None:
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.DEFAULT
            typecheck.is_enum(interpretation, raritan.rpc.peripheral.GatewaySensorManager.Interpretation, AssertionError)
            typecheck.is_int(ignoreTimeout, AssertionError)

            self.interpretation = interpretation
            self.ignoreTimeout = ignoreTimeout

        def encode(self):
            json = {}
            json['interpretation'] = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.encode(self.interpretation)
            json['ignoreTimeout'] = self.ignoreTimeout
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["interpretation", "ignoreTimeout"]
            return elements

    # value object
    class InterpretationRuleInvertable(InterpretationRule):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable:1.0.0"

        def __init__(self, invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleInvertable, self).__init__(interpretation, ignoreTimeout)
            typecheck.is_bool(invertCondition, AssertionError)

            self.invertCondition = invertCondition

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleInvertable, self).encode()
            json['invertCondition'] = self.invertCondition
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["invertCondition"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleInvertable, self).listElements()
            return elements

    # value object
    class InterpretationRuleModbusException(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleModbusException:1.0.0"

        def __init__(self, exceptions=[], invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusException, self).__init__(invertCondition, interpretation, ignoreTimeout)
            for x0 in exceptions:
                typecheck.is_int(x0, AssertionError)

            self.exceptions = exceptions

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusException, self).encode()
            json['exceptions'] = [x0 for x0 in self.exceptions]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                exceptions = [x0 for x0 in json['exceptions']],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["exceptions"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusException, self).listElements()
            return elements

    # value object
    class InterpretationRuleModbusSystemError(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleModbusSystemError:1.0.0"

        def __init__(self, errnos=[], invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSystemError, self).__init__(invertCondition, interpretation, ignoreTimeout)
            for x0 in errnos:
                typecheck.is_int(x0, AssertionError)

            self.errnos = errnos

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSystemError, self).encode()
            json['errnos'] = [x0 for x0 in self.errnos]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                errnos = [x0 for x0 in json['errnos']],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["errnos"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSystemError, self).listElements()
            return elements

    # value object
    class InterpretationRuleModbusSpecificError(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleModbusSpecificError:1.0.0"

        def __init__(self, errors=[], invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSpecificError, self).__init__(invertCondition, interpretation, ignoreTimeout)
            for x0 in errors:
                typecheck.is_enum(x0, raritan.rpc.peripheral.ModbusCfg.SpecificModbusErrors, AssertionError)

            self.errors = errors

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSpecificError, self).encode()
            json['errors'] = [raritan.rpc.peripheral.ModbusCfg.SpecificModbusErrors.encode(x0) for x0 in self.errors]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                errors = [raritan.rpc.peripheral.ModbusCfg.SpecificModbusErrors.decode(x0) for x0 in json['errors']],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["errors"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleModbusSpecificError, self).listElements()
            return elements

    # value object
    class InterpretationRuleRAW(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleRAW:1.0.0"

        def __init__(self, value=0, mask=0, invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRAW, self).__init__(invertCondition, interpretation, ignoreTimeout)
            typecheck.is_long(value, AssertionError)
            typecheck.is_long(mask, AssertionError)

            self.value = value
            self.mask = mask

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRAW, self).encode()
            json['value'] = self.value
            json['mask'] = self.mask
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                value = int(json['value']),
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["value", "mask"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRAW, self).listElements()
            return elements

    # value object
    class InterpretationRuleRangeRAW(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleRangeRAW:1.0.0"

        def __init__(self, min=0, max=0, mask=0, invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRangeRAW, self).__init__(invertCondition, interpretation, ignoreTimeout)
            typecheck.is_long(min, AssertionError)
            typecheck.is_long(max, AssertionError)
            typecheck.is_long(mask, AssertionError)

            self.min = min
            self.max = max
            self.mask = mask

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRangeRAW, self).encode()
            json['min'] = self.min
            json['max'] = self.max
            json['mask'] = self.mask
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                min = int(json['min']),
                max = int(json['max']),
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["min", "max", "mask"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleRangeRAW, self).listElements()
            return elements

    # value object
    class InterpretationRuleEnum(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleEnum:1.0.0"

        def __init__(self, enumValues=[], invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleEnum, self).__init__(invertCondition, interpretation, ignoreTimeout)
            for x0 in enumValues:
                typecheck.is_long(x0, AssertionError)

            self.enumValues = enumValues

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleEnum, self).encode()
            json['enumValues'] = [x0 for x0 in self.enumValues]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enumValues = [int(x0) for x0 in json['enumValues']],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = ["enumValues"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleEnum, self).listElements()
            return elements

    # value object
    class InterpretationRuleIEEE754INF(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleIEEE754INF:1.0.0"

        def __init__(self, invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754INF, self).__init__(invertCondition, interpretation, ignoreTimeout)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754INF, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754INF, self).listElements()
            return elements

    # value object
    class InterpretationRuleIEEE754NAN(InterpretationRuleInvertable):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleIEEE754NAN:1.0.0"

        def __init__(self, invertCondition=False, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754NAN, self).__init__(invertCondition, interpretation, ignoreTimeout)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754NAN, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRuleInvertable
                invertCondition = json['invertCondition'],
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleIEEE754NAN, self).listElements()
            return elements

    # value object
    class InterpretationRuleCatchAll(InterpretationRule):
        idlType = "peripheral.GatewaySensorManager_2_0_0.InterpretationRuleCatchAll:1.0.0"

        def __init__(self, interpretation=None, ignoreTimeout=0):
            super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleCatchAll, self).__init__(interpretation, ignoreTimeout)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleCatchAll, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.InterpretationRule
                interpretation = raritan.rpc.peripheral.GatewaySensorManager.Interpretation.decode(json['interpretation']),
                ignoreTimeout = json['ignoreTimeout'],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.InterpretationRuleCatchAll, self).listElements()
            return elements

    # value object
    class ValueEncoding(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ValueEncoding:1.0.0"

        def __init__(self, encodingId="", type=None, invertState=False, interpretationRules=[]):
            if type is None:
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.BOOL
            typecheck.is_string(encodingId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.peripheral.GatewaySensorManager.EncodingType, AssertionError)
            typecheck.is_bool(invertState, AssertionError)
            for x0 in interpretationRules:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.InterpretationRule, AssertionError)

            self.encodingId = encodingId
            self.type = type
            self.invertState = invertState
            self.interpretationRules = interpretationRules

        def encode(self):
            json = {}
            json['encodingId'] = self.encodingId
            json['type'] = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.encode(self.type)
            json['invertState'] = self.invertState
            json['interpretationRules'] = [ValueObject.encode(x0) for x0 in self.interpretationRules]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = ["encodingId", "type", "invertState", "interpretationRules"]
            return elements

    # value object
    class NumericValueEncoding(ValueEncoding):
        idlType = "peripheral.GatewaySensorManager_2_0_0.NumericValueEncoding:1.0.0"

        def __init__(self, scalingFactor=0.0, offset=0.0, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.NumericValueEncoding, self).__init__(encodingId, type, invertState, interpretationRules)
            typecheck.is_float(scalingFactor, AssertionError)
            typecheck.is_float(offset, AssertionError)

            self.scalingFactor = scalingFactor
            self.offset = offset

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.NumericValueEncoding, self).encode()
            json['scalingFactor'] = self.scalingFactor
            json['offset'] = self.offset
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                scalingFactor = json['scalingFactor'],
                offset = json['offset'],
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = ["scalingFactor", "offset"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.NumericValueEncoding, self).listElements()
            return elements

    # value object
    class ModbusValueEncodingBit(ValueEncoding):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusValueEncodingBit:1.0.0"

        def __init__(self, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncodingBit, self).__init__(encodingId, type, invertState, interpretationRules)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncodingBit, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncodingBit, self).listElements()
            return elements

    # value object
    class ModbusValueEncoding8(NumericValueEncoding):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding8:1.0.0"

        def __init__(self, byteSwap=False, mask=0, scalingFactor=0.0, offset=0.0, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding8, self).__init__(scalingFactor, offset, encodingId, type, invertState, interpretationRules)
            typecheck.is_bool(byteSwap, AssertionError)
            typecheck.is_long(mask, AssertionError)

            self.byteSwap = byteSwap
            self.mask = mask

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding8, self).encode()
            json['byteSwap'] = self.byteSwap
            json['mask'] = self.mask
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                byteSwap = json['byteSwap'],
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.NumericValueEncoding
                scalingFactor = json['scalingFactor'],
                offset = json['offset'],
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = ["byteSwap", "mask"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding8, self).listElements()
            return elements

    # value object
    class ModbusValueEncoding16(ModbusValueEncoding8):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding16:1.0.0"

        def __init__(self, byteSwap=False, mask=0, scalingFactor=0.0, offset=0.0, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding16, self).__init__(byteSwap, mask, scalingFactor, offset, encodingId, type, invertState, interpretationRules)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding16, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding8
                byteSwap = json['byteSwap'],
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.NumericValueEncoding
                scalingFactor = json['scalingFactor'],
                offset = json['offset'],
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding16, self).listElements()
            return elements

    # enumeration
    class ModbusEndianness(Enumeration):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusEndianness:1.0.0"
        values = ["MODBUS_BIG_ENDIAN", "MODBUS_LITTLE_ENDIAN"]

    ModbusEndianness.MODBUS_BIG_ENDIAN = ModbusEndianness(0)
    ModbusEndianness.MODBUS_LITTLE_ENDIAN = ModbusEndianness(1)

    # value object
    class ModbusValueEncoding32(ModbusValueEncoding16):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding32:1.0.0"

        def __init__(self, endianness=None, byteSwap=False, mask=0, scalingFactor=0.0, offset=0.0, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding32, self).__init__(byteSwap, mask, scalingFactor, offset, encodingId, type, invertState, interpretationRules)
            if endianness is None:
                endianness = raritan.rpc.peripheral.GatewaySensorManager.ModbusEndianness.MODBUS_BIG_ENDIAN
            typecheck.is_enum(endianness, raritan.rpc.peripheral.GatewaySensorManager.ModbusEndianness, AssertionError)

            self.endianness = endianness

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding32, self).encode()
            json['endianness'] = raritan.rpc.peripheral.GatewaySensorManager.ModbusEndianness.encode(self.endianness)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                endianness = raritan.rpc.peripheral.GatewaySensorManager.ModbusEndianness.decode(json['endianness']),
                # for peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding8
                byteSwap = json['byteSwap'],
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.NumericValueEncoding
                scalingFactor = json['scalingFactor'],
                offset = json['offset'],
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = ["endianness"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding32, self).listElements()
            return elements

    # value object
    class ModbusValueEncoding64(ModbusValueEncoding32):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding64:1.0.0"

        def __init__(self, endianness=None, byteSwap=False, mask=0, scalingFactor=0.0, offset=0.0, encodingId="", type=None, invertState=False, interpretationRules=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding64, self).__init__(endianness, byteSwap, mask, scalingFactor, offset, encodingId, type, invertState, interpretationRules)

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding64, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding32
                endianness = raritan.rpc.peripheral.GatewaySensorManager.ModbusEndianness.decode(json['endianness']),
                # for peripheral.GatewaySensorManager_2_0_0.ModbusValueEncoding8
                byteSwap = json['byteSwap'],
                mask = int(json['mask']),
                # for peripheral.GatewaySensorManager_2_0_0.NumericValueEncoding
                scalingFactor = json['scalingFactor'],
                offset = json['offset'],
                # for peripheral.GatewaySensorManager_2_0_0.ValueEncoding
                encodingId = json['encodingId'],
                type = raritan.rpc.peripheral.GatewaySensorManager.EncodingType.decode(json['type']),
                invertState = json['invertState'],
                interpretationRules = [ValueObject.decode(x0, agent) for x0 in json['interpretationRules']],
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusValueEncoding64, self).listElements()
            return elements

    # value object
    class Sensor(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.Sensor:1.0.0"

        def __init__(self, sensorId="", disabled=False, deviceId="", classId="", encodingId="", defaultName=""):
            typecheck.is_string(sensorId, AssertionError)
            typecheck.is_bool(disabled, AssertionError)
            typecheck.is_string(deviceId, AssertionError)
            typecheck.is_string(classId, AssertionError)
            typecheck.is_string(encodingId, AssertionError)
            typecheck.is_string(defaultName, AssertionError)

            self.sensorId = sensorId
            self.disabled = disabled
            self.deviceId = deviceId
            self.classId = classId
            self.encodingId = encodingId
            self.defaultName = defaultName

        def encode(self):
            json = {}
            json['sensorId'] = self.sensorId
            json['disabled'] = self.disabled
            json['deviceId'] = self.deviceId
            json['classId'] = self.classId
            json['encodingId'] = self.encodingId
            json['defaultName'] = self.defaultName
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sensorId = json['sensorId'],
                disabled = json['disabled'],
                deviceId = json['deviceId'],
                classId = json['classId'],
                encodingId = json['encodingId'],
                defaultName = json['defaultName'],
            )
            return obj

        def listElements(self):
            elements = ["sensorId", "disabled", "deviceId", "classId", "encodingId", "defaultName"]
            return elements

    # value object
    class ModbusSensor(Sensor):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ModbusSensor:1.0.0"

        def __init__(self, function=None, regAddr=0, sensorId="", disabled=False, deviceId="", classId="", encodingId="", defaultName=""):
            super(raritan.rpc.peripheral.GatewaySensorManager.ModbusSensor, self).__init__(sensorId, disabled, deviceId, classId, encodingId, defaultName)
            if function is None:
                function = raritan.rpc.peripheral.ModbusCfg.ModbusFunction.COIL
            typecheck.is_enum(function, raritan.rpc.peripheral.ModbusCfg.ModbusFunction, AssertionError)
            typecheck.is_int(regAddr, AssertionError)

            self.function = function
            self.regAddr = regAddr

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ModbusSensor, self).encode()
            json['function'] = raritan.rpc.peripheral.ModbusCfg.ModbusFunction.encode(self.function)
            json['regAddr'] = self.regAddr
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                function = raritan.rpc.peripheral.ModbusCfg.ModbusFunction.decode(json['function']),
                regAddr = json['regAddr'],
                # for peripheral.GatewaySensorManager_2_0_0.Sensor
                sensorId = json['sensorId'],
                disabled = json['disabled'],
                deviceId = json['deviceId'],
                classId = json['classId'],
                encodingId = json['encodingId'],
                defaultName = json['defaultName'],
            )
            return obj

        def listElements(self):
            elements = ["function", "regAddr"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ModbusSensor, self).listElements()
            return elements

    # value object
    class SnmpSensor(Sensor):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SnmpSensor:1.0.0"

        def __init__(self, oid="", sensorId="", disabled=False, deviceId="", classId="", encodingId="", defaultName=""):
            super(raritan.rpc.peripheral.GatewaySensorManager.SnmpSensor, self).__init__(sensorId, disabled, deviceId, classId, encodingId, defaultName)
            typecheck.is_string(oid, AssertionError)

            self.oid = oid

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.SnmpSensor, self).encode()
            json['oid'] = self.oid
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oid = json['oid'],
                # for peripheral.GatewaySensorManager_2_0_0.Sensor
                sensorId = json['sensorId'],
                disabled = json['disabled'],
                deviceId = json['deviceId'],
                classId = json['classId'],
                encodingId = json['encodingId'],
                defaultName = json['defaultName'],
            )
            return obj

        def listElements(self):
            elements = ["oid"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.SnmpSensor, self).listElements()
            return elements

    # structure
    class ConfigurationPackage(Structure):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ConfigurationPackage:1.0.0"
        elements = ["disabled", "name", "classes", "devices", "encodings", "sensors"]

        def __init__(self, disabled=False, name="", classes=[], devices=[], encodings=[], sensors=[]):
            typecheck.is_bool(disabled, AssertionError)
            typecheck.is_string(name, AssertionError)
            for x0 in classes:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.SensorClass, AssertionError)
            for x0 in devices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.RemoteDevice, AssertionError)
            for x0 in encodings:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.ValueEncoding, AssertionError)
            for x0 in sensors:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.Sensor, AssertionError)

            self.disabled = disabled
            self.name = name
            self.classes = classes
            self.devices = devices
            self.encodings = encodings
            self.sensors = sensors

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                disabled = json['disabled'],
                name = json['name'],
                classes = [ValueObject.decode(x0, agent) for x0 in json['classes']],
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                encodings = [ValueObject.decode(x0, agent) for x0 in json['encodings']],
                sensors = [ValueObject.decode(x0, agent) for x0 in json['sensors']],
            )
            return obj

        def encode(self):
            json = {}
            json['disabled'] = self.disabled
            json['name'] = self.name
            json['classes'] = [ValueObject.encode(x0) for x0 in self.classes]
            json['devices'] = [ValueObject.encode(x0) for x0 in self.devices]
            json['encodings'] = [ValueObject.encode(x0) for x0 in self.encodings]
            json['sensors'] = [ValueObject.encode(x0) for x0 in self.sensors]
            return json

    class _getConfiguration(Interface.Method):
        name = 'getConfiguration'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.peripheral.GatewaySensorManager.ConfigurationPackage.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    ERR_CONFIG_INCONSISTENT = 1

    ERR_CONFIG_STORAGE_FAILED = 2

    class _setConfiguration(Interface.Method):
        name = 'setConfiguration'

        @staticmethod
        def encode(cfg):
            args = {}
            args['cfg'] = [dict(
                key = k,
                value = raritan.rpc.peripheral.GatewaySensorManager.ConfigurationPackage.encode(v))
                for k, v in cfg.items()]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # value object
    class ConfigurationChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.GatewaySensorManager_2_0_0.ConfigurationChangedEvent:1.0.0"

        def __init__(self, configuration={}, source=None):
            super(raritan.rpc.peripheral.GatewaySensorManager.ConfigurationChangedEvent, self).__init__(source)

            self.configuration = configuration

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.ConfigurationChangedEvent, self).encode()
            json['configuration'] = [dict(
                key = k,
                value = raritan.rpc.peripheral.GatewaySensorManager.ConfigurationPackage.encode(v))
                for k, v in self.configuration.items()]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                configuration = dict([(
                    elem['key'],
                    raritan.rpc.peripheral.GatewaySensorManager.ConfigurationPackage.decode(elem['value'], agent))
                    for elem in json['configuration']]),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["configuration"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.ConfigurationChangedEvent, self).listElements()
            return elements

    # structure
    class FeedbackObject(Structure):
        idlType = "peripheral.GatewaySensorManager_2_0_0.FeedbackObject:1.0.0"
        elements = ["key", "value", "stateTansitionTo"]

        def __init__(self, key="", value="", stateTansitionTo=None):
            if stateTansitionTo is None:
                stateTansitionTo = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.UNSPECIFIED
            typecheck.is_string(key, AssertionError)
            typecheck.is_string(value, AssertionError)
            typecheck.is_enum(stateTansitionTo, raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState, AssertionError)

            self.key = key
            self.value = value
            self.stateTansitionTo = stateTansitionTo

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                key = json['key'],
                value = json['value'],
                stateTansitionTo = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.decode(json['stateTansitionTo']),
            )
            return obj

        def encode(self):
            json = {}
            json['key'] = self.key
            json['value'] = self.value
            json['stateTansitionTo'] = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.encode(self.stateTansitionTo)
            return json

        # enumeration
        class FeedbackState(Enumeration):
            idlType = "peripheral.GatewaySensorManager_2_0_0.FeedbackObject.FeedbackState:1.0.0"
            values = ["UNSPECIFIED", "INTENTIONALLY_UNUSED", "FAILED_PRECONDITIONS_UNUSED", "FAILED", "GOOD"]

        FeedbackState.UNSPECIFIED = FeedbackState(0)
        FeedbackState.INTENTIONALLY_UNUSED = FeedbackState(1)
        FeedbackState.FAILED_PRECONDITIONS_UNUSED = FeedbackState(2)
        FeedbackState.FAILED = FeedbackState(3)
        FeedbackState.GOOD = FeedbackState(4)

    # value object
    class Feedback(ValueObject):
        idlType = "peripheral.GatewaySensorManager_2_0_0.Feedback:1.0.0"

        def __init__(self, currentState=None, infos=[]):
            if currentState is None:
                currentState = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.UNSPECIFIED
            typecheck.is_enum(currentState, raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState, AssertionError)
            for x0 in infos:
                typecheck.is_struct(x0, raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject, AssertionError)

            self.currentState = currentState
            self.infos = infos

        def encode(self):
            json = {}
            json['currentState'] = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.encode(self.currentState)
            json['infos'] = [raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.encode(x0) for x0 in self.infos]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                currentState = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.decode(json['currentState']),
                infos = [raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.decode(x0, agent) for x0 in json['infos']],
            )
            return obj

        def listElements(self):
            elements = ["currentState", "infos"]
            return elements

    # value object
    class DeviceFeedback(Feedback):
        idlType = "peripheral.GatewaySensorManager_2_0_0.DeviceFeedback:1.0.0"

        def __init__(self, packageId="", deviceId="", currentState=None, infos=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.DeviceFeedback, self).__init__(currentState, infos)
            typecheck.is_string(packageId, AssertionError)
            typecheck.is_string(deviceId, AssertionError)

            self.packageId = packageId
            self.deviceId = deviceId

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.DeviceFeedback, self).encode()
            json['packageId'] = self.packageId
            json['deviceId'] = self.deviceId
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageId = json['packageId'],
                deviceId = json['deviceId'],
                # for peripheral.GatewaySensorManager_2_0_0.Feedback
                currentState = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.decode(json['currentState']),
                infos = [raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.decode(x0, agent) for x0 in json['infos']],
            )
            return obj

        def listElements(self):
            elements = ["packageId", "deviceId"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.DeviceFeedback, self).listElements()
            return elements

    # value object
    class SensorFeedback(Feedback):
        idlType = "peripheral.GatewaySensorManager_2_0_0.SensorFeedback:1.0.0"

        def __init__(self, packageId="", deviceId="", sensorId="", currentState=None, infos=[]):
            super(raritan.rpc.peripheral.GatewaySensorManager.SensorFeedback, self).__init__(currentState, infos)
            typecheck.is_string(packageId, AssertionError)
            typecheck.is_string(deviceId, AssertionError)
            typecheck.is_string(sensorId, AssertionError)

            self.packageId = packageId
            self.deviceId = deviceId
            self.sensorId = sensorId

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.SensorFeedback, self).encode()
            json['packageId'] = self.packageId
            json['deviceId'] = self.deviceId
            json['sensorId'] = self.sensorId
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageId = json['packageId'],
                deviceId = json['deviceId'],
                sensorId = json['sensorId'],
                # for peripheral.GatewaySensorManager_2_0_0.Feedback
                currentState = raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.decode(json['currentState']),
                infos = [raritan.rpc.peripheral.GatewaySensorManager.FeedbackObject.decode(x0, agent) for x0 in json['infos']],
            )
            return obj

        def listElements(self):
            elements = ["packageId", "deviceId", "sensorId"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.SensorFeedback, self).listElements()
            return elements

    class _getFeedback(Interface.Method):
        name = 'getFeedback'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [ValueObject.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.Feedback, DecodeException)
            return _ret_

    # value object
    class FeedbackChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.GatewaySensorManager_2_0_0.FeedbackChangedEvent:1.0.0"

        def __init__(self, feedback=[], source=None):
            super(raritan.rpc.peripheral.GatewaySensorManager.FeedbackChangedEvent, self).__init__(source)
            for x0 in feedback:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.GatewaySensorManager.Feedback, AssertionError)

            self.feedback = feedback

        def encode(self):
            json = super(raritan.rpc.peripheral.GatewaySensorManager.FeedbackChangedEvent, self).encode()
            json['feedback'] = [ValueObject.encode(x0) for x0 in self.feedback]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                feedback = [ValueObject.decode(x0, agent) for x0 in json['feedback']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["feedback"]
            elements = elements + super(raritan.rpc.peripheral.GatewaySensorManager.FeedbackChangedEvent, self).listElements()
            return elements
    def __init__(self, target, agent):
        super(GatewaySensorManager, self).__init__(target, agent)
        self.getConfiguration = GatewaySensorManager._getConfiguration(self)
        self.setConfiguration = GatewaySensorManager._setConfiguration(self)
        self.getFeedback = GatewaySensorManager._getFeedback(self)

#
# Section generated by IdlC from "PeripheralDevicePackage.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.peripheral


# structure
class PackageInfo(Structure):
    idlType = "peripheral.PackageInfo:6.0.0"
    elements = ["state", "position", "hwInfo", "fwInfo"]

    def __init__(self, state=None, position=[], hwInfo=None, fwInfo=None):
        if state is None:
            state = raritan.rpc.peripheral.PackageInfo.State.NORMAL
        if hwInfo is None:
            hwInfo = raritan.rpc.peripheral.PackageInfo.HardwareInfo()
        if fwInfo is None:
            fwInfo = raritan.rpc.peripheral.PackageInfo.FirmwareInfo()
        typecheck.is_enum(state, raritan.rpc.peripheral.PackageInfo.State, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(hwInfo, raritan.rpc.peripheral.PackageInfo.HardwareInfo, AssertionError)
        typecheck.is_struct(fwInfo, raritan.rpc.peripheral.PackageInfo.FirmwareInfo, AssertionError)

        self.state = state
        self.position = position
        self.hwInfo = hwInfo
        self.fwInfo = fwInfo

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            state = raritan.rpc.peripheral.PackageInfo.State.decode(json['state']),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            hwInfo = raritan.rpc.peripheral.PackageInfo.HardwareInfo.decode(json['hwInfo'], agent),
            fwInfo = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.decode(json['fwInfo'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['state'] = raritan.rpc.peripheral.PackageInfo.State.encode(self.state)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['hwInfo'] = raritan.rpc.peripheral.PackageInfo.HardwareInfo.encode(self.hwInfo)
        json['fwInfo'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.encode(self.fwInfo)
        return json

    # enumeration
    class State(Enumeration):
        idlType = "peripheral.PackageInfo_6_0_0.State:1.0.0"
        values = ["NORMAL", "FW_UPDATE", "INTERNAL_ERROR", "CONFIG_ERROR"]

    State.NORMAL = State(0)
    State.FW_UPDATE = State(1)
    State.INTERNAL_ERROR = State(2)
    State.CONFIG_ERROR = State(3)

    # structure
    class HardwareInfo(Structure):
        idlType = "peripheral.PackageInfo_6_0_0.HardwareInfo:1.0.0"
        elements = ["serial", "packageClass", "model", "minDowngradeVersion", "revision", "address"]

        def __init__(self, serial="", packageClass="", model="", minDowngradeVersion=0, revision="", address=""):
            typecheck.is_string(serial, AssertionError)
            typecheck.is_string(packageClass, AssertionError)
            typecheck.is_string(model, AssertionError)
            typecheck.is_int(minDowngradeVersion, AssertionError)
            typecheck.is_string(revision, AssertionError)
            typecheck.is_string(address, AssertionError)

            self.serial = serial
            self.packageClass = packageClass
            self.model = model
            self.minDowngradeVersion = minDowngradeVersion
            self.revision = revision
            self.address = address

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                serial = json['serial'],
                packageClass = json['packageClass'],
                model = json['model'],
                minDowngradeVersion = json['minDowngradeVersion'],
                revision = json['revision'],
                address = json['address'],
            )
            return obj

        def encode(self):
            json = {}
            json['serial'] = self.serial
            json['packageClass'] = self.packageClass
            json['model'] = self.model
            json['minDowngradeVersion'] = self.minDowngradeVersion
            json['revision'] = self.revision
            json['address'] = self.address
            return json

    # structure
    class FirmwareInfo(Structure):
        idlType = "peripheral.PackageInfo_6_0_0.FirmwareInfo:1.0.0"
        elements = ["compileDate", "version", "updateDate", "firmwareName"]

        def __init__(self, compileDate=None, version=None, updateDate=None, firmwareName=""):
            if version is None:
                version = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version()
            typecheck.is_time(compileDate, AssertionError)
            typecheck.is_struct(version, raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version, AssertionError)
            typecheck.is_time(updateDate, AssertionError)
            typecheck.is_string(firmwareName, AssertionError)

            self.compileDate = compileDate
            self.version = version
            self.updateDate = updateDate
            self.firmwareName = firmwareName

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                compileDate = raritan.rpc.Time.decode(json['compileDate']),
                version = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.decode(json['version'], agent),
                updateDate = raritan.rpc.Time.decode(json['updateDate']),
                firmwareName = json['firmwareName'],
            )
            return obj

        def encode(self):
            json = {}
            json['compileDate'] = raritan.rpc.Time.encode(self.compileDate)
            json['version'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.encode(self.version)
            json['updateDate'] = raritan.rpc.Time.encode(self.updateDate)
            json['firmwareName'] = self.firmwareName
            return json

        # structure
        class Version(Structure):
            idlType = "peripheral.PackageInfo_6_0_0.FirmwareInfo.Version:1.0.0"
            elements = ["majorNumber", "minorNumber", "bootloaderVersion"]

            def __init__(self, majorNumber=0, minorNumber=0, bootloaderVersion=0):
                typecheck.is_int(majorNumber, AssertionError)
                typecheck.is_int(minorNumber, AssertionError)
                typecheck.is_int(bootloaderVersion, AssertionError)

                self.majorNumber = majorNumber
                self.minorNumber = minorNumber
                self.bootloaderVersion = bootloaderVersion

            @classmethod
            def decode(cls, json, agent):
                obj = cls(
                    majorNumber = json['majorNumber'],
                    minorNumber = json['minorNumber'],
                    bootloaderVersion = json['bootloaderVersion'],
                )
                return obj

            def encode(self):
                json = {}
                json['majorNumber'] = self.majorNumber
                json['minorNumber'] = self.minorNumber
                json['bootloaderVersion'] = self.bootloaderVersion
                return json

# interface
class Package(Interface):
    idlType = "peripheral.Package:3.0.2"

    class _getPackageInfo(Interface.Method):
        name = 'getPackageInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.PackageInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.PackageInfo, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Package, self).__init__(target, agent)
        self.getPackageInfo = Package._getPackageInfo(self)

# interface
class DoorHandleControllerPackage(Package):
    idlType = "peripheral.DoorHandleControllerPackage:3.0.2"

    SUCCESS = 0

    ERR_NOT_SUPPORTED = 1

    ERR_OPERATION_FAILED = 2

    class _getSupportedHandleTypes(Interface.Method):
        name = 'getSupportedHandleTypes'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getSupportedExternalDeviceTypes(Interface.Method):
        name = 'getSupportedExternalDeviceTypes'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getHandleType(Interface.Method):
        name = 'getHandleType'

        @staticmethod
        def encode(channel):
            typecheck.is_int(channel, AssertionError)
            args = {}
            args['channel'] = channel
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _getExternalDeviceType(Interface.Method):
        name = 'getExternalDeviceType'

        @staticmethod
        def encode(channel):
            typecheck.is_int(channel, AssertionError)
            args = {}
            args['channel'] = channel
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _setHandleType(Interface.Method):
        name = 'setHandleType'

        @staticmethod
        def encode(channel, handleType):
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(handleType, AssertionError)
            args = {}
            args['channel'] = channel
            args['handleType'] = handleType
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setExternalDeviceType(Interface.Method):
        name = 'setExternalDeviceType'

        @staticmethod
        def encode(channel, type):
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(type, AssertionError)
            args = {}
            args['channel'] = channel
            args['type'] = type
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # value object
    class MechanicallyUnlockedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DoorHandleControllerPackage_3_0_2.MechanicallyUnlockedEvent:1.0.0"

        def __init__(self, packageInfo=None, channel=0, doorStateName="", doorHandleName="", doorLockName="", source=None):
            super(raritan.rpc.peripheral.DoorHandleControllerPackage.MechanicallyUnlockedEvent, self).__init__(source)
            if packageInfo is None:
                packageInfo = raritan.rpc.peripheral.PackageInfo()
            typecheck.is_struct(packageInfo, raritan.rpc.peripheral.PackageInfo, AssertionError)
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(doorStateName, AssertionError)
            typecheck.is_string(doorHandleName, AssertionError)
            typecheck.is_string(doorLockName, AssertionError)

            self.packageInfo = packageInfo
            self.channel = channel
            self.doorStateName = doorStateName
            self.doorHandleName = doorHandleName
            self.doorLockName = doorLockName

        def encode(self):
            json = super(raritan.rpc.peripheral.DoorHandleControllerPackage.MechanicallyUnlockedEvent, self).encode()
            json['packageInfo'] = raritan.rpc.peripheral.PackageInfo.encode(self.packageInfo)
            json['channel'] = self.channel
            json['doorStateName'] = self.doorStateName
            json['doorHandleName'] = self.doorHandleName
            json['doorLockName'] = self.doorLockName
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageInfo = raritan.rpc.peripheral.PackageInfo.decode(json['packageInfo'], agent),
                channel = json['channel'],
                doorStateName = json['doorStateName'],
                doorHandleName = json['doorHandleName'],
                doorLockName = json['doorLockName'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["packageInfo", "channel", "doorStateName", "doorHandleName", "doorLockName"]
            elements = elements + super(raritan.rpc.peripheral.DoorHandleControllerPackage.MechanicallyUnlockedEvent, self).listElements()
            return elements

    # value object
    class DoorForcedOpenEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DoorHandleControllerPackage_3_0_2.DoorForcedOpenEvent:1.0.0"

        def __init__(self, packageInfo=None, channel=0, doorStateName="", doorHandleName="", doorLockName="", source=None):
            super(raritan.rpc.peripheral.DoorHandleControllerPackage.DoorForcedOpenEvent, self).__init__(source)
            if packageInfo is None:
                packageInfo = raritan.rpc.peripheral.PackageInfo()
            typecheck.is_struct(packageInfo, raritan.rpc.peripheral.PackageInfo, AssertionError)
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(doorStateName, AssertionError)
            typecheck.is_string(doorHandleName, AssertionError)
            typecheck.is_string(doorLockName, AssertionError)

            self.packageInfo = packageInfo
            self.channel = channel
            self.doorStateName = doorStateName
            self.doorHandleName = doorHandleName
            self.doorLockName = doorLockName

        def encode(self):
            json = super(raritan.rpc.peripheral.DoorHandleControllerPackage.DoorForcedOpenEvent, self).encode()
            json['packageInfo'] = raritan.rpc.peripheral.PackageInfo.encode(self.packageInfo)
            json['channel'] = self.channel
            json['doorStateName'] = self.doorStateName
            json['doorHandleName'] = self.doorHandleName
            json['doorLockName'] = self.doorLockName
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageInfo = raritan.rpc.peripheral.PackageInfo.decode(json['packageInfo'], agent),
                channel = json['channel'],
                doorStateName = json['doorStateName'],
                doorHandleName = json['doorHandleName'],
                doorLockName = json['doorLockName'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["packageInfo", "channel", "doorStateName", "doorHandleName", "doorLockName"]
            elements = elements + super(raritan.rpc.peripheral.DoorHandleControllerPackage.DoorForcedOpenEvent, self).listElements()
            return elements
    def __init__(self, target, agent):
        super(DoorHandleControllerPackage, self).__init__(target, agent)
        self.getSupportedHandleTypes = DoorHandleControllerPackage._getSupportedHandleTypes(self)
        self.getSupportedExternalDeviceTypes = DoorHandleControllerPackage._getSupportedExternalDeviceTypes(self)
        self.getHandleType = DoorHandleControllerPackage._getHandleType(self)
        self.getExternalDeviceType = DoorHandleControllerPackage._getExternalDeviceType(self)
        self.setHandleType = DoorHandleControllerPackage._setHandleType(self)
        self.setExternalDeviceType = DoorHandleControllerPackage._setExternalDeviceType(self)

# interface
class BatteryPoweredDevicePackage(Package):
    idlType = "peripheral.BatteryPoweredDevicePackage:1.0.1"

    class _getBatteryVoltage(Interface.Method):
        name = 'getBatteryVoltage'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_double(_ret_, DecodeException)
            return _ret_

    # value object
    class VoltageChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.BatteryPoweredDevicePackage_1_0_1.VoltageChangedEvent:1.0.0"

        def __init__(self, oldVoltage=0.0, newVoltage=0.0, source=None):
            super(raritan.rpc.peripheral.BatteryPoweredDevicePackage.VoltageChangedEvent, self).__init__(source)
            typecheck.is_double(oldVoltage, AssertionError)
            typecheck.is_double(newVoltage, AssertionError)

            self.oldVoltage = oldVoltage
            self.newVoltage = newVoltage

        def encode(self):
            json = super(raritan.rpc.peripheral.BatteryPoweredDevicePackage.VoltageChangedEvent, self).encode()
            json['oldVoltage'] = self.oldVoltage
            json['newVoltage'] = self.newVoltage
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldVoltage = json['oldVoltage'],
                newVoltage = json['newVoltage'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldVoltage", "newVoltage"]
            elements = elements + super(raritan.rpc.peripheral.BatteryPoweredDevicePackage.VoltageChangedEvent, self).listElements()
            return elements
    def __init__(self, target, agent):
        super(BatteryPoweredDevicePackage, self).__init__(target, agent)
        self.getBatteryVoltage = BatteryPoweredDevicePackage._getBatteryVoltage(self)

#
# Section generated by IdlC from "SensorHub.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.peripheral

import raritan.rpc.portsmodel


# interface
class SensorHub(Interface):
    idlType = "peripheral.SensorHub:2.0.3"

    # enumeration
    class UpstreamType(Enumeration):
        idlType = "peripheral.SensorHub_2_0_3.UpstreamType:1.0.0"
        values = ["BUILTIN", "ENV_HUB", "REMOTE_HUB"]

    UpstreamType.BUILTIN = UpstreamType(0)
    UpstreamType.ENV_HUB = UpstreamType(1)
    UpstreamType.REMOTE_HUB = UpstreamType(2)

    # structure
    class HubPortInfo(Structure):
        idlType = "peripheral.SensorHub_2_0_3.HubPortInfo:1.0.0"
        elements = ["hubPort", "fuse"]

        def __init__(self, hubPort="", fuse=None):
            typecheck.is_string(hubPort, AssertionError)
            typecheck.is_interface(fuse, raritan.rpc.portsmodel.PortFuse, AssertionError)

            self.hubPort = hubPort
            self.fuse = fuse

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                hubPort = json['hubPort'],
                fuse = Interface.decode(json['fuse'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['hubPort'] = self.hubPort
            json['fuse'] = Interface.encode(self.fuse)
            return json

    # structure
    class DeviceInfo(Structure):
        idlType = "peripheral.SensorHub_2_0_3.DeviceInfo:1.0.0"
        elements = ["serial", "model", "upstreamType", "position", "protocolVersion", "bootVersion", "appVersion", "hubPortInfos"]

        def __init__(self, serial="", model="", upstreamType=None, position=None, protocolVersion=0, bootVersion=0, appVersion=0, hubPortInfos=[]):
            if upstreamType is None:
                upstreamType = raritan.rpc.peripheral.SensorHub.UpstreamType.BUILTIN
            if position is None:
                position = raritan.rpc.peripheral.PosElement()
            typecheck.is_string(serial, AssertionError)
            typecheck.is_string(model, AssertionError)
            typecheck.is_enum(upstreamType, raritan.rpc.peripheral.SensorHub.UpstreamType, AssertionError)
            typecheck.is_struct(position, raritan.rpc.peripheral.PosElement, AssertionError)
            typecheck.is_int(protocolVersion, AssertionError)
            typecheck.is_int(bootVersion, AssertionError)
            typecheck.is_int(appVersion, AssertionError)
            for x0 in hubPortInfos:
                typecheck.is_struct(x0, raritan.rpc.peripheral.SensorHub.HubPortInfo, AssertionError)

            self.serial = serial
            self.model = model
            self.upstreamType = upstreamType
            self.position = position
            self.protocolVersion = protocolVersion
            self.bootVersion = bootVersion
            self.appVersion = appVersion
            self.hubPortInfos = hubPortInfos

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                serial = json['serial'],
                model = json['model'],
                upstreamType = raritan.rpc.peripheral.SensorHub.UpstreamType.decode(json['upstreamType']),
                position = raritan.rpc.peripheral.PosElement.decode(json['position'], agent),
                protocolVersion = json['protocolVersion'],
                bootVersion = json['bootVersion'],
                appVersion = json['appVersion'],
                hubPortInfos = [raritan.rpc.peripheral.SensorHub.HubPortInfo.decode(x0, agent) for x0 in json['hubPortInfos']],
            )
            return obj

        def encode(self):
            json = {}
            json['serial'] = self.serial
            json['model'] = self.model
            json['upstreamType'] = raritan.rpc.peripheral.SensorHub.UpstreamType.encode(self.upstreamType)
            json['position'] = raritan.rpc.peripheral.PosElement.encode(self.position)
            json['protocolVersion'] = self.protocolVersion
            json['bootVersion'] = self.bootVersion
            json['appVersion'] = self.appVersion
            json['hubPortInfos'] = [raritan.rpc.peripheral.SensorHub.HubPortInfo.encode(x0) for x0 in self.hubPortInfos]
            return json

    class _getDeviceInfo(Interface.Method):
        name = 'getDeviceInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.SensorHub.DeviceInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.SensorHub.DeviceInfo, DecodeException)
            return _ret_

    class _getPackageInfo(Interface.Method):
        name = 'getPackageInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.PackageInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.PackageInfo, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(SensorHub, self).__init__(target, agent)
        self.getDeviceInfo = SensorHub._getDeviceInfo(self)
        self.getPackageInfo = SensorHub._getPackageInfo(self)

#
# Section generated by IdlC from "PeripheralDeviceManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.portsmodel

import raritan.rpc.sensors


# interface
class DeviceManager(Interface):
    idlType = "peripheral.DeviceManager:5.2.4"

    ERR_INVALID_PARAMS = 1

    ERR_NOT_ON_SECONDARY = 2

    # enumeration
    class ZCoordMode(Enumeration):
        idlType = "peripheral.DeviceManager_5_2_4.ZCoordMode:1.0.0"
        values = ["RACKUNITS", "FREEFORM"]

    ZCoordMode.RACKUNITS = ZCoordMode(0)
    ZCoordMode.FREEFORM = ZCoordMode(1)

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceManager_5_2_4.Settings:1.0.0"
        elements = ["zCoordMode", "autoManageNewDevices", "deviceAltitude", "presenceDetectionTimeout", "defaultThresholdsMap", "maxActivePoweredDryContacts", "muteOtherAccessControlUnit"]

        def __init__(self, zCoordMode=None, autoManageNewDevices=False, deviceAltitude=0.0, presenceDetectionTimeout=0, defaultThresholdsMap={}, maxActivePoweredDryContacts=0, muteOtherAccessControlUnit=False):
            if zCoordMode is None:
                zCoordMode = raritan.rpc.peripheral.DeviceManager.ZCoordMode.RACKUNITS
            typecheck.is_enum(zCoordMode, raritan.rpc.peripheral.DeviceManager.ZCoordMode, AssertionError)
            typecheck.is_bool(autoManageNewDevices, AssertionError)
            typecheck.is_float(deviceAltitude, AssertionError)
            typecheck.is_int(presenceDetectionTimeout, AssertionError)
            typecheck.is_int(maxActivePoweredDryContacts, AssertionError)
            typecheck.is_bool(muteOtherAccessControlUnit, AssertionError)

            self.zCoordMode = zCoordMode
            self.autoManageNewDevices = autoManageNewDevices
            self.deviceAltitude = deviceAltitude
            self.presenceDetectionTimeout = presenceDetectionTimeout
            self.defaultThresholdsMap = defaultThresholdsMap
            self.maxActivePoweredDryContacts = maxActivePoweredDryContacts
            self.muteOtherAccessControlUnit = muteOtherAccessControlUnit

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                zCoordMode = raritan.rpc.peripheral.DeviceManager.ZCoordMode.decode(json['zCoordMode']),
                autoManageNewDevices = json['autoManageNewDevices'],
                deviceAltitude = json['deviceAltitude'],
                presenceDetectionTimeout = json['presenceDetectionTimeout'],
                defaultThresholdsMap = dict([(
                    elem['key'],
                    raritan.rpc.sensors.NumericSensor.Thresholds.decode(elem['value'], agent))
                    for elem in json['defaultThresholdsMap']]),
                maxActivePoweredDryContacts = json['maxActivePoweredDryContacts'],
                muteOtherAccessControlUnit = json['muteOtherAccessControlUnit'],
            )
            return obj

        def encode(self):
            json = {}
            json['zCoordMode'] = raritan.rpc.peripheral.DeviceManager.ZCoordMode.encode(self.zCoordMode)
            json['autoManageNewDevices'] = self.autoManageNewDevices
            json['deviceAltitude'] = self.deviceAltitude
            json['presenceDetectionTimeout'] = self.presenceDetectionTimeout
            json['defaultThresholdsMap'] = [dict(
                key = k,
                value = raritan.rpc.sensors.NumericSensor.Thresholds.encode(v))
                for k, v in self.defaultThresholdsMap.items()]
            json['maxActivePoweredDryContacts'] = self.maxActivePoweredDryContacts
            json['muteOtherAccessControlUnit'] = self.muteOtherAccessControlUnit
            return json

    # structure
    class MetaData(Structure):
        idlType = "peripheral.DeviceManager_5_2_4.MetaData:1.0.0"
        elements = ["oneWirePortCount", "onboardDeviceCount"]

        def __init__(self, oneWirePortCount=0, onboardDeviceCount=0):
            typecheck.is_int(oneWirePortCount, AssertionError)
            typecheck.is_int(onboardDeviceCount, AssertionError)

            self.oneWirePortCount = oneWirePortCount
            self.onboardDeviceCount = onboardDeviceCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oneWirePortCount = json['oneWirePortCount'],
                onboardDeviceCount = json['onboardDeviceCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['oneWirePortCount'] = self.oneWirePortCount
            json['onboardDeviceCount'] = self.onboardDeviceCount
            return json

    # structure
    class DeviceTypeInfo(Structure):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceTypeInfo:1.0.0"
        elements = ["type", "isActuator", "identifier", "name", "defaultRange", "defaultDecDigits"]

        def __init__(self, type=None, isActuator=False, identifier="", name="", defaultRange=None, defaultDecDigits=0):
            if type is None:
                type = raritan.rpc.sensors.Sensor.TypeSpec()
            if defaultRange is None:
                defaultRange = raritan.rpc.sensors.NumericSensor.Range()
            typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
            typecheck.is_bool(isActuator, AssertionError)
            typecheck.is_string(identifier, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_struct(defaultRange, raritan.rpc.sensors.NumericSensor.Range, AssertionError)
            typecheck.is_int(defaultDecDigits, AssertionError)

            self.type = type
            self.isActuator = isActuator
            self.identifier = identifier
            self.name = name
            self.defaultRange = defaultRange
            self.defaultDecDigits = defaultDecDigits

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                isActuator = json['isActuator'],
                identifier = json['identifier'],
                name = json['name'],
                defaultRange = raritan.rpc.sensors.NumericSensor.Range.decode(json['defaultRange'], agent),
                defaultDecDigits = json['defaultDecDigits'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
            json['isActuator'] = self.isActuator
            json['identifier'] = self.identifier
            json['name'] = self.name
            json['defaultRange'] = raritan.rpc.sensors.NumericSensor.Range.encode(self.defaultRange)
            json['defaultDecDigits'] = self.defaultDecDigits
            return json

    # structure
    class FirmwareUpdateState(Structure):
        idlType = "peripheral.DeviceManager_5_2_4.FirmwareUpdateState:1.0.0"
        elements = ["active", "remaining"]

        def __init__(self, active=False, remaining=0):
            typecheck.is_bool(active, AssertionError)
            typecheck.is_int(remaining, AssertionError)

            self.active = active
            self.remaining = remaining

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                active = json['active'],
                remaining = json['remaining'],
            )
            return obj

        def encode(self):
            json = {}
            json['active'] = self.active
            json['remaining'] = self.remaining
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceManager_5_2_4.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.peripheral.DeviceManager.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.peripheral.DeviceManager.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class DeviceEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceEvent:1.0.0"

        def __init__(self, devices=[], allDevices=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).__init__(source)
            for x0 in devices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, AssertionError)
            for x0 in allDevices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, AssertionError)

            self.devices = devices
            self.allDevices = allDevices

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).encode()
            json['devices'] = [ValueObject.encode(x0) for x0 in self.devices]
            json['allDevices'] = [ValueObject.encode(x0) for x0 in self.allDevices]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["devices", "allDevices"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).listElements()
            return elements

    # value object
    class DeviceAddedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceAddedEvent:1.0.0"

        def __init__(self, devices=[], allDevices=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).__init__(devices, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_5_2_4.DeviceEvent
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).listElements()
            return elements

    # value object
    class DeviceRemovedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceRemovedEvent:1.0.0"

        def __init__(self, devices=[], allDevices=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).__init__(devices, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_5_2_4.DeviceEvent
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).listElements()
            return elements

    # value object
    class UnknownDeviceAttachedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_5_2_4.UnknownDeviceAttachedEvent:1.0.0"

        def __init__(self, romCode="", position=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).__init__(source)
            typecheck.is_string(romCode, AssertionError)
            for x0 in position:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)

            self.romCode = romCode
            self.position = position

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).encode()
            json['romCode'] = self.romCode
            json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                romCode = json['romCode'],
                position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["romCode", "position"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).listElements()
            return elements

    # enumeration
    class DeviceFirmwareUpdateState(Enumeration):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceFirmwareUpdateState:1.0.0"
        values = ["UPDATE_STARTED", "UPDATE_SUCCESSFUL", "UPDATE_FAILED"]

    DeviceFirmwareUpdateState.UPDATE_STARTED = DeviceFirmwareUpdateState(0)
    DeviceFirmwareUpdateState.UPDATE_SUCCESSFUL = DeviceFirmwareUpdateState(1)
    DeviceFirmwareUpdateState.UPDATE_FAILED = DeviceFirmwareUpdateState(2)

    # value object
    class DeviceFirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_5_2_4.DeviceFirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, oldVersion="", newVersion="", serial="", state=None, source=None):
            super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).__init__(source)
            if state is None:
                state = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.UPDATE_STARTED
            typecheck.is_string(oldVersion, AssertionError)
            typecheck.is_string(newVersion, AssertionError)
            typecheck.is_string(serial, AssertionError)
            typecheck.is_enum(state, raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState, AssertionError)

            self.oldVersion = oldVersion
            self.newVersion = newVersion
            self.serial = serial
            self.state = state

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).encode()
            json['oldVersion'] = self.oldVersion
            json['newVersion'] = self.newVersion
            json['serial'] = self.serial
            json['state'] = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.encode(self.state)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldVersion = json['oldVersion'],
                newVersion = json['newVersion'],
                serial = json['serial'],
                state = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.decode(json['state']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldVersion", "newVersion", "serial", "state"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class FirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_5_2_4.FirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, newState=None, source=None):
            super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).__init__(source)
            if newState is None:
                newState = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState()
            typecheck.is_struct(newState, raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState, AssertionError)

            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).encode()
            json['newState'] = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newState = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newState"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class PackageEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_5_2_4.PackageEvent:1.0.0"

        def __init__(self, packageInfos=[], allPackages=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).__init__(source)
            for x0 in packageInfos:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, AssertionError)
            for x0 in allPackages:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, AssertionError)

            self.packageInfos = packageInfos
            self.allPackages = allPackages

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).encode()
            json['packageInfos'] = [raritan.rpc.peripheral.PackageInfo.encode(x0) for x0 in self.packageInfos]
            json['allPackages'] = [raritan.rpc.peripheral.PackageInfo.encode(x0) for x0 in self.allPackages]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["packageInfos", "allPackages"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).listElements()
            return elements

    # value object
    class PackageAddedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager_5_2_4.PackageAddedEvent:1.0.0"

        def __init__(self, packageInfos=[], allPackages=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).__init__(packageInfos, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_5_2_4.PackageEvent
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).listElements()
            return elements

    # value object
    class PackageRemovedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager_5_2_4.PackageRemovedEvent:1.0.0"

        def __init__(self, packageInfos=[], allPackages=[], source=None):
            super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).__init__(packageInfos, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_5_2_4.PackageEvent
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).listElements()
            return elements

    # structure
    class Statistics(Structure):
        idlType = "peripheral.DeviceManager_5_2_4.Statistics:1.0.0"
        elements = ["cSumErrCnt", "fuseTripCnt"]

        def __init__(self, cSumErrCnt=0, fuseTripCnt=0):
            typecheck.is_int(cSumErrCnt, AssertionError)
            typecheck.is_int(fuseTripCnt, AssertionError)

            self.cSumErrCnt = cSumErrCnt
            self.fuseTripCnt = fuseTripCnt

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cSumErrCnt = json['cSumErrCnt'],
                fuseTripCnt = json['fuseTripCnt'],
            )
            return obj

        def encode(self):
            json = {}
            json['cSumErrCnt'] = self.cSumErrCnt
            json['fuseTripCnt'] = self.fuseTripCnt
            return json

    class _getDeviceSlots(Interface.Method):
        name = 'getDeviceSlots'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, DecodeException)
            return _ret_

    class _getDeviceSlot(Interface.Method):
        name = 'getDeviceSlot'

        @staticmethod
        def encode(idx):
            typecheck.is_int(idx, AssertionError)
            args = {}
            args['idx'] = idx
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.peripheral.DeviceSlot, DecodeException)
            return _ret_

    class _getSensorHubs(Interface.Method):
        name = 'getSensorHubs'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.peripheral.SensorHub, DecodeException)
            return _ret_

    class _getDiscoveredDevices(Interface.Method):
        name = 'getDiscoveredDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [ValueObject.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, DecodeException)
            return _ret_

    class _getDiscoveredPackageInfos(Interface.Method):
        name = 'getDiscoveredPackageInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.MetaData, DecodeException)
            return _ret_

    class _getDeviceTypeInfos(Interface.Method):
        name = 'getDeviceTypeInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo, DecodeException)
            return _ret_

    class _getFirmwareUpdateState(Interface.Method):
        name = 'getFirmwareUpdateState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.Statistics.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Statistics, DecodeException)
            return _ret_

    class _getDiscoveredPackages(Interface.Method):
        name = 'getDiscoveredPackages'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.peripheral.Package, DecodeException)
            return _ret_

    class _getPortFuse(Interface.Method):
        name = 'getPortFuse'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.portsmodel.PortFuse, DecodeException)
            return _ret_

    class _getGatewaySensorManager(Interface.Method):
        name = 'getGatewaySensorManager'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.peripheral.GatewaySensorManager, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DeviceManager, self).__init__(target, agent)
        self.getDeviceSlots = DeviceManager._getDeviceSlots(self)
        self.getDeviceSlot = DeviceManager._getDeviceSlot(self)
        self.getSensorHubs = DeviceManager._getSensorHubs(self)
        self.getDiscoveredDevices = DeviceManager._getDiscoveredDevices(self)
        self.getDiscoveredPackageInfos = DeviceManager._getDiscoveredPackageInfos(self)
        self.getSettings = DeviceManager._getSettings(self)
        self.setSettings = DeviceManager._setSettings(self)
        self.getMetaData = DeviceManager._getMetaData(self)
        self.getDeviceTypeInfos = DeviceManager._getDeviceTypeInfos(self)
        self.getFirmwareUpdateState = DeviceManager._getFirmwareUpdateState(self)
        self.getStatistics = DeviceManager._getStatistics(self)
        self.getDiscoveredPackages = DeviceManager._getDiscoveredPackages(self)
        self.getPortFuse = DeviceManager._getPortFuse(self)
        self.getGatewaySensorManager = DeviceManager._getGatewaySensorManager(self)

#
# Section generated by IdlC from "PeripheralG2Production.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class G2Production(Interface):
    idlType = "peripheral.G2Production:4.0.0"

    SUCCESS = 0

    ERR_INVALID_PARAMS = 1

    ERR_NO_CONFIG_MODE = 2

    ERR_NO_DEVICE = 3

    ERR_OPERATION_FAILED = 4

    class _programSerialNumber(Interface.Method):
        name = 'programSerialNumber'

        @staticmethod
        def encode(romcode, serial):
            typecheck.is_string(romcode, AssertionError)
            typecheck.is_string(serial, AssertionError)
            args = {}
            args['romcode'] = romcode
            args['serial'] = serial
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(G2Production, self).__init__(target, agent)
        self.programSerialNumber = G2Production._programSerialNumber(self)
