# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from User.idl.

use strict;

package Raritan::RPC::usermgmt::User;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "usermgmt.User:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::usermgmt::User::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_PASSWORD_UNCHANGED => 1;

use constant ERR_PASSWORD_EMPTY => 2;

use constant ERR_PASSWORD_TOO_SHORT => 3;

use constant ERR_PASSWORD_TOO_LONG => 4;

use constant ERR_PASSWORD_CTRL_CHARS => 5;

use constant ERR_PASSWORD_NEED_LOWER => 6;

use constant ERR_PASSWORD_NEED_UPPER => 7;

use constant ERR_PASSWORD_NEED_NUMERIC => 8;

use constant ERR_PASSWORD_NEED_SPECIAL => 9;

use constant ERR_PASSWORD_IN_HISTORY => 10;

use constant ERR_PASSWORD_TOO_SHORT_FOR_SNMP => 11;

use constant ERR_INVALID_ARGUMENT => 12;

use Raritan::RPC::usermgmt::UserInfo;

sub getInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfo', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::usermgmt::UserInfo::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub setAccountPassword($$) {
    my ($self, $password) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'password'} = "$password";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setAccountPassword', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::usermgmt::UserInfo;

sub updateAccountFull($$$) {
    my ($self, $password, $info) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'password'} = "$password";
    $args->{'info'} = Raritan::RPC::usermgmt::UserInfo::encode($info);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'updateAccountFull', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::usermgmt::UserInfo;
use Raritan::RPC::usermgmt::Role::Privilege;

sub getInfoAndPrivileges($$$) {
    my ($self, $info, $privileges) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfoAndPrivileges', $args);
    $$info = Raritan::RPC::usermgmt::UserInfo::decode($agent, $rsp->{'info'});
    $$privileges = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'privileges'}}; $i0++) {
        $$privileges->[$i0] = Raritan::RPC::usermgmt::Role::Privilege::decode($agent, $rsp->{'privileges'}->[$i0]);
    }
}

Raritan::RPC::Registry::registerProxyClass('usermgmt.User', 1, 0, 0, 'Raritan::RPC::usermgmt::User');
1;
