#include <assert.h>
#include "game_state.h"
#include "rockdodger_globals.h"
#include "highscore_io.h"
#include "ship.h"
#include "sound.h"

void dead_pause() {
  play_tune(1);
  initialshield = 150;
  xship = 10;
  yship = ysize / 2;
  xvel = 2;
  yvel = 0;
  shieldlevel = 3 * W;
  laserlevel = 3 * W;
}


void handle_state_timeout(void) {
  //Ignore any state timeout in GAME PLAY mode.
  if(state == GAME_PLAY) return;
  // Count down the game loop timer, and change state when it gets to zero or less;
  if((state_timeout -= movementrate * 3) < 0) {
    switch (state) {
    case DEAD_PAUSE:
      // Create a new ship and start all over again
      state = GAME_PLAY;
      dead_pause();
      break;
    case GAME_OVER:
      state = HIGH_SCORE_ENTRY;
      game_over();
      break;
    case HIGH_SCORE_DISPLAY:
      state = TITLE_PAGE;
      state_timeout = 500.0;
      break;
    case HIGH_SCORE_ENTRY:
      // state = TITLE_PAGE;
      // play_tune(1);
      // state_timeout=100.0;
      break;
    case TITLE_PAGE:
      state = current_edition == EDITION_greeblies ? HIGH_SCORE_DISPLAY : DEMO;
      state_timeout = 400.0;
      sfx_enabled = 0;
      reset_ship_state();
      break;
    case DEMO:
      state = HIGH_SCORE_DISPLAY;
      state_timeout = 222.365;
      break;
    case SETUP:
      state = TITLE_PAGE;
      state_timeout = 500.0;
      break;
    case GAME_PLAY:
    case RESTART_GAME:
      assert(0); //Never happens.
      break;
    case GAME_PAUSED:
    case QUIT_GAME:
      break;
    }
  }
}


void pausegame() {
  switch(state) {
  case GAME_PLAY:
    state = GAME_PAUSED;
    break;
  case GAME_PAUSED:
    state = GAME_PLAY;
    break;
  default:
    assert(0);
  }
}


void reset_ship_state() {
  nships = 4;
  clear_score();
  xvel = 0;
  yvel = 0;
  xship = 10;
  yship = ysize / 2;
  shieldlevel = 3 * W;
  laserlevel = 3 * W;
  initialshield = 150;
}
