/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.installer;

import gnu.io.installer.InstallInstruction;
import gnu.io.installer.macosx.MACOSXRXTXInstaller;
import gnu.io.installer.util.InstallUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.prefs.Preferences;

public abstract class RXTXInstaller {
    static Preferences sysPref = Preferences.systemRoot();
    Preferences checkPref = null;
    protected File jarFolder;
    protected File libFolder;
    InstallInstruction inst = new InstallInstruction();

    public abstract void runPreProcess();

    public abstract void runPostProcess();

    public void install() {
        this.initInstallation(RXTXInstaller.class);
        this.runPreProcess();
        if (this.inst != null) {
            Enumeration e = this.inst.getKeys();
            while (e.hasMoreElements()) {
                File f = (File)e.nextElement();
                InstallUtil.installPart(sysPref, this.checkPref, this.inst.getPath(f), f);
            }
        }
        this.runPostProcess();
        this.finishInstallation();
    }

    protected void finishInstallation() {
        if (this.checkPref == null) {
            return;
        }
        try {
            this.checkPref.removeNode();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public InstallInstruction getInstallInstruction() {
        return this.inst;
    }

    public static RXTXInstaller getInstance() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac")) {
            return new MACOSXRXTXInstaller();
        }
        return null;
    }

    protected void initInstallation(Class rootClass) {
        this.checkPref = null;
        if (rootClass == null) {
            return;
        }
        try {
            Preferences.importPreferences(rootClass.getResourceAsStream("installer.pref"));
            String checkPrefName = "/check";
            this.checkPref = sysPref.nodeExists(checkPrefName) ? sysPref.node(checkPrefName) : null;
        }
        catch (Throwable t) {
            this.checkPref = null;
            System.out.println("Throwable " + t);
        }
    }

    public void addLibResource(String path, String resource) {
        if (this.libFolder == null || path == null || resource == null) {
            return;
        }
        File libFile = new File(this.libFolder, path);
        this.addResource(libFile, resource);
    }

    public void addJarResource(String path, String resource) {
        if (this.jarFolder == null || path == null || resource == null) {
            return;
        }
        File jarFile = new File(this.jarFolder, path);
        this.addResource(jarFile, resource);
    }

    public void addResource(File path, String resource) {
        if (this.inst == null) {
            this.inst = new InstallInstruction();
        }
        this.inst.addResource(path, resource);
    }

    public static void main(String[] args) {
        RXTXInstaller installer = RXTXInstaller.getInstance();
        if (installer != null) {
            installer.install();
        }
    }
}

