/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define LINE_DLG
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Line_dlg.h"



/* -------------------------------------------------------------------
 * 線種を表示しているボタンの再描画
 * style_box "expose (再描画)" イベントハンドラ
 */
gint style_box_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	gint w, h;
	GdkGC *ld_gc;
	int style;
	
	/* 再描画する widget のスタイル値を取得 */
	style = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	
	/* GC 作成 */
	ld_gc = create_gc(widget);
	
	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;
	
	/* ボタンの背景 */
	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);
	
	/* ボタンに見えるように立体にする */
	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_line(widget->window, ld_gc, 2, h-2, w-2, h-2);
	gdk_draw_line(widget->window, ld_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, ld_gc, w-2, 2, w-2, h-2);
	gdk_draw_line(widget->window, ld_gc, w-1, 1, w-1, h-1);
	PenSet(ld_gc, 1, 0xffffff);
	gdk_draw_line(widget->window, ld_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, ld_gc, 2, 2, w-2, 2);
	gdk_draw_line(widget->window, ld_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, ld_gc, 2, 2, 2, h-2);
	
	/* 線を表示　バックカラーも指定 */
	PenSet_with_back(ld_gc, style, 0x000000, 0xe0e0e0);
	gdk_draw_line(widget->window, ld_gc, 3, h/2, w-3, h/2);
	
	/* GC 開放 */
	gdk_gc_destroy(ld_gc);
	
	return FALSE;
}



/* ------------------------------------------------------------------
 * 色を表示している widget の再描画
 * color_box "expose (再描画)" イベントハンドラ
 */
gint color_box_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	gint w, h;
	GdkGC *ld_gc;
	long color;
	
	/* widget の値を取得 */
	color = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	
	/* GC 作成 */
	ld_gc = create_gc(widget);
	
	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;
	
	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);
	
	PenSet(ld_gc, 1, color);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 1, 1, w-1, h-1);
	
	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 1, 1, w-1, h-1);
	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 2, 2, w-2, h-2);
	
	/* GC 開放 */
	gdk_gc_destroy(ld_gc);
	
	return FALSE;
}



/* ------------------------------------------------------------------
 * draw_area "expose (再描画)" イベントハンドラ
 */
gint draw_area_expose_event(GtkWidget *widget, GdkEventExpose *event, Line_set *lsbox)
{
	draw_area_box_draw(widget, lsbox);
	return FALSE;
}



int draw_area_box_draw(GtkWidget *widget, Line_set *lsbox)
{
	gint w, h, i;
	GdkGC *ld_gc;
	
	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;
	
	/* GC 作成 */
	ld_gc = create_gc(widget);
	
	PenSet(ld_gc, 1, sagcad_color.Back);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);
	
	PenSet(ld_gc, 1, 0xffffff);
	gdk_draw_rectangle (widget->window, ld_gc, FALSE, 0, 0, w, h);
	
	PenSet(ld_gc, lsbox->style_value, lsbox->color_value);
	if (lsbox->style_value == 0 || lsbox->style_value == 1){
		gdk_draw_line(widget->window, ld_gc, 0, h/2, w, h/2);
	}
	if (lsbox->style_value == 2){
		for (i = 5; i < 105; i = i + 10) {
			gdk_draw_line(widget->window, ld_gc, i-5, h/2, i, h/2);
		}
	}
	if (lsbox->style_value == 3){
		gdk_draw_line(widget->window, ld_gc, 0, h/2, 15, h/2);
		gdk_draw_line(widget->window, ld_gc, 20, h/2, 25, h/2);
		gdk_draw_line(widget->window, ld_gc, 30, h/2, 70, h/2);
		gdk_draw_line(widget->window, ld_gc, 75, h/2, 80, h/2);
		gdk_draw_line(widget->window, ld_gc, 85, h/2, w, h/2);
	}
	if (lsbox->style_value == 4){
		gdk_draw_line(widget->window, ld_gc, 0, h/2, 37, h/2);
		gdk_draw_line(widget->window, ld_gc, 42, h/2, 47, h/2);
		gdk_draw_line(widget->window, ld_gc, 52, h/2, 57, h/2);
		gdk_draw_line(widget->window, ld_gc, 62, h/2, w, h/2);
	}
	
	/* GC 開放 */
	gdk_gc_destroy(ld_gc);
	return 1;
}



int style_box_button_press_event(GtkWidget *widget, GdkEventButton *event, Line_set *lsbox)
{
	/* 押された style_box の値を取得 */
	lsbox->style_value = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	draw_area_box_draw(lsbox->draw_area, lsbox);
	return TRUE;
}



int color_box_button_press_event(GtkWidget *widget, GdkEventButton *event, Line_set *lsbox)
{
	/* 押された color_box の値を取得 */
	lsbox->color_value = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	draw_area_box_draw(lsbox->draw_area, lsbox);
	return TRUE;
}



/* -------------------------
 * キーが押されたイベント
 */
static gint lsbox_key_press_event(GtkWidget *widget, GdkEventKey *event, Line_set *lsbox)
{		
#ifdef TEST
	g_print("sagcad : key_press_event\n");
	g_print("state  = %d\n", event->state);
	g_print("keyval = %d   0x%x\n", event->keyval, event->keyval);
	g_print("length = %d\n", event->length);
	g_print("string = %s\n", event->string);
#endif
//	0xff8d;

	if(event->keyval == 0xff8d || event->keyval == 0xff0d) 	{
		/* 押されたボタンの値を取得 */
		gtk_main_quit();
	}
	return TRUE; 
}



/* -------------------------------------------------------
 * 線種設定 ダイアログ Line_set_dlg
 */
int Line_set_dlg(int *style, long *color)
{
	Line_set *lsbox;
	
	int x, y, l;
	GtkWidget *action_vbox;
	GtkWidget *hbox1;
	GtkWidget *style_box;
	GtkWidget *table1;
	GtkWidget *table2;
	GtkWidget *color_box;
	GtkWidget *hbox2;
	GtkWidget *line_status;
	GtkWidget *btn_ok;
	GtkWidget *separator;
	
	lsbox = (Line_set *)g_malloc(sizeof(Line_set));
	
	lsbox->style_value = *style;
	lsbox->color_value = *color;
	
	
	/* ダイアログ生成 */
	lsbox->dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(lsbox->dialog), "Line Setting");
	g_signal_connect( G_OBJECT(lsbox->dialog), "key_press_event",
				G_CALLBACK(lsbox_key_press_event), lsbox);
	
	/* action_vbox 生成 */
	action_vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)GTK_DIALOG(lsbox->dialog)->action_area, 
					   action_vbox, TRUE, TRUE, 0);
	gtk_widget_show(action_vbox);
	
	/* hbox1 生成 */
	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)action_vbox, hbox1, TRUE, TRUE, 0);
	gtk_widget_show(hbox1);
	
	/* セパレータ 生成 */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(action_vbox), separator, FALSE, FALSE, 8);
	gtk_widget_show(separator);
	
	/* hbox2 生成 */
	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)action_vbox, hbox2, TRUE, TRUE, 0);
	gtk_widget_show(hbox2);
	
	
	/* table(style) 生成 */
	table1 = gtk_table_new(1, 5, FALSE);
	for (y = 0 ; y < 5 ; y++) {
		style_box = gtk_drawing_area_new();
		g_object_set_data(G_OBJECT(style_box), "value", (gpointer)y);
		/* ドローイングエリアのサイズ設定 */
		gtk_widget_set_size_request(style_box, 100, 22);
		/* "expose_event" イベントハンドラ設定 */
		g_signal_connect(G_OBJECT(style_box), "expose_event",
					G_CALLBACK(style_box_expose_event), lsbox);
		/* "button_press_event" イベントハンドラ設定 */
		g_signal_connect(G_OBJECT(style_box), "button_press_event",
					G_CALLBACK(style_box_button_press_event), lsbox);
		/* イベントマスク設定 */
		gtk_widget_set_events(style_box,  GDK_EXPOSURE_MASK
										| GDK_LEAVE_NOTIFY_MASK
										| GDK_BUTTON_PRESS_MASK
										| GDK_POINTER_MOTION_MASK
										| GDK_POINTER_MOTION_HINT_MASK);
		gtk_table_attach_defaults(GTK_TABLE(table1), style_box, 0, 1, y, y+1);
		gtk_widget_show(style_box);
	}
	gtk_box_pack_start((GtkBox *)hbox1, table1, TRUE, TRUE, 0);
	gtk_widget_show(table1);
	
	
	/* セパレータ 生成 */
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox1), separator, FALSE, FALSE, 4);
	gtk_widget_show(separator);
	
	
	/* table(color) 生成 */
	table2 = gtk_table_new(5, 5, FALSE);
	for (x = 0 ; x < 5 ; x++) {
		for (y = 0 ; y < 5 ; y++) {
			l = y * 5 + x;
			
			color_box = gtk_drawing_area_new();
			/* ドローイングエリアのサイズ設定 */
			gtk_widget_set_size_request(color_box, 20, 20);
			/* "expose_event"イベントハンドラ設定 */
			g_signal_connect(G_OBJECT(color_box), "expose_event",
					   G_CALLBACK(color_box_expose_event), lsbox);
			/* "button_press_event"イベントハンドラ設定 */
			g_signal_connect(G_OBJECT(color_box), "button_press_event",
					   G_CALLBACK(color_box_button_press_event), lsbox);
			/* イベントマスク設定 */
			gtk_widget_set_events(color_box,  GDK_EXPOSURE_MASK
											| GDK_LEAVE_NOTIFY_MASK
											| GDK_BUTTON_PRESS_MASK
											| GDK_POINTER_MOTION_MASK
											| GDK_POINTER_MOTION_HINT_MASK);
			
			gtk_table_attach_defaults(GTK_TABLE(table2), color_box, x, x+1, y, y+1);
			g_object_set_data(G_OBJECT(color_box), "value", (gpointer)ColorMenu[l]);
			gtk_widget_show(color_box);
		}
	}
	gtk_box_pack_start((GtkBox *)hbox1, table2, TRUE, TRUE, 0);
	gtk_widget_show(table2);
	
	
	/* draw_area 生成 */
	line_status = gtk_drawing_area_new();
	/* ドローイングエリアのサイズ設定 */
	gtk_widget_set_size_request(line_status, 100, 18);
	gtk_box_pack_start(GTK_BOX(hbox2), line_status, FALSE, TRUE, 0);
	/* "expose_event" イベントハンドラ設定 */
	g_signal_connect(G_OBJECT(line_status), "expose_event",
					   G_CALLBACK(draw_area_expose_event), lsbox);
	lsbox->draw_area = line_status;
	gtk_widget_show(line_status);
	
	
	/* セパレータ 生成 */
	separator = gtk_vseparator_new();
	gtk_box_pack_start(GTK_BOX(hbox2), separator, FALSE, FALSE, 4);
	gtk_widget_show(separator);
	
	
	/* OKボタンの生成 */
	btn_ok = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox2), btn_ok, TRUE, TRUE, 0);
	g_object_set_data(G_OBJECT(btn_ok), "value", (gpointer)-1);
	g_signal_connect(G_OBJECT(btn_ok), "clicked",
				G_CALLBACK(gtk_main_quit), NULL);
	gtk_widget_show(btn_ok);
	
	GTK_WINDOW(lsbox->dialog)->focus_widget = GTK_WIDGET(btn_ok);
	
	/* ダイアログを可視状態へ */
	gtk_widget_show(lsbox->dialog);
	/* グラブを設定 */
	gtk_grab_add(lsbox->dialog);
	
	/* メインイベントループ */
	gtk_main();
	
	gtk_grab_remove(lsbox->dialog);
	gtk_widget_destroy(lsbox->dialog);
	
	*style = lsbox->style_value;
	*color = lsbox->color_value;
	return 1; 
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Line_dlg.c
 * ====================================================================
 */
