---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, figures, tables, centrer
---

# Comment centrer une figure ou une table très large ?

Pour centrer une figure ou un tableau, la méthode classique consiste 
à inclure la commande `\centering` au début du code de ce flottant. 
Mais cela ne donne pas des résultats corrects si l'objet est plus large 
que la largeur du texte (valeur de `\textwidth`). En effet, dans ce cas, 
le flottant va déborder dans la marge droite (ce qui est en fait doublement
insatisfaisant car, en plus d'être visuellement mal placé, le flottant 
ne sera pas placé avant la prochaine commande `\clearpage` ou similaire). 
Voici différentes corrections possibles selon la dimension du flottant.


## Avec un redimensionnement du flottant

Vous pouvez éviter ce problème en redimensionnant la figure ou le tableau 
pour l'adapter, mais cela n'est souvent pas satisfaisant 
pour de multiples raisons (souvent la lisibilité du flottant lui-même).


## Avec une rotation du flottant

Aussi, si l'objet est plus large que la zone imprimable de la page, 
vous n'avez d'autre choix que de le faire pivoter. La question 
"[](/3_composition/texte/pages/parametres_de_page/changer_l_orientation_d_un_document)"
détaille ce point.


## Avec la commande `\makebox`

Cependant, si l'objet est *juste* plus large que la zone de texte, vous pouvez
faire semblant d'avoir la bonne taille en utilisant ce code. Dans l'exemple suivant,
nous avons volontairement redimensionné l'image pour qu'elle soit 20% plus large 
que la zone de texte afin d'illustrer cette technique.

```
\documentclass[french, twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Nous n'avons pas assez de mots pour décrire les émotions qui nous traverse à 
la vue de ceci :
\begin{figure}[h]
  \noindent
  \makebox[\textwidth]{\includegraphics[width=1.2\textwidth]{example-image-a}}%
  \caption{Une figure débordante d'émotion}
\end{figure}
\end{document}
```

Notez ici la présence de `\noindent` : comme la commande `\makebox` débute 
un nouveau paragraphe, elle évite qu'il soit indenté avec `\parindent`.


:::{sources}
[Centring a very wide figure or table](faquk:FAQ-wideflt)
:::