---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, texte verbatim, verbatim
---

# Comment encadrer du texte verbatim ?


## Avec l'extension <ctanpkg:moreverb>

L'extension <ctanpkg:moreverb> propose un environnement encadré, `boxedverbatim` :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page
  \usepackage{moreverb}

\begin{document}
Le source encadré ci-dessous :

\begin{boxedverbatim}
La commande \verb.\LaTeX{}. permet
d'appeler le logo \LaTeX{}.
\end{boxedverbatim}
produira :

La commande \verb.\LaTeX{}. permet
d'appeler le logo \LaTeX{}.
\end{document}
```

## Avec l'extension <ctanpkg:fancyvrb>

L'extension <ctanpkg:fancyvrb> permet d'écrire du texte `verbatim` encadré, en couleur, etc :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
  \usepackage{lmodern}  % Caractères plus lisibles
  \usepackage{babel}    % Réglages linguistiques (avec french)
  \pagestyle{empty}     % N'affiche pas de numéro de page
  \usepackage[width=9cm]{geometry}
  \usepackage{fancyvrb}

\begin{document}
\fvset{frame=single,numbers=left,numbersep=3pt,
  commandchars=\\\{\},label=Exemple}
\begin{Verbatim}
Ici, je mets mon programme.
Avec des maths : \(a, b, \alpha, \beta,\ldots\)
ou de l'\textit{italique}.

\large{Pratique, non ?}
\end{Verbatim}
\end{document}
```