IF (MAGMA_LIBRARY_DIRS AND MAGMA_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(MAGMA INTERFACE LIBRARIES ${MAGMA_LIBRARIES} LIBRARY_PATHS ${MAGMA_LIBRARY_DIRS})
ELSEIF (MAGMA_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(MAGMA INTERFACE LIBRARIES ${MAGMA_LIBRARIES})
ELSEIF (MAGMA_LIBRARY_DIRS)
  KOKKOSKERNELS_FIND_IMPORTED(MAGMA INTERFACE LIBRARIES amath ${MAGMA_LIB} LIBRARY_PATHS ${MAGMA_LIBRARY_DIRS})
ELSEIF (KokkosKernels_MAGMA_ROOT OR DEFINED ENV{MAGMA_DIR})
  IF (KokkosKernels_MAGMA_ROOT AND DEFINED ENV{MAGMA_DIR})
    MESSAGE(FATAL_ERROR "Both KokkosKernels_MAGMA_ROOT and ENV{MAGMA_DIR} are defined!")
  ENDIF()

  IF (KokkosKernels_MAGMA_ROOT)
    SET(MAGMA_ROOT ${KokkosKernels_MAGMA_ROOT})
  ELSE()
    SET(MAGMA_ROOT $ENV{MAGMA_DIR})
  ENDIF()

  KOKKOSKERNELS_FIND_IMPORTED(MAGMA INTERFACE
    LIBRARIES
      magma
      magma_sparse
    LIBRARY_PATHS
      ${MAGMA_ROOT}/lib
    HEADERS
      magmablas.h
    HEADER_PATHS
      ${MAGMA_ROOT}/include
  )
ELSE()
  FIND_PACKAGE(MAGMA REQUIRED)
  KOKKOSKERNELS_CREATE_IMPORTED_TPL(MAGMA INTERFACE LINK_LIBRARIES ${MAGMA_LIBRARIES})
ENDIF()

TRY_COMPILE(KOKKOSKERNELS_TRY_COMPILE_MAGMA
  ${KOKKOSKERNELS_TOP_BUILD_DIR}/tpl_tests
  ${KOKKOSKERNELS_TOP_SOURCE_DIR}/cmake/compile_tests/magma.cpp
  CMAKE_FLAGS -DINCLUDE_DIRECTORIES=${MAGMA_ROOT}/include
  LINK_LIBRARIES -L${MAGMA_ROOT}/lib -lmagma -lmagma_sparse
  OUTPUT_VARIABLE KOKKOSKERNELS_TRY_COMPILE_MAGMA_OUT)
IF(NOT KOKKOSKERNELS_TRY_COMPILE_MAGMA)
  MESSAGE(FATAL_ERROR "KOKKOSKERNELS_TRY_COMPILE_MAGMA_OUT=${KOKKOSKERNELS_TRY_COMPILE_MAGMA_OUT}")
ENDIF()
