#pragma once

#define _REPLACE_TYPE(_old, _new) typedef _new _old __attribute__((__deprecated__("use " #_new " instead")))
#define _REPLACE_TYPE_ERROR(_old, _new) typedef _new _old __attribute__((__unavailable__("use " #_new " instead")))
#define _REPLACE_VALUE(_old, _new) _old __attribute__((__deprecated__("use " #_new " instead"))) = (_new)
#define _REPLACE_STRUCT(_old, _new) struct _old __attribute__((__unavailable__("use struct " #_new " instead")))
#define _REPLACE_ENUM(_old, _new) enum _old __attribute__((__unavailable__("use enum " #_new " instead")))

typedef void (*ResourceReleased)(const char *type);

_REPLACE_TYPE(NDLInitCallback, ResourceReleased);

typedef enum NDL_DIRECTVIDEO_SRC_TYPE_ {
    NDL_DIRECTVIDEO_SRC_TYPE_NONE = 0,
    NDL_DIRECTVIDEO_SRC_TYPE_H264 = 1,
} NDL_DIRECTVIDEO_SRC_TYPE;

typedef enum NDL_DIRECTAUDIO_SRC_TYPE_ {
    NDL_DIRECTAUDIO_SRC_TYPE_NONE = 0,
    /** PCM Mix Channel */
    NDL_DIRECTAUDIO_SRC_TYPE_PCM = 1,
    NDL_DIRECTAUDIO_SRC_TYPE_AC3 = 2,
    /** AAC. audio/mpeg,mpegversion=4,stream-format=adts */
    NDL_DIRECTAUDIO_SRC_TYPE_AAC = 3,
    NDL_DIRECTAUDIO_SRC_TYPE_WTF = 4,
} NDL_DIRECTAUDIO_SRC_TYPE;

_REPLACE_TYPE(NDL_DIRECTAUDIO_SRC_TYPE_T, NDL_DIRECTAUDIO_SRC_TYPE);

typedef enum NDL_DIRECTAUDIO_SAMPLING_FREQ_ {
    NDL_DIRECTAUDIO_SAMPLING_FREQ_NONE = 0,
    NDL_DIRECTAUDIO_SAMPLING_FREQ_4_KHZ = 1,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_4KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_4_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_8_KHZ = 2,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_8KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_8_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_11_025KHZ = 3,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_11KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_11_025KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_12_KHZ = 4,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_12KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_12_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_16_KHZ = 5,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_16KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_16_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_22_05KHZ = 6,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_22KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_22_05KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_24_KHZ = 7,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_24KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_24_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_32_KHZ = 8,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_32KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_32_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_44_1KHZ = 9,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_44KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_44_1KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_48_KHZ = 10,
    _REPLACE_VALUE(NDL_DIRECTAUDIO_SAMPLING_FREQ_48KHZ, NDL_DIRECTAUDIO_SAMPLING_FREQ_48_KHZ),
    NDL_DIRECTAUDIO_SAMPLING_FREQ_64_KHZ = 11,
} NDL_DIRECTAUDIO_SAMPLING_FREQ;

_REPLACE_TYPE(NDL_DIRECTAUDIO_SAMPLING_FREQ_T, NDL_DIRECTAUDIO_SAMPLING_FREQ);

typedef enum NDL_DIRECTAUDIO_CH_ {
    NDL_DIRECTAUDIO_CH_MAIN = 0,
    NDL_DIRECTAUDIO_CH_SUB = 1,
    NDL_DIRECTAUDIO_CH_MAX = 2,
} NDL_DIRECTAUDIO_CH;

_REPLACE_TYPE(NDL_DIRECTAUDIO_CH_T, NDL_DIRECTAUDIO_CH);

typedef enum NDL_DIRECTAUDIO_NODELAY_MODE_ {
    NDL_DIRECTAUDIO_NODELAY_MODE_DISABLED = -1,
    NDL_DIRECTAUDIO_NODELAY_MODE_DEFAULT = 0,
    NDL_DIRECTAUDIO_NODELAY_MODE_CUSTOM = 1,
} NDL_DIRECTAUDIO_NODELAY_MODE;

typedef enum NDL_DIRECTMEDIA_APP_STATE_ {
    NDL_DIRECTMEDIA_APP_STATE_FOREGROUND = 0,
    NDL_DIRECTMEDIA_APP_STATE_BACKGROUND = 1,
} NDL_DIRECTMEDIA_APP_STATE;

_REPLACE_TYPE(NDL_DIRECTMEDIA_APP_STATE_T, NDL_DIRECTMEDIA_APP_STATE);

typedef struct NDL_DIRECTAUDIO_DATA_INFO {
    unsigned int number_of_channel;
    unsigned int bit_per_sample;
    NDL_DIRECTAUDIO_NODELAY_MODE no_delay_mode;
    int no_delay_upper_time;
    int no_delay_lower_time;
    NDL_DIRECTAUDIO_CH channel;
    NDL_DIRECTAUDIO_SRC_TYPE source;
    NDL_DIRECTAUDIO_SAMPLING_FREQ frequency;
} NDL_DIRECTAUDIO_DATA_INFO_T;

_REPLACE_TYPE_ERROR(NDL_DIRECTAUDIO_DATA_INFO, NDL_DIRECTAUDIO_DATA_INFO_T);

typedef struct NDL_DIRECTVIDEO_DATA_INFO {
    int width;
    int height;
    NDL_DIRECTVIDEO_SRC_TYPE source;
} NDL_DIRECTVIDEO_DATA_INFO_T;

_REPLACE_TYPE_ERROR(NDL_DIRECTVIDEO_DATA_INFO, NDL_DIRECTVIDEO_DATA_INFO_T);

#if defined(NDL_DIRECTMEDIA_API_VERSION) && (NDL_DIRECTMEDIA_API_VERSION >= 2)
/* types for API version 2 (webOS 5+) */

typedef void (*NDLMediaLoadCallback)(int, long long, const char *);

#define NDL_DIRECTMEDIA_AUDIO_PCM_FORMAT_S16LE "S16LE"
#define NDL_DIRECTMEDIA_AUDIO_PCM_MODE_MONO "mono"
#define NDL_DIRECTMEDIA_AUDIO_PCM_MODE_STEREO "stereo"
#define NDL_DIRECTMEDIA_AUDIO_PCM_MODE_6_CHANNEL "6-channel"
#define NDL_DIRECTMEDIA_AUDIO_PCM_LAYOUT_INTERLEAVED "interleaved"
#define NDL_DIRECTMEDIA_AUDIO_PCM_LAYOUT_NON_INTERLEAVED "non-interleaved"

typedef enum NDL_VIDEO_TYPE_ {
    NDL_VIDEO_TYPE_H264 = 1,
    NDL_VIDEO_TYPE_H265 = 2,
    NDL_VIDEO_TYPE_VP9 = 3,
    NDL_VIDEO_TYPE_AV1 = 4,
    NDL_VIDEO_TYPE_MAX = 0x7FFFFFFF,
} NDL_VIDEO_TYPE;

_REPLACE_ENUM(NDL_VIDEO_TYPE, NDL_VIDEO_TYPE_);

typedef enum NDL_AUDIO_TYPE_ {
    NDL_AUDIO_TYPE_PCM = 1,
    NDL_AUDIO_TYPE_MP3 = 2,
    NDL_AUDIO_TYPE_OPUS = 3,
    NDL_AUDIO_TYPE_MAX = 0x7FFFFFFF,
} NDL_AUDIO_TYPE;

_REPLACE_ENUM(NDL_AUDIO_TYPE, NDL_AUDIO_TYPE_);

typedef enum NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_ {
    /* I'm pretty sure the app will crash on this value */
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_NONE = 0,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_48KHZ = 1,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_44KHZ = 2,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_32KHZ = 3,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_24KHZ = 4,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_22KHZ = 5,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_16KHZ = 6,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_12KHZ = 7,
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_8KHZ = 8,
} NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE;

_REPLACE_ENUM(NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE, NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_);

static inline __attribute__((__const__)) NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_OF(int hertz) {
    switch (hertz) {
        case 48000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_48KHZ;
        case 44100:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_44KHZ;
        case 32000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_32KHZ;
        case 24000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_24KHZ;
        case 22050:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_22KHZ;
        case 16000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_16KHZ;
        case 12000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_12KHZ;
        case 8000:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_8KHZ;
        default:
            return NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE_NONE;
    }
}

/* name confirmed: struct NDL_DIRECTAUDIO_PCM_INFO_ */
typedef struct NDL_DIRECTAUDIO_PCM_INFO_ {
    NDL_AUDIO_TYPE type;
    int unknown1;
    const char *format;
    const char *layout;
    const char *channelMode;
    NDL_DIRECTMEDIA_AUDIO_PCM_SAMPLE_RATE sampleRate;
} NDL_DIRECTAUDIO_PCM_INFO_T;

_REPLACE_STRUCT(NDL_DIRECTMEDIA_AUDIO_PCM_INFO_T, NDL_DIRECTAUDIO_PCM_INFO_);
_REPLACE_TYPE(NDL_DIRECTMEDIA_AUDIO_PCM_INFO, NDL_DIRECTAUDIO_PCM_INFO_T);

typedef struct NDL_DIRECTMEDIA_AUDIO_OPUS_INFO {
    NDL_AUDIO_TYPE type;
    int unknown1;
    int channels;
    int unknown2;
    double sampleRate;
    const char *streamHeader;
} NDL_DIRECTMEDIA_AUDIO_OPUS_INFO_T;

_REPLACE_STRUCT(NDL_DIRECTMEDIA_AUDIO_OPUS_INFO_T, NDL_DIRECTMEDIA_AUDIO_OPUS_INFO);
_REPLACE_TYPE(NDL_DIRECTMEDIA_AUDIO_OPUS_INFO, NDL_DIRECTMEDIA_AUDIO_OPUS_INFO_T);

/* name confirmed: struct NDL_DIRECTMEDIA_DATA_INFO */
typedef struct NDL_DIRECTMEDIA_DATA_INFO {
    struct NDL_DIRECTMEDIA_VIDEO_INFO {
        int width;
        int height;
        NDL_VIDEO_TYPE type;
        int unknown1;
    } video;
    union {
        NDL_AUDIO_TYPE type;
        NDL_DIRECTAUDIO_PCM_INFO_T pcm;
        NDL_DIRECTMEDIA_AUDIO_OPUS_INFO_T opus;
        char padding[32];
    } audio;
} NDL_DIRECTMEDIA_DATA_INFO_T;

_REPLACE_STRUCT(NDL_DIRECTMEDIA_DATA_INFO_T, NDL_DIRECTMEDIA_DATA_INFO);
_REPLACE_TYPE(NDL_DIRECTMEDIA_DATA_INFO, NDL_DIRECTMEDIA_DATA_INFO_T);

/* name confirmed: struct NDL_DIRECTVIDEO_HDR_INFO */
typedef struct NDL_DIRECTVIDEO_HDR_INFO {
    int displayPrimariesX0;
    int displayPrimariesY0;
    int displayPrimariesX1;
    int displayPrimariesY1;
    int displayPrimariesX2;
    int displayPrimariesY2;
    int whitePointX;
    int whitePointY;
    int maxDisplayMasteringLuminance;
    int minDisplayMasteringLuminance;
    int maxContentLightLevel;
    int maxPicAverageLightLevel;
    int transferCharacteristics;
    int colorPrimaries;
    int matrixCoeffs;
    unsigned char reserved[32];
} NDL_DIRECTVIDEO_HDR_INFO_T;

_REPLACE_STRUCT(NDL_DIRECTVIDEO_HDR_INFO_T, NDL_DIRECTVIDEO_HDR_INFO);
_REPLACE_TYPE(NDL_DIRECTVIDEO_HDR_INFO, NDL_DIRECTVIDEO_HDR_INFO_T);

#endif

#undef _REPLACE_TYPE
#undef _REPLACE_VALUE
#undef _REPLACE_STRUCT
#undef _REPLACE_ENUM
