// Copyright 2016-2018 LG Electronics, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

#ifndef WEBOS_COMMON_WEBOS_KEYBOARD_CODES_H_
#define WEBOS_COMMON_WEBOS_KEYBOARD_CODES_H_


#define XKB_KEY_WEBOS_INVALID 0x00

/* Misc KEYS */
#define XKB_KEY_WEBOS_TAB 0x01000001
#define XKB_KEY_WEBOS_RETURN 0x01000004
#define XKB_KEY_WEBOS_LEFT 0x01000012
#define XKB_KEY_WEBOS_UP 0x01000013
#define XKB_KEY_WEBOS_RIGHT 0x01000014
#define XKB_KEY_WEBOS_DOWN 0x01000015
#define XKB_KEY_WEBOS_SHIFT 0x01000020

/* Media Buttons */
#define XKB_KEY_WEBOS_MEDIA_PLAY 0x01000080
#define XKB_KEY_WEBOS_MEDIA_STOP 0x01000081
#define XKB_KEY_WEBOS_MEDIA_PREVIOUS 0x01000082
#define XKB_KEY_WEBOS_MEDIA_NEXT 0x01000083
#define XKB_KEY_WEBOS_MEDIA_RECORD 0x01000084
#define XKB_KEY_WEBOS_MEDIA_PAUSE 0x01000085
#define XKB_KEY_WEBOS_AUDIO_REWIND 0x010000c5
#define XKB_KEY_WEBOS_AUDIO_FORWARD 0x01000102
#define XKB_KEY_WEBOS_SUBTITLE 0x01000105
/* Volume Button */
#define XKB_KEY_WEBOS_VOLUME_DOWN 0x01000070
#define XKB_KEY_WEBOS_VOLUME_MUTE 0x01000071
#define XKB_KEY_WEBOS_VOLUME_UP 0x01000072
/* Misc Buttons */
#define XKB_KEY_WEBOS_SUPER_L 0x01000053
#define XKB_KEY_WEBOS_OPTION 0x010000e1
#define XKB_KEY_WEBOS_VIDEO 0x010000f3
#define XKB_KEY_WEBOS_PRINTER 0x01020002
/* webOS Buttons */
#define XKB_KEY_WEBOS_POWER_ON_OFF 0x01200000
#define XKB_KEY_WEBOS_EXIT 0x01200001
#define XKB_KEY_WEBOS_INFO 0x01200002
#define XKB_KEY_WEBOS_BACK 0x01200003
#define XKB_KEY_WEBOS_SETTINGS 0x01200004
#define XKB_KEY_WEBOS_RECENT 0x01200005
#define XKB_KEY_WEBOS_RED 0x01200011
#define XKB_KEY_WEBOS_GREEN 0x01200012
#define XKB_KEY_WEBOS_YELLOW 0x01200013
#define XKB_KEY_WEBOS_BLUE 0x01200014
#define XKB_KEY_WEBOS_TWIN 0x01200015
#define XKB_KEY_WEBOS_MAGNIFIER_ZOOM 0x01200016
#define XKB_KEY_WEBOS_LIVE_ZOOM 0x01200017
#define XKB_KEY_WEBOS_STBMENU 0x01200018
#define XKB_KEY_WEBOS_STBPOWER 0x01200019
#define XKB_KEY_WEBOS_CHANNEL_UP 0x01200021
#define XKB_KEY_WEBOS_CHANNEL_DOWN 0x01200022
#define XKB_KEY_WEBOS_CHANNEL_DASH 0x01200023
#define XKB_KEY_WEBOS_CHANNEL_BACK 0x01200024
#define XKB_KEY_WEBOS_FAVORITE 0x01200025
#define XKB_KEY_WEBOS_SET_CHANNEL 0x01200026
#define XKB_KEY_WEBOS_TIMER_POWER_ON 0x01200027
#define XKB_KEY_WEBOS_IVI 0x0120002a
#define XKB_KEY_WEBOS_3_DMODE 0x01200031
#define XKB_KEY_WEBOS_SCREEN_REMOTE 0x01200032
#define XKB_KEY_WEBOS_QMENU 0x01200033
#define XKB_KEY_WEBOS_VOICE 0x01200034
#define XKB_KEY_WEBOS_INPUT_SOURCE 0x01200035
#define XKB_KEY_WEBOS_INPUT_TV 0x01200036
#define XKB_KEY_WEBOS_ASPECT_RATIO 0x01200037
#define XKB_KEY_WEBOS_LIVE_TVMENU 0x01200038
#define XKB_KEY_WEBOS_TVGUIDE 0x01200039
#define XKB_KEY_WEBOS_AUDIO_DESCRIPTION 0x01200040
#define XKB_KEY_WEBOS_MHP 0x01200041
#define XKB_KEY_WEBOS_TELETEXT 0x01200042
#define XKB_KEY_WEBOS_TEXT_OPTION 0x01200043
#define XKB_KEY_WEBOS_TEXT_MODE 0x01200044
#define XKB_KEY_WEBOS_TEXT_MIX 0x01200045
#define XKB_KEY_WEBOS_TELETEXT_SUB_PAGE 0x01200046
#define XKB_KEY_WEBOS_TELETEXT_REVEAL 0x01200047
#define XKB_KEY_WEBOS_TELETEXT_FREEZE 0x01200048
#define XKB_KEY_WEBOS_TELETEXT_POSITION 0x01200049
#define XKB_KEY_WEBOS_TELETEXT_SIZE 0x01200050
#define XKB_KEY_WEBOS_TELETEXT_IN_TIME 0x01200051
#define XKB_KEY_WEBOS_SIMPLINK 0x01200053
#define XKB_KEY_WEBOS_MULTI_PIP 0x01200054
#define XKB_KEY_WEBOS_INPUT_TVRADIO 0x01200055
#define XKB_KEY_WEBOS_PROGRAM_LIST 0x01200056
#define XKB_KEY_WEBOS_RECORD_LIST 0x01200057
#define XKB_KEY_WEBOS_STORE_MODE 0x01200058
/* Local keys (front panel buttons) */
#define XKB_KEY_WEBOS_LOCAL_UP 0x01200061
#define XKB_KEY_WEBOS_LOCAL_DOWN 0x01200062
#define XKB_KEY_WEBOS_LOCAL_LEFT 0x01200063
#define XKB_KEY_WEBOS_LOCAL_RIGHT 0x01200064
#define XKB_KEY_WEBOS_LOCAL_ENTER 0x01200065
#define XKB_KEY_WEBOS_LOCAL_LONG_PRESS 0x01200066
#define XKB_KEY_WEBOS_LOCAL_POWER 0x01200067
#define XKB_KEY_WEBOS_LOCAL_VOLUME_UP 0x01200068
#define XKB_KEY_WEBOS_LOCAL_VOLUME_DOWN 0x01200069
/* Japan Only */
#define XKB_KEY_WEBOS_BS 0x01200091
#define XKB_KEY_WEBOS_CS_1 0x01200092
#define XKB_KEY_WEBOS_CS_2 0x01200093
#define XKB_KEY_WEBOS_TER 0x01200094
#define XKB_KEY_WEBOS_3_DIGIT_INPUT 0x01200095
#define XKB_KEY_WEBOS_BMLDATA 0x01200096
#define XKB_KEY_WEBOS_JAPAN_DISPLAY 0x01200097
#define XKB_KEY_WEBOS_BS_1 0x01200111
#define XKB_KEY_WEBOS_BS_2 0x01200112
#define XKB_KEY_WEBOS_BS_3 0x01200113
#define XKB_KEY_WEBOS_BS_4 0x01200114
#define XKB_KEY_WEBOS_BS_5 0x01200115
#define XKB_KEY_WEBOS_BS_6 0x01200116
#define XKB_KEY_WEBOS_BS_7 0x01200117
#define XKB_KEY_WEBOS_BS_8 0x01200118
#define XKB_KEY_WEBOS_BS_9 0x01200119
#define XKB_KEY_WEBOS_BS_10 0x0120011a
#define XKB_KEY_WEBOS_BS_11 0x0120011b
#define XKB_KEY_WEBOS_BS_12 0x0120011c
#define XKB_KEY_WEBOS_CS_1_1 0x01200121
#define XKB_KEY_WEBOS_CS_1_2 0x01200122
#define XKB_KEY_WEBOS_CS_1_3 0x01200123
#define XKB_KEY_WEBOS_CS_1_4 0x01200124
#define XKB_KEY_WEBOS_CS_1_5 0x01200125
#define XKB_KEY_WEBOS_CS_1_6 0x01200126
#define XKB_KEY_WEBOS_CS_1_7 0x01200127
#define XKB_KEY_WEBOS_CS_1_8 0x01200128
#define XKB_KEY_WEBOS_CS_1_9 0x01200129
#define XKB_KEY_WEBOS_CS_1_10 0x0120012a
#define XKB_KEY_WEBOS_CS_1_11 0x0120012b
#define XKB_KEY_WEBOS_CS_1_12 0x0120012c
#define XKB_KEY_WEBOS_CS_2_1 0x01200131
#define XKB_KEY_WEBOS_CS_2_2 0x01200132
#define XKB_KEY_WEBOS_CS_2_3 0x01200133
#define XKB_KEY_WEBOS_CS_2_4 0x01200134
#define XKB_KEY_WEBOS_CS_2_5 0x01200135
#define XKB_KEY_WEBOS_CS_2_6 0x01200136
#define XKB_KEY_WEBOS_CS_2_7 0x01200137
#define XKB_KEY_WEBOS_CS_2_8 0x01200138
#define XKB_KEY_WEBOS_CS_2_9 0x01200139
#define XKB_KEY_WEBOS_CS_2_10 0x0120013a
#define XKB_KEY_WEBOS_CS_2_11 0x0120013b
#define XKB_KEY_WEBOS_CS_2_12 0x0120013c
#define XKB_KEY_WEBOS_TER_1 0x01200141
#define XKB_KEY_WEBOS_TER_2 0x01200142
#define XKB_KEY_WEBOS_TER_3 0x01200143
#define XKB_KEY_WEBOS_TER_4 0x01200144
#define XKB_KEY_WEBOS_TER_5 0x01200145
#define XKB_KEY_WEBOS_TER_6 0x01200146
#define XKB_KEY_WEBOS_TER_7 0x01200147
#define XKB_KEY_WEBOS_TER_8 0x01200148
#define XKB_KEY_WEBOS_TER_9 0x01200149
#define XKB_KEY_WEBOS_TER_10 0x0120014a
#define XKB_KEY_WEBOS_TER_11 0x0120014b
#define XKB_KEY_WEBOS_TER_12 0x0120014c
/* It is not a physical button but acts like a key */
#define XKB_KEY_WEBOS_CURSOR_SHOW 0x01200201
#define XKB_KEY_WEBOS_CURSOR_HIDE 0x01200202
#define XKB_KEY_WEBOS_CAMERA_VOICE 0x01200203
/* For commercial model */
#define XKB_KEY_WEBOS_TV_LINK 0x01200301
#define XKB_KEY_WEBOS_HOTEL_MODE 0x01200302
#define XKB_KEY_WEBOS_HOTEL_MODE_READY 0x01200303
/* Factory keys It is used to check the specific functionality in the factory
   or adjust the system internal settings by the developers. */
#define XKB_KEY_WEBOS_FACTORY_POWER_ONLY 0x01201001   /* P-ONLY */
#define XKB_KEY_WEBOS_FACTORY_IN_START 0x01201002   /* IN START */
#define XKB_KEY_WEBOS_FACTORY_IN_STOP 0x01201003   /* IN STOP */
#define XKB_KEY_WEBOS_FACTORY_ADJUST 0x01201004   /* ADJ */
#define XKB_KEY_WEBOS_FACTORY_TV 0x01201010   /* TV */
#define XKB_KEY_WEBOS_FACTORY_VIDEO_1 0x01201011   /* AV1 */
#define XKB_KEY_WEBOS_FACTORY_VIDEO_2 0x01201012   /* AV2 */
#define XKB_KEY_WEBOS_FACTORY_COMPONENT_1 0x01201013   /* COMP1 */
#define XKB_KEY_WEBOS_FACTORY_COMPONENT_2 0x01201014   /* COMP2 */
#define XKB_KEY_WEBOS_FACTORY_HDMI_1 0x01201015   /* HDMI1 */
#define XKB_KEY_WEBOS_FACTORY_HDMI_2 0x01201016   /* HDMI2 */
#define XKB_KEY_WEBOS_FACTORY_HDMI_3 0x01201017   /* HDMI3 */
#define XKB_KEY_WEBOS_FACTORY_HDMI_4 0x01201018   /* HDMI4 */
#define XKB_KEY_WEBOS_FACTORY_RGB_PC 0x01201019   /* RGB */
#define XKB_KEY_WEBOS_FACTORY_EYE_Q 0x01201020   /* EYE */
#define XKB_KEY_WEBOS_FACTORY_PICTURE_MODE 0x01201021   /* PSM */
#define XKB_KEY_WEBOS_FACTORY_SOUND_MODE 0x01201022   /* SSM */
#define XKB_KEY_WEBOS_FACTORY_PICTURE_CHECK 0x01201023   /* P-CHECK */
#define XKB_KEY_WEBOS_FACTORY_SOUND_CHECK 0x01201024   /* S-CHECK */
#define XKB_KEY_WEBOS_FACTORY_MULTI_SOUND_SETTING 0x01201025   /* MPX */
#define XKB_KEY_WEBOS_FACTORY_TILT 0x01201026   /* TILT */
#define XKB_KEY_WEBOS_FACTORY_PIP 0x01201027   /* PIP */
#define XKB_KEY_WEBOS_FACTORY_HDMI_CHECK 0x01201028   /* HDMI HOT */
#define XKB_KEY_WEBOS_FACTORY_USB_CHECK 0x01201029   /* USB HOT */
#define XKB_KEY_WEBOS_FACTORY_USB_2_CHECK 0x01201030   /* USB HOT */
#define XKB_KEY_WEBOS_FACTORY_POWER_OFF 0x01201031   /* 'discrete IR power off' */
#define XKB_KEY_WEBOS_FACTORY_POWER_ON 0x01201032   /* 'discrete IR power on' */
#define XKB_KEY_WEBOS_FACTORY_SUBSTRATE 0x01201033   /* 'change mode to circuit board product' */
#define XKB_KEY_WEBOS_FACTORY_VOLUME_30 0x01201034   /* 'set volume to 30' */
#define XKB_KEY_WEBOS_FACTORY_VOLUME_50 0x01201035   /* 'set volume to 50' */
#define XKB_KEY_WEBOS_FACTORY_VOLUME_80 0x01201036   /* 'set volume to 80' */
#define XKB_KEY_WEBOS_FACTORY_VOLUME_100 0x01201037   /* 'set volume to 100' */
#define XKB_KEY_WEBOS_FACTORY_WHITE_BALANCE 0x01201038   /* 'adjust white balance' */
#define XKB_KEY_WEBOS_FACTORY_3_DPATTERN 0x01201039   /* '3D pattern' */
#define XKB_KEY_WEBOS_FACTORY_SELF_DIAGNOSIS 0x01201040   /* 'self diagnosis' */
#define XKB_KEY_WEBOS_FACTORY_PATTERN_CHECK 0x01201041   /* 'pattern check on p-only mode' */
#define XKB_KEY_WEBOS_FACTORY_QRCHECK 0x01201042   /* 'QR code check on p-only mode' */
/* Another key codes for local keys (power only full-white mode) */
#define XKB_KEY_WEBOS_FACTORY_LOCAL_UP 0x01201061
#define XKB_KEY_WEBOS_FACTORY_LOCAL_DOWN 0x01201062
#define XKB_KEY_WEBOS_FACTORY_LOCAL_LEFT 0x01201063
#define XKB_KEY_WEBOS_FACTORY_LOCAL_RIGHT 0x01201064
#define XKB_KEY_WEBOS_FACTORY_LOCAL_ENTER 0x01201065
#define XKB_KEY_WEBOS_CEC_POWER 0x01202000
#define XKB_KEY_WEBOS_CEC_MEDIA_HOME 0x01202001
#define XKB_KEY_WEBOS_CEC_INFO_MENU 0x01202002
#define XKB_KEY_WEBOS_CEC_INPUT 0x01202003
#define XKB_KEY_WEBOS_CEC_TITLE_POPUP 0x01202004
#define XKB_KEY_WEBOS_CEC_TV_GUIDE 0x01202005
#define XKB_KEY_WEBOS_CEC_CONTENTS_MENU 0x01202006
#define XKB_KEY_WEBOS_CEC_SKIP_BACK_10 0x01202007
#define XKB_KEY_WEBOS_CEC_SKIP_FORWARD_30 0x01202008
#define XKB_KEY_WEBOS_MHL_SCREEN_REMOTE 0x01202032
#define XKB_KEY_WEBOS_VIRTUAL_TELE_TEXT 0x01202042

// In goldilocks InputMethodAuraLinux::OnPreeditChanged generates key event for each input from IME
// This key event can be delivered to app as a keycode 229
// should handle this keycodes in somewhere to block unexpected keyevent
// This keycode is not related to LSM
#define XKB_KEY_WEBOS_IMEPROCESS 0x01200401

#endif  // WEBOS_COMMON_WEBOS_KEYBOARD_CODES_H_
