# Copyright (C) 2003, 2004 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from chestnut_dialer.sig import Signal

class NoAccountException(Exception):
  def __init__(self, account_id): self.account_id = account_id
  
class _AccountMeta:
  def __init__(self):
    self._attrs_info = {
      'answer_cmd': {
	'type': 'string'},
      'ask_passwd': {
	'type': 'boolean'},
      'auth_type': {
	'type': 'string'},
      'busy_resp': {
	'type': 'string'},
      'callback': {
	'type': 'boolean'},
      'callback_init_cmd': {
	'type': 'string'},
      'callback_init2_cmd': {
	'type': 'string'},
      'callback_phone_number': {
	'type': 'string'},
      'chat_login_prompt': {
	'type': 'string'},
      'chat_passwd_prompt': {
	'type': 'string'},
      'chat_script': {
	'type': 'text'},
      'comment': {
	'type': 'text'},
      'connect_program': {
	'type': 'string'},
      'connect_resp': {
	'type': 'string'},
      'default_route': {
	'type': 'boolean'},
      'device': {
	'type': 'string'},
      'dial_cmd': {
	'type': 'string'},
      'dial_prefix': {
	'type': 'string'},
      'dial_timeout': {
	'type': 'integer'},
      'disconnect_program': {
	'type': 'string'},
      'dns_servers': {
	'type': 'list'},
      'error_resp': {
	'type': 'string'},
      'flow_control': {
	'type': 'string'},
      'hangup_cmd': {
	'type': 'string'},
      'hangup_resp': {
	'type': 'string'},
      'id': {
	'type': 'integer'},
      'init_cmd': {
	'type': 'string'},
      'init_resp': {
	'type': 'string'},
      'init2_cmd': {
	'type': 'string'},
      'ip': {
	'type': 'string'},
      'lock_device': {
	'type': 'boolean'},
      'low_vol_cmd': {
	'type': 'string'},
      'mask': {
	'type': 'string'},
      'max_vol_cmd': {
	'type': 'string'},
      'min_speed': {
	'type': 'integer'},
      'modem': {
	'type': 'boolean'},
      'modem_term': {
	'type': 'string'},
      'modem_timeout': {
	'type': 'integer'},
      'mru': {
	'type': 'integer'},
      'mtu': {
	'type': 'integer'},
      'mute_cmd': {
	'type': 'string'},
      'name': {
	'type': 'string'},
      'noanswer_resp': {
	'type': 'string'},
      'nocarrier_resp': {
	'type': 'string'},
      'nodialtone_resp': {
	'type': 'string'},
      'passwd': {
	'type': 'string'},
      'phone_numbers': {
	'type': 'list'},
      'ppp_options': {
	'type': 'string'},
      'ppp_timeout': {
	'type': 'integer'},
      'prompt_timeout': {
	'type': 'integer'},
      'redial_attempts': {
	'type': 'integer'},
      'redial_auto': {
	'type': 'boolean'},
      'redial_if': {
        'type': 'list'},
      'remote': {
	'type': 'string'},
      'remotename': {
	'type': 'string'},
      'ring_resp': {
	'type': 'string'},
      'speed': {
	'type': 'string'},
      'user': {
	'type': 'string'},
      'use_passwordfd': {
	'type': 'boolean'},
      'use_script': {
	'type': 'string'},
      'vol_resp': {
	'type': 'string'},
      'volume_setting': {
	'type': 'integer'},
      }
    self.keys = self._attrs_info.keys
    self.has_key = self._attrs_info.has_key
  def get_attr_type(self, attr):
    try: return self._attrs_info[attr]['type']
    except KeyError: return None
  def get_attr_type_dict(self):
    d = {}
    for k in self._attrs_info.keys():
      d[k] = self._attrs_info[k]['type']
    return d

class Account:
  """Base abstract class for account."""
  meta = _AccountMeta()
  attr_changed_signal = None
  _default_account = None
  def __init__(self):
    self.attr_changed_signal = Signal()
  def set_default_account(self, account):
    self._default_account = account
  def get_default_account(self):
    return self._default_account
  def _get_acc_attr(self, name):
    return None
  def _set_acc_attr(self, name, value):
    pass
  def __getattr__(self, name):
    if name[0:1] == "_": raise AttributeError(name)
    if not Account.meta.has_key(name):
      raise AttributeError(name)
    defacc = self._default_account
    value = self._get_acc_attr(name)
    if value == None and defacc != None:
      value = getattr(defacc, name)
    return value
  def __setattr__(self, name, value):
    if name[:1] != "_" and Account.meta.has_key(name):
      if self._get_acc_attr(name) != value:
        self._set_acc_attr(name, value)
        self.attr_changed_signal(name, value)
      return
    self.__dict__[name] = value
  def __getitem__(self, key):
    try: return getattr(self, key)
    except AttributeError: raise KeyError(key)
  def __setitem__(self, key, value):
    if Account.meta.has_key(key):
      setattr(self, key, value)
    else: raise KeyError(key)
  def copy(self):
    d = {}
    for attr in Account.meta.keys():
      d.update({attr: getattr(self, attr)})
    return d
  def keys(self):
    return Account.meta.keys()
  def has_key(self, key):
    return Account.meta.has_key(key)
  def get_attr_type(self, attr):
    return Account.meta.get_attr_type(attr)
  def get_attr_type_dict(self):
    return Account.meta.get_attr_type_dict()
  def update(self, d):
    for attr in d.keys():
      if Account.meta.has_key(attr) and attr != 'id':
        setattr(self, attr, d[attr])

class AccountSet:
  """Base abstract class for account set."""
  changed_signal = None
  def __init__(self):
    self.changed_signal = Signal()
  def ls_accounts(self):
    "List avaible accounts. Return list of tupe [(account_name, account_id), ...]"
    pass
  def get_account(self, account_id):
    "Return account object."
    raise NoAccountException(account_id)
  def new_account(self, name = None):
    """Create new account and return new account object.
if name != None assign name to new account name"""
    pass
  def insert_account(self, account):
    acc = self.new_account()
    acc.update(account)
    return acc
  def remove_accounts(self, account_ids):
    "Remove accounts. account_ids - list of account identifiers."
    pass
  def duplicate_account(self, account_id, name = None):
    """Duplicate account and return new account object.
if name != None assign name to new account name"""
    acc = self.insert_account(self.get_account(account_id))
    if name != None: acc.name = name
    return acc
