#!/bin/bash

WKDIR="$(pwd)"

mkdir livebuildk

cd livebuildk

lb config --apt-recommends true --architectures amd64 --archive-areas "main contrib non-free non-free-firmware" --binary-images iso-hybrid --bootappend-live "boot=live components hostname=gluz-host locales=es_ES keyboard-layouts=es,es"  --cache true --debian-installer live --debian-installer-gui true --distribution bookworm --firmware-binary true --firmware-chroot true --image-name "gluz-kde.iso" --iso-application gluz --iso-preparer OSLUZ --iso-publisher https://osluz.unizar.es --iso-volume gluz_3.2 --linux-flavours amd64 --mode debian --parent-mirror-bootstrap "http://softlibre.unizar.es/debian" --security true --updates true --win32-loader false

echo "accountsservice akregator arc-theme asunder breeze-gtk-theme breeze-icon-theme gnome-keyring gnome-nettool gnome-system-tools greybird-gtk-theme gthumb guvcview gvfs-fuse k3b kcalc kde-cli-tools kde-cli-tools-data kde-config-cddb kde-config-cron kde-config-screenlocker kde-config-sddm kde-config-systemd kde-full kde-spectacle khelpcenter konq-plugins kwalletmanager libpam-kwallet5 materia-kde normalize-audio numix-gtk-theme plasma-theme-oxygen print-manager qt5-style-kvantum qt5-style-kvantum-l10n qt5-style-kvantum-themes remmina sddm sddm-theme-breeze sddm-theme-debian-breeze skanlite sweeper systemsettings task-kde-desktop task-spanish task-spanish-desktop task-spanish-kde-desktop" > $WKDIR/livebuildk/config/package-lists/kdedesktop.list.chroot

echo "aisleriot alsa-utils apparmor apt-file apt-transport-https audacity autoconf automake bash-completion bleachbit build-essential busybox-static b43-fwcutter cdtool cdrdao cdrskin cifs-utils clamav clamav-daemon clamtk command-not-found cpio cups cups-filters curl cron davfs2 default-jdk default-jre dialog dirmngr dkms dmidecode dnsutils dos2unix dosbox dosfstools dpkg-dev dvdauthor elisa faac faad fakeroot ffmpeg file firefox-esr-l10n-es-es flac flameshot fonts-freefont-otf fonts-freefont-ttf frei0r-plugins friendly-recovery ftp fuse3 fwupdate gcc gdebi gimp git gnome-chess gnome-disk-utility gnome-mahjongg gparted grsync grub-pc gstreamer1.0-libav gstreamer1.0-plugins-bad gstreamer1.0-plugins-ugly gstreamer1.0-plugins-good gstreamer1.0-pulseaudio gthumb gvfs gvfs-backends gvfs-fuse g++ handbrake handbrake-cli hardinfo haveged hdparm htop icedtea-netx iftop imagemagick info inxi iptables iputils-tracepath irqbalance isenkram-cli isolinux jfsutils keepassxc kget kgpg kolourpaint kompare kpat ksystemlog ktorrent kwave kwin-addons lame less libclamunrar libreoffice-help-es libreoffice-l10n-es libnotify-bin libnss-mdns libpam-systemd libqt5opengl5 libsmbclient libxvidcore4 linux-headers-amd64 live-build logrotate lsb-release lshw lsof ltrace man-db manpages mencoder menu mime-support mjpegtools mlocate module-assistant mpg321 mtools nano neofetch netcat-openbsd network-manager-openvpn ntfs-3g nvidia-detect nvidia-openjdk-8-jre obs-studio openvpn openvpn-systemd-resolved openssh-client openssh-server papirus-icon-theme parted patch pciutils plymouth pptp-linux printer-driver-all psensor psmisc p7zip-full p7zip-rar rar rename rsync setserial shotcut simple-scan simplescreenrecorder software-properties-common soundconverter sox squashfs-tools strace streamripper sudo svgpart synaptic syslinux syslinux-common systemd systemd-sysv tcpdump telegram-desktop telnet testdisk thunderbird thunderbird-l10n-es-es thunderbolt-tools time transmission-gtk twolame ufw unrar usbutils uuid-runtime vlc vlc-l10n wget xfsprogs xorriso xserver-xorg-input-synaptics x264 x265 zulucrypt-gui zulumount-gui zulupolkit" > $WKDIR/livebuildk/config/package-lists/packages.list.chroot

echo "atmel-firmware bluez-firmware firmware-linux-free midisport-firmware firmware-misc-nonfree firmware-amd-graphics firmware-atheros firmware-bnx2 firmware-bnx2x firmware-brcm80211 firmware-cavium firmware-intel-sound firmware-iwlwifi firmware-libertas firmware-linux firmware-linux-nonfree firmware-misc-nonfree firmware-myricom firmware-netronome firmware-netxen firmware-qcom-media firmware-qcom-soc firmware-qlogic firmware-realtek firmware-samsung firmware-siano firmware-ti-connectivity firmware-sof-signed firmware-zd1211" > $WKDIR/livebuildk/config/package-lists/firmware.list.chroot

echo "efibootmgr grub-common grub-pc-bin grub2-common grub-efi-amd64 grub-efi-amd64-bin grub-efi-amd64-signed grub-efi-ia32-bin libefiboot1 libefivar1 mokutil os-prober shim-helpers-amd64-signed shim-signed shim-signed-common shim-unsigned" > $WKDIR/livebuildk/config/package-lists/grubs.list.binary

# DRIVERS INALÁMBRICOS BROADCOM
echo "b43-fwcutter firmware-b43-installer firmware-b43legacy-installer" > $WKDIR/livebuildk/config/package-lists/bcmfirmware.list.chroot

# CALAMARES
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/applications
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/skel/Desktop
cp -r $WKDIR/gluz3/calamares/ $WKDIR/livebuildk/config/includes.chroot/etc/
cp $WKDIR/gluz3/calamares/usr/share/applications/install-debian.desktop $WKDIR/livebuildk/config/includes.chroot/usr/share/applications/install-debian.desktop
echo "calamares calamares-settings-debian" > $WKDIR/livebuildk/config/package-lists/calamares.list.chroot

# TOUCHPAD
echo "xserver-xorg-input-libinput" > $WKDIR/livebuildk/config/package-lists/touchpad.list.chroot
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/X11/xorg.conf.d/
cp $WKDIR/gluz3/touchpad/* $WKDIR/livebuildk/config/includes.chroot/etc/X11/xorg.conf.d/

# BOOTLOADERS
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc/
cp -r $WKDIR/gluz3/bootloaders $WKDIR/livebuildk/config
cp $WKDIR/gluz3/bootloaders/splash.png $WKDIR/livebuildk/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc/splash.png

# BACKGROUNDS
## Creación directorios
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/images/desktop-base
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/emerald-theme/wallpaper/contents/images

##
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/wallpaper/contents/images
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/homeworld
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login
##
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/futureprototype
##

mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/lines
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/moonlight
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/softwaves
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/active-theme/grubs
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/

##
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/wallpapers/Next/contents/images
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc

## Copia
cp -r $WKDIR/gluz3/backgrounds/* $WKDIR/livebuildk/config/includes.chroot/usr/share/images/desktop-base/
cp -r $WKDIR/gluz3/backgrounds2/* $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/emerald-theme/wallpaper/contents/images/
##

cp -r $WKDIR/gluz3/backgrounds2/* $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/wallpaper/contents/images
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/homeworld/debian.png
##
##

cp -r $WKDIR/gluz3/backgrounds2/jpg/* $WKDIR/livebuildk/config/includes.chroot/usr/share/wallpapers/Next/contents/images/

##
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/futureprototype/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/lines/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/moonlight/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuildk/config/includes.chroot/usr/share/plymouth/themes/softwaves/debian.png
cp $WKDIR/gluz3/backgrounds2/gluz_640x480.jpg $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/grub-4x3.png
cp $WKDIR/gluz3/backgrounds2/gluz1920x1080.jpg $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/grub-16x9.png
cp $WKDIR/gluz3/backgrounds2/splashgluz640x480.png $WKDIR/livebuildk/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc/splash.png
cp $WKDIR/gluz3/backgrounds2/2620x1474.svg $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login/background.svg
cp $WKDIR/gluz3/backgrounds2/2620x1474.svg $WKDIR/livebuildk/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login/background-nologo.svg

# ICONOS
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/icons/default
cp -r $WKDIR/gluz3/icons/* $WKDIR/livebuildk/config/includes.chroot/usr/share/icons/default/

# DOCUMENTOS
## Creación directorios de documentos
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/livebuildk
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/driverimpresorasharp
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/guestAdditions
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/skel/.config
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/skel/.local

## Copia de directorios de documentos
cp -r $WKDIR/gluz3/doc/* $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/livebuildk/
cp -a $WKDIR/gluz3/sharp/* $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/driverimpresorasharp/
cp -r $WKDIR/gluz3/panel/* $WKDIR/livebuildk/config/includes.chroot/etc/skel/.config
cp -r $WKDIR/gluz3/share $WKDIR/livebuildk/config/includes.chroot/etc/skel/.local/share

# Enlaces simbólicos de documentos
ln -s /usr/share/doc/livebuildk $WKDIR/livebuildk/config/includes.chroot/etc/skel/Desktop/informacion
ln -s /usr/share/doc/driverimpresorasharp $WKDIR/livebuildk/config/includes.chroot/etc/skel/Desktop/
#ln -s /usr/share/doc/guestAdditions $WKDIR/livebuildk/config/includes.chroot/etc/skel/Desktop/


# USUARIOS ADMINISTRADORES
cp -r $WKDIR/gluz3/instalador/* $WKDIR/livebuildk/config/includes.installer/preseed.cfg

# REPOS
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/apt
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/repos
cp $WKDIR/gluz3/sources/sources.list $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/repos
#cp $WKDIR/gluz3/sources/sources.list $WKDIR/livebuildk/config/includes.chroot/etc/apt/sources.list

# NAVEGADOR
## Creación directorio
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/firefox

## Copia
cp $WKDIR/gluz3/navegador/defaults.list $WKDIR/livebuildk/config/includes.chroot/usr/share/applications/defaults.list
cp -r $WKDIR/gluz3/navegador/mimeapps.list $WKDIR/livebuildk/config/includes.chroot/etc/skel/.config/mimeapps.list
cp $WKDIR/gluz3/firefox/firefox.js $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/firefox

# GUEST ADDITIONS
## Creación directorios
mkdir -p $WKDIR/livebuildk/config/includes.chroot/etc/guest
mkdir -p $WKDIR/livebuildk/config/includes.chroot/usr/local/bin

## Copia
cp -ar $WKDIR/gluz3/guestAdditions/* $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/guestAdditions/
cp -r $WKDIR/gluz3/hooks/guest_7.0.6/* $WKDIR/livebuildk/config/includes.chroot/etc/guest
cp $WKDIR/gluz3/scripts/* $WKDIR/livebuildk/config/includes.chroot/usr/local/bin/

# EJECUTABLES DE ESCRITORIO
cp -r $WKDIR/gluz3/ejecutables/sources/sources.sh $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/repos/
cp -r $WKDIR/gluz3/ejecutables/sources/sources.desktop $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/repos/
cp $WKDIR/livebuildk/config/includes.chroot/usr/share/doc/repos/sources.desktop $WKDIR/livebuildk/config/includes.chroot/etc/skel/Desktop/

## HOOKS
## Creación directorios
mkdir -p $WKDIR/livebuildk/config/hooks/normal
mkdir -p $WKDIR/livebuildk/config/hooks/live
mkdir -p $WKDIR/livebuildk/config/includes.chroot/lib/live/config

## Copia
cp -r $WKDIR/gluz3/hooks/* $WKDIR/livebuildk/config/hooks/normal/
cp -r $WKDIR/gluz3/hooks/* $WKDIR/livebuildk/config/hooks/live/
cp $WKDIR/gluz3/hooks/9999-calamares.hook.chroot $WKDIR/livebuildk/config/includes.chroot/lib/live/config/
cp $WKDIR/gluz3/hooks/0005-configurar-repos-gluz.hook.chroot $WKDIR/livebuildk/config/includes.chroot/lib/live/config/
cp $WKDIR/gluz3/hooks/0006-firefox.hook.chroot $WKDIR/livebuildk/config/includes.chroot/lib/live/config/


lb build #>> $WKDIR/iso.log

mv $WKDIR/livebuildk/gluz-kde.iso-amd64.hybrid.iso $WKDIR/gluz-kde.iso
rm -r $WKDIR/livebuildk
