#!/bin/bash
#
# Author: Khurram M. <makhmct@hotmail.com>
# Script Version: 1.2
# Script type: Opensource, Debian 9/Stretch
# Licensed: GPL v3
# Created on: 24 November 2017
# Last edited: 22 December 2017
#
# Tested to work on: VirtualBox 5.2, 64-bit
# Host: Arch Linux, kernel ver 4.13.12-1
# Guests: Debian 9.2, 
#

echo 'Checking if run as Root...'
if [[ $EUID -ne 0 ]]
   then
      echo "[ERROR] This script must be run as root."
      echo "Exiting ..."
      exit 1
   else
      echo "[OK] This script is run by the root."
fi

echo "Testing the dependencies..."

if [dpkg-query -W -f='${Status}' dkms 2>/dev/null | grep -c "ok installed"] -eq 0; then apt update; apt install dkms; fi
if [dpkg-query -W -f='${Status}' gcc 2>/dev/null | grep -c "ok installed"] -eq 0; then apt update; apt install gcc; fi
if [dpkg-query -W -f='${Status}' make 2>/dev/null | grep -c "ok installed"] -eq 0; then apt update; apt install make; fi
if [dpkg-query -W -f='${Status}' perl 2>/dev/null | grep -c "ok installed"] -eq 0; then apt update; apt install dkms; fi
if [dpkg-query -W -f='${Status}' linux-headers-$(uname -r|sed 's,[^-]*-[^-]*-,,') 2>/dev/null | grep -c "ok installed"] -eq 0; then apt update; apt install linux-headers-$(uname -r|sed 's,[^-]*-[^-]*-,,'); fi

echo "[OK] All the dependencies are met. Good to go."

echo

echo 'Checking mount point...'
file1="/mnt/cdrom"
if [ ! -f "$file1" ]
	then
		echo "File $file1 does not exist."
		echo 'Creating the Mount point...'
		mkdir -pv /mnt/cdrom && echo '[OK] Mount point created ...'
	else
		echo "[OK] Mount point $file1 exists..."
fi

echo

echo 'Mounting the disk...'
mount -v /dev/sr0 /mnt/cdrom && echo '[OK] Disk Mounted ...'

echo

echo 'Installing the guest addition modules...'

echo

sh /mnt/cdrom/VBoxLinuxAdditions.run && echo '[OK] Guest additions installed ...'

echo

echo 'Umounting disk...'
umount -v /dev/sr0 && echo '[OK] Umount of disk is successful'

echo '[OK] Exiting the script ... Have a nice day! :) ... '

exit 1
