#!/bin/bash

WKDIR="$(pwd)"

mkdir livebuild

cd livebuild

lb config --apt-recommends true --architectures amd64 --archive-areas "main contrib non-free non-free-firmware" --binary-images iso-hybrid --bootappend-live "boot=live components hostname=gluz-host locales=es_ES.UTF-8 keyboard-layouts=es,es" --cache true --debian-installer live --debian-installer-gui true --distribution bookworm --firmware-binary true --firmware-chroot true --image-name "gluz-xfce.iso" --iso-application gluz --iso-preparer OSLUZ --iso-publisher https://osluz.unizar.es --iso-volume gluz_3.2 --linux-flavours amd64 --mode debian --security true --updates true --win32-loader false

echo "arc-theme asunder breeze-gtk-theme breeze-icon-theme galculator gnome-keyring gnome-nettool gnome-system-tools greybird-gtk-theme gthumb guvcview gvfs-fuse network-manager-openvpn numix-gtk-theme remmina simple-scan task-xfce-desktop xfce4 xfce4-goodies xfce4-power-manager xfce4-terminal xscreensaver" > $WKDIR/livebuild/config/package-lists/xfcedesktop.list.chroot

echo "aisleriot alsa-utils apparmor apt-file apt-transport-https ark audacity autoconf automake bash-completion bleachbit build-essential busybox-static b43-fwcutter cdtool cdrdao cdrskin cifs-utils clamav clamav-daemon clamtk command-not-found cpio cups cups-filters curl cron default-jdk dialog dirmngr dkms dmidecode dnsutils dolphin dolphin-dev dos2unix dosbox dosfstools dpkg-dev dvdauthor faac faad fakeroot ffmpeg file firefox-esr-l10n-es-es flac flameshot fonts-freefont-otf fonts-freefont-ttf frei0r-plugins friendly-recovery ftp fuse3 fwupdate gcc gdebi gimp git gnome-chess gnome-disk-utility gnome-mahjongg gparted grsync grub-pc gstreamer1.0-libav gstreamer1.0-plugins-bad gstreamer1.0-plugins-ugly gstreamer1.0-plugins-good gstreamer1.0-pulseaudio gthumb gvfs gvfs-backends gvfs-fuse g++ handbrake handbrake-cli hardinfo haveged hdparm htop icedtea-netx iftop info inxi iptables iputils-tracepath irqbalance isolinux jfsutils kate keepassxc konsole kpartx lame less libavcodec-extra libreoffice-help-es libreoffice-l10n-es libnss3-tools libpam-systemd libqt5opengl5 libxvidcore4 linux-headers-amd64 live-build logrotate lsb-release lshw lsof ltrace make man-db manpages mencoder menu mime-support mjpegtools mlocate module-assistant mpg321 mtools nano neofetch network-manager-openvpn ntfs-3g nvidia-detect nvidia-openjdk-8-jre obs-studio openjdk-17-jre openvpn openvpn-systemd-resolved openssh-client openssh-server papirus-icon-theme parted patch pciutils plymouth pptp-linux printer-driver-all psensor psmisc p7zip-full p7zip-rar rar rename rsync setserial shotcut simple-scan simplescreenrecorder software-properties-common soundconverter sox squashfs-tools strace streamripper sudo synaptic syslinux syslinux-common systemd-sysv tcpdump telegram-desktop telnet testdisk thunderbird thunderbird-l10n-es-es thunderbolt-tools time transmission-gtk twolame ufw unrar usbutils uuid-runtime vorbis-tools vlc vlc-l10n wget xfsprogs xorriso x264 x265 zulucrypt-gui zulumount-gui zulupolkit" > $WKDIR/livebuild/config/package-lists/packages.list.chroot

echo "atmel-firmware bluez-firmware firmware-linux-free midisport-firmware firmware-misc-nonfree firmware-amd-graphics firmware-atheros firmware-bnx2 firmware-bnx2x firmware-brcm80211 firmware-cavium firmware-intel-sound firmware-iwlwifi firmware-libertas firmware-linux firmware-linux-nonfree firmware-misc-nonfree firmware-myricom firmware-netronome firmware-netxen firmware-qcom-media firmware-qcom-soc firmware-qlogic firmware-realtek firmware-samsung firmware-siano firmware-ti-connectivity firmware-sof-signed firmware-zd1211" > $WKDIR/livebuild/config/package-lists/firmware.list.chroot

echo "efibootmgr grub-common grub-pc-bin grub2-common grub-efi-amd64 grub-efi-amd64-bin grub-efi-amd64-signed grub-efi-ia32-bin libefiboot1 libefivar1 mokutil os-prober shim-helpers-amd64-signed shim-signed shim-signed-common shim-unsigned" > $WKDIR/livebuild/config/package-lists/grubs.list.binary

# DRIVERS INALÁMBRICOS
echo "b43-fwcutter firmware-b43-installer firmware-b43legacy-installer" > $WKDIR/livebuild/config/package-lists/bcmfirmware.list.chroot

# CALAMARES
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/applications/
cp -r $WKDIR/gluz3/calamares/ $WKDIR/livebuild/config/includes.chroot/etc/
cp $WKDIR/gluz3/calamares/usr/share/applications/install-debian.desktop $WKDIR/livebuild/config/includes.chroot/usr/share/applications/install-debian.desktop
echo "calamares calamares-settings-debian" > $WKDIR/livebuild/config/package-lists/calamares.list.chroot

# TOUCHPAD
echo "xserver-xorg-input-libinput" > $WKDIR/livebuild/config/package-lists/touchpad.list.chroot
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/X11/xorg.conf.d/
cp $WKDIR/gluz3/touchpad/* $WKDIR/livebuild/config/includes.chroot/etc/X11/xorg.conf.d/


# BOOTLOADERS
cp -r $WKDIR/gluz3/bootloaders/ $WKDIR/livebuild/config/

# BACKGROUNDS
## Creación directorios
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/images/desktop-base
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/emerald-theme/wallpaper/contents/images
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/wallpaper/contents/images
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/homeworld
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/futureprototype
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/lines
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/moonlight
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/softwaves
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/active-theme/grubs
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc

## Copia
cp -r $WKDIR/gluz3/backgrounds/* $WKDIR/livebuild/config/includes.chroot/usr/share/images/desktop-base/
cp -r $WKDIR/gluz3/backgrounds2/* $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/emerald-theme/wallpaper/contents/images/
cp -r $WKDIR/gluz3/backgrounds2/* $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/wallpaper/contents/images/
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/homeworld/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/futureprototype/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/lines/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/moonlight/debian.png
cp $WKDIR/gluz3/backgrounds2/logogluz264.png $WKDIR/livebuild/config/includes.chroot/usr/share/plymouth/themes/softwaves/debian.png
cp $WKDIR/gluz3/backgrounds2/gluz_640x480.jpg $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/grub-4x3.png
cp $WKDIR/gluz3/backgrounds2/gluz1920x1080.jpg $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/grub/grub-16x9.png
cp $WKDIR/gluz3/backgrounds2/splashgluz640x480.png $WKDIR/livebuild/config/includes.chroot/usr/share/live/build/bootloaders/grub-pc/splash.png
cp $WKDIR/gluz3/backgrounds2/2620x1474.svg $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login/background.svg
cp $WKDIR/gluz3/backgrounds2/2620x1474.svg $WKDIR/livebuild/config/includes.chroot/usr/share/desktop-base/homeworld-theme/login/background-nologo.svg

# ICONOS
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/icons/default
cp -r $WKDIR/gluz3/icons/* $WKDIR/livebuild/config/includes.chroot/usr/share/icons/default/

# DOCUMENTOS
## Creación directorios de documentos
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/skel/Desktop/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/doc/livebuild/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/doc/driverimpresorasharp/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/doc/guestAdditions
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/skel/.config/
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/skel/.local/

## Copia de directorios de documentos
cp -r $WKDIR/gluz3/doc/* $WKDIR/livebuild/config/includes.chroot/usr/share/doc/livebuild/
cp -a $WKDIR/gluz3/sharp/* $WKDIR/livebuild/config/includes.chroot/usr/share/doc/driverimpresorasharp/
cp -r $WKDIR/gluz3/xfce4/ $WKDIR/livebuild/config/includes.chroot/etc/skel/.config/
cp -r $WKDIR/gluz3/share $WKDIR/livebuild/config/includes.chroot/etc/skel/.local/share

# Enlaces simbólicos de documentos
ln -s /usr/share/doc/livebuild $WKDIR/livebuild/config/includes.chroot/etc/skel/Desktop/informacion
ln -s /usr/share/doc/driverimpresorasharp $WKDIR/livebuild/config/includes.chroot/etc/skel/Desktop/
#ln -s /usr/share/doc/guestAdditions $WKDIR/livebuild/config/includes.chroot/etc/skel/Desktop/


# USUARIOS ADMINISTRADORES
cp -r $WKDIR/gluz3/instalador/* $WKDIR/livebuild/config/includes.installer/preseed.cfg

# REPOS
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/apt/
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/doc/repos/
cp $WKDIR/gluz3/sources/sources.list $WKDIR/livebuild/config/includes.chroot/usr/share/doc/repos
#cp $WKDIR/gluz3/sources/sources.list $WKDIR/livebuild/config/includes.chroot/etc/apt/sources.list

# DOLPHIN
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/xdg/xfce4/
cp -r $WKDIR/gluz3/dolphin/* $WKDIR/livebuild/config/includes.chroot/etc/xdg/xfce4/

# NAVEGADOR
## Creación directorio
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/share/doc/firefox/

## Copia
cp $WKDIR/gluz3/navegador/defaults.list $WKDIR/livebuild/config/includes.chroot/usr/share/applications/defaults.list
cp $WKDIR/gluz3/firefox/firefox.js $WKDIR/livebuild/config/includes.chroot/usr/share/doc/firefox

# GUEST ADDITIONS
## Creación directorios
mkdir -p $WKDIR/livebuild/config/includes.chroot/etc/guest
mkdir -p $WKDIR/livebuild/config/includes.chroot/usr/local/bin

## Copia
cp -ar $WKDIR/gluz3/guestAdditions/* $WKDIR/livebuild/config/includes.chroot/usr/share/doc/guestAdditions/
cp -r $WKDIR/gluz3/hooks/guest_7.0.6/* $WKDIR/livebuild/config/includes.chroot/etc/guest
cp $WKDIR/gluz3/scripts/guestadditions.sh $WKDIR/livebuild/config/includes.chroot/usr/local/bin/

# EJECUTABLES DE ESCRITORIO
cp -r $WKDIR/gluz3/ejecutables/sources/sources.sh $WKDIR/livebuild/config/includes.chroot/usr/share/doc/repos/
cp -r $WKDIR/gluz3/ejecutables/sources/sources.desktop $WKDIR/livebuild/config/includes.chroot/usr/share/doc/repos/
cp $WKDIR/livebuild/config/includes.chroot/usr/share/doc/repos/sources.desktop $WKDIR/livebuild/config/includes.chroot/etc/skel/Desktop/

## HOOKS
## Creación directorios
mkdir -p $WKDIR/livebuild/config/hooks/normal
mkdir -p $WKDIR/livebuild/config/hooks/live
mkdir -p $WKDIR/livebuild/config/includes.chroot/lib/live/config

## Copia
cp -r $WKDIR/gluz3/hooks/* $WKDIR/livebuild/config/hooks/normal/
cp -r $WKDIR/gluz3/hooks/* $WKDIR/livebuild/config/hooks/live/
cp $WKDIR/gluz3/hooks/0005-configurar-repos-gluz.hook.chroot $WKDIR/livebuild/config/includes.chroot/lib/live/config/
cp $WKDIR/gluz3/hooks/0006-firefox.hook.chroot $WKDIR/livebuild/config/includes.chroot/lib/live/config/

lb build #2>> $WKDIR/iso.log

mv $WKDIR/livebuild/gluz-xfce.iso-amd64.hybrid.iso $WKDIR/gluz-xfce.iso
rm -r $WKDIR/livebuild
