{$W-,R+,V-,G+}
unit wbibeps;

interface

Uses
  WinTypes,WinProcs,WObjects,strings;

const
  { Callback messages }
  GSDLL_STDIN  = 1;   { get count characters to str from stdin  }
                      {   return number of characters read      }
  GSDLL_STDOUT = 2;   { put count characters from str to stdout }
                      {   return number of characters written   }
  GSDLL_DEVICE = 3;   { device = str has been opened if count=1 }
                      {                    or closed if count=0 }
  GSDLL_SYNC   = 4;   { sync_output for device str              } 
  GSDLL_PAGE   = 5;   { output_page for device str              }
  GSDLL_SIZE   = 6;   { resize for device str                   }
                      {   LOWORD(count) is new xsize            }
                      {   HIWORD(count) is new ysize            }
  GSDLL_POLL   = 7;   { Called from gp_check_interrupt          }
			  { Can be used by caller to poll the message queue       }
			  { Normally returns 0                                    }
			  { To abort gsdll_execute_cont(), return a               }
			  { non zero error code until gsdll_execute_cont()        }
			  { returns                                               }

  { gsdll_init return codes }
  GSDLL_INIT_IN_USE = 100;    { DLL is in use                       }
  GSDLL_INIT_QUIT   = 101;    { quit or EOF during init             }
                              {    This is not an error.            }
                              {    gsdll_exit() must not be called. }

  MaxArgv = 5;

type
{$IFDEF REVC}
  TGSCallback = function(count : longint; S: PChar; Message: integer): integer;
{$ELSE}
  TGSCallback = function(Message: integer; S: PChar; count : longint): integer;
{$ENDIF}
  PPchar = ^PChar;
  TPCharArr = array[0..MaxArgv-1] of PChar;
  PPCharArr = ^TPCharArr;

{var
  GsInitStr,GsDir: PChar;}

function  gsdll_revision(Product,Copyright: PPChar;
                         gs_revision,gs_revisiondate: Plongint): integer;
function  gsdll_init(Callback: TGSCallback; Wnd: HWnd; argc: integer;
                     argv: TPCharArr): integer;
function  gsdll_execute_begin: integer;
function  gsdll_execute_cont(S: PChar; len: integer): integer;
function  gsdll_execute_end: integer;
function  gsdll_exit: integer;
function  gsdll_lock_device(Device: PChar; flag: integer): integer;

function  gsdll_copy_DIB(Device: PChar): THandle;
function  gsdll_copy_palette(Device: PChar): HPalette;
procedure gsdll_draw(Device: PChar; DC: hDC; dest,src: PRect);
function  gsdll_get_bitmap_row(Device: PChar; pbmih: PBitmapInfoHeader): integer;

procedure InitEpsDLL(GsDir: PChar);
procedure UnloadEpsDLL;

implementation

type
  TGSRevision   = function(Product,Copyright: PPChar;
                           gs_revision,gs_revisiondate: Plongint): integer;
{$IFDEF REV}
  TGSInit       = function(argv: TPCharArr; argc: integer;
                           Wnd: HWnd; Callback: TGSCallback): integer;
{$ELSE}
  TGSInit       = function(Callback: TGSCallback; Wnd: HWnd; argc: integer;
                     argv: TPCharArr): integer;          
{$ENDIF}
  TGSExecBegin  = function: integer;
  TGSExecCont   = function(S: PChar; len: integer): integer;
  TGSExecEnd    = function: integer;              
  TGSExit       = function: integer;
  TGSLockDevice = function(Device: Pchar; flag: integer): integer;
  TGSCopyDIB    = function(Device: PChar): THandle;
  TGSCopyPalette= function(Device: PChar): HPalette;
  TGSDraw       = procedure(Device: PChar; DC: hDC; dest,src: PRect);
  TGSGetBitmapRow=function(Device: PChar; pbmih: PBitmapInfoHeader): integer;

var
  { Basic DLL services }
  GSRevision,GSInit,GSExecBegin,GSExecCont,GSExecEnd,GSExit,
  GSLockDevice: TFarProc;
  { MsWin DLL services }
  GSCopyDIB,GSCopyPalette,GSDraw,GSGetBitmapRow: TFarProc;

  GS_Module: THandle;
  OldExitProc: Pointer;

function gsdll_revision(Product,Copyright: PPChar;
                        gs_revision,gs_revisiondate: Plongint): integer;
var
  i: integer;
begin
  gsdll_revision:=0;
  if GS_Module<>0 then
    gsdll_revision:=TGSRevision(GSrevision)(Product,Copyright,
                                gs_revision,gs_revisiondate);
end;

function gsdll_init(Callback: TGSCallback; Wnd: HWnd; argc: integer;
                     argv: TPCharArr): integer;
var
  i: integer;
begin
  gsdll_init:=0;
  messagebox(0,'a','',mb_ok);
  if GS_Module<>0 then
{$IFDEF REV}
    gsdll_init:=TGSInit(GSInit)(argv,argc,Wnd,Callback);
{$ELSE}
    gsdll_init:=TGSInit(GSInit)(Callback,Wnd,argc,argv);
{$ENDIF}
  messagebox(0,'b','',mb_ok);
end;

function gsdll_execute_begin: integer;
var
  i: integer;
begin
  gsdll_execute_begin:=0;
  if GS_Module<>0 then
    gsdll_execute_begin:=TGSExecBegin(GSExecBegin);
end;

function gsdll_execute_cont(S: PChar; len: integer): integer;
var
  i: integer;
begin
  gsdll_execute_cont:=0;
  if GS_Module<>0 then
    gsdll_execute_cont:=TGSExecCont(GSExecCont)(S,len);
end;

function gsdll_execute_end: integer;
var
  i: integer;
begin
  gsdll_execute_end:=0;
  if GS_Module<>0 then
    gsdll_execute_end:=TGSExecEnd(GSExecEnd);
end;

function gsdll_exit: integer;
var
  i: integer;
begin
  gsdll_exit:=0;
  if GS_Module<>0 then gsdll_exit:=TGSExit(GSExit);
end;

function gsdll_lock_device(Device: PChar; flag: integer): integer;
var
  i: integer;
begin
  gsdll_lock_device:=0;
  if GS_Module<>0 then
    gsdll_lock_device:=TGSLockDevice(GSLockDevice)(Device,flag);
end;

function gsdll_copy_DIB(Device: PChar): THandle;
var
  i: integer;
begin
  gsdll_Copy_DIB:=0;
  if GS_Module<>0 then
    gsdll_Copy_DIB:=TGSCopyDIB(GSCopyDIB)(Device);
end;

function gsdll_copy_palette(Device: PChar): HPalette;
var
  i: integer;
begin
  gsdll_copy_palette:=0;
  if GS_Module<>0 then
    gsdll_copy_palette:=TGSCopyPalette(GSCopyPalette)(Device);
end;

procedure gsdll_draw(Device: PChar; DC: hDC; dest,src: PRect);
var
  i: integer;
begin
  if GS_Module<>0 then TGSDraw(GSDraw)(Device,DC,dest,src);
end;

function gsdll_get_bitmap_row(Device: PChar; pbmih: PBitmapInfoHeader): integer;
var
  i: integer;
begin
  gsdll_get_bitmap_row:=0;
  if GS_Module<>0 then
    gsdll_Get_Bitmap_row:=TGSGetBitmapRow(GSGetBitmapRow)(Device,pbmih);
end;


procedure InitEpsDLL(GsDir: PChar);
const
  SEM_NoOpenFileErrorBox = $8000;
var
  PrevErrorMode: word;
  F: array[0..255] of char;
  Nmodule,i: integer;
begin
  if GS_Module<>0 then Exit;   { Already loaded }
  PrevErrorMode:=SetErrorMode(SEM_NoOpenFileErrorBox);
  StrCopy(F,GsDir); StrCat(F,'\gsdll16.dll');
  GS_Module:=LoadLibrary(F);
  SetErrorMode(PrevErrorMode);
  if GS_Module<22 then
  begin
    messagebox(0,'Can''t load Ghostview DLL!',Nil,mb_ok); GS_Module:=0
  end else
  begin
    NModule:=GetModuleUsage(GS_Module);
    if NModule>1 then
    begin
      if Messagebox(0,'DLL already loaded! Unload all extra instances?',
                    Nil,mb_yesno) = id_yes then
      begin
        for i:=1 to NModule do FreeLibrary(GS_Module);
        GS_Module:=LoadLibrary(F);
      end else
      begin
        FreeLibrary(GS_Module);
        GS_Module:=0;
      end;
    end;
  end;
  if GS_Module<>0 then
  begin
    GSRevision    :=GetProcAddress(GS_Module,'gsdll_revision');
    GSInit        :=GetProcAddress(GS_Module,'gsdll_init');
    GSExecBegin   :=GetProcAddress(GS_Module,'gsdll_execute_begin');
	  GSExecCont    :=GetProcAddress(GS_Module,'gsdll_execute_cont');
    GSExecEnd     :=GetProcAddress(GS_Module,'gsdll_execute_end');
    GSExit        :=GetProcAddress(GS_Module,'gsdll_exit');
    GSLockDevice  :=GetProcAddress(GS_Module,'gsdll_lock_device');

    GSCopyDIB     :=GetProcAddress(GS_Module,'gsdll_copy_dib');
    GSCopyPalette :=GetProcAddress(GS_Module,'gsdll_copy_palette');
	  GSDraw        :=GetProcAddress(GS_Module,'gsdll_draw');
	  GSGetBitmapRow:=GetProcAddress(GS_Module,'gsdll_get_bitmap_row');
  end;
end;                     { InitEpsDLL }

procedure UnloadEpsDLL;
begin
  if GS_Module<>0 then
  begin
    FreeLibrary(GS_Module); GS_Module:=0;
  end;
end;                  { UnloadEpsDLL }

procedure GSExitProc; far;
begin
  ExitProc:=OldExitProc;
  UnloadEpsDLL;
end;

begin
  GS_Module:=0;
  GSRevision   :=Nil; GSInit:=Nil; GSExecBegin   :=Nil; GSExecCont:=Nil;
  GSExecEnd    :=Nil; GSExit:=Nil; GSLockDevice  :=Nil; GSCopyDIB :=Nil;
  GSCopyPalette:=Nil; GSDraw:=Nil; GSGetBitmapRow:=Nil;
  OldExitProc:=ExitProc; ExitProc:=@GSExitProc;
end.