#include "FindDial.h"

FindDial::FindDial(QWidget *parent, const char *name)
: QDialog(parent, name, TRUE)
{
  QFont fnt;
  QColor fg, bg, light, dark, mid, text, base;
  QColorGroup normal, disabled, active;
  QPalette pal;

  this->resize(400, 620);
  this->setCaption("Find");
  frame = new QFrame(this);
  frame->setGeometry(0, 0, 400, 125);
  frame->setFrameStyle(33);
  exp = new QLineEdit(frame);
  exp->setGeometry(15, 45, 220, 25);
  lab = new QLabel(frame);
  lab->setGeometry(20, 10, 215, 35);
  lab->setText("Enter regular expression to search for");
  lab->setAlignment(33);
  all = new QCheckBox(frame);
  all->setGeometry(15, 75, 140, 30);
  all->setStyle((GUIStyle)1);
  all->setText("search in any field or");
  all->setChecked((bool)1);
  Case_sens = new QCheckBox(frame);
  Case_sens->setGeometry(245, 40, 100, 30);
  Case_sens->setStyle((GUIStyle)1);
  Case_sens->setText("Case sensitive");
  Case_sens->setChecked((bool)0);
  sfield = new QButtonGroup(this);
  sfield->setGeometry(0, 135, 400, 430);
  sfield->setTitle("search in");
  ok = new QPushButton(this);
  ok->setGeometry(40, 575, 100, 30);
  ok->setText("search");
  ok->setDefault((bool)1);
  cancel = new QPushButton(this);
  cancel->setGeometry(260, 575, 100, 30);
  cancel->setText("cancel");

  connect(ok,SIGNAL(clicked()),this,SLOT(acc()));
  connect(cancel,SIGNAL(clicked()),this,SLOT(reject()));
  connect(all,SIGNAL(toggled(bool)),this,SLOT(alltoggled(bool)));
  for (int i=0;i<26;i++){
   chbf[i]=new QCheckBox(sfield);
   chbf[i]->setStyle(WindowsStyle);
   chbf[i]->setGeometry(10+(i/13)*250,20+30*(i%13),100,30);
   if (i) chbf[i]->setText(FIELDS[i-1]);else chbf[0]->setText("ID");
  }
  alltoggled(1);
}

FindDial::~FindDial()
{
}

void FindDial::alltoggled(bool on)
{
  sfield->setEnabled(!on);
  for (int i=0;i<26;i++)
   chbf[i]->setEnabled(!on);
}

/*!
*/

void FindDial::acc()
{
  QRegExp x(exp->text());
  if  (!x.isValid()) {
    QMessageBox::warning(this,"Warning","This is not a valid regular expression");
    return;
  }
  int b=0;
  for (int i=0;i<26;i++)
   b|=chbf[i]->isChecked();
  b|=all->isChecked();
  if (!b) {
   QMessageBox::warning(this,"Warning","You should enabled at least one field to search in!");
   return;
  }
  emit accept();
}
