#!/bin/csh -f

#	S. Kremer, Sep 1989.

# 	texswlist - make a 'swlist' file from a bibliographic database
#	and TeX it.

set swortcp=AAAAA/swortcp	# splits the %W lines of the ref file
set tiblist=BBBBB/tiblist
set swlist_tibstyle=texswlist		# the file has a .tib suffix
set tibinputs=CCCCC	# contains $swlist_tibstyle
set tex=DDDDD
set tmp=/tmp/swlist$$
alias announce 'if ($V == 1) echo'

# init
set tibopt=(-d $tibinputs -s $swlist_tibstyle -i quote.ttx)
	# quote.ttx uses `` and '' instead of german quotes

set V=0	tib_verbose='-z'	# do not be verbose as default
set K=0				# do not keep tmp files

if ($#argv == 0) then
	echo 'Usage:' $0 '[-vk] [tib options] file[.ref]'
	echo '-v: be verbose'
	echo "-k: keep intermediate files and don't run TeX"
	exit
endif

set infile=$argv[$#argv]	# last arg is filename
set argv[$#argv]=''		# delete it form arg list

foreach i ($*)
	switch("$i")
	case '-v': 
		set V=1 tib_verbose='' 
		breaksw
	case '-k':
		set K=1
		breaksw
	case '-vk':
	case '-kv':
		set V=1 tib_verbose='' K=1
		breaksw
	default:
		set tibopt=($tibopt $i)
	endsw
end

set in=$infile	# the original input file name
# If specified input file does not exist, user probably forgot .ref.
# We fix it for him:
if (! -f $in && -f $in.ref) set in=$in.ref
set root=$in:r	# root name of input file

$swortcp $in	> $root-s.ref				|| exit 1
echo '\def\jobname{'$in:r' (swlist)}'	> $tmp.1
$tiblist $tib_verbose $tibopt $root-s.ref -x > $tmp.2	|| exit 1
/bin/cat $tmp.[1-2]			> $root-s.tex
/bin/rm -f $tmp.[1-2]

if ($K == 1) then	# do no tex and do not clean up
	announce Tiblist output is in $root-s.tex
	exit
endif

if ($V == 0) then
	$tex $root-s.tex		> /dev/null 	|| exit 1
else
	$tex $root-s.tex				|| exit 1
endif
if ($K == 0) then
	announce Removing $root-s.{ref,tex,log}
	/bin/rm -f $root-s.{ref,tex,log}
endif
