{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibflch2;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, wbibdisp, wbibgui, streams,
{$ELSE}
  Objects, BibCrt, bibdisp, bibsedit,
{$ENDIF}
  bibstrg, bibstrm, bibvars, bibutil, bibfile, bibPchec, rc_strng,
  bibtmplt;

procedure ExtractSortRec(var Srec: SortRecType; var M: ConfigSortType;
                         SortPattern: PatRecPtr; Entry: EntryRecPtr);
procedure WriteSortRec(F: PStream; var Srec: SortRecType);
function  PutEntryTemp(F: PStream; Entry: EntryRecPtr; Ttag: boolean): boolean;
procedure GetEntryTemp(F: PStream; Entry: EntryRecPtr; var TTag: boolean);
procedure WriteElist(F: PStream; var M: ConfigSortType;
                     SortPattern: PatRecPtr; Entry: EntryRecPtr);


implementation

procedure ExtractSortRec(var Srec: SortRecType; var M: ConfigSortType;
                         SortPattern: PatRecPtr; Entry: EntryRecPtr);
const
  KeyForbid = '''"`\~:[]()?!.,;'+lbrace+rbrace;
var
  i,j: integer;
begin
  with Srec do
  begin
    Patt:=true;
    place:=entry^.Beginning; Size:=Entry^.Ending-Place+1;
    name:=Entry^.name;
    Ereal:=Entry^.RealNum;
    if EditOnlyStrings then
    begin
      Patt:=true;
      for i:=1 to NSortKeys do Keys[i]:='';
    end else
    begin
      if M.SortPatternExists then
      begin
        PatternCheck(entry,SortPattern,Patt,false);
      end;
      for i:=1 to NSortKeys do
      begin
        FillTemplate(Entry,Keys[i],M.SortKey[i,Patt],VerbatimFormat,true,false);
        j:=1;
        while j<=length(Keys[i]) do
        begin
          if Pos(Keys[i][j],KeyForbid)>0 then Delete(Keys[i],j,1)
          else inc(j);
        end;
      end;
    end;
    {
    if Patt then
      message('WRITE <'+entry^.name+'>,<'+key1+'>,conform')
    else
      message('WRITE <'+entry^.name+'>,<'+key1+'>,not conform')
    }
  end;
end;                              { ExtractSortRec }

procedure WriteSortRec(F: PStream; var Srec: SortRecType);
var
  i: integer;
begin
  with Srec do
  begin
    F^.write(place,sizeof(place));
    F^.write(size,sizeof(size));
    F^.write(Ereal,sizeof(Ereal));
    F^.write(name[0],length(name)+1);
    if not EditOnlyStrings then
    begin
      F^.write(Patt,sizeof(Patt));
      for i:=1 to NSortKeys do F^.write(keys[i][0],length(keys[i])+1);
    end;
  end;
end;                                { WriteSortRec }

function PutEntryTemp(F: PStream; Entry: EntryRecPtr; Ttag: boolean): boolean;
begin                            { PutEntryTemp }
  F^.write(Ttag,sizeof(Ttag));
  PutEntryTemp:=StoreEntry(F,Entry);
end;                         { PutEntryTemp }

procedure GetEntryTemp(F: PStream; Entry: EntryRecPtr; var TTag: boolean);
begin                         { GetEntryTemp }
  F^.read(Ttag,sizeof(Ttag));
  LoadEntry(F,Entry);
end;                             { GetEntryTemp }

procedure WriteElist(F: PStream; var M: ConfigSortType;
                     SortPattern: PatRecPtr; Entry: EntryRecPtr);
var
  Srec: SortRecType;
begin
  ExtractSortRec(Srec,M,SortPattern,Entry);
  WriteSortRec(F,Srec);
end;


end.
