/*********************************************************************/
/*  bibView: Administration of BibTeX-Databases                      */
/*           (Verwaltung von BibTeX-Literaturdatenbanken)            */
/*                                                                   */
/*  Module:  gui_help.c                                              */
/*                                                                   */
/*             GUI Help Window                                       */
/*                                                                   */
/*  Author:  Armin Liebl ,  liebla@informatik.tu-muenchen.de         */
/*                                                                   */
/*  History:                                                         */
/*    07.15.92  PMU  created                                         */
/*    05.26.92       Version 1.0 released                            */
/*                                                                   */
/*  Copyright 1992 TU MUENCHEN                                       */
/*    See ./Copyright for complete rights and liability information. */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include "bibview.h"


/* imported global variables */
/* ------------------------- */
extern Widget topLevel;
extern Pixmap helpIconPixmap;

/* macros and definitions */
/* ---------------------- */


/* local function prototypes */
/* ------------------------- */
static void hlpQuitHelpCmd(Widget w, XtPointer clientData, XtPointer callData);


/* exported variables */
/* ------------------ */


/* local global variables */
/* ---------------------- */

static Widget helpShell[7];

static int exists[7] = {FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE};

#ifdef GERMAN
static char *line1   = "Ueberblick";
#else
static char *line1   = "Survey";
#endif

#ifdef GERMAN
static char *line2   = "Hauptfenster";
#else
static char *line2   = "Main Window";
#endif

#ifdef GERMAN
static char *line3   = "Bibliographiefenster";
#else
static char *line3   = "Bibliography Window";
#endif

#ifdef GERMAN
static char *line4   = "Listenfenster";
#else
static char *line4   = "List Window";
#endif

#ifdef GERMAN
static char *line5   = "Kartenfenster";
#else
static char *line5   = "Card Window";
#endif

#ifdef GERMAN
static char *line6   = "Andere Fenster";
#else
static char *line6   = "Other Windows";
#endif

#ifdef GERMAN
char *errtitlestr   = "FEHLER-Hilfe";
#else
char *errtitlestr   = "HELP for finding errors";
#endif

#ifdef GERMAN
static char *string1 = "BIBVIEW - Eine graphische Benutzerschnittstelle\n\
\tzur Verwaltung von BibTeX-Literaturdatenbanken\n\n\
AUFRUF\n\
bibview  [Standardoptionen] [-file <Dateiname>] [-rcfile <Konfdatei>]\n\n\
DESCRIPTION\n\
Bibview erleichtert die Verwaltung von BibTeX-Literaturdatenbanken\n\
(im folgenden als BiB bezeichnet). Der Benutzer wird beim\n\
Eintragen von Daten, bei der Suche nach Eintraegen und beim\n\
Kopieren von Eintraegen zwischen verschiedenen BiBs unterstuetzt.\n\
Es kann gleichzeitig mit mehreren BiBs gearbeitet werden. \n\
\n\
Es gibt sieben verschiedene Fensterarten in bibview:\n\
\n\
Das Hauptfenster (main window) enthaelt Menues zum Einstellen von\n\
Optionen und zum Arbeiten mit BiBs auf Dateiebene.\n\
\n\
Das Bibliographiefenster (bibliography window) (eines pro geoeffneter\n\
BiB) enthaelt Kommandos zum Bearbeiten der BiB.\n\
\n\
Das Listenfenster (list window) (maximal eines pro geoeffneter BiB)\n\
zeigt eine Liste von Eintraegen. Die Felder Autor, Titel, Typ\n\
und Jahr werden gezeigt.\n\
\n\
Das Kartenfenster (card window) (maximal eines pro Eintrag)\n\
dient zum Editieren der Eintraege. Es enthaelt Boxen fuer alle\n\
Felder des Eintrags (je nach dem Typ des Eintrags).\n\
Die von BibTeX geforderten\n\
Felder sind durch fette Linien markiert.\n\
Ein Kartenfenster wird nach dem Anklicken des entsprechenden Eintrags\n\
im Listenfenster (mit der linken Maustaste) oder nach der Auswahl\n\
des Typs im Neu-Menue des Bibliographiefensters geoeffnet.\n\
\n\
Im Annote-Fenster (annote window) (maximal eines pro Eintrag) \n\
kann das Annote-Feld eines Eintrags editiert werden. \n\
\n\
Im Makrofenster (macro window) (maximal eines pro BiB) koennen die \n\
STRING- and PREAMBLE-Teile  einer BiB editiert werden. \n\
\n\
Das Fehlerfenster (error window) (maximal eines pro BiB) erscheint,\n\
falls in einer BiB Syntaxfehler aufgetreten sind. In einem Hilfefenster\n\
werden die BibTeX-Schluessel der fehlerhaften Eintraege angezeigt.\n\
Die Datei kann editiert und erneut geoeffnet werden.\n\n\
OPTIONEN\n\
\n\
Standardoptionen:\n\
\n\
Die Standardoptionen sind\n\
-display, -geometry, -iconic and others.\n\
\n\
-file <Dateiname>:\n\
\n\
Die BibTeX Literaturdatenbank <Dateiname> wird geladen .\n\
\n\
-rcfile <Konfdatei>:\n\
\n\
Anstelle der Datei .bibviewrc im Homedirectory des Benutzers\n\
wird die Datei <Konfdatei> verwendet.\n\
\n\
-bibdir <Directory>:\n\
\n\
Die Auswahl von BibTeX Dateien beginnt in <Directory>\n\
\n\n\
EINSCHRAENKUNGEN\n\
Bei Dateien mit mehr als 1000 Eintraegen kann es aufgrund eines\n\
Fehlers bei bestimmten Servern zum Absturz kommen.\n\
\n\
Vorschlaege fuer weitere Features sind willkommen.\n\
\n\
COPYRIGHT\n\
Copyright 1992 Technische Universitaet Muenchen\n\
\n\
AUTOREN\n\
Holger Martin, Peter Urban and Armin Liebl.\n\
Fehlermeldungen und Erweiterungsvorschlaege bitte an\n\n\
\tliebla@informatik.tu-muenchen.de";
#else  
static char *string1 = "BIBVIEW - an X based graphical user interface\n\
\tfor manipulating BibTeX databases\n\n\
SYNOPSIS\n\
bibview  [standard options] [-file <bib file>] [-rcfile <conf file>]\n\n\
DESCRIPTION\n\
Bibview facilitates the manipulation of BibTeX databases (in the \n\
following called BiB). It supports the user in making new entries,\n\
searching for entries and moving entries from one BiB to another.\n\
It is possible to work with more than one BiB simultaneously. \n\
\n\
There are seven types of windows in bibview:\n\
\n\
The main window contains menus for customizing bibview and\n\
for working with BiBs on the file level.\n\
\n\
The bibliography window (one for every open BiB) contains commands\n\
for manipulating the BiB.\n\
\n\
The list window (at most one for every open BiB) shows a list of\n\
entries. It displays the fields author, title, type and year.\n\
\n\
The card window (at most one for every entry) helps editing an \n\
entry.  It contains boxes for each field of the entry (according \n\
to the type).\n\
The required fields are marked by bold lines.\n\
A card window is displayed after clicking an entry in the list menu\n\
(left mouse button) or selecting a type in the `New` menu of a\n\
bibliography window.\n\
\n\
The annote window (at most one for every entry) helps editing \n\
the annote field of an entry. \n\
\n\
The macro window (at most one for every open BiB) helps editing \n\
the STRING and PREAMBLE parts of a BiB. \n\
\n\
The error window (at most one for every BiB) is displayed\n\
if a BiB cannot be opened because of syntax errors. In a help\n\
window the keys and line numbers of the entries with syntax\n\
error are displayed. The file can be edited and opened again.\n\n\
OPTIONS\n\
\n\
standard options:\n\
\n\
The standard options are\n\
-display, -geometry, -iconic and others.\n\
\n\
-file <bib file>:\n\
\n\
The BibTeX database <bib file> is loaded at the start of bibview.\n\
\n\
-rcfile <conf file>:\n\
\n\
Instead of the file .bibviewrc in the home directory of the user\n\
the file <conf file> is used.\n\
\n\
-bibdir <directory>:\n\
\n\
The file selection process starts in <directory>.\n\
\n\n\
LIMITATIONS\n\
There may be problems with files containing more than ca. 1000\n\
entries. \n\
The consistency check could be more sophisticated.\n\
\n\
Ideas for more features are welcome.\n\
\n\
COPYRIGHT\n\
Copyright 1992 Technische Universitaet Muenchen\n\
\n\
AUTHORS\n\
Holger Martin, Peter Urban and Armin Liebl.\n\
Send bug reports and ideas for enhancement to\n\n\
\tliebla@informatik.tu-muenchen.de";
#endif  

#ifdef GERMAN
static char *string2 = "HAUPTFENSTER\n\
\n\
Das Hauptfenster erscheint beim Starten von bibview.\n\
Es enthaelt die folgenden Menues:\n\
\n\
DATEI:  Laden und Speichern von BiBs. Der Auswahl von Dateinamen \n\
erfolgt ueber eine Fileselect-Box. Das DATEI-Menue bietet die\n\
folgende Kommandos:\n\
\tNeu             - Erzeugen einer neuen BiB.\n\
\tOeffnen         - Einlesen einer existierenden BiB.\n\
\tSchliessen      - Schliessen einer geoeffneten BiB.\n\
\tSpeichern       - Abspeichern einer  geoeffneten BiB.\n\
\tSpeichern unter - Abspeichern einer geoeffneten BiB unter\n\
\t                  neuem Namen.\n\
\tBeenden         - Beenden einer bibview-Sitzung.\n\
\n\
DIENSTE:\n\
Das DIENSTE-Menue enthaelt die folgenden Kommandos:\n\
\n\
Konsistenzcheck - \n\
\tEintraege, die nicht alle von BibTeX fuer den entsprechenden\n\
\tTyp geforderten Felder aufweisen, werden im Listenfenster\n\
\tangezeigt.\n\
\n\
Mischen - \
Alle Eintraege einer BiB werden in eine andere BiB \n\
\teingefuegt. Eintraege mit gleichem Schluessel werden \n\
\tignoriert.\n\
\n\
Druck in Datei - \
Eine LaTeX-Datei mit den Datensaetzen der BiB \n\
\twird erzeugt. \n\
\n\
Makros editieren- \n\
\tDas Makrofenster zum Editieren der Makros einer BiB\n\
\twird geoeffnet\n\
\n\
Konfiguration laden- \n\
\tEine Konfigurationsdatei wird geladen. Der Options-Teil\n\
\tder Konfigurationsdatei wird nicht ausgewertet.\n\
\n\
OPTIONEN: \n\
Das OPTIONEN-Menue dient zum Aendern der voreingestellten\n\
Optionen.\n\
\n\
Warnton bei Fehler -\n\
\tIm Falle eines Fehlers ertoent ein Warnton \n\
\t(Voreinstellung: TRUE).\n\
\n\
Sicherungskopien - \n\
\tVor dem Abspeichern einer BiB wird eine Sicherungskopie\n\
\tmit der Endung .bak erzeugt (Voreinstellung: TRUE).\n\
\n\
Icons auf Desktop - \n\
\tIcons vom Listenfenster und von Kartenfenstern werden auf\n\
\tdem zugehoerigen Bibliographiefenster abgelegt\n\
\t(Voreinstellung: FALSE).\n\
\tDiese Option funktioniert nicht bei allen Window-Managern.\n\
\n\
Autom. Ueberpruefung - \n\
\tBeim Laden einer neuen BiB findet ein Konsistenzcheck statt \n\
\t(Voreinstellung: TRUE).\n\
\n\
Zwingende Felder - \n\
\tEin Eintrag kann nur abgespeichert werden,\n\
\twenn alle von BibTeX geforderten Felder ausgefuellt sind\n\
\t(Voreinstellung: FALSE).\n\
\n\
Ignoriere Gross/Klein - \n\
\tBei einer Suche wird Gross- und Kleinschreibung nicht\n\
\tberuecksichtigt (Voreinstellung: TRUE).\n\
\n\
Drucke als BibTeX - \n\
\tBeim Ausdrucken von BibTeX-Dateien wird eine LaTeX-Datei\n\
\tmit \\nocite-Befehl erzeugt (Voreinstellung: TRUE).\n\
\tDas verwendete Style-file ist alpha. Die Voreinstellung\n\
\tkann im [StyleFile]-Teil der Konfigurationsdatei\n\
\tveraendert werden.\n\
\tAndernfalls ist die entstehende LaTeX-Datei von\n\
\teinem festgelegten Format.\n\
\n\
Fehlerfenster - \n\
\tIm Falle eines Syntaxfehlers erscheint ein Fenster auf dem\n\
\tBildschirm, in dem der Fehler ausgebessert werden kann.\n\
\tIn einem Hilfefenster wird der BibTeX-Schluessel und die\n\
\tZeilennummer des betroffenen Eintrags angegeben\n\
\t(Voreinstellung: TRUE).\n\
\tAndernfalls erscheint kein Fenster zum Editieren der Datei.\n\
\n\
\n\
FENSTER: \n\
\n\
Kaskadieren - \n\
\tDie Fenster, die zur selben BiB gehoeren \n\
\t(Bibliographiefenster, Makrofenster, Kartenfenster) werden\n\
\tzusammen gruppiert.\n\
\tDas funktioniert nicht bei allen Window-Managern.\n\
\n\
HILFE: Oeffnen eines Fensters mit dem entsprechenden Hilfetext.";
#else
static char *string2 = "MAIN WINDOW\n\
\n\
The main window is displayed when bibview is started.\n\
It offers the following menus:\n\
\n\
FILE:  Load and save BiBs. For choosing a name a file select box \n\
is displayed. The FILE menu consists of the following commands:\n\
\tNew\t - Create a new BiB.\n\
\tOpen\t - Read an existing BiB.\n\
\tClose\t - Close an open BiB.\n\
\tSave\t - Save an open BiB.\n\
\tSave as\t - Save an open BiB and select a new name for it.\n\
\tQuit\t - Quit a bibview session.\n\
\n\
SERVICES:\n\
The SERVICES menu consists of the following commands:\n\
\n\
Consistency Check - \n\
\tEntries that don't contain all required fields\n\
\tfor that type are shown in the list window.\n\
\t(More sophisticated tests should be implemented.)\n\
\n\
Unify - \
Insert all entries of one BiB in another. Entries with\n\
\tconflicting keys are ignored.\n\
\n\
Print - \
A LaTeX file with the entries of a BiB is created. \n\
\n\
Edit Macros - \n\
\tOpen macro window for editing the macros of a BiB.\n\
\n\
Load Configuration - \n\
\tLoad a configuration file. \n\
\n\
OPTIONS: \n\
The OPTIONS menu serves for changing default options\n\
\n\
Beep on Error -\n\
\tBeep in case of an error (default: TRUE).\n\
\n\
Backup - \n\
\tBefore writing a BiB on disk, a backup of the file with the\n\
\tending '.bak' is created (default: TRUE).\n\
\n\
Icons on Desktop - \n\
\tIcons of list and card windows are layed down\n\
\ton the corresponding bibliography window (default: FALSE).\n\
\tThis option doesn't work with all window managers.\n\
\n\
Autom. Check - \n\
\tA consistency check takes place if a new BiB is\n\
\tloaded (default: TRUE).\n\
\n\
Required Fields - \n\
\tAn entry can only be saved if it contains all\n\
\tfields required by BibTeX (default: FALSE).\n\
\n\
Ignore Case - \n\
\tIn a search the case is ignored (default: TRUE)\n\
\n\
Print As Bib - \n\
\tWhen printing a file, a LaTeX file containing\n\
\t\\nocite commands is created (default: TRUE).\n\
\tThe style file is alpha. This default\n\
\tcan be changed in the [StyleFile] part of the\n\
\tconfiguration file.\n\
\tOtherwise the format of the LaTeX file is fixed.\n\
\n\
Display Error Window - \n\
\tIn case of a syntax error, a window is displayed\n\
\tin which the file can be edited. A help window\n\
\tappears that contains the BibTeX keys and the line numbers\n\
\tof the syntax errors. (default: TRUE)\n\
\tOtherwise, no error window is displayed.\n\
\n\
\n\
WINDOW: \n\
\n\
Cascade - \n\
\tThe windows belonging to the same BiB (bibliography window,\n\
\tmacro window, card windows) are grouped together.\n\
\tThis doesn't work with all window managers.\n\
\n\
HELP: Show help information.";
#endif

#ifdef GERMAN
static char *string3 = "BIBLIOGRAPHIEFENSTER\n\
\n\
Der Menuebalken des Bibliographiefensters enthaelt Funktionen\n\
zum Bearbeiten der entsprechenden BiB:\n\
\n\
Neu:\t\
Einfuegen eines neuen Eintrags in die BiB. Der Typ des\n\
\tEintrags wird von einem Pulldown-Menue gewaehlt. Daraufhin\n\
\terscheint ein Kartenfenster, das an den Typ angepasst ist.\n\
\n\
Suchen: \
Suche nach Eintraegen, die bestimmte Bedingungen erfuellen\n\
\tEin Fenster erscheint, in dem fuer jedes Feld\n\
\tein regulaerer Ausdruck eingegeben werden kann.\n\
\tDas Ergebnis der Suche (alle Eintraege, bei denen die \n\
\tFelder mit den angegebenen regulaeren Ausdruecken \n\
\tuebereinstimmen) wird im Listenfenster gezeigt und kann\n\
\tweiterverarbeitet werden.\n\
\tFalls die Option \"Ignoriere Gross/Klein\" gewaehlt\n\
\tist, wird bei Vergleichen Gross- und Kleinschreibung\n\
\tnicht beruecksichtigt.\n\
\n\
Liste:\t\
Alle Eintraege der BiB werden im Listenfenster gezeigt. \n\
\tNach dem Anklicken eines Eintrags mit der linken Maus-Taste\n\
\terscheint ein Kartenfenster.\n\
\n\
Makros: \
Das Makrofenster zum Editieren der STRING- und PREAMBLE-Teile\n\
\teiner BiB wird geoeffnet.\n\
\n\
Drucken:    Eine LaTeX-Datei mit den Eintraegen der BiB wird erzeugt.\n\
\n\
Speichern:  Abspeichern der BiB. \n\
\n\
Schliessen: Schliessen der BiB. Falls Eintraege veraendert wurden\n\
	    oder neue Eintraege erzeugt wurden, ohne dass die BiB\n\
	    gepeichert wurde, erfolgt eine Warnung.\n\
\n\
Fenster:    Die Fenster, die zur BiB gehoeren (Bibliographiefenster,\n\
            Makrofenster, Kartenfenster), werden zusammen gruppiert.\n\
            Das funktioniert nicht bei allen Window-Managern.";
#else
static char *string3 = "BIBLIOGRAPHY WINDOW\n\
\n\
The menu bar of the bibliography window contains functions for\n\
manipulating the corresponding BiB:\n\
\n\
New:\t\
Create a new entry. The type of the entry must be chosen\n\
\tfrom a pulldown menu.\n\
\n\
Search: \
Search for all entries that fullfill certain\n\
\tconditions. \n\
\tA window is displayed in which for every field a \n\
\tregular expression can be entered. The result of the search \n\
\t(the entries that match all regular expressions)\n\
\tis shown in the list window.\n\
\tIf the option \"Ignore Case\" is chosen, uppercase/lowercase\n\
\tdistinctions are ignored during comparisons.\n\
\n\
List:\t\
All entries of the BiB are shown in the list window. \n\
\tThe card window is displayed after clicking the \n\
\tcorresponding entry with the left mouse button.\n\
\n\
Macros: \
The macro window for editing STRING und PREAMBLE\n\
\tmacros is displayed.\n\
\n\
Print:\t\
A LaTeX file with the entries of the list is created\n\
\n\
Save: \t\
Save the BiB on disk. The BiB remains loaded.\n\
\n\
Close:\t\
Close the BiB.\n\
\n\
Window:\
\tThe windows belonging to the BiB (bibliography window,\n\
\tmacro window, card windows) are grouped together.\n\
\tThis doesn't work with all window managers.";
#endif

#ifdef GERMAN
static char *string4 = "LISTENFENSTER\n\n\
Ein Listenfenster erscheint nach dem Anklicken des Menuepunkts \n\
\"Liste\" im Bibliographiefenster, als Ergebnis einer Suche oder\n\
als Anzeige von fehlerhaften Eintraegen nach einem Konsistenzcheck.\n\
Der Menuebalken des Listenfenster enthaelt die folgenden Kommandos:\n\
\n\
Speichern:   Die Eintraege der Liste werden als neue BiB gespeichert.\n\
\n\
Sortieren:   Die Eintraege der Liste werden sortiert.\n\
             Das Sortierkriterium (Author, Mainkey, Title,\n\
	     Year, Category oder Journal) kann durch ein Menue.\n\
	     gewaehlt werden.\n\
\n\
Kopieren:    Die Eintraege der Liste werden in eine andere\n\
             BiB eingefuegt.\n\
	     gewaehlt werden.\n\
\n\
Drucken:     Eine LaTeX-Datei mit den Eintraegen der Liste wird\n\
	     erzeugt.\n\
             Der Dateiname wird mit einer Fileselect-Box\n\
	     ausgewaehlt.\n\
\n\
Schliessen:  Das Listenfenster wird geschlossen.";
#else
static char *string4 = "LIST WINDOW\n\n\
The list window is displayed after clicking the menu \n\
item list of the bibliography window, as result of a search\n\
or as result of a consistency check. The menu bar of the list window\n\
offers the following commands:\n\
\n\
Save:\t\
The entries of the list are saved as a new BiB.\n\
\n\
Sort:\t\
The entries of the list are sorted as a new BiB.\n\
\tThe way in which the entries are sorted (Author, Mainkey,\n\
\tTitle, Year, Category or Journal) can be chosen by a menu.\n\
\n\
Copy:\t\
The entries of the list are inserted into another BiB.\n\
\n\
Print:\t\
A LaTeX file with the entries of the list is created.\n\
\n\
Close:\t\
The list window is closed.";
#endif

#ifdef GERMAN
static char *string5 = "KARTENFENSTER\n\
\n\
Das Kartenfenster dient zum Erstellen von neuen Eintraegen\n\
bzw. zum Editieren vorhandener Eintraege.\n\
Das Eingabefeld enthaelt keinen Rand bzw. (in der Farbversion)\n\
einen roten Rand. Es kann durch die <tab>- und <esc>-Tasten\n\
und durch das Druecken der rechten Maustaste in einem Feld\n\
geaendert werden.\n\
In der Ressourcedatei bzw. in der Datei .bibviewrc kann dieses\n\
Verhalten geaendert werden. Dann ist das Eingabefeld das Feld,\n\
in dem sich der Mauscursor befindet.\n\
Der dazu erforderliche Eintrag in der Ressourcedatei ist:\n\
    BibView.focus:false\n\
Der dazu erforderliche Eintrag im [Options]-Teil von .bibviewrc ist:\n\
    Focus:false\n\
\n\
Die erforderlichen Klammern fuer Feldinhalte werden automatisch\n\
ergaenzt. Zur Eingabe von Makros und der Zeichen '#' und '@' ist\n\
erforderlich, ein '@' voranzustellen.\n\
In der Ressourcedatei bzw. in der Datei .bibviewrc kann dieses\n\
Verhalten geaendert werden.\n\
Der dazu erforderliche Eintrag in der Ressourcedatei ist:\n\
    BibView.orig:true\n\
Der dazu erforderliche Eintrag im [Options]-Teil von .bibviewrc ist:\n\
    Orig:true\n\
De  Menuebalken des Kartenfensters enthaelt die folgenden\n\
Kommandos:\n\
\n\
Verdoppeln:    Ein neues Kartenfenster wird geoeffnet,\n\
	       in dem die Feldinhalte des aktuellen\n\
	       Kartenfensters uebernommen werden. Der\n\
	       Typ der neuen Karte kann von einem Menue\n\
	       gewaehlt werden. Es werden nur diejenigen\n\
	       Feldinhalte beruecksichtigt, die schon\n\
	       abgespeichert sind. Der BibTeX-Schluessel\n\
	       der neuen Karte ist leer.\n\
\n\
Benutzerdaten: Das Kartenfenster wird um die Felder, die vom \n\
	       Benutzer definiert wurden, erweitert.\n\
\n\
Anmerkung:     Ein Fenster wird geoeffnet, in dem das \n\
	       Annote-Feld bequem editiert werden kann.\n\
\n\
Loeschen:      Der Eintrag wird aus der BiB entfernt.\n\
\n\
Speichern:     Der Eintrag wird in der BiB gespeichert.\n\
\n\
Kopieren:      Der Eintrag wird in eine andere BiB kopiert.\n\
\n\
Crossref:      Falls das crossref-Feld des Eintrags nicht leer ist,\n\
	       wird ein Kartenfenster fuer den crossref-Eintrag\n\
	       geoeffnet.\n\
\n\
Next:          Der Eintrag wird in der BiB gespeichert, und ein\n\
	       neuer Eintrag kann erfolgen.\n\
\n\
Schliessen:    Schliessen des Kartenfensters.";
#else
static char *string5 = "CARD WINDOW\n\
\n\
The card window is used to create new entries or to edit\n\
existing entries.\n\
The field with the input focus has no border or (in the colour\n\
version) a red border. It can be moved using the <tab> and <esc>\n\
keys or by clicking the right button of the mouse in a field.\n\
\n\
You can change this behaviour in the resource file or in the\n\
file .bibviewrc. In this case the input focus is set to the\n\
field where the cursor is placed.\n\
The necessary entry in the resource file is:\n\
    BibView.focus:false\n\
The corresponding entry in the [Options] part of .bibviewrc is:\n\
    Focus:false\n\
\n\
The contents of the fields are entered without the surrounding\n\
brackets. If you want to enter a macro, '@' or '#', you have to\n\
use a preceding '@'.\n\
\n\
You can change this behaviour in the resource file or in the\n\
file .bibviewrc.\n\
The necessary entry in the resource file is:\n\
    BibView.orig:true\n\
The corresponding entry in the [Options] part of .bibviewrc is:\n\
    Orig:true\n\
\n\
The menu bar of the card window offers the following commands:\n\
\n\
Duplicate: \
\tA new card window is opened in which the field \n\
\t\tcontents (except mainkey) are taken from the\n\
\t\tactual card window. The actual card window must\n\
\t\thave been saved, otherwise the new card window is\n\
\t\tempty.\n\
\n\
User Data: \
\tThe card window is extended with the\n\
\t\tfields defined by the user.\n\
\n\
Annote: \
\tA window is displayed in which the annote field\n\
\t\tof an entry can be edited.\n\
\n\
Delete:\t\t\
The entry is deleted from the BiB.\n\
\n\
Save: \t\t\
The entry is saved in the BiB.\n\
\n\
Copy: \t\t\
The entry is copied in another BiB.\n\
\n\
Crossref: \
\tIf the entry contains a crossref, the card with the\n\
\t\tcrossref is opened.\n\
\n\
Next: \t\t\
The entry is saved in the BiB and a new entry can be\n\
\t\tmade.\n\
\n\
Close: \t\t\
Close the card window.";
#endif

#ifdef GERMAN
static char *string6 = "ANDERE FENSTER\n\n\
Annote-Fenster\n\
\n\
Der Menuebalken des Annote-Fenster enthaelt die folgenden\n\
Kommandos:\n\
Speichern:   Speichern des Annote-Feldes eines Eintrags.\n\
Schliessen:  Schliessen des Annote-Fensters, ohne den Inhalt zu \n\
	     speichern.\n\
\n\n\
Makrofenster\n\
\n\
Der Menuebalken des Makrofensters enthaelt die folgenden\n\
Kommandos:\n\
Speichern:   Speichern der MAKRO- und PREAMBLE-Teile des \n\
	     Makrofensters.\n\
Schliessen:  Schliessen des Makrofensters, ohne den Inhalt zu \n\
	     speichern.  Falls Aenderungen vorgenommen wurden,\n\
	     erfolgt eine Rueckfrage.\n\
\n\n\
Fehlerfenster\n\
\n\
Das Fehlerfenster dient zum Korrigieren von Syntaxfehlern.\n\
Der Menuebalken des Fehlerfensters enthaelt die folgenden\n\
Kommandos:\n\
Speichern:   Speichern des Fehlerfensters.\n\
Schliessen:  Schliessen des Fehlerfensters, ohne den Inhalt zu\n\
	     speichern.";
#else
static char *string6 = "OTHER WINDOWS\n\n\
Annote Window\n\
\n\
The menu bar of the annote window offers the following commands:\n\
Save: \t\
Save the annote field.\n\
Close: \t\
Close the annote window without saving the annote field.\n\
\n\n\
Macro Window\n\
\n\
The menu bar of the macro window offers the following commands:\n\
Save: \t\
Save the macros and preambles of the macro window.\n\
Close: \t\
Close the macro window.\n\
\n\n\
Error Window\n\
\n\
The menu bar of the error window offers the following commands:\n\
Save: \t\
Save the content of the error window.\n\
Close: \t\
Close the error window without saving the content.";
#endif



/*********************************************************************/
/* hlpOpenHelpWin:                                                   */
/*    Opens shell for Help-Window                                    */
/*********************************************************************/
void
hlpOpenHelpWin(int nummer, char *string1, char *string2)

{
Widget helpWin, cmdBox, close;
   
   if (exists[nummer-1])
     {XtPopup(helpShell[nummer-1], XtGrabNone);
      return;
      }
   
   /* create popup shell for new file */
   helpShell[nummer-1] = XtVaCreatePopupShell("helpShell",
		  topLevelShellWidgetClass, topLevel, 
		  XtNtitle, string1,
		  XtNiconName, string1,
		  XtNiconPixmap, helpIconPixmap, NULL);
   helpWin = XtVaCreateManagedWidget("helpWin",
		  panedWidgetClass, helpShell[nummer-1], NULL);

   /* create command buttons */
   cmdBox = XtVaCreateManagedWidget("commandBox", 
		  boxWidgetClass, helpWin, NULL);
   close  = XtVaCreateManagedWidget("close", 
	          commandWidgetClass, cmdBox, NULL);
            XtVaCreateManagedWidget("helpText", 
	          asciiTextWidgetClass, helpWin, 
		  XtNtype, XawAsciiString,
		  XtNstring, string2,
		  XtNscrollHorizontal, XawtextScrollWhenNeeded,
		  XtNscrollVertical, XawtextScrollWhenNeeded, NULL);
   exists[nummer-1]=TRUE;
   XtAddCallback(close, XtNcallback, hlpQuitHelpCmd,(XtPointer)nummer);
   XtPopup(helpShell[nummer-1], XtGrabNone);
   return;
}


/*********************************************************************/
/* hlpOpenHelpWinCmd:                                                */
/*    Opens shell for Help-Window                                    */
/*********************************************************************/
void
hlpOpenHelpWinCmd(Widget w, XtPointer clientData, XtPointer callData)
{
   int nummer = (int) clientData;
   if (nummer==1)
      hlpOpenHelpWin(nummer,line1,string1);
   else if (nummer==2)
      hlpOpenHelpWin(nummer,line2,string2);
   else if (nummer==3)
      hlpOpenHelpWin(nummer,line3,string3);
   else if (nummer==4)
      hlpOpenHelpWin(nummer,line4,string4);
   else if (nummer==5)
      hlpOpenHelpWin(nummer,line5,string5);
   else if (nummer==6)
      hlpOpenHelpWin(nummer,line6,string6);
   return;
}

/*********************************************************************/
/* hlpQuitHelp:                                                      */
/*    Callback function for macro window button close                */
/*********************************************************************/
void
hlpQuitHelpError(int nummer)
{  
   if (exists[nummer-1]){
      XtDestroyWidget(helpShell[nummer-1]);
      exists[nummer-1] = FALSE;
      }
   return;
}

/*********************************************************************/
/* hlpQuitHelpCmd:                                                   */
/*    Callback function for help window button close                 */
/*********************************************************************/
static void
hlpQuitHelpCmd(Widget w, XtPointer clientData, XtPointer callData)
{  
   
   int nummer = (int) clientData;
   XtPopdown(helpShell[nummer-1]);
   return;
}
