/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Renamed, reformed, and reworked:   January 2002
 *
 */

#include  <gtk/gtk.h>


//extern  void close_window();   /* contained in cleanup.c */
//extern  void article();        /* contained in article.c */
//extern  void book();           /* contained in book.c */
//extern  void linkwindow();
//extern  int format;


/* This procedure produces a window allowing selection of the
 * 14 BibTeX reference formats */

void available(GtkWidget *widget)
{
  GtkTooltips *tooltips;
  GtkWidget   *window, *panel, *description, *selectionKeypad, *separ, *finish;
  GtkWidget   *artkey, *bookkey;
  GtkWidget   *bookletkey, *confkey;
  GtkWidget   *inbookkey, *incolkey;
  GtkWidget   *inprockey, *mankey;
  GtkWidget   *masterskey, *misckey;
  GtkWidget   *procedkey, *phdkey;
  GtkWidget   *techkey, *unpubkey;

  extern  void article();
  extern  void book();
  extern  void inproc();
  extern  void phd();
  extern  void masters();
  extern  void incol();
  extern  void booklet();       /* contained in file booklet.c */
  extern  void conference();    /* contained in file conference.c */
  extern  void inbook();        /* contained in file inbook.c */
  extern  void unpublished();   /* contained in file unpublished.c */
  extern  void manual();        /* contained in file manual.c */
  extern  void misc();          /* contained in file misc.c */
  extern  void proceedings();   /* contained in file proceedings.c */
  extern  void techreport();    /* contained in file techreport.c */
  extern  void close_window(GtkWidget);   /* contained in file cleanup.c */


                    /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

                    /* form the outline of the window */

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile select");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size(GTK_WINDOW(window), 250, 300);
  panel = gtk_vbox_new(FALSE, 10);
  description = gtk_label_new("Select a reference type");
  gtk_box_pack_start_defaults(GTK_BOX(panel), description);
  selectionKeypad = gtk_table_new(7, 2, TRUE);
  gtk_widget_set_usize(GTK_WIDGET(selectionKeypad), 230, 210);
  gtk_container_add(GTK_CONTAINER(window), panel);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);
  gtk_box_pack_start_defaults(GTK_BOX(panel), selectionKeypad);
  separ = gtk_hseparator_new();
  gtk_box_pack_start_defaults(GTK_BOX(panel), separ);
  finish = gtk_button_new_with_label("Cancel");
  gtk_widget_set_usize(GTK_WIDGET(finish), 130, 30);
  g_signal_connect(GTK_OBJECT(finish), "clicked",
                   G_CALLBACK(close_window), NULL);
  gtk_box_pack_start_defaults(GTK_BOX(panel), finish);
  gtk_tooltips_set_tip(tooltips, finish,
                       "Finished inserting into this reference database", NULL);

                    /* connect the Article reference type */
  artkey = gtk_button_new_with_label("Article");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            artkey, 0, 1, 0 ,1);
  g_signal_connect(GTK_OBJECT(artkey), "clicked",
                   G_CALLBACK(article), NULL);
  gtk_tooltips_set_tip(tooltips, artkey,
                       "Make an Article reference", NULL);

                    /* connect the Book reference type */
  bookkey = gtk_button_new_with_label("Book");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            bookkey, 0, 1, 1 ,2);
  g_signal_connect(GTK_OBJECT(bookkey), "clicked",
                   G_CALLBACK(book), NULL);
  gtk_tooltips_set_tip(tooltips, bookkey,
                       "Make a Book reference", NULL);

                    /* connect the Booklet reference type */
  bookletkey = gtk_button_new_with_label("Booklet");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            bookletkey, 0, 1, 2 ,3);
  g_signal_connect(GTK_OBJECT(bookletkey), "clicked",
                   G_CALLBACK(booklet), NULL);
  gtk_tooltips_set_tip(tooltips, bookletkey,
                       "Make a Booklet reference", NULL);

                    /* connect the Conference reference type */
  confkey = gtk_button_new_with_label("Conference");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            confkey, 0, 1, 3 ,4);
  g_signal_connect(GTK_OBJECT(confkey), "clicked",
                   G_CALLBACK(conference), NULL);
  gtk_tooltips_set_tip(tooltips, confkey,
                       "Make a reference to a Conference", NULL);

                    /* connect the InBook reference type */
  inbookkey = gtk_button_new_with_label("In Book");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            inbookkey, 0, 1, 4 ,5);
  g_signal_connect(GTK_OBJECT(inbookkey), "clicked",
                   G_CALLBACK(inbook), NULL);
  gtk_tooltips_set_tip(tooltips, inbookkey,
                       "Make an In Book reference", NULL);

                    /* connect the InCollection reference type */
  incolkey = gtk_button_new_with_label("In Collection");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            incolkey, 0, 1, 5 ,6);
  g_signal_connect(GTK_OBJECT(incolkey), "clicked",
                   G_CALLBACK(incol), NULL);
  gtk_tooltips_set_tip(tooltips, incolkey,
                       "Make an In Collection reference", NULL);

                    /* connect the InProceedings reference type */
  inprockey = gtk_button_new_with_label("In Proceedings");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            inprockey, 0, 1, 6 ,7);
  g_signal_connect(GTK_OBJECT(inprockey), "clicked",
                   G_CALLBACK(inproc), NULL);
  gtk_tooltips_set_tip(tooltips, inprockey,
                       "Make an In Proceedings reference", NULL);

                    /* connect the Manual reference type */
  mankey = gtk_button_new_with_label("Manual");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            mankey, 1, 2, 0 ,1);
  g_signal_connect(GTK_OBJECT(mankey), "clicked",
                   G_CALLBACK(manual), NULL);
  gtk_tooltips_set_tip(tooltips, mankey,
                       "Make a reference to a Manual", NULL);

                    /* connect the Masters reference type */
  masterskey = gtk_button_new_with_label("Masters thesis");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            masterskey, 1, 2, 1 ,2);
  g_signal_connect(GTK_OBJECT(masterskey), "clicked",
                   G_CALLBACK(masters), NULL);
  gtk_tooltips_set_tip(tooltips, masterskey,
                       "Make a reference to a Masters thesis", NULL);

                    /* connect the Misc reference type */
  misckey = gtk_button_new_with_label("Misc");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            misckey, 1, 2, 2 ,3);
  g_signal_connect(GTK_OBJECT(misckey), "clicked",
                   G_CALLBACK(misc), NULL);
  gtk_tooltips_set_tip(tooltips, misckey,
                       "Make a reference to a Miscellaneous type document", NULL);

                    /* connect the PhDthesis reference type */
  phdkey = gtk_button_new_with_label("PhD thesis");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            phdkey, 1, 2, 3 ,4);
  g_signal_connect(GTK_OBJECT(phdkey), "clicked",
                   G_CALLBACK(phd), NULL);
  gtk_tooltips_set_tip(tooltips, phdkey,
                       "Make a reference to a PhD thesis", NULL);

                    /* connect the Proceedings reference type */
  procedkey = gtk_button_new_with_label("Proceedings");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            procedkey, 1, 2, 4 ,5);
  g_signal_connect(GTK_OBJECT(procedkey), "clicked",
                   G_CALLBACK(proceedings), NULL);
  gtk_tooltips_set_tip(tooltips, procedkey,
                       "Make a reference to a Proceedings", NULL);

                    /* connect the TechReport reference type */
  techkey = gtk_button_new_with_label("Tech Report");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            techkey, 1, 2, 5 ,6);
  g_signal_connect(GTK_OBJECT(techkey), "clicked",
                   G_CALLBACK(techreport), NULL);
  gtk_tooltips_set_tip(tooltips, techkey,
                       "Make a reference to a Technical Report", NULL);

                    /* connect the Unpublished reference type */
  unpubkey = gtk_button_new_with_label("Unpublished");
  gtk_table_attach_defaults(GTK_TABLE(selectionKeypad),
                            unpubkey, 1, 2, 6 ,7);
  g_signal_connect(GTK_OBJECT(unpubkey), "clicked",
                   G_CALLBACK(unpublished), NULL);
  gtk_tooltips_set_tip(tooltips, unpubkey,
                       "Make a reference to an Unpublished document", NULL);


                    /* make the composite window visible on the screen */
  gtk_widget_show_all(window);
}
