/*
** Datei: DVIFX80.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dviframe.h"
#include "dvihdcp.h"


/*
** ------------------------ FX80 (240x216) --------------------
*/

static int send_fx80(long addr, int words, int frame_width, int pos)
{
    unsigned int lines, columns, pattern;
    for (lines=0; lines<3; lines++, addr+=frame_width)
    {
	if (op.separate) { pattern=0xAAAA; columns=0; }
	else {pattern=0xFFFF; columns=1; }
	for (; columns<2; columns++, pattern>>=1)
	{
	    register int i;
	    prbyte(27); prbyte('Z');
	    prbyte( (words*16+pos)&255 );
	    prbyte( (words*16+pos)>>8  );
	    for (i=0; i<pos; i++) prbyte(0);
	    send8(frame_ptr(addr),words,frame_width*3,pattern);

	    prbyte(13);
	}
	prbyte(10);
    }
    return 3;
}

static void init_fx80(void)
{
    prbyte(27); prbyte('3'); prbyte(1);
}

static void exit_fx80(void)
{
    if (op.formfeed) prbyte(12);
    prbyte(27); prbyte('2');
}

int fx80(void)
{
    extern void skpl_p6low(int);
    return print_page(24,skpl_p6low,send_fx80,init_fx80,exit_fx80);
}
