(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67665,       2701]*)
(*NotebookOutlinePosition[     68516,       2731]*)
(*  CellTagsIndexPosition[     68472,       2727]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Math",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->48,
    FontSlant->"Italic"],
  StyleBox["Source",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->48,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["The Electronic Resource for ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->16],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[" Material",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->16],
  StyleBox["\n\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Submission Form",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Introduction"], "Subtitle",
  Editable->False,
  Evaluatable->False,
  TextAlignment->Left,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This notebook contains the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Submission Form.  You may submit new material for publication in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " via email, anonymous FTP, or conventional postal mail.  A completed ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" Submission Form must accompany all new submissions.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For your convenience, there are two different versions of the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Submission Form contained in this notebook -- a long version and a short \
version.  If you are new to the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " submission process, the long version is recommended.  The long version \
provides more information and examples for each question on the form.  \
Conversely, if you are already familiar with the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " submission process, you may find it easier to use the short version which \
does not contain instructions or examples for the information requested.\n\n\
Both the long and short versions of the form ask the same questions. Complete \
only one version of the Submission Form.  It is not necessary to complete ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["both",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" a ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["long",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" and ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["short",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" form.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Long Version"], "Subtitle",
  Editable->False,
  Evaluatable->False,
  TextAlignment->Left,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Instructions"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This is the long version of the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Submission Form.  The same is requested here as in the short version, \
except more detailed instructions and examples are provided to complement the \
questions.  You do not have to complete both a ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["long",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["version",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" and a ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["short",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["version",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " for the same submission. \n\nYou may submit new material for publication \
in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " via email, anonymous FTP, or conventional postal mail.  A completed ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Submission Form must accompany all new submissions.\n\nIn order to \
provide an accurate listing for your material in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", please complete the required items in this notebook.  Then send all \
files comprising your submission (including this notebook) to ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " as described in the cells labeled Email, FTP, and Postal Mail below.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Email"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The email address for ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["submissions is ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ms-submit@wri.com",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".  Materials can be sent to this address for publication in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " in a number of different formats, including plain-text, NeXTmail, and",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" Eudora attachments",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["NeXTmail and Eudora"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Create a folder on your machine containing the files in your submission, \
plus a completed copy of this Submission Form.  The name of the folder should \
be either your submission title, or your name.  The filenames within the \
folder should be the same as those listed in this notebook.  Then send the \
entire folder as an attachment to ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ms-submit@wri.com",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Conventional email"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "When submitting files with conventional email, each file must be sent as a \
separate message to ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ms-submit@wri.com",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  ".  The subject lines of the messages comprising your submission should be \
identical to the filenames provided in this notebook.  ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["(See the example below for more details.)",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Example"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "A submission entitled \"Pseudo-Random Pulse Sequencing\" might include the \
files ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PseudoRandom.m",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PRSequenceTest.ma",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".  When submitting this material to ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["the subject lines should read:\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["contents of message",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\t\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["subject line",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tSubmission Form\t\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["submission form",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PseudoRandom.m",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\t\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PseudoRandom.m",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PRSequenceTest.ma",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\t\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PRSequenceTest.ma",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["FTP"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "New materials may be submitted via anonymous FTP for publication in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".  The ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" FTP address is ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["mathsource.wri.com",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  ".  The IP# is 140.177.10.5.  All materials comprising your submission, \
including this Submission Form, should be bundled into a .tar.Z, .zip, or \
.sit.hqx archive file and transferred to the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["/pub/incoming",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" directory.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Postal Mail"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Due to the electronic nature of ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", we encourage all submissions be handled through electronic mail or \
anonymous FTP.  However, disks and tapes sent by conventional courier are \
also acceptable.  Load all files comprising your submission and the completed \
Submission Form (this ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["notebook",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[") onto any media on which ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " is distributed. Label each disk or tape with your name, address, and \
submission title and send all materials to:\n\n\t\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Submissions\n\t\tWolfram Research, Inc.\n\t\t100 Trade Centre Drive\n\t\t\
Champaign, IL  61820-7237  USA",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Title of your Submission"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"After the colon on the lines below, please type the title for your entire \
submission, for example: \"Pseudo-Random Pulse Sequencing\"."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Submission Title:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["   Virtual Font Collection to use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" s PostScript Fonts with LaTeX2e and TeX",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Files Included in your Submission"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Complete a filename/description block for each file in your submission. \
Indicate whether the file is a ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" package, ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["notebook",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  ", example, documentation, etc.  Make as many copies of the block as you \
have files.  Please use the naming conventions described in the cell below.  \
The Naming Conventions cell also contains an example file listing.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Naming Conventions and an Example:"], "Subsection",
  Editable->False,
  CellMargins->{{Inherited, Inherited}, {Inherited, 2}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Please use the following standard suffixes in your filenames.\n\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".m",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" packages (ascii text files)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".ma",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["notebook",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["s (all systems)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".mb",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["notebook",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" resource (system-specific)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".txt",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tASCII text file\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".tex",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tTeX or LaTeX document\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".ps\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["PostScript document\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".exe",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tMachine-specific executable\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".zip",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tZip file in PKZIP format\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".uu",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tUuencoded file\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".Z",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tCompressed file (Unix)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".tar.Z",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tCompressed tar file (Unix)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".hqx",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tBinhexed file (Macintosh)\n\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".sit",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\tStuffit file (Macintosh)\n\nTo ensure that all ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " users have an equal chance to use your material to its full potential, \
please make sure the first eight characters of each file name are unique for \
every file in your submission.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Example:"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Filename:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  PseudoRandom.m  Mathematica Package\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Revision Date:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  December 1993",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Filename:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  PRSequenceTest.ma Example notebook for PseudoRandom.m\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Revision Date:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  January 1994",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Filenames and Descriptions",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[":",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Complete a Filename/Description and Revision Date block for each file in \
your ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" submission.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "\n",
  StyleBox["texmf/doc/mma: ",
    FontWeight->"Bold"],
  "Documentation of the Virtual TeX Font Collection\n",
  StyleBox["msymdoc.ps   msymdoc.tex\n",
    FontFamily->"Courier"],
  "\n\n",
  StyleBox["texmf/dvips/init: ",
    FontWeight->"Bold"],
  "Map file for dvips\n",
  StyleBox["mma.map",
    FontFamily->"Courier"],
  "\n\n",
  StyleBox["texmf/fonts/tfm/mma: ",
    FontWeight->"Bold"],
  "The TeX tfm files for the native PostScript fonts and the virtual fonts\n",
  
  StyleBox[
  "Math1-Bold.tfm      Math3Mono-Bold.tfm  zwamb.tfm           zwcrb.tfm\n\
Math1.tfm           Math3Mono.tfm       zwamm.tfm           zwcrm.tfm\n\
Math1Mono-Bold.tfm  Math4-Bold.tfm      zwarb.tfm           zwcvb.tfm\n\
Math1Mono.tfm       Math4.tfm           zwarm.tfm           zwcvm.tfm\n\
Math2-Bold.tfm      Math4Mono-Bold.tfm  zwavb.tfm           zwcyb.tfm\n\
Math2.tfm           Math4Mono.tfm       zwavm.tfm           zwcym.tfm\n\
Math2Mono-Bold.tfm  Math5-Bold.tfm      zwayb.tfm           zwsm.tfm\n\
Math2Mono.tfm       Math5.tfm           zwaym.tfm\nMath3-Bold.tfm      \
Math5Mono-Bold.tfm  zwcmb.tfm\nMath3.tfm           Math5Mono.tfm       \
zwcmm.tfm",
    FontFamily->"Courier"],
  "\n\n\n",
  StyleBox["texmf/fonts/vf/mma: ",
    FontWeight->"Bold"],
  "The virtual fonts\n",
  StyleBox[
  "zwamb.vf  zwarb.vf  zwavm.vf  zwcmb.vf  zwcrm.vf  zwcyb.vf\nzwamm.vf  \
zwarm.vf  zwayb.vf  zwcmm.vf  zwcvb.vf  zwcym.vf\nzwamr.vf  zwavb.vf  \
zwaym.vf  zwcrb.vf  zwcvm.vf  zwsm.vf\n",
    FontFamily->"Courier"],
  "\n",
  StyleBox["texmf/tex/latex/mma: ",
    FontWeight->"Bold"],
  "The font definition files for LaTeX2e and the macro package mmasym.sty for \
the encoded new symbols\n",
  StyleBox[
  "OMLzwam.fd  OMSzwcy.fd  OT1zwar.fd  mmasym.sty  omszway.fd  omxzwcv.fd  \
uzws.fd\nOMLzwmc.fd  OMXzwav.fd  OT1zwcr.fd  omlzwam.fd  omszwcy.fd  \
ot1zwar.fd\nOMSzway.fd  OMXzwcv.fd  Uzws.fd     omlzwcm.fd  omxzwav.fd  \
ot1zwcr.fd",
    FontFamily->"Courier"],
  "\n"
}], "Text"],

Cell[TextData[{
  StyleBox["Revision Date:",
    FontWeight->"Bold"],
  " November 1997"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData["Classification and Keywords"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " collection is divided into four main categories:  General, Enhancements, \
Applications, and Publications.   Please \"X\" each category/sub-category \
below that applies to your submission:  The checked areas will be used as \
keywords for your submission, and as guidelines for placing your submission \
in the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " collection.  Note that more than one subject area may be marked.  Use the \
Additional Keywords section to provide more precise indexing information for \
your submission.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Primary Category Selection"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["General"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This directory contains items of general interest to the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" community, such as administrative info, Mathgroup archives, ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" tutorials, ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" information, utility programs, and ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " tips. The General directory also contains programs, tips, and technical \
information for specific computer platforms on which ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" is available. ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["General directory listing",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Bold"]], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Administrative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Archives",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Demos",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Information",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathReader",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Info",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Utilities",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Systems",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Apollo",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Convex",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DEC",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DOS",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["HP",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["300-400",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["700",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["General",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mac",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NEC",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NeXT",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RS6000",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Sparc",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Sun",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Unix",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Windows",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Tips",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Tutorials",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Algebraic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["General",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Graphics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Numerical",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Programming",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Utilities",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Enhancements"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The Enhancements directory contains items that enhance the functionality \
of ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " beyond the capabilities of the basic kernel. Included in this directory \
are different methods of interfacing with ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", programming examples, topic-specific enhancements in mathematics and \
graphics, and more. ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Enhancements Directory Listing",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Bold"]], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Algebraic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DiscreteMath",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FrontEnd",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Geometry",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Graphics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["2D",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["3D",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Animation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["General",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[X]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Interfacing",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DOS",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Emacs",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Fortran",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Graphics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["InterCall",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mac",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Matlab",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NeXT",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SGI",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[X]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["TeX",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["WordPerfect",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Language",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LinearAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathFunctions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathLink",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NumberTheory",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Numerical",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Sound",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Statistics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["System",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Applications"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Items in this directory deal with the application of ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " to specific problems or subject areas. The subcategories group related \
items together into manageable sizes. Subcategories under Applications \
include: Audio, Astronomy, Chemistry, Complexity, Computer Science, \
Data-Tables, Economics-Finance, Education, Engineering, Geography, Graphics, \
Life Science, Material Science, Mathematics, and Physics. ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Applications Directory Listing",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Bold"]], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Audio\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Astronomy\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Chemistry",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Complexity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ComputerScience",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DataTables",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["EconomicsFinance",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Education",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Calculus",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Engineering",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Control",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Electrical",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Signals",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["General",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mechanical",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Geography",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Graphics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["2D",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["3D",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Animation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LifeScience",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MaterialScience",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Applied",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Pure",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Physics",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Publications"], "Subsubsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The Publications directory contains the elctronic supplements for The \
Mathematica Journal, Mathematica in Educaton, and MathUser; example code from \
",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " books; bibliographical information; Mathematica documentation, etc.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Publications Directory Listing",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Bold"]], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Announcements",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Bibliography",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["BookSupplements",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Documentation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Other",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Periodicals",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathUser",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathematicaInEducation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\n\t[ ]  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["TheMathematicaJournal",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Additional Keywords"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "You may provide additional, specific keywords for your submission. These \
keywords are analogous to index entries and are used by the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" search routines to identify your submission",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[".  Keywords should be listed one per line.  Duplicate the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Keyword: ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["block below as many times as necessary, once for each keyword.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Keyword:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  LaTeX2e",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Keyword:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  Virtual TeX fonts",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Keyword:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  Typesetting",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Abstract of Material "], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Provide a brief summary of the purpose and content of your material (about \
200 words or less, please):"], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Abstract:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "  The virtual font collection enables TeX/LaTeX2e users the access to the \
mathematical fonts distributed with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" 3.0 from LaTeX2e and TeX. By using the style file ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["mmasym.sty ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "the LaTeX2e user can produce a bitmap free TeX output. The the fonts \
encode almost all new symbols introduced by ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[
  " 3.0. The font collection includes the mono spaced fonts for typesetting ",
    
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" s Input in TeX exactly as on the screen.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Author Information"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Copy the template below for each author. Fill in all fields for each \
author in a separate template block.  Only your name and affiliation (if any) \
will be published in ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", outside of the files you supply.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Name:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  Jens-Peer Kuska\t\t\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Organization:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  \tMax-Planck Insitut f\[UDoubleDot]r Aeronomie\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Street address:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  Max-Planck-Strasse 2\t\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["City:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  \tKatlenburg-Lindau\t\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["State:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  \t\t\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZIP/Postal code:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  37191\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Country: ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Germany\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Telephone:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" \t[49] 5556 979160 \n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Fax:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  \t\t[49] 5556 979240\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Email:",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["  kuska@osf2.mpae.gwdg.de\t\t",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Distribution and Copyright"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Please check the appropriate distribution information box below."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["\t[ X] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["YES",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[", this package can be distributed freely.\n\t[ ] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NO",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[",   this package is not for free distribution.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "All material received will be assumed to be for free distribution in the \
public domain in accordance with the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" Author Agreement.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\n\n",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\t",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "You are fully responsible for the contents of your submission.  It is your\
\n\t responsibility to ensure that the work does not infringe any applicable\n\
\t patent, copyright, trademark, or trade secret agreements.",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Additional Comments"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Additional comments or questions for the ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MathSource",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" administrator:",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["\n"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{825, 627},
WindowMargins->{{178, Automatic}, {Automatic, 107}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 1365, 56, 222, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3099, 109, 132, 4, 98, "Subtitle",
  Evaluatable->False],
Cell[3234, 115, 1041, 37, 96, "Text",
  Evaluatable->False],
Cell[4278, 154, 2091, 69, 246, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6406, 228, 132, 4, 98, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6563, 236, 108, 3, 77, "Section",
  Evaluatable->False],
Cell[6674, 241, 2711, 96, 296, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9410, 341, 104, 3, 72, "Subsection",
  Evaluatable->False],
Cell[9517, 346, 1248, 46, 97, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10790, 396, 121, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[10914, 401, 773, 23, 122, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[11724, 429, 120, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[11847, 434, 792, 26, 98, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[12676, 465, 109, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[12788, 470, 2577, 100, 221, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15414, 576, 102, 3, 72, "Subsection",
  Evaluatable->False],
Cell[15519, 581, 1375, 49, 122, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[16931, 635, 110, 3, 72, "Subsection",
  Evaluatable->False],
Cell[17044, 640, 1553, 51, 271, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18646, 697, 120, 3, 77, "Section",
  Evaluatable->False],
Cell[18769, 702, 230, 5, 71, "Text",
  Evaluatable->False],
Cell[19002, 709, 497, 17, 71, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[19536, 731, 129, 3, 77, "Section",
  Evaluatable->False],
Cell[19668, 736, 922, 30, 121, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20615, 770, 190, 4, 45, "Subsection",
  Evaluatable->False],
Cell[20808, 776, 4902, 189, 496, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[25735, 969, 110, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[25848, 974, 574, 22, 71, "Text",
  Evaluatable->False],
Cell[26425, 998, 591, 22, 71, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27065, 1026, 329, 13, 72, "Subsection",
  Evaluatable->False],
Cell[27397, 1041, 490, 19, 71, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[27914, 1064, 2008, 51, 808, "Text"],
Cell[29925, 1117, 100, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[30050, 1125, 123, 3, 77, "Section",
  Evaluatable->False],
Cell[30176, 1130, 1103, 34, 171, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31304, 1168, 125, 3, 72, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31454, 1175, 109, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[31566, 1180, 1563, 55, 121, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[33154, 1239, 217, 7, 46, "Text",
  Evaluatable->False],
Cell[33374, 1248, 955, 38, 146, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[34354, 1290, 274, 11, 46, "Text",
  Evaluatable->False],
Cell[34631, 1303, 423, 17, 71, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[35091, 1325, 246, 10, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[35362, 1339, 766, 31, 121, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[36153, 1374, 243, 10, 46, "Text",
  Evaluatable->False],
Cell[36399, 1386, 602, 24, 96, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[37016, 1413, 1456, 59, 221, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[38499, 1476, 243, 10, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[38767, 1490, 248, 10, 46, "Text",
  Evaluatable->False],
Cell[39018, 1502, 961, 38, 146, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[39994, 1543, 248, 10, 46, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40291, 1559, 114, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[40408, 1564, 907, 32, 121, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[41340, 1600, 222, 7, 46, "Text",
  Evaluatable->False],
Cell[41565, 1609, 777, 31, 121, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[42367, 1644, 246, 10, 46, "Text",
  Evaluatable->False],
Cell[42616, 1656, 766, 31, 121, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[43419, 1692, 250, 10, 46, "Text",
  Evaluatable->False],
Cell[43672, 1704, 2165, 87, 321, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[45852, 1794, 1948, 78, 271, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47849, 1878, 114, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[47966, 1883, 806, 22, 146, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[48797, 1909, 222, 7, 46, "Text",
  Evaluatable->False],
Cell[49022, 1918, 1315, 52, 196, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[50362, 1974, 248, 10, 46, "Text",
  Evaluatable->False],
Cell[50613, 1986, 423, 17, 71, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[51073, 2008, 250, 10, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[51348, 2022, 248, 10, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[51621, 2036, 251, 10, 46, "Text",
  Evaluatable->False],
Cell[51875, 2048, 250, 10, 46, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[52140, 2061, 601, 24, 96, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[52768, 2089, 248, 10, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[53041, 2103, 246, 10, 46, "Text",
  Evaluatable->False],
Cell[53290, 2115, 592, 24, 96, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[53897, 2142, 432, 17, 71, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[54354, 2163, 250, 10, 46, "Text",
  Evaluatable->False],
Cell[54607, 2175, 421, 17, 71, "Text",
  Evaluatable->False]
}, Open  ]],
Cell[55043, 2195, 418, 17, 71, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55510, 2218, 114, 3, 60, "Subsubsection",
  Evaluatable->False],
Cell[55627, 2223, 622, 21, 96, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[56274, 2248, 222, 7, 46, "Text",
  Evaluatable->False],
Cell[56499, 2257, 965, 38, 146, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[57489, 2299, 250, 10, 46, "Text",
  Evaluatable->False],
Cell[57742, 2311, 630, 24, 96, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58445, 2343, 118, 3, 72, "Subsection",
  Evaluatable->False],
Cell[58566, 2348, 997, 32, 121, "Text",
  Evaluatable->False],
Cell[59566, 2382, 251, 10, 46, "Text",
  Evaluatable->False],
Cell[59820, 2394, 261, 10, 46, "Text",
  Evaluatable->False],
Cell[60084, 2406, 255, 10, 46, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60388, 2422, 117, 3, 77, "Section",
  Evaluatable->False],
Cell[60508, 2427, 198, 5, 46, "Text",
  Evaluatable->False],
Cell[60709, 2434, 1464, 49, 146, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[62210, 2488, 114, 3, 77, "Section",
  Evaluatable->False],
Cell[62327, 2493, 604, 20, 71, "Text",
  Evaluatable->False],
Cell[62934, 2515, 1989, 73, 271, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[64960, 2593, 122, 3, 77, "Section",
  Evaluatable->False],
Cell[65085, 2598, 158, 4, 46, "Text",
  Evaluatable->False],
Cell[65246, 2604, 569, 20, 71, "Text",
  Evaluatable->False],
Cell[65818, 2626, 1094, 37, 171, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[66949, 2668, 115, 3, 77, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[67089, 2675, 457, 17, 72, "Subsection",
  Evaluatable->False],
Cell[67549, 2694, 76, 2, 71, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

