#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

CUR_DIR=$PWD
SCRIPT_DIR=$CUR_DIR/pescript
SRC_DIR=$CUR_DIR/src
OUT_DIR=$CUR_DIR/output
MK_FONT="fontforge -script $SCRIPT_DIR/makefont.pe"

function process_family () {
    TAG=$1
    LANG=$2
    LANG_FULL=$3
    ENC=$4
    
    $MK_FONT "fcmr$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Regular" "" "" $TAG "fcmr$ENC"
    $MK_FONT "fcmri$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "" "Italic" "" $TAG "fcmri$ENC"
    $MK_FONT "fcmrc$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Regular" "" "SC" $TAG "fcmrc$ENC"
    $MK_FONT "fcmrij$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "" "Italic" "OsF" $TAG "fcmrij$ENC"
    $MK_FONT "fcmb$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Bold" "" "" $TAG "fcmb$ENC"
    $MK_FONT "fcmbi$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Bold" "Italic" "" $TAG "fcmbi$ENC"
    $MK_FONT "fcmbc$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Bold" "" "SC" $TAG "fcmbc$ENC"
    $MK_FONT "fcmbij$TAG" "CM Roman$LANG" "Computer Modern Roman$LANG_FULL" "Bold" "Italic" "OsF" $TAG "fcmbij$ENC"

    $MK_FONT "fcsr$TAG" "CM Sans$LANG" "Computer Modern Sans$LANG_FULL" "Regular" "" "" $TAG "fcsr$ENC"
    $MK_FONT "fcsro$TAG" "CM Sans$LANG" "Computer Modern Sans$LANG_FULL" "" "Slanted" "" $TAG "fcsro$ENC"
    $MK_FONT "fcsb$TAG" "CM Sans$LANG" "Computer Modern Sans$LANG_FULL" "Bold" "" "" $TAG "fcsb$ENC"
    $MK_FONT "fcsbo$TAG" "CM Sans$LANG" "Computer Modern Sans$LANG_FULL" "Bold" "Slanted" "" $TAG "fcsbo$ENC"

    $MK_FONT "fctr$TAG" "CM Typewriter$LANG" "Computer Modern Typewriter$LANG_FULL" "Regular" "" "" $TAG "fctr$ENC"
    $MK_FONT "fctri$TAG" "CM Typewriter$LANG" "Computer Modern Typewriter$LANG_FULL" "" "Italic" "" $TAG "fctri$ENC"
    $MK_FONT "fctrc$TAG" "CM Typewriter$LANG" "Computer Modern Typewriter$LANG_FULL" "Regular" "" "SC" $TAG "fctrc$ENC"
    $MK_FONT "fctrij$TAG" "CM Typewriter$LANG" "Computer Modern Typewriter$LANG_FULL" "" "Italic" "OsF" $TAG "fctrij$ENC"
}

if !([ -d $SRC_DIR ]); then
    mkdir $SRC_DIR
fi

if !([ -d $OUT_DIR ]); then
    mkdir $OUT_DIR
fi

cd $SCRIPT_DIR
process_family "lat" "" "" "8a"
process_family "ceu" " CE" " Central European" "ce"
process_family "cyr" " Cyrillic" " Cyrillic" "6z"
process_family "asi" " Asian" " Asian Cyrillic" "6y"
process_family "grk" " Greek" " Greek" "pg"
