# -*- python -*-
# Focus is a dialog for TFMPK application.
# It holds a images of:
# + single character
# + Kerning pair
# + Extension character.

import GDK;
import GTK;
import gtk;
import gnome.ui;
#
import tfm;
import canvases;
# import gdkgoods;
import gtkgoods;
import goods;

# class Focus(gnome.ui.GnomeDialog):
class Focus(gtk.GtkWindow):
   "Focus dialog for TFMPK"
   def __init__(self, tfmpkFont=None, title="TFMPK - Focus", magInitVal=2):
      gtk.GtkWindow.__init__(self, title=title);
      self.set_geometry_hints(base_width=300, base_height=300,
                              min_width=300,  min_height=300,
                              max_width=gtkgoods.MaxScreenSize, 
                              max_height=gtkgoods.MaxScreenSize);
      self._tfmpkFont = tfmpkFont;
      self.tfm = tfmpkFont.tfm();
      self._focusItem = None;
      vbox = gtk.GtkVBox();
      notebook = gtkgoods.MyNoteBook()
      notebook.set_tab_pos(GTK.POS_TOP)
      pageChar = self.makePageChar(notebook.newPage("Character"));
      lengths = self.tfm.lengths();
      self.kernShow = None;
      self.extenShow = None;
      lkk1st = self.firstKernInLigKern();
      if lkk1st != -1:
         self.kernShow = KernShow(tfmpkFont, notebook.newPage("Kerning"),
                                  lkk1st, magInitVal);
      if lengths[tfm.ne]:
         self.extenShow = ExtenShow(tfmpkFont, notebook.newPage("Extension"),
                                    magInitVal);
      pageChar.show();
      notebook.show();
      vbox.pack_start(notebook);
      hbox = gtk.GtkHBox();
      mag = gtk.GtkLabel("Magnify:");
      mag.show();
      hbox.pack_start(mag, expand=0, fill=0, padding=2);
      adj = gtk.GtkAdjustment(value=magInitVal, lower=1, upper=6, step_incr=1);
      spinner = self.magSpinner = gtk.GtkSpinButton(adj=adj, digits=0)
      spinner.set_max_length(2);
      spinner.show();
      spinner.connect('event', self.magCallback);
      hbox.pack_start(spinner, expand=0, fill=0, padding=2);
      hbox.show();
      vbox.pack_start(hbox, expand=0, fill=0, padding=3);
      vbox.show();
      self.add(vbox);

   def makePageChar(self, page):
      vbox = gtk.GtkVBox();
      sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC);
      self.canvChar = canv = canvases.FocusChar(self._tfmpkFont, self.probeOut);
      canv.show();
      sw.add(canv);
      sw.show();
      vbox.pack_start(sw);
      self.charInfo = gtk.GtkLabel("Char Probe Info:");
      self.charInfo.show();
      vbox.pack_start(self.charInfo, expand=0, fill=0, padding=2);
      vbox.show();
      page.add(vbox);
      return page;

   def selectChar(self, c):
      self.probeOut();
      self.canvChar.draw(self._tfmpkFont.pk(), c,
                         self.magSpinner.get_value_as_int());

   def magCallback(self, w, e):
      # print "magCallback: w=", w;
      #gdkgoods.printEvent(e);
      if (e.type == GDK.BUTTON_RELEASE or
          e.type == GDK.KEY_RELEASE and e.keyval == GDK.Return):
         self.selectChar(self._tfmpkFont.getSelection());
         if self.kernShow != None:
            self.kernShow.redraw(w.get_value_as_int());
         if self.extenShow != None:
            self.extenShow.setMag(w.get_value_as_int());

   def probeOut(self, msg=""):
      if msg == "":
         sc = self._tfmpkFont.selectedChar();
         pk = self._tfmpkFont.pk();
         msg = goods.charDisplay(sc) +  ("  %dx%d +(%d,%d)" %
                (pk.bitmapwidth(sc), pk.bitmapheight(sc),
                 pk.hoff(sc), pk.voff(sc)));
      self.charInfo.set_text(msg);
      gtk.gdk_flush();
   # Get index of first LigKern entry which is Kerning, -1 otherwise
   def firstKernInLigKern(self):
      i = -1;
      self.tfm = self._tfmpkFont.tfm()
      lki = 0;
      nl = self.tfm.lengths()[tfm.nl];
      while  i == -1  and  lki < nl:
         lk = self.tfm.ligkern(lki);
         kernFlag = ((lk[tfm.ligkern_byte_op] & 0x80) != 0);
         if kernFlag:
            i = lki;
         lki = lki + 1;
      return i;

   def setKernEntry(self, lki):
      self.kernShow.setKernEntry(lki);

# Kern page show the effect of kerning between pair of characters.
# Each Kerning-program record (LigKern) determines the _second_ character,
# but there could be several 1st characters.
# We provide user control on thefirst character,
# and whether to activate the kerning.
class KernShow:
   def __init__(self, tfmpkFont, page, ki, magInitVal):
      self._tfmpkFont = tfmpkFont;
      self.tfm = tfmpkFont.tfm();
      self._mag = magInitVal;
      hbox = gtk.GtkHBox();
      #
      vboxL = gtk.GtkVBox();
      self.char1stList = char1stList = gtk.GtkCList(1, ["1st-Char"]);
      # gtkgoods.clistSetFixedFont(char1stList);
      char1stList.set_column_auto_resize(0, 1);
      char1stList.connect('event', self.char1st_cb);
      char1stList.thaw();
      char1stList.show();
      sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_NEVER, GTK.POLICY_AUTOMATIC);
      sw.add(char1stList);
      sw.show();
      vboxL.pack_start(sw, expand=1, fill=1, padding=3);
      kernCheck = self.kernCheck = gtk.GtkCheckButton("Kern");
      kernCheck.connect('clicked', self.check_cb);
      kernCheck.show();
      vboxL.pack_start(kernCheck, expand=0, fill=0, padding=5);
      vboxL.show();
      hbox.pack_start(vboxL, expand=0, fill=1, padding=3);
      #
      vboxR = gtk.GtkVBox();
      title = self.pairTitle = gtk.GtkLabel("??? + ???");
      title.show();
      vboxR.pack_start(title, expand=0, fill=0, padding=3);
      sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC);
      self.canvKern = canv = canvases.Kern(tfmpkFont, ki);
      canv.show();
      sw.add(canv);
      sw.show();
      vboxR.pack_start(sw, expand=1, fill=1, padding=6);
      vboxR.show();
      hbox.pack_start(vboxR, padding=2);
      #
      hbox.show();
      page.add(hbox);
      self.setKernEntry(ki);
      page.show();
   def setKernEntry(self, lki):
      self.kernEntryIndex = lki;
      self.char1stList.clear();
      self.owners = self.tfm.ligkernusers(lki);
      ffStyle = gtkgoods.getFFStyleFrom(self.char1stList);
      i = 0;
      for owner in self.owners:
         self.char1stList.append([goods.charDisplay(owner)]);
         self.char1stList.set_row_style(i, ffStyle);
         i = i + 1;
      # gtkgoods.clistSelectShowRow(self.char1stList, 0);
      self.curr1stIndex = 0;
      self.char1stList.select_row(self.curr1stIndex, 0);
      self.showPair(self.curr1stIndex);
   def showPair(self, firstIndex):
      ligkern = self._tfmpkFont.tfm().ligkern(self.kernEntryIndex);
      if firstIndex < len(self.owners):
         char1st = self.owners[firstIndex];
         char2nd = ligkern[tfm.ligkern_byte_next];
         t = goods.charDisplay(char1st) + ' + ' + goods.charDisplay(char2nd);
         self.pairTitle.set_text(t);
         self.canvKern.showPair(self._mag, char1st, char2nd,
                                self.kernCheck.active,
                                ligkern[tfm.ligkern_byte_reminder]);
      else:
         self.pairTitle.set_text("Inaccessible");
         self.canvKern.unshowPair();
   def char1st_cb(self, w, e):
      if e.type == GDK.BUTTON_RELEASE:
         self.curr1stIndex = self.char1stList.focus_row;
         self.showPair(self.curr1stIndex);
   # for strange reason, event is not passed?
   def check_cb(self, w):
      self.showPair(self.curr1stIndex);
   def redraw(self, mag):
      self._mag = mag;
      self.showPair(self.curr1stIndex);

class ExtenShow:
   def __init__(self, tfmpkFont, page, magInitVal):
      self._tfmpkFont = tfmpkFont;
      self._mag = magInitVal;
      vbox = gtk.GtkVBox();
      hbox = gtk.GtkHBox();
      rep = gtk.GtkLabel("#Rep:");
      rep.show();
      hbox.pack_start(rep, expand=0, fill=0, padding=2);
      adj = gtk.GtkAdjustment(value=1, lower=0, upper=8, step_incr=1);
      spinner = self.repSpinner = gtk.GtkSpinButton(adj=adj, digits=0)
      spinner.set_max_length(2);
      spinner.show();
      spinner.connect('event', self.rep_cb);
      hbox.pack_start(spinner, expand=0, fill=0, padding=4);
      hbox.show();
      vbox.pack_start(hbox, expand=0, fill=0, padding=2);
      sw = gtk.GtkScrolledWindow();
      sw.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC);
      canv = self.canvExten = canvases.Exten(tfmpkFont);
      canv.show();
      sw.add(canv);
      sw.show();
      vbox.pack_start(sw, expand=1, fill=1, padding=3);
      vbox.show();
      page.add(vbox);
      page.show();
      self.showExten(0);
   def setMag(self, mag):
      self._mag = mag;
      self.showExten(self._extenIndex);
   def rep_cb(self, w, e):
      if (e.type == GDK.BUTTON_RELEASE or
          e.type == GDK.KEY_RELEASE and e.keyval == GDK.Return):
         self.showExten(self._extenIndex);
   def showExten(self, ei):
      self._extenIndex = ei;
      recipe = self._tfmpkFont.tfm().exten(ei);
      # print "Focus.showExten: ei=", ei, ", recipe=", recipe;
      self.canvExten.showExten(self._mag,
                               recipe[tfm.exten_top],
                               recipe[tfm.exten_mid],
                               recipe[tfm.exten_bot],
                               recipe[tfm.exten_rep],
                               self.repSpinner.get_value_as_int());
      
if __name__ == '__main__':
   print "Testing Focus dialog";
   import sys;
   dlg = Focus();
   dlg.show();
   gtk.mainloop();
   sys.exit(0);

