/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.util.JVMHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrivilegedRunner {
    private final Platform platform;
    private static final Logger logger = Logger.getLogger(PrivilegedRunner.class.getName());

    public PrivilegedRunner(Platform platform) {
        this.platform = platform;
    }

    public boolean isPlatformSupported() {
        return this.platform.isA(Platform.Name.UNIX) || this.platform.isA(Platform.Name.WINDOWS);
    }

    public boolean isElevationNeeded() {
        return this.isElevationNeeded(null);
    }

    public boolean isElevationNeeded(String path) {
        boolean result;
        if (this.platform.isA(Platform.Name.WINDOWS)) {
            if (path != null) {
                path = new File(path).getParent();
            }
            if (path == null || path.trim().length() == 0) {
                path = this.getProgramFiles();
            }
            result = !PrivilegedRunner.isPrivilegedMode() && !this.canWrite(path);
        } else {
            result = path != null ? !this.canWrite(path) : !System.getProperty("user.name").equals("root");
        }
        return result;
    }

    public boolean isAdminUser() {
        if (this.platform.isA(Platform.Name.WINDOWS)) {
            try {
                String NTAuthority = "HKU\\S-1-5-19";
                String command = "reg query \"" + NTAuthority + "\"";
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                return p.exitValue() == 0;
            }
            catch (Exception e) {
                return this.canWrite(this.getProgramFiles());
            }
        }
        try {
            String command = "id -u";
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            InputStream stdIn = p.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stdIn));
            String value = bufferedReader.readLine();
            return value.equals("0");
        }
        catch (Exception e) {
            return System.getProperty("user.name").equals("root");
        }
    }

    public boolean hasCorrectPermissions(Info info, RulesEngine rules) {
        if (info.isPrivilegedExecutionRequired()) {
            boolean shouldElevate = true;
            String conditionId = info.getPrivilegedExecutionConditionID();
            if (conditionId != null) {
                shouldElevate = rules.getCondition(conditionId).isTrue();
            }
            if (shouldElevate) {
                return this.isAdminUser();
            }
        }
        return true;
    }

    public int relaunchWithElevatedRights() throws Exception {
        return this.relaunchWithElevatedRights(new String[0]);
    }

    public int relaunchWithElevatedRights(String ... args) throws Exception {
        if (!this.platform.isA(Platform.Name.WINDOWS)) {
            throw new Exception("Installer should be run as admin");
        }
        String javaCommand = this.getJavaCommand(args);
        String installer = this.getInstallerJar();
        ProcessBuilder builder = new ProcessBuilder(this.getElevator(javaCommand, installer, args));
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Relaunching: " + StringTool.listToString(builder.command(), " "));
        }
        builder.environment().put("izpack.mode", "privileged");
        Process process = builder.start();
        return process.waitFor();
    }

    public static boolean isPrivilegedMode() {
        return "privileged".equals(System.getenv("izpack.mode")) || "privileged".equals(System.getProperty("izpack.mode"));
    }

    protected List<String> getElevator(String javaCommand, String installer, String[] args) throws IOException {
        List<String> jvmArgs = new JVMHelper().getJVMArguments();
        ArrayList<String> elevator = new ArrayList<String>();
        if (this.platform.isA(Platform.Name.MAC_OSX)) {
            elevator.add(this.extractMacElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.addAll(jvmArgs);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (this.platform.isA(Platform.Name.UNIX)) {
            elevator.add("xterm");
            elevator.add("-title");
            elevator.add("Installer");
            elevator.add("-e");
            elevator.add("sudo");
            elevator.add(javaCommand);
            elevator.addAll(jvmArgs);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (this.platform.isA(Platform.Name.WINDOWS)) {
            elevator.add("wscript");
            elevator.add(this.extractVistaElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.addAll(jvmArgs);
            elevator.add("-Dizpack.mode=privileged");
            elevator.add("-jar");
            elevator.add(installer);
        }
        for (String arg : args) {
            elevator.add(arg);
        }
        return elevator;
    }

    protected File extractVistaElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer.js";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/util/windows/elevate.js");
        this.copyStream(out, in);
        in.close();
        out.close();
        elevator.deleteOnExit();
        return elevator;
    }

    protected File extractMacElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/util/mac/run-with-privileges-on-osx");
        this.copyStream(out, in);
        in.close();
        out.close();
        if (!elevator.setExecutable(true)) {
            throw new IOException("Failed to set execute permission on " + path);
        }
        elevator.deleteOnExit();
        return elevator;
    }

    private void copyStream(OutputStream out, InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private String getInstallerJar() {
        try {
            URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uri.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uri);
            }
            return new File(uri.getSchemeSpecificPart()).getCanonicalPath();
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    private String getJavaCommand(String[] args) {
        boolean console = false;
        if (args.length > 0) {
            console = true;
        }
        String java = this.platform.isA(Platform.Name.WINDOWS) ? (console ? "java.exe" : "javaw.exe") : "java";
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + java;
    }

    private boolean canWrite(String path) {
        File file = new File(path);
        boolean canWrite = file.canWrite();
        if (canWrite) {
            try {
                File test = File.createTempFile(".izpackwritecheck", null, file);
                if (!test.delete()) {
                    test.deleteOnExit();
                }
            }
            catch (IOException exception) {
                canWrite = false;
            }
        }
        return canWrite;
    }

    private String getProgramFiles() {
        String path = System.getenv("ProgramFiles");
        if (path == null) {
            path = "C:\\Program Files";
        }
        return path;
    }
}

