UNIT EXSYSTEM;

{$IFDEF DOK}
    ============================ UNIT EXSYSTEM =============================
    UNIT zur Ergaenzung des Standardunits SYSTEM.
    Enthaelt:
      Mathematische Funktionen, Rundungsfunktionen
      Binaer- und Hexdarstellung von Zahlen.
      Verbesserte Routinen zur Umwandlung von Zahlenstring in Zahlen
      und umgekehrt.

    Legende:
    --------
    Datum        Routinen                               bearbeitet von

    Version 1.00:
    01.12.88     ValReal, ValInt                        Robert Ebe
    02.02.89     LgT,Pwr,PwrTn,PwrT                     M.Mayr-Willius

    Version 1.10:
    09.04.89     ValReal, ValInt in FUNCTIONs umgewandelt,
                 alle REAL in EXTENDED,
                 Compiler-Schalter fuer Koprozessor,
                 LoChar,LoCharExt,UpChar,UpCharExt,
                 Tan,ArcSin,ArcCos,ArcCot,ArcTan2,
                 Sinh,Cosh,Tanh,Coth,
                 ArSinh,ArCosh,ArTanh,ArCoth            Robert Ebe
    Version 1.11:
    21.04.89     Exponent,Mantisse,RoundReal,RoundStr   Robert Ebe

    Version 1.12:
    21.07.89     ValInt in Typ LONGINT geaendert        Robert Ebe

    Version 1.13:
    08.10.89     HexString, BinString                   Robert Ebe
    Version 1.14:
    05.12.89     Cot
                 xxCharExt in xxCharX umbenannt
                 xxStringExt in xxStringX umbenannt
                 Laufzeitfehlermeldung eingebaut        Robert Ebe
{$ENDIF DOK}

{$A+ Variablen auf Wortgrenzen legen }
{$B- Kurzschlussverfahren fuer boolsche Ausdruecke }
{$D- keine Debug-Informationen aufnehmen }
{$I- keine Ein-/Ausgabepruefung (da keine Ein-/Ausgaben in dieser UNIT) }
{$L- keine lokalen Informationen aufnehmen }
{$N+ verwende Coprozessor... }
{$E+ ... bzw. Emulator }
{$O- keine Overlays erlaubt }
{$R- keine Indexueberpruefung }
{$S+ Stack Ueberpruefung eingeschaltet }
{$V- Relaxed VarString-Check }
{$F+ nur FAR-Calls verwenden (wegen Exit-Proc) }
{$H- 89 gab's nur kurze Strings}
INTERFACE
{========}

CONST
  Version    = '89-12-05';
  VersionsNr = '1.14';

{ weitere Exponent- und Logarithmus-Funktionen }
FUNCTION Pwr (mantisse, exponent: EXTENDED): EXTENDED;
FUNCTION PwrT (exponent: EXTENDED): EXTENDED;
FUNCTION LgT (x: EXTENDED): EXTENDED;

FUNCTION Exponent (x: EXTENDED): INTEGER;
FUNCTION Mantisse (x: EXTENDED): EXTENDED;

{ weitere Kreis-Funktionen }
FUNCTION Tan (x: EXTENDED): EXTENDED;
FUNCTION Cot (x: EXTENDED): EXTENDED;
FUNCTION ArcSin (x: EXTENDED): EXTENDED;
FUNCTION ArcCos (x: EXTENDED): EXTENDED;
FUNCTION ArcCot (x: EXTENDED): EXTENDED;
FUNCTION ArcTan2 (Re, Im: EXTENDED): EXTENDED;

{ Hyperbel-Funktionen }
FUNCTION Sinh (x: EXTENDED): EXTENDED;
FUNCTION Cosh (x: EXTENDED): EXTENDED;
FUNCTION Tanh (x: EXTENDED): EXTENDED;
FUNCTION Coth (x: EXTENDED): EXTENDED;
FUNCTION ArSinh (x: EXTENDED): EXTENDED;
FUNCTION ArCosh (x: EXTENDED): EXTENDED;
FUNCTION ArTanh (x: EXTENDED): EXTENDED;
FUNCTION ArCoth (x: EXTENDED): EXTENDED;

{ verbesserte Datenumwandlungen }
FUNCTION ValReal (s: STRING; VAR Code: INTEGER): EXTENDED;
FUNCTION ValInt  (s: STRING; VAR Code: INTEGER): LONGINT;
FUNCTION RoundReal (x: EXTENDED; Stellen: BYTE): EXTENDED;
FUNCTION RoundStr  (x: EXTENDED; Stellen: BYTE): STRING;
FUNCTION HexString (x: LONGINT; Stellen: BYTE): STRING;
FUNCTION BinString (x: LONGINT; Stellen: BYTE): STRING;

{ Umwandlung Gross-/Kleinschreibung }
FUNCTION LoChar (ch: CHAR): CHAR;
FUNCTION UpChar (ch: CHAR): CHAR;
FUNCTION LoString (st: STRING): STRING;
FUNCTION UpString (st: STRING): STRING;
FUNCTION LoCharX (ch: CHAR): CHAR;
FUNCTION UpCharX (ch: CHAR): CHAR;
FUNCTION LoStringX (st: STRING): STRING;
FUNCTION UpStringX (st: STRING): STRING;

IMPLEMENTATION
{=============}

VAR RunErrorNr: INTEGER;
    ExitSave: POINTER;
CONST RunErrorFkt : ARRAY [1..17] OF STRING[7] = (
        {1}  'Pwr'     ,
        {2}  'PwrT'    ,
        {3}  'LgT'     ,

        {4}  'Tan'     ,
        {5}  'Cot'     ,
        {6}  'ArcSin'  ,
        {7}  'ArcCos'  ,
        {8}  'ArcCot'  ,
        {9}  'ArcTan2' ,

       {10}   'Sinh'    ,
       {11}   'Cosh'    ,
       {12}   'Tanh'    ,
       {13}   'Coth'    ,
       {14}   'ArSinh'  ,
       {15}   'ArCosh'  ,
       {16}   'ArTanh'  ,
       {17}   'ArCoth'  );

PROCEDURE RuntimeExit;
BEGIN
  ExitProc := ExitSave;
  IF RunErrorNr <> 0 THEN BEGIN
    Writeln('Laufzeitfehler in EXSYSTEM.', RunErrorFkt[RunErrorNr]);
  END;
END;

{ ============================================ }
{ weitere Exponent- und Logarithmus-Funktionen }
{ ============================================ }


FUNCTION Pwr (mantisse, exponent: EXTENDED): EXTENDED;
{===========}
{$IFDEF DOK}
    FUNCTION Pwr (mantisse, exponent: EXTENDED): EXTENDED;
    Berechnet mantisse hoch exponent.
{$ENDIF DOK}
VAR     negativ          : BOOLEAN;
        potenz           : EXTENDED;
BEGIN
  RunErrorNr := 1;
  IF mantisse=0.0 THEN potenz:=0.0
  ELSE BEGIN
    negativ := mantisse<0.0;
    mantisse:=ABS(mantisse);
    potenz:=EXP(exponent*LN(mantisse));
    IF ODD(TRUNC(exponent)) AND negativ THEN potenz:=-potenz;
    END;
  Pwr:=potenz;
  RunErrorNr := 0;
END;

FUNCTION PwrT (exponent: EXTENDED): EXTENDED;
{============}
{$IFDEF DOK}
    FUNCTION PwrT (exponent: EXTENDED): EXTENDED;
    Berechnet 10 hoch exponent.
{$ENDIF DOK}
BEGIN
  RunErrorNr := 2;
  PwrT:=Pwr(10.0,exponent);
  RunErrorNr := 0;
END;

FUNCTION LgT (x: EXTENDED): EXTENDED;
{===========}
{$IFDEF DOK}
    FUNCTION LgT (x: EXTENDED): EXTENDED;
    Berechnet den Logarithmus zur Basis 10.
    Definitionsbereich: x > 0
{$ENDIF DOK}
BEGIN
  RunErrorNr := 3;
  Lgt:=LN(x)/LN(10.0);
  RunErrorNr := 0;
END;

{ ============================================ }
{          weitere Kreis-Funktionen            }
{ ============================================ }

FUNCTION Tan (x: EXTENDED): EXTENDED;
{===========}
{$IFDEF DOK}
    FUNCTION Tan (x: EXTENDED): EXTENDED;
    Berechnet den Tangens vom Winkel x (Bogenmass).
    Definitionsbereich: alle ausser Polstellen
    Wertebereich:       alle darstellbaren Zahlen
{$ENDIF DOK}
BEGIN
  RunErrorNr := 4;
  Tan := Sin(x) / Cos(x);
  RunErrorNr := 0;
END;


FUNCTION Cot (x: EXTENDED): EXTENDED;
{===========}
{$IFDEF DOK}
    FUNCTION Cot (x: EXTENDED): EXTENDED;
    Berechnet den Cotangens vom Winkel x (Bogenmass).
    Definitionsbereich: alle ausser Polstellen
    Wertebereich:       alle darstellbaren Zahlen
{$ENDIF DOK}
BEGIN
  RunErrorNr := 5;
  Cot := Cos(x) / Sin(x);
  RunErrorNr := 0;
END;


FUNCTION ArcSin (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArcSin (x: EXTENDED): EXTENDED;
    Berechnet den Arcus Sinus von x.
    Definitionsbereich: [-1 ; 1]
    Wertebereich:       [-Pi/2 ; Pi/2]
{$ENDIF DOK}
VAR y: EXTENDED;
BEGIN
  RunErrorNr := 6;
  IF x = -1.0 THEN
    ArcSin := -Pi/2.0
  ELSE IF x = 1.0 THEN
    ArcSin := Pi/2.0
  ELSE BEGIN
    y := x / sqrt(1.0 - sqr(x));
    ArcSin := ArcTan(y);
  END;
  RunErrorNr := 0;
END;

FUNCTION ArcCos (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArcCos (x: EXTENDED): EXTENDED;
    Berechnet den Arcus Cosinus von x.
    Definitionsbereich: [-1 ; 1]
    Wertebereich:       [0 ; Pi]
{$ENDIF DOK}
VAR Tmp: EXTENDED;
BEGIN
  RunErrorNr := 7;
  IF x = -1.0 THEN
    Tmp := -Pi/2.0
  ELSE IF x = 1.0 THEN
    Tmp := Pi/2.0
  ELSE BEGIN
    Tmp := x / sqrt(1.0 - sqr(x));
    Tmp := ArcTan(Tmp);
  END;
  ArcCos := Pi/2.0 - Tmp;
  RunErrorNr := 0;
END;

FUNCTION ArcCot (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArcCot (x: EXTENDED): EXTENDED;
    Berechnet den Arcus Cotangens von x.
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       [0 ; Pi]
{$ENDIF DOK}
BEGIN
  RunErrorNr := 8;
  IF x = 0.0 THEN ArcCot := Pi/2.0
  ELSE IF x > 0.0 THEN ArcCot := ArcTan(1.0/x)
  ELSE ArcCot := ArcTan(1.0/x) + Pi;
  RunErrorNr := 0;
END;

FUNCTION ArcTan2 (Re, Im: EXTENDED): EXTENDED;
{===============}
{$IFDEF DOK}
    FUNCTION ArcTan2 (Re, Im: EXTENDED): EXTENDED;
    Berechnet den Winkel (Bogenmass) der komplexen Zahl (Re,Im)
    "Vier-Quadranten-Arcus-Tangens".
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       (-Pi ; Pi]
{$ENDIF DOK}
BEGIN
  RunErrorNr := 9;
  IF Re = 0.0 THEN
    IF Im = 0.0 THEN
      ArcTan2 := 0.0
    ELSE
      IF Im > 0.0 THEN
        ArcTan2 := Pi/2.0
      ELSE
        ArcTan2 := -Pi/2.0
  ELSE
    IF Re > 0.0 THEN
      ArcTan2 := ArcTan (Im/Re)
    ELSE
      IF Im >= 0.0 THEN
        ArcTan2 := Pi + ArcTan (Im/Re)
      ELSE
        ArcTan2 := -Pi + ArcTan (Im/Re);
  RunErrorNr := 0;
END;

{ ============================================ }
{            Hyperbel-Funktionen               }
{ ============================================ }

FUNCTION Sinh (x: EXTENDED): EXTENDED;
{============}
{$IFDEF DOK}
    FUNCTION Sinh (x: EXTENDED): EXTENDED;
    Berechnet den Hyperbel-Sinus von x.
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       alle darstellbaren Zahlen
{$ENDIF DOK}
BEGIN
  RunErrorNr := 10;
  Sinh := (exp(x) - exp(-x)) / 2.0;
  RunErrorNr := 0;
END;

FUNCTION Cosh (x: EXTENDED): EXTENDED;
{============}
{$IFDEF DOK}
    FUNCTION Cosh (x: EXTENDED): EXTENDED;
    Berechnet den Hyperbel-Cosinus von x.
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       Cosh(x) >= 1
{$ENDIF DOK}
BEGIN
  RunErrorNr := 11;
  Cosh := (exp(x) + exp(-x)) / 2.0;
  RunErrorNr := 0;
END;

FUNCTION Tanh (x: EXTENDED): EXTENDED;
{============}
{$IFDEF DOK}
    FUNCTION Tanh (x: EXTENDED): EXTENDED;
    Berechnet den Hyperbel-Tangens von x.
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       (-1 ; 1)
{$ENDIF DOK}
VAR y1, y2: EXTENDED;
BEGIN
  RunErrorNr := 12;
  y1 := exp(x);
  y2 := exp(-x);
  Tanh := (y1 - y2) / (y1 + y2);
  RunErrorNr := 0;
END;

FUNCTION Coth (x: EXTENDED): EXTENDED;
{============}
{$IFDEF DOK}
    FUNCTION Coth (x: EXTENDED): EXTENDED;
    Berechnet den Hyperbel-Cotangens von x.
    Definitionsbereich: alle darstellbaren Zahlen \ {0}
    Wertebereich:       alle darstellbaren Zahlen \ [-1 ; 1]
{$ENDIF DOK}
VAR y1, y2: EXTENDED;
BEGIN
  RunErrorNr := 13;
  y1 := exp(x);
  y2 := exp(-x);
  Coth := (y1 + y2) / (y1 - y2);
  RunErrorNr := 0;
END;

FUNCTION ArSinh (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArSinh (x: EXTENDED): EXTENDED;
    Berechnet den Area Sinus von x.
    Definitionsbereich: alle darstellbaren Zahlen
    Wertebereich:       alle darstellbaren Zahlen
{$ENDIF DOK}
BEGIN
  RunErrorNr := 14;
  ArSinh := ln(x + sqrt(sqr(x) + 1));
  RunErrorNr := 0;
END;

FUNCTION ArCosh (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArCosh (x: EXTENDED): EXTENDED;
    Berechnet den Area Cosinus von x.
    Definitionsbereich: x >=1
    Wertebereich:       ArCosh(x) >= 0
{$ENDIF DOK}
BEGIN
  RunErrorNr := 15;
  ArCosh := ln(x + sqrt(sqr(x) - 1));
  RunErrorNr := 0;
END;

FUNCTION ArTanh (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArTanh (x: EXTENDED): EXTENDED;
    Berechnet den Area Tangens von x.
    Definitionsbereich: (-1 ; 1)
    Wertebereich:       alle darstellbaren Zahlen
{$ENDIF DOK}
BEGIN
  RunErrorNr := 16;
  ArTanh := 0.5 * ln((1+x)/(1-x));
  RunErrorNr := 0;
END;

FUNCTION ArCoth (x: EXTENDED): EXTENDED;
{==============}
{$IFDEF DOK}
    FUNCTION ArCoth (x: EXTENDED): EXTENDED;
    Berechnet den Area Cotangens von x.
    Definitionsbereich: alle darstellbaren Zahlen \ [-1 ; 1]
    Wertebereich:       alle darstellbaren Zahlen \ {0}
{$ENDIF DOK}
BEGIN
  RunErrorNr := 17;
  ArCoth := 0.5 * ln((x+1)/(x-1));
  RunErrorNr := 0;
END;

{ ============================================ }
{        erweiterte Datenumwandlungen          }
{ ============================================ }

FUNCTION ValReal (s: STRING; VAR Code: INTEGER): EXTENDED;
{===============}
{$IFDEF DOK}
    FUNCTION ValReal (s: STRING; VAR Code: INTEGER): EXTENDED;
    Ersetzt die Procedure Val fuer Gleitkomma-Umwandlung und
    fngt fhrende Blanks sowie angehngte nichtnumerische Zeichen ab.
    "Code" enthaelt bei fehlerfreier Ausfuehrung den Wert 0, sonst die
    Position des Zeichen in s, bei dem der Fehler auftrat.
{$ENDIF DOK}
CONST MantisseZeichen : SET OF CHAR = ['0'..'9', '.', '+', '-'];
      Exponent : SET OF CHAR = ['e', 'E'];
      ExponentZeichen : SET OF CHAR = ['+', '-', '0'..'9'];
      Blanks : SET OF CHAR = [' ', #9];
VAR Laenge, Start: BYTE;
    i : byte;
    Verlaengerung : BYTE;
    Sz : STRING;
    v : EXTENDED;

begin
  laenge := length(s);
  i := 1;
  { Fhrende Blanks und Tabs berspringen: }
  while (i<=Laenge) and (s[i] in Blanks) do inc(i);
  Start := i;

  { in HilfsString Sz uebertragen }
  Sz := copy(s, Start, 255);
  Laenge := length(Sz);

  if Laenge = 0 then
  begin  { Blank-STRING }
    ValReal := 0.0;
    Code := 1;
    exit;
  end;

  i := 1;
  while (i<=Laenge) and (sz[i] in MantisseZeichen) do inc(i);
  if (i<=Laenge) and (sz[i] in Exponent) then inc(i);
  while (i<=Laenge) and (sz[i] in ExponentZeichen) do inc(i);

  { STRING hinten begrenzen }
  sz := copy(sz, 1, i-1);
  Laenge := length(sz);
  if Laenge = 0 then
  begin
    ValReal := 0.0;
    Code := Start;
    exit;
  end;

  Verlaengerung := 0;
  if Laenge > 1 then
  begin
    case sz[1] of
      '-','+':
        begin
          if sz[2] = '.' then sz := sz[1] + '0' + copy(sz, 2, 255);
          inc(Verlaengerung);
          Laenge := length(sz);
        end;
      '.':
        begin
          sz := '0' + sz;
          inc(Verlaengerung);
          Laenge := length(sz);
        end;
    end;  { case }
  end;

  case sz[Laenge] of
    'E','e','+','-','.':
      begin
        sz := copy(sz, 1, Laenge-1);
        Laenge := length(sz);
      end;
  end;

  val(sz, v, code);
  if code <> 0 then begin
    code := code + start - verlaengerung - 1;
    v := 0.0;
  end;
  ValReal := v;
end;

FUNCTION ValInt (s: STRING; VAR code:INTEGER): LONGINT;
{==============}
{$IFDEF DOK}
    FUNCTION ValInt (s: STRING; VAR code:INTEGER): LONGINT;
    Ersetzt die Procedure Val fuer Integer-Umwandlung und fngt
    fhrende Blanks sowie angehngte nichtnumerische Zeichen ab.
    "Code" enthaelt bei fehlerfreier Ausfuehrung den Wert 0, sonst die
    Position des Zeichen in s, bei dem der Fehler auftrat.
{$ENDIF DOK}
CONST   Ziffern : set of char = ['0'..'9'];
        Vorzeichen : set of char = ['+', '-'];
        Blanks : set of char = [' ', #9];
VAR Laenge, Start: byte;
    i : byte;
    Sz : STRING;
    v: LONGINT;

begin
  laenge := length(s);
  i := 1;
  { Fhrende Blanks und Tabs berspringen: }
  while (i<=Laenge) and (s[i] in Blanks) do inc(i);
  Start := i;

  { in HilfsString Sz uebertragen }
  Sz := copy(s, Start, 255);
  Laenge := length(Sz);

  if Laenge = 0 then
  begin  { Blank-STRING }
    ValInt := 0;
    Code := 1;
    exit;
  end;

  i := 1;
  if sz[i] in Vorzeichen then inc(i);

  while (i<=Laenge) and (sz[i] in Ziffern) do inc(i);
  val(copy(sz, 1, i-1), v, code);
  if code <> 0 then begin
    code := start + code - 1;
    v := 0;
  end;
  ValInt := v;
end;


FUNCTION Exponent (x: EXTENDED): INTEGER;
{================}
{$IFDEF DOK}
    FUNCTION Exponent (x: EXTENDED): INTEGER;
    Gibt den Dezimal-Exponenten von x zurueck. Es gilt der Zusammenhang
             x = Mantisse(x) * pwrt(Exponent(x))
{$ENDIF DOK}
BEGIN
  IF abs(x) = 0.0 THEN
    Exponent := 0
  ELSE IF abs(x) < 1.0 THEN
    Exponent := Trunc(lgt(abs(x))) - 1
  ELSE
    Exponent := Trunc(lgt(abs(x)));
END;


FUNCTION Mantisse (x: EXTENDED): EXTENDED;
{================}
{$IFDEF DOK}
    FUNCTION Mantisse (x: EXTENDED): EXTENDED;
    Gibt die Dezimal-Mantisse von x zurueck.
    Wertebereich:       1 <= Mantisse < 10
{$ENDIF DOK}
BEGIN
  Mantisse := x * pwrt(-Exponent(x));   { 1 Stelle vor Komma }
END;


FUNCTION RoundReal (x:EXTENDED; Stellen: BYTE): EXTENDED;
{=================}
{$IFDEF DOK}
    FUNCTION RoundReal (x:EXTENDED; Stellen: BYTE): EXTENDED;
    Rundet x auf "Stellen" gueltige Stellen.
{$ENDIF DOK}
VAR Mant: EXTENDED;
BEGIN
  IF Stellen > 20 THEN Stellen := 20;  { max. 20 Stellen }
  IF Stellen = 0 THEN Stellen := 1;
  Mant := Mantisse(x);
  RoundReal := Int(Mant*pwrt(Stellen-1)+0.5) * pwrt(Exponent(x)-Stellen+1);
END;


FUNCTION RoundStr (x: EXTENDED; Stellen: BYTE): STRING;
{----------------}
{$IFDEF DOK}
    FUNCTION RoundStr (x: EXTENDED; Stellen: BYTE): STRING;
    Gibt x als STRING im E-Format zurueck, auf "Stellen" Genauigkeit gerundet.
    Fuehrende Nullen im Exponenten werden unterdrueckt.
    Bei x >= 0 ist erstes Zeichen ' '
    bei x <  0 ist erstes Zeichen '-'
{$ENDIF DOK}
VAR y: EXTENDED;
    e, Code: INTEGER;
    EPosition: BYTE;
    es: STRING[10];
    ys: STRING[30];
BEGIN
  y := RoundReal(x, Stellen);
  str(y, ys);
  Eposition := pos('E', ys);
  e := ValInt( copy(ys, Eposition+1, 5), Code );
  str(e, es);
  ys := copy (ys, 1, Eposition-1);
  IF Stellen <= 1 THEN
    ys := copy (ys, 1, 2)  { Dezimalpunkt unterdruecken }
  ELSE
    ys := copy (ys, 1, Stellen+2);
  RoundStr := ys + 'E' + es;
END;

{ ============================================ }
{       Umwandlung Gross-/Kleinschreibung      }
{ ============================================ }

FUNCTION LoChar (ch: CHAR): CHAR;
{==============}
{$IFDEF DOK}
    FUNCTION LoChar (ch: CHAR): CHAR;
    Konvertiert Gro- in Kleinbuchstaben.
    Mitteleuropische Umlaute werden nicht bercksichtigt.
{$ENDIF DOK}
BEGIN
  IF (ch >= 'A') AND (ch <= 'Z') THEN
    LoChar := Chr(Ord(ch) + $20)
  ELSE
    LoChar := ch;
END;

FUNCTION UpChar (ch: CHAR): CHAR;
{==============}
{$IFDEF DOK}
    FUNCTION UpChar (ch: CHAR): CHAR;
    Konvertiert Klein- in Grobuchstaben.
    Mitteleuropische Umlaute werden nicht bercksichtigt.
    UpChar ist identisch mit der Turbo PASCAL-Funktion UpCase.
{$ENDIF DOK}
BEGIN
  UpChar := UpCase(ch);
END;

FUNCTION LoString (st: STRING): STRING;
{================}
{$IFDEF DOK}
    FUNCTION LoString (st: STRING): STRING;
    Konvertiert einen kompletten String in Kleinbuchstaben.
    Mitteleuropische Umlaute werden nicht bercksichtigt.
{$ENDIF DOK}
VAR i: BYTE;
BEGIN
  FOR i:=1 TO Length(st) DO
    st[i] := LoChar(st[i]);
    LoString := st;
END;

FUNCTION UpString (st: STRING): STRING;
{================}
{$IFDEF DOK}
    FUNCTION UpString (st: STRING): STRING;
    Konvertiert einen kompletten String in Grobuchstaben.
    Mitteleuropische Umlaute werden nicht bercksichtigt.
{$ENDIF DOK}
VAR i: BYTE;
BEGIN
  FOR i:=1 TO Length(st) DO
    st[i] := UpCase(st[i]);
    UpString := st;
END;

FUNCTION LoCharX (ch: CHAR): CHAR;
{=================}
{$IFDEF DOK}
    FUNCTION LoCharX (ch: CHAR): CHAR;
    Konvertiert Gro- in Kleinbuchstaben.
    Mitteleuropische Umlaute werden dabei bercksichtigt.
{$ENDIF DOK}
BEGIN
  IF (ch >= 'A') AND (ch <= 'Z') THEN
    ch := Chr(Ord(ch) + $20)
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := '';
  LoCharX := ch;
END;

FUNCTION UpCharX (ch: CHAR): CHAR;
{=================}
{$IFDEF DOK}
    FUNCTION UpCharX (ch: CHAR): CHAR;
    Konvertiert Klein- in Grobuchstaben.
    Mitteleuropische Umlaute werden dabei bercksichtigt.
{$ENDIF DOK}
BEGIN
  IF (ch >= 'a') AND (ch <= 'z') THEN
    ch := Chr(Ord(ch) - $20)
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := ''
  ELSE IF ch = '' THEN ch := '';
  UpCharX := ch;
END;

FUNCTION LoStringX (st: STRING): STRING;
{===================}
{$IFDEF DOK}
    FUNCTION LoStringX (st: STRING): STRING;
    Konvertiert einen String in Kleinbuchstaben.
    Mitteleuropische Umlaute werden dabei bercksichtigt.
{$ENDIF DOK}
VAR i: BYTE;
BEGIN
  FOR i:=1 TO Length(st) DO
    st[i] := LoCharX(st[i]);
    LoStringX := st;
END;

FUNCTION UpStringX (st: STRING): STRING;
{===================}
{$IFDEF DOK}
    FUNCTION UpStringX (st: STRING): STRING;
    Konvertiert einen String in Grobuchstaben.
    Mitteleuropische Umlaute werden dabei bercksichtigt.
{$ENDIF DOK}
VAR i: BYTE;
BEGIN
  FOR i:=1 TO Length(st) DO
    st[i] := UpCharX(st[i]);
    UpStringX := st;
END;

FUNCTION HexString (x: LONGINT; Stellen: BYTE): STRING;
{=================}
{$IFDEF DOK}
    FUNCTION HexString (x: LONGINT; Stellen: BYTE): STRING;
    Konvertiert alle Integer-Formate in einen Hexadezimal-String mit
    'Stellen' Hexadezimalziffern. Werden mehr Stellen gewandelt, als
    das aktuelle Argument x aufweist, wird entsprechend der Maschinen-
    darstellung vorzeichenbehafteter Ganzzahlen links aufgefuellt.
    Bei weniger Stellen wird links abgeschnitten.
    Beispiele:
      HexString(44, 4)          { '002C' }
      HexString(-1, 8)          { 'FFFFFFFF' }
      HexString( 1, 8)          { '00000001' }
      HexString($12345678, 4)   { '5678' }
{$ENDIF DOK}
VAR st: STRING;
    i: BYTE;
    Rest: SHORTINT;
CONST HexChar: ARRAY[0..15] OF CHAR ='0123456789ABCDEF';
BEGIN
  FOR i := 0 TO Stellen-1 DO BEGIN
    Rest := x AND $0000000F;
    x := x SHR 4;
    st[Stellen-i] := HexChar[Rest];
  END;
  st[0] := Chr(Stellen);
  HexString := st;
END;


FUNCTION BinString (x: LONGINT; Stellen: BYTE): STRING;
{=================}
{$IFDEF DOK}
    FUNCTION BinString (x: LONGINT; Stellen: BYTE): STRING;
    Konvertiert alle Integer-Formate in einen Binaer-String mit
    'Stellen' Binaerziffern. Werden mehr Stellen gewandelt, als
    das aktuelle Argument x aufweist, wird entsprechend der Maschinen-
    darstellung vorzeichenbehafteter Ganzzahlen links aufgefuellt.
    Bei weniger Stellen wird links abgeschnitten.
    Beispiele:
      BinString(44, 8)          { '00101100' }
      BinString(-1, 16)         { '1111111111111111' }
      BinString( 1, 4)          { '0001' }
      BinString($12345678, 16)  { '0000011100001000' }
{$ENDIF DOK}
VAR st: STRING;
    i: BYTE;
    Rest: SHORTINT;
BEGIN
  FOR i := 0 TO Stellen-1 DO BEGIN
    IF Odd(x) THEN st[Stellen-i] := '1'
              ELSE st[Stellen-i] := '0';
    x := x SHR 1;
  END;
  st[0] := Chr(Stellen);
  BinString := st;
END;


BEGIN
  RunErrorNr := 0;
  ExitSave := ExitProc;
  ExitProc := @RunTimeExit;
END.
