unit tc;

interface

USES
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, StdCtrls, ComCtrls, Menus, //Grids,// Math,
  TextUnit, Protokollunit, TeXCadLesen,
  einstellunit,clip,  registry,
  Formel, exsystem,
  MDraw, utils , inifiles;

const version='4.4.1.3';
      compdat='16.03.04';


{$I Strings.pas}

type
 modus=(linie,textm,Kreis,FKreis,pick,pickdel,nichts,auswahl,move,move1,
 move_c, macro, Macro_click,  Macroeinfuegen,
 kurvenzeichnen,Pfeil,linie1, Kreisgross,
 zoomarea, pickarea, warten,texted, rechteck ,
 randwahl);

 com_typ=(c_lin,c_txt,c_circ,c_box,c_meta,c_aux);
 obj_art_type =(lin,txt,{box,} circ{ ,aux},pf {pfeil} );
 ptr_obj_type=^obj_type;
 obj_type=record
   typ:obj_art_type;
   picked: boolean;       // ist gepickt
   posspicked: boolean;   //kann gepickt sein
   deleted:boolean;
   farbe:Tcolor;
   Gruppe:integer;     //Linien:3, Kreise: 5, Text: 8
   case obj_art_type of
     lin, pf: (lx1,ly1,lx2,ly2: double; ldicke:smallint; );
     txt: (tx,ty:double; tadjust: string[2];tinhalt: string[255]);
{     box: (bx,by,bdx,bdy:double; badjust: string[2];
             binhalt: string[255]; bdash, bsolid:boolean;
             bpcolor,bbcolor: TColor);   }
     circ: (cx,cy,r:double; cdicke:smallint; filled:boolean;);
//     aux: (strichdicke: integer; afarbe: TColor);
   end;

   const elementgross=sizeof(obj_type);
   typgross=sizeof(obj_art_type);

type
  zeichnungstyp= array[1..32000] of ptr_obj_type;

  randelement=record
   nummer: integer;
   x,y:double;
   end;

  Flaeche= record
   nummer:integer;
   farbe:TColor;
   schraffur:boolean;
   winkel: integer;
   abstand:integer;
   end;

  P_Flaeche= ^Flaeche;



  type

  linientyp= record           //Egebnisse von Kurvenzeichnen
   x1,x2,y1,y2:double
  end;
  linien=array[1..32000] of linientyp;
//   Zeichnungssorte=(Linie_,Kreis_,Pfeil_,Kurve_);

  kurveninfotyp=record
    x_text,y_text,z_text,von_text,bis_text:string;
    n_aktuell : integer;
    _3d, x_vorne:boolean;
    typ:smallint; // 0: Lnge, 1:Richtung, 2: ohne
    strichlaenge, zielwinkel,
    delta_p,wertgrenze: double;
    Fehler_aufgetreten:boolean;
   end;

      const
      paramstart: double= 0.0; {Anfangswerte der Parametrisierungen}
      paramend:   double= 0.0; {Endwerte der Parametrisierungen}
      y_faktor=0.5;
      cos_a=0.74314;   //cos(42*Pi/180);
      sin_a=0.66913;   //sin(42*Pi/180);

  type

  TDrawingTool = (dtLine, dtRectangle, dtEllipse, dtRoundRect, dtArc);

  liniendicke=array[-1..2] of smallint; //Dicke in Pixeln auf dem Schirm

  TEinstellungen = Record
   dicken: liniendicke;
   textanzeige,
   zoomstufe,
   snapfak,
   pickdist:smallint;
   linieunsichtbar,linieduenn, linienormal,liniedick:smallint;
   {duenn, normal oder dick, index fr Liniendicke}
   unitlength, tex_unsichtbar,tex_duenn,tex_normal,tex_dick:string[10];
   p_winkel: double; // = 0.25;
   p_lang:   double; // = 2.2;
   gitter, snap :boolean;
   // export_dick, export_normal, export_duenn: string;
   gitterda: boolean;
   clipaktiv:boolean;
   cl,cr,co,cu:integer;
   aktcol:tcolor;
   massstab: integer;
   x_off,y_off: string[10];
   startschritt, schrittfaktor: double;
  end;

  exporttyp = (tec, tcpps);



  TForm1 = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Open1: TMenuItem;
    Speichernunter1: TMenuItem;
    Speichern1: TMenuItem;
    Ansicht1: TMenuItem;
    Zeichengruppe: TPanel;
    LineButton: TSpeedButton;
    Circbutton: TSpeedButton;
    Fillcircbutton: TSpeedButton;
    Textbutton: TSpeedButton;
    Editiergruppe: TPanel;
    Delete: TSpeedButton;
    Movebutton: TSpeedButton;
    Textedit: TSpeedButton;
    Ansicht: TMenuItem;
    Gitter1: TMenuItem;
    Protokoll: TMenuItem;
    SaveDialog1: TSaveDialog;
    paintboxh: TPaintbox;
    paintboxv: TPaintbox;
    ZF: MyDraw;     //Zeichenflche
    Zoom1: TMenuItem;
    N11: TMenuItem;
    N21: TMenuItem;
    N31: TMenuItem;
    N41: TMenuItem;
    N51: TMenuItem;
    N61: TMenuItem;
    N71: TMenuItem;
    N81: TMenuItem;
    N91: TMenuItem;
    Kreis2: TSpeedButton;
    Info1: TMenuItem;
    Status: TPanel;
    StatusBar1: TStatusBar;
    Linie2: TSpeedButton;
    snapcheck: TCheckBox;
    Snapbox: TComboBox;
    Pfeil1: TSpeedButton;
    rechteck1: TSpeedButton;
    Bearbeiten1: TMenuItem;
    Bearbeiten2: TMenuItem;
    AusschneidenStrgX1: TMenuItem;
    EinfgenStrgV1: TMenuItem;
    Clip1: TMenuItem;
    Tecexp1: TMenuItem;
    Tecexpals: TMenuItem;
    PicTcp1: TMenuItem;
    Kurve: TSpeedButton;
    Pickbutton: TSpeedButton;
    Pickareabutton: TSpeedButton;
    Unpick: TSpeedButton;
    ZoomAreaButton: TSpeedButton;
    unzoombutton: TSpeedButton;
    repaint: TSpeedButton;
    PopupMenu1: TPopupMenu;
    Aufrumen1: TMenuItem;
    TcpPsExport1: TMenuItem;
    TcpPsExportals1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N1: TMenuItem;
    Skalieren1: TMenuItem;
    Kurvenwahl: TSpeedButton;
    P2: TEdit;
    P1: TEdit;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    P3: TEdit;
    P4: TEdit;
    UpDown3: TUpDown;
    UpDown4: TUpDown;
    Label1: TLabel;
    Linienbreite: TComboBox;
    ColorDialog1: TColorDialog;
    gotozero: TSpeedButton;
    Kontrolle: TComboBox;
    Strichlangedit: TEdit;
    Winkeldiffedit: TEdit;
    Deltaedit: TEdit;
    N7: TMenuItem;
    macroladen1: TMenuItem;
    Macroopen: TOpenDialog;
    Macrosave: TSaveDialog;
    Macrospeichern1: TMenuItem;
    Rckgngig1: TMenuItem;
    N8: TMenuItem;
    Drehen1: TMenuItem;

    procedure BoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LineButtonClick(Sender: TObject);
    procedure CircbuttonClick(Sender: TObject);
    procedure FillcircbuttonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure zeichneneu(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure ImportClick(Sender: TObject);
    procedure Exportierenunter1Click(Sender: TObject);
    procedure einstellungenclick(Sender: TObject);
//    procedure ZoomfertigClick(Sender: TObject);
    procedure pickclick(Sender: TObject);
    procedure BoxClick(Sender: TObject);
    procedure JClick(antwort:char);
    procedure DeleteClick(Sender: TObject);
    procedure MovebuttonClick(Sender: TObject);
    procedure UnpickClick(Sender: TObject);
    procedure undeleteClick(Sender: TObject);
    procedure KurveClick(Sender: TObject);
{   procedure breitduennClick(Sender: TObject);
    procedure breitnormalClick(Sender: TObject);
    procedure breitdickClick(Sender: TObject);   }
    procedure ProtokollClick(Sender: TObject);
    procedure ZoomAreaButtonClick(Sender: TObject);
    procedure unzoombuttonClick(Sender: TObject);
    procedure PickareabuttonClick(Sender: TObject);
    procedure TextbuttonClick(Sender: TObject);
    procedure TexteditClick(Sender: TObject);
    procedure Gitter1Click(Sender: TObject);
    procedure zoommenuclick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Pfeil1Click(Sender: TObject);
    procedure Kreis2Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Linie2Click(Sender: TObject);
    procedure snapcheckClick(Sender: TObject);
    procedure SnapboxChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rechteck1click(Sender: TObject);
    procedure gotozeroClick(Sender: TObject);
    procedure ausschneiden(Sender:Tobject);
    procedure einfuegen(Sender:Tobject);
    procedure kopieren(Sender:Tobject);
    procedure Clip1Click(Sender: TObject);
    procedure Aufrumen1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure Exportieren1click(Sender: TObject);
    procedure TecexpalsClick(Sender: TObject);
    procedure Tecexp1Click(Sender: TObject);
    procedure TcpPsExport1Click(Sender: TObject);
    procedure TcpPsExportals1Click(Sender: TObject);
    procedure Skalieren1Click(Sender: TObject);
    procedure pickzaehlen;
    procedure farbeaendern;
    procedure Label1Click(Sender: TObject);
    procedure LinienbreiteChange(Sender: TObject);
    procedure KontrolleChange(Sender: TObject);
    procedure DeltaeditChange(Sender: TObject);
    procedure StrichlangeditChange(Sender: TObject);
    procedure WinkeldiffeditChange(Sender: TObject);
    procedure StatusBar1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure KurvenwahlClick(Sender: TObject);
    procedure repaintClick(Sender: TObject);
    procedure ZFFocus(Sender: TObject);
    procedure macrospeichern1Click(Sender: TObject);
    procedure macroladen1Click(Sender: TObject);
    procedure Macroeinfuegenclick(Sender: TObject);
    procedure Drehen1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
    dirty: boolean;
    BrushStyle: TBrushStyle;
    PenStyle: TPenStyle;
    PenWide: Integer;

    Drawing, Moving: Boolean;
    Origin, MovePt,CP, CPA, cursor_alt: TPoint;
    snapfak :double;
    DrawingTool: TDrawingTool;
    CurrentFile, Currentfile_tec, Currentfile_PS: TFileName;
    Export_tec, Export_ps:boolean;
    obj: obj_type;
    P: ptr_obj_type;
    zeichnung: zeichnungstyp;
    zeichzahl: integer;
    puffer: zeichnungstyp;
    puffzahl: integer;
//    drawfehlt: boolean;
    cursor_gesetzt: boolean;
    boxfertig: boolean;
    curcol,
    piccol, posspiccol, deletedcol, unsichtbarcol: Tcolor;
    zoomfak: double;
//    zoomstufe: integer;
    zoom_ok: boolean;
//    nullx, nully:integer;
    x0,y0, x0_alt, y0_alt :integer;   //war mal double
    zoom_alt:integer;
    pmm:integer; //Punkte per mm Bildschirm
    pbh: integer;
    cancapture:boolean;  {Capture mglich}
    aktmodus: modus;
    element_i: smallint; //aktuell gepicktes Element
    pickzahl: integer; //Anzahl der gepickten Elemente
    posspickzahl: integer; //Anzahl der Elemente, die gepickt werden knnen
    ignorenextclick, ignorenextmove: boolean; // nchsten Mausclick ignorieren
    moveorg: TPoint;
    move_x, Move_y:integer;
    debug: boolean;
    einst: TEinstellungen;
    breite: smallint;
    letzte_cursor: array[1..4] of TPoint;
    tc_file,ps_file,tcp_file: text;
    r_max:integer;  //maximaler kreisradius;

    //**** Kurvenzeichnen
    //{$N+}{$E+}
    {$H-}
    neue_linien: linien;         //Kurvenzeichnen
    neue_linien_zahl: integer;   //Rckgabewerte
    p_kurveninfo, p_kreisinfo, p_linieninfo:kurveninfotyp;
    phase, phasenzaehler: Integer;
    phaseok: boolean;
    phasemax:array [1..4] of integer;

    massstab:double;       {Vergrerung: 10 entspricht 1mm pro Einheit}
    FormelX,FormelY,FormelZ, FormelV,FormelB: FormelPtr;
    //Fnr,
    Fpos: INTEGER;
    strichlaenge,     //Die Strichlnge in der Kopfleiste
    z_strichlaenge,    //Die Strichlaenge beim Zeichnen
    zielwinkel,       // in der Kopfleiste
    z_zielwinkel,      // beim Zeichnen
    schrittfaktor, startschritt,
    q,
    delta_p, z_delta_p: double;
    _3d,x_vorne:boolean;
    XEingabe,YEingabe,ZEingabe,VonEingabe,Biseingabe: STRING;
    RK,LK,KK: boolean;   //Richtungs-, Lngen-, keine Kontrolle
    wertgrenze,
    r_alt_x,r_alt_y,nv_1,nv_2, p_alt_1,p_alt_2: extended;
    zu_gross: boolean;
    x_offset,y_offset: Integer;  //ausser bei Kurven Null;
    {$H-}
    Etyp: Exporttyp;   //Dateierweiterung fr Export

    rand: array[1..32000] of randelement;
    flaechen: array[1..1000] of flaeche;
    flaechenzahl: integer;

    function x(p:extended):extended;
    function y(p:extended):extended;
    function z(p:extended):extended;
    procedure formelfehler(s:string;q,para:double);
    procedure Auswertefehler(s:string);
    procedure Wert_zu_Gross;
    procedure prolog(var Kurveninfo:Kurveninfotyp);
    procedure zeichne_kurve;


    procedure cursor_setzen(x,y:integer);
    procedure Zeichne(zahl: integer);
    procedure DrawShape(TopLeft, BottomRight: TPoint; AMode: TPenMode);
    function Sx(a: integer): integer;
    function Sy(a: integer): integer;
    procedure cursor_loeschen;
    procedure info(infotext:string);
    function  worldtoscreenx(x:double): integer;
    function  worldtoscreeny(y:double): integer;
    function screentoworldx(x:integer): double;
    function screentoworldy(y:integer): double;
    function adj2dis(c:char): double;
    procedure linienmousedown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure linienmouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure linien1mouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure linienmousemove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PfeilMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure kreismousedown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure kreismouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure kreismousemove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure kreisgrossmouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure rechteckmouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pickboxclick(Sender: TObject);
    procedure pickmousemove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure fragemousedown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure fragemouseclick(Sender: TObject);
    procedure moveclick(Sender: TObject);
    procedure move1click(Sender: TObject);
//    procedure textmclick(Sender: TObject);
//    procedure nullsetzmouseup(Sender:TObject; Button: TMouseButton;
//              Shift: TShiftstate; X,Y: Integer);
    procedure zoommousemove(Sender: TObject;
     Shift: TShiftState; X, Y: Integer);
    procedure zoommouseDown(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X, Y: Integer);
    procedure zoommouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
    procedure move_cmousemove(Sender: TObject;
     Shift: TShiftState; X, Y: Integer);
    procedure move_cmouseDown(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X, Y: Integer);
    procedure move_cmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
    procedure pickareamousemove(Sender: TObject;
     Shift: TShiftState; X, Y: Integer);
    procedure pickareamouseDown(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X, Y: Integer);
    procedure pickareamouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
    procedure textmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
    procedure textedmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
    procedure setmodus(m: modus);
    procedure texcadschreiben;
    procedure Macroschreiben;
    procedure MacroClick(Sender: TObject);
    procedure Sourceschreiben;
    procedure sourcelesen;
    function nahe_dran(i: integer):boolean;
    procedure getcolor(zahl:integer);
    procedure gitter(teiler,teiler1:smallint);
    procedure Buttonhoch;
    procedure setzesnap;
    procedure aufraeumen;
    Procedure breite_aendern;
    procedure setzefarbe(f:tcolor);
    function tcolor2rgbps(farbe:Tcolor): string;
    function tcolor2rgbtec(farbe:Tcolor): string;
    procedure setze_zoom(stufe:integer);
    procedure neue_linien_uebernehmen(p1,p2,p3,p4:integer);
    procedure zeigeClip;
    procedure Kontrollsicht;
    procedure macroladen(Key:word);
    end;


var
  Form1: TForm1;

  const zooma:    array[0..8] of double=(0.3333333333,0.5,1,2,3,5,8,10,20);
        teilera:  array[0..8] of integer=(50,50,20,10,10,10,10,5,5);
        teiler1a: array[0..8] of integer=(5,5,2,1,1,1,1,1,1);
        dicken:    array[0..2] of string[7]=('\duenn','\normal','\dick');
        dicken_ps:    array[0..2] of string[7]=('duenn','normal','dick');
        Farbe1:   TColor = $00808080;
        Farbe2:   TColor = $000000ff;
        Weite1:   smallint = 1;
        Weite2:   smallint = 1;  //fr Gitter
//        strichlaenge: double =1.0;
        mm2p:     double = 72/25.4; //(Punkt pro Unitlength)
        ZFlag:    boolean=false;   //True, wenn gerade gezeichnet wird;
//////////////// DEBUG

//        zahl: Integer = 0;
//        zahl1: Integer = 0;
//        zahl2: Integer=0;

implementation

uses  Kreise,Kurvenunit, linienunit, Skalieren , Drehen;


{$R *.DFM}






///////////////////////////////////////////////////////
//                                                   //
//   Initialisierung und Hilfsfunktionen             //
//                                                   //
///////////////////////////////////////////////////////

procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
BEGIN

  for i:=1 to 4 do letzte_cursor[i]:=point(-30000,-3000);
  cpa.x:=0;
  cpa.y:=0;
  cursor_alt.x:=0;
  cursor_alt.y:=0;
  zeichzahl:=0;
  for i:=1 to 32000 do zeichnung[i]:=nil;
  cursor_gesetzt:=false;
  ZF.cursor:=CrArrow;
  curcol:=clblack;
  boxfertig:=false;
  zoomfak:=3.0;
  einst.zoomstufe:=4;
  snapfak:=1;
  form1.Width:=getsystemmetrics(SM_CXFULLSCREEN)-100;
  form1.height:=getsystemmetrics(SM_CYFULLSCREEN)-100;
  form1.left:=18;
  form1.top:=20;
  x0:=-2;
  y0:=-2;
  pmm:=3;
  decimalseparator:='.';
  setmodus(nichts);
  dirty:=false;
  piccol:=clfuchsia;      // *********************** clblue
  posspiccol:=clgreen;
  unsichtbarcol:=clmaroon;
  ignorenextclick:=false;
  ignorenextmove:=true;
  deletedcol:=cllime;
  setzefarbe(clblack);
  debug:=false;
  pickzahl:=0;
  einst.textanzeige :=1;
  einst.dicken[-1]  :=0;
  einst.dicken[0]   :=1;
  einst.dicken[1]   :=2;
  einst.dicken[2]   :=3;
//  einst.zoom        :=4;
  einst.snapfak     :=2;
  einst.gitter      :=true;
  einst.snap        :=true;
  einst.pickdist    :=10;
  einst.massstab:=10;
  breite:=1;
  einst.p_winkel:=0.25;
  einst.p_lang:=2.0;
  currentfile:='';
  savedialog1.InitialDir:=extractfilepath(paramstr(0));
  opendialog1.InitialDir:=extractfilepath(paramstr(0));
  zf.besitzer:=form1.Handle;
  zoom_alt:=4;
  puffzahl:=0;
  form1.Caption:='TeXCad32';
  strichlaenge:=1;
  zielwinkel:=5/180*pi;
  delta_p:=0.1;
  startschritt:=0.001;
  schrittfaktor:=1.2;
  x_offset:=0;
  y_offset:=0;
  massstab:=10;
  flaechenzahl:=0;
  moving:=false;
// von create

end;



procedure TForm1.FormShow(Sender: TObject);
var inifile:TInifile;
    ininame:Tfilename;
    hs:string;
    reg:Tregistry;

function liesint(schluessel:String; alt:Integer): Integer;
begin
  try
   liesint:=reg.readinteger(Schluessel);
  except
   liesint:=alt;
  end;
end;

begin
ininame:=extractfilepath(paramstr(0))+'language.dat';
if fileexists(ininame) then begin
inifile:=Tinifile.create(ininame);

// SPRACHANPASSUNG
{$I SPRAChE.PAS}
 end;

  Kontrolle.itemindex:=0;
  zeigeclip;
// nach create
  currentfile:='';
  currentfile_tec:='';
  currentfile_ps:='';
  export_tec:=false;
  export_ps:=false;
//  linienart.Left:=form1.left+form1.Width-120;
//  linienart.top:=form1.top+form1.Height-linienart.Height;

 reg:=TRegistry.create;
 if reg.keyexists('Software\Texcad32')then begin
  reg.openkey('Software\Texcad32',false);
 try
 if reg.readbool('Form1_Maximized') then form1.windowstate:=wsmaximized
 else begin
   Form1.top:=liesint('Form1_top',Form1.top);
   Form1.left:=liesint('Form1_Left',Form1.Left);
   Form1.height:=liesint('Form1_Height',Form1.height);
   Form1.width:=liesint('Form1_Width',Form1.width);
 end ;
 macroopen.InitialDir:=reg.ReadString('Macro_directory');
 except
 macroopen.initialdir:=ExtractFilePath(application.ExeName);
 end; //try
 macrosave.InitialDir:=macroopen.initialdir;
 end;
 reg.Destroy;


  if paramcount =0 then exit;

    currentfile:=paramstr(1);
    currentfile_tec:=currentfile;
    changefileext(currentfile_tec,'.tec');
    currentfile_ps:=currentfile;
    changefileext(currentfile_ps,'.ps');

    opendialog1.initialdir:=extractfilepath(paramstr(1));
    savedialog1.initialdir:=extractfilepath(paramstr(1));
    zf.SetFocus;
  if  uppercase(extractfileext(currentfile))='.TCS' then
    sourcelesen
  else
   begin
    texcadlesen.oeffne(currentfile);
    texcadlesen.liesalles;
    texcadlesen.schliesse;
    speichern1.enabled:=true;
   end;
      changefileext(currentfile,'.tcs');
      hs:=extractfilename(currentfile);
      opendialog1.FileName:=hs;
      savedialog1.filename:=hs;
      form1.caption:='TeXCad32 '+hs;
 end;


Procedure Tform1.aufraeumen;
var i:integer;
    puffer:zeichnungstyp;
    puffzahl:integer;
begin
 puffzahl:=0;
 for i:=1 to 32000 do if zeichnung[i]<> nil then
   if not zeichnung[i]^.deleted then begin
    inc(puffzahl);
    puffer[puffzahl]:=Zeichnung[i];
   end
   else dispose(zeichnung[i]);
 for i:=1 to 32000 do zeichnung[i]:=nil;
 if puffzahl>0 then for i:=1  to puffzahl do
   zeichnung[i]:=puffer[i];
   zeichzahl:=puffzahl;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
showmessage(s34+' '+version+' '+s35+' '+compdat);
end;


procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var antwort: word;
reg:Tregistry;
ok:boolean;

begin
  if dirty then
   begin
   antwort:= messagedlg(s36,
                   mtconfirmation,[mbyes,mbno,mbcancel],0);
   if antwort=mrcancel then action:= canone;
   if antwort = mrno then  action:=  cafree;
   if antwort= mryes then Speichern1click(sender);
  end;
 reg:=TRegistry.create;
 reg.openkey('Software\Texcad32',true);
 if form1.WindowState=wsmaximized then
  reg.writebool('Form1_maximized',true) else
  begin
   reg.writebool('Form1_maximized',false);
   reg.writeinteger('Form1_Top',Form1.Top);
   reg.writeinteger('Form1_Left',Form1.left);
   reg.writeinteger('Form1_Width',Form1.width);
   reg.writeinteger('Form1_Height',Form1.height);
  end;
 reg.writestring('Macro_Directory',macroopen.InitialDir);
reg.Destroy;
end;




function Tform1.screentoworldx(x:integer): double;
begin
result:=x/(zoomfak*pmm)+x0
end;

function Tform1.screentoworldy(y:integer): double;
begin
result:=(ZF.height-y)/(zoomfak*pmm)+y0
end;

function  TForm1.worldtoscreeny(y:double): integer;
begin
result:=round(ZF.height-zoomfak*pmm*(y-y0));
end;

function  TForm1.worldtoscreenx(x:double): integer;
begin
result:=round(zoomfak*pmm*(x-x0));
end;

function tform1.sx(a:integer):integer;
begin
  if not einst.snap then
   sx:=a else
   sx:=worldtoscreenx(round(screentoworldx(a)/snapfak)*snapfak)
end;

function tform1.sy(a:integer):integer;
begin
  if not einst.snap then
   sy:=a else
   sy:=worldtoscreeny(round(screentoworldy(a)/snapfak)*snapfak)
end;


function TForm1.Tcolor2RGBps(Farbe: TColor): string;
var rot,gruen,blau: longint;

begin
 gruen:=(farbe and $0000ff00) shr 8;
 blau:=(farbe and $00ff0000) shr 16;
 rot:=(farbe and $000000ff);
 Tcolor2RGBps:=format('%5.3f %5.3f %5.3f setrgbcolor',[rot/255, gruen/255, blau/255]);
end;

function TForm1.Tcolor2RGBtec(Farbe: TColor): string;
var rot,gruen,blau: longint;
begin
 gruen:=(farbe and $0000ff00) shr 8;
 blau:=(farbe and $00ff0000) shr 16;
 rot:=(farbe and $000000ff);
 Tcolor2RGBtec:=format('\color[rgb]{%5.3f,%5.3f,%5.3f}',[rot/255, gruen/255, blau/255]);
end;


///////////////////////////////////////////////////////
//                                                   //
//   Modus und Verteilprozeduren                     //
//                                                   //
///////////////////////////////////////////////////////

procedure TForm1.Buttonhoch;

begin
 linebutton.down:=false;
 textbutton.down:=false;
 kurve.down:=false;
 circbutton.down:=false;
 fillcircbutton.down:=false;
 kreis2.down:=false;
 Pfeil1.down:=false;
 Linie2.down:=false;
end;

procedure Tform1.Kontrollsicht;
var    sicht:boolean;
begin
 if aktmodus in [Linie1,pfeil,Kreisgross,rechteck] then
 sicht:=true else sicht:=false;;
p1.enabled:=sicht;
p2.enabled:=sicht;
p3.enabled:=sicht;
p4.enabled:=sicht;
updown1.enabled:=sicht;
updown2.enabled:=sicht;
updown3.enabled:=sicht;
updown4.enabled:=sicht;
kontrolle.enabled:=sicht;
deltaedit.enabled:=sicht;
strichlangedit.enabled:=sicht;
winkeldiffedit.enabled:=sicht;
end;


procedure TForm1.setmodus(m: modus);
var i:integer;

begin
statusbar1.Panels[2].text:=inttostr(zeichzahl)+S11;
aktmodus:=m;
kontrollsicht;
if m in [linie,rechteck,pfeil,linie1,kreis,fkreis,kreisgross,textm] then
 begin
  zf.canvas.pen.color:=curcol;
  zf.canvas.Pen.Width:=einst.dicken[breite];
  if m=fkreis then zf.canvas.brush.color:=clblack
           else zf.canvas.brush.color:=clwhite;
 end;
if m in [pick, auswahl, move,zoomarea,pickarea,macroeinfuegen] then
 begin
  zf.canvas.pen.color:=clblack;
  zf.canvas.Pen.Width:=1;
  zf.canvas.brush.color:=clwhite;
 end;

case m of
  linie: begin
           statusbar1.panels[0].text:=S12;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
           dirty:=true;
          end;

  rechteck: begin
           statusbar1.panels[0].text:=s13;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
           dirty:=true;
           if kurvenform.Kurventyp.ItemIndex=1 then
           kurvenform.Kurventyp.ItemIndex:=0;
          end;


  pfeil,linie1 : begin
           if aktmodus=pfeil then
            statusbar1.panels[0].text:=s14
           else
            statusbar1.panels[0].text:=s12;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
           dirty:=true;
           if kurvenform.Kurventyp.ItemIndex=1 then
           kurvenform.Kurventyp.ItemIndex:=0;
          end;

  kreis, FKreis, Kreisgross: begin
           if aktmodus=fkreis then
             begin
             r_max:=3;
             statusbar1.panels[0].text:=s15
             end  else if aktmodus=kreis then
             begin
             r_max:=6;
             statusbar1.panels[0].text:=s16
             end
             else begin
             r_max:=10000;
             statusbar1.panels[0].text:=s17
             end;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
           dirty:=true;
          end;

   textm:  begin
            statusbar1.panels[0].text:=s18;
            cancapture:=true;
            ZF.cursor:=crnone;
            cursor_gesetzt:=false;
            cpa.x:=-10000;
            cpa.y:=-10000;
           dirty:=true;
           end;

   pick, kurvenzeichnen:
           begin
            buttonhoch;
            cancapture:=false;
            statusbar1.panels[0].text:=s19;
            if m=kurvenzeichnen then
                    statusbar1.panels[0].text:=s20;
            ZF.Cursor:=CrArrow;
            cursor_gesetzt:=false;
            pickzahl:=0;
            for i:=1 to zeichzahl do
              if zeichnung[zeichzahl]^.picked then inc(pickzahl);
           dirty:=true;
           //if aktmodus=pick then zeichneneu(nil);
           end;

   auswahl:   statusbar1.panels[0].text:=s21;

   move: begin
          buttonhoch;
          statusbar1.panels[0].text:=s22;
          cancapture:=true;
          ZF.cursor:=crnone;
           dirty:=true;
         end;

   move1: begin
          cancapture:=true;
          statusbar1.panels[0].text:=s23;
          end;

   move_c: begin
           buttonhoch;
          statusbar1.panels[0].text:=s22;
          cancapture:=true;
          ZF.cursor:=crnone;
           dirty:=true;
         end;

   nichts: begin
            buttonhoch;
            releasecapture;
            cancapture:=false;
            ZF.cursor:=CrArrow;
            statusbar1.panels[0].text:=' ';
            cursor_loeschen;
           end;

  zoomArea: begin
             buttonhoch;
             statusbar1.panels[0].text:=s24;
             ZF.canvas.pen.color:=clblack;
             ZF.cursor:=CrArrow;
             ZF.canvas.Pen.Width:=1;
             ZF.Canvas.pen.style:=psdot;
           end;

  PickArea: begin
             buttonhoch;
             statusbar1.panels[0].text:=s25;
             ZF.canvas.pen.color:=clblack;
             ZF.cursor:=CrArrow;
             ZF.canvas.Pen.Width:=1;
             ZF.Canvas.pen.style:=psdot;
           dirty:=true;
           end;

  texted: begin
           buttonhoch;
           statusbar1.panels[0].text:=s26;
           ZF.cursor:=CrArrow;
           dirty:=true;
          end;
  macro_click: begin
           statusbar1.panels[0].text:=s66;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
          end;

  macroeinfuegen: begin
           statusbar1.panels[0].text:=s66;
           cancapture:=true;
           ZF.cursor:=crnone;
           cursor_gesetzt:=false;
           cpa.x:=-10000;
           cpa.y:=-10000;
           dirty:=true;
          end;

  else
end; //case
//statusbar1.panels[0].text:='ll';

end;


procedure TForm1.BoxMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if zflag then exit;
  case aktmodus of
  linie:    linienmouseup(Sender, Button, Shift, X, Y);
  linie1:    linien1mouseup(Sender, Button, Shift, X, Y);
  pfeil:    pfeilmouseup(Sender, Button, Shift, X, Y);
  rechteck: rechteckmouseup(Sender,Button,Shift,x,y);
  kreis,fkreis:    kreismouseup(Sender, Button, Shift, X, Y);
  kreisgross:    kreisgrossmouseup(Sender, Button, Shift, X, Y);
  zoomarea: zoommouseup(Sender, Button, Shift, X, Y);
  pickarea: pickareamouseup(Sender, Button, Shift, X, Y);
  textm:    textmouseup(Sender, Button, Shift, X, Y);
  texted:   textedmouseup(Sender, Button, Shift, X, Y);
  move_c:   move_cmouseup(Sender, Button, Shift, X, Y);
  end;
end;


procedure TForm1.BoxMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if zflag then exit;
 case aktmodus of
 linie, move1,rechteck,
  textm,pfeil,linie1,
  macro_click, macroeinfuegen  :  linienmousemove(sender,Shift,x,y);
 kreis, fkreis, kreisgross:     kreismousemove(Sender,Shift,x,y);
 pick:              pickmousemove(sender,Shift,x,y);
 ZoomArea:          Zoommousemove(sender, Shift, X, Y);
 pickArea:          pickareamousemove(sender, Shift, X, Y);
 move_c:            move_cmousemove(sender,Shift,X,Y);
 end; // case
end;

procedure TForm1.BoxMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
//  inherited;
  if zflag then exit;
  zf.setfocus;
///   zf.canvas.pen.Width :=einst.dicken[breite];      //***************
  case aktmodus of
  linie,pfeil,linie1,rechteck:
  begin
   if aktmodus=rechteck then drawingtool:=dtrectangle;
   linienmousedown(Sender, Button, Shift, X, Y);
  end;
  kreis,FKreis,kreisgross:    kreismousedown(Sender, Button, Shift, X, Y);
  auswahl:  fragemousedown(Sender, Button, Shift, X, Y);
  zoomarea: zoommousedown(sender,button, Shift,X,Y);
  pickarea: pickareamousedown(sender,button, Shift,X,Y);
  move_c:     move_cmousedown(Sender, Button, Shift, X, Y);
  end; //case
 if not form1.focused then
  begin
   form1.setfocus;
   cursor_loeschen;
   ignorenextmove:=true;
  end;
end;

procedure TForm1.BoxClick(Sender: TObject);
begin
 inherited;
 case aktmodus of
  pick:    pickboxclick(sender);
  auswahl: fragemouseclick(sender);
  move:    moveclick(sender);
  move1:   move1click(sender);
  macro_click: macroclick(sender);
  macroeinfuegen: macroeinfuegenclick(sender);
//  textm: textmclick(sender);
 end; //case
end;

procedure TForm1.repaintClick(Sender: TObject);
begin
setmodus(nichts);
zeichneneu(nil);
end;

procedure TForm1.ZFFocus(Sender: TObject);
begin
zf.setfocus;
end;


///////////////////////////////////////////////////////
//                                                   //
//    Zeichnen                                       //
//                                                   //
///////////////////////////////////////////////////////




function TForm1.adj2dis(c:char): double;
begin
 case c of
  'l','t' : result:=0;
  'r','b' : result:=1;
  'c'      : result:=0.5;
  else result:=0.5
 end;
end;

procedure TForm1.getcolor(zahl:integer);
begin
  ZF.canvas.pen.color:=zeichnung[zahl]^.farbe;
  ZF.Canvas.font.Color:=zeichnung[zahl]^.farbe;
  {if aktmodus = pick then begin
   ZF.canvas.pen.color:=clblack;
   ZF.Canvas.font.Color:=clblack;
  end; }
  if zeichnung[zahl]^.picked then begin
   ZF.canvas.pen.color:=piccol;
   ZF.Canvas.font.Color:=piccol;
  end;
  if zeichnung[zahl]^.posspicked then begin
   ZF.canvas.pen.color:=posspiccol;
      ZF.Canvas.font.Color:=posspiccol;
  end;
  if zeichnung[zahl]^.deleted then begin
   ZF.canvas.pen.color:=deletedcol;
   ZF.Canvas.font.Color:=deletedcol;
  end;

  if (zeichnung[zahl]^.typ in [lin,pf])
    then ZF.canvas.pen.width:=einst.dicken[zeichnung[zahl]^.ldicke];
    if zeichnung[zahl]^.ldicke=-1 then  ZF.canvas.pen.color:=unsichtbarcol;
  if (zeichnung[zahl]^.typ=circ)
    then ZF.canvas.pen.width:=einst.dicken[zeichnung[zahl]^.cdicke];

end;

procedure TForm1.Zeichne(zahl:integer);
var ausgabe: string[255];
    ppi, ox,oy:smallint;
    fstyle:Tfontstyles;
    pmode:TPenMode;
//   war pmcopy  statt pmNotXor
begin
  if moving then pmode:= pmNotXOR else pmode:=pmCopy;
  with zeichnung[zahl]^ do
   begin
  if deleted then exit;
  case typ of
   lin, pf: begin
             if einst.dicken[zeichnung[zahl]^.ldicke]=0 then exit;
             getcolor(zahl);
             drawingtool:=dtline;
             drawshape(point(worldtoscreenx(lx1),worldtoscreeny(ly1)),
             point(worldtoscreenx(lx2),worldtoscreeny(ly2)),pmode);
         end;
   circ: begin
             if einst.dicken[zeichnung[zahl]^.cdicke]=0 then exit;
             getcolor(zahl);
             if filled then begin
                ZF.canvas.brush.style:=bssolid;
                ZF.Canvas.Brush.Color:=ZF.Canvas.pen.color;
               end
               else ZF.canvas.brush.Style:=bsclear;
             drawingtool:=dtellipse;
             drawshape(point(worldtoscreenx(cx-r/2),worldtoscreeny(cy-r/2)),
             point(worldtoscreenx(cx+r/2),worldtoscreeny(cy+r/2)),pmode);
             ZF.canvas.brush.Style:=bsclear;
         end;
   txt: begin
         getcolor(zahl);
         ppi:=10;
         fstyle:=[];
         case einst.textanzeige of
         0,3: begin ppi:=ZF.canvas.Font.PixelsPerInch;
                    fstyle:=ZF.canvas.Font.Style;
                    ZF.canvas.Font.PixelsPerInch:=12;
                    ZF.canvas.Font.Style:=[FSbold];
                    if einst.textanzeige=0 then ausgabe:='T'
                        else ausgabe:=tadjust;

              end;
           1: ausgabe:=tinhalt;
           2: ausgabe:='';
         end;
          ox:=round(ZF.canvas.textwidth(ausgabe)*adj2dis(tadjust[2]));
          oy:=round(ZF.canvas.textheight(ausgabe)*adj2dis(tadjust[1]));
          ZF.canvas.textout(worldtoscreenx(tx)-ox,
             worldtoscreeny(ty)-oy,ausgabe);
          ZF.canvas.Font.PixelsPerInch:=ppi;
          ZF.canvas.Font.Style:=fstyle;
        end;
     {aux: begin
           if strichdicke=1 then ZF.canvas.Pen.Width:=1;
           if strichdicke=2 then ZF.canvas.Pen.Width:=3;
          end; //aux     }
    end; //case
  end; //with
end;



procedure TForm1.DrawShape(TopLeft, BottomRight: TPoint; AMode: TPenMode);
var cursor_war:boolean;
begin
  cursor_war:=cursor_gesetzt;
  with ZF.Canvas do
  begin
    Pen.Mode := AMode;
    case DrawingTool of
      dtLine:
        begin
          cursor_loeschen;
         // image1.canvas.pen.width:=einst.dicken[breite];
          ZF.Canvas.MoveTo(TopLeft.X, TopLeft.Y);
          ZF.Canvas.LineTo(BottomRight.X, BottomRight.Y);
          if cursor_war then cursor_setzen(cursor_alt.x,cursor_alt.y);
        end;
      dtRectangle: begin
      ZF.Canvas.Rectangle(TopLeft.X, TopLeft.Y,
                   BottomRight.X,BottomRight.Y);
                   end;
      dtEllipse: begin
      ZF.Canvas.Ellipse(Topleft.X, TopLeft.Y,
                   bottomright.X,bottomright.Y);
                end;
      dtRoundRect: ZF.Canvas.RoundRect(TopLeft.X, TopLeft.Y,
                   BottomRight.X,BottomRight.Y,
                   (TopLeft.X - BottomRight.X) div 2,
                   (TopLeft.Y - BottomRight.Y) div 2);
    end;
  end;
end;


procedure TForm1.setzesnap;

begin
     case einst.snapfak of
     0: snapfak:=1/3;
     1: snapfak:=0.5;
     2: snapfak:=1;
     3: snapfak:=2;
     4: snapfak:=3;
     5: snapfak:=4;
     6: snapfak:=5;
     7: snapfak:=6;
     8: snapfak:=8;
     9: snapfak:=10;
     end;

end;

procedure TForm1.zeichneneu(Sender: TObject);
var i,grupp, teiler, teiler1:smallint;
     savecol1, Savecol2: TColor;
     savewidth: smallint;
     savetool: TDRawingtool;

begin
     savecol1:=zf.canvas.pen.color;
     savecol2:=zf.canvas.Brush.Color;
     savewidth:=zf.canvas.pen.width;
     savetool:=drawingtool;
     zflag:=true;
//     inc(zahl2);

     zoomfak:=zooma[einst.zoomstufe];
     teiler :=teilera[einst.zoomstufe];
     teiler1:=teiler1a[einst.zoomstufe];
 //    setzesnap;
   //  nully:=nully+image1.canvas.height-pbh;    //falls sich die gre der
  //   pbh:=image1.canvas.height;                //zeichenflche gendert hat
     ZF.Canvas.pen.Mode:=pmcopy;
     ZF.Canvas.Brush.style:=bssolid;
     ZF.Canvas.pen.Color:=clwhite;
     ZF.Canvas.Brush.color:=clwhite;
     paintboxh.Canvas.pen.Color:=clwhite;
     paintboxh.Canvas.Brush.color:=clwhite;
     paintboxv.Canvas.pen.Color:=clwhite;
     paintboxv.Canvas.Brush.color:=clwhite;
     //zf.Invalidate; geht nicht
     paintboxh.Canvas.Rectangle(0,0,paintboxh.Width,paintboxh.Height);
     ZF.Canvas.Rectangle(0,0,ZF.Width,ZF.Height+1);
     paintboxv.Canvas.Rectangle(0,0,paintboxv.Width,paintboxv.Height);
     paintboxv.Canvas.pen.Color:=clblack;
     paintboxh.Canvas.pen.Color:=clblack;

 if gitter1.checked then gitter(teiler,teiler1);
  ZF.Canvas.pen.Color:=clblack;

  if zeichzahl>0 then for grupp:=0 to 9 do
     for i:=1 to zeichzahl do
       if zeichnung[i]^.gruppe=grupp then  zeichne(i);
 if cursor_gesetzt then
   begin cursor_gesetzt:=false;
   cursor_setzen(cursor_alt.x,cursor_alt.y);
  end;
  boxfertig:=true;
  zflag:=false;
  //image1.Canvas.ClipRect:=rect(30,0,image1.canvas.Width,image1.canvas.Height-30);
  setmodus(aktmodus);
  zf.canvas.pen.color:=savecol1;
  zf.canvas.Brush.Color:=savecol2;
  zf.canvas.pen.width:=savewidth;
  drawingtool:=savetool;

end;


///////////////////////////////////////////////////////
//                                                   //
//    Picken                                         //
//                                                   //
///////////////////////////////////////////////////////



procedure TForm1.pickclick(Sender: TObject);
begin
 if sender=pickbutton then setmodus(pick);
end;

function TForm1.nahe_dran(i:integer): boolean; //ist der Cursor CP
begin                                          //in der Nhe von Zeichnung[i]?
case zeichnung[i]^.typ of
 lin,pf:  result:= (
   ((abs(worldtoscreenx(zeichnung[i]^.lx1)-cp.x)<einst.pickdist)  and
   (abs(worldtoscreeny(zeichnung[i]^.ly1)-cp.y)<einst.pickdist)
   ) or (
   (abs(worldtoscreenx(zeichnung[i]^.lx2)-cp.x)<einst.pickdist) and
   (abs(worldtoscreeny(zeichnung[i]^.ly2)-cp.y)<einst.pickdist)));
 txt: result:=
    (abs(worldtoscreenx(zeichnung[i]^.tx)-cp.x)<einst.pickdist) and
   (abs(worldtoscreeny(zeichnung[i]^.ty)-cp.y)<einst.pickdist);
 circ: result:=
    (abs(worldtoscreenx(zeichnung[i]^.cx)-cp.x)<einst.pickdist) and
   (abs(worldtoscreeny(zeichnung[i]^.cy)-cp.y)<einst.pickdist);
 else result:=false;
end //case
end;

procedure TForm1.pickboxclick(sender:TObject);
var i:smallint;
 begin
 if ignorenextclick then begin
  ignorenextclick:=false;
  exit
 end;
 if (zeichzahl=0)  then exit;

 posspickzahl:=0;

 for i:=1 to  zeichzahl do
   if
   (not zeichnung[i]^.picked) and
   (not zeichnung[i]^.deleted) and
    nahe_dran(i)
    then begin
     zeichnung[i]^.posspicked:=true;
     inc(posspickzahl);
    end else
    zeichnung[i]^.posspicked:=false;
   if posspickzahl=0 then exit;
   i:=1;
   while not(zeichnung[i]^.posspicked) do inc(i);
   element_i:=i;      //suche das erste element mit posspicked
   zeichne(i);
   setmodus(auswahl);
   statusbar1.panels[0].text:=s27+inttostr(posspickzahl)+s28
end;

procedure TForm1.pickmousemove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
begin
cp.x:=x;cp.y:=y;
end;

procedure TForm1.fragemousedown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
begin
 if button=mbright then Jclick(SN) else JClick(sj)
end;

procedure TForm1.fragemouseclick(Sender: TObject);
begin
// nix
end;



procedure TForm1.JClick(antwort: char);
var i:integer;
begin
 if antwort=sn then begin
  zeichnung[element_i]^.posspicked:=false;
  zeichne(element_i);
  dec(posspickzahl);
  if posspickzahl>0 then begin
    i:=1;
    while not(zeichnung[i]^.posspicked) do inc(i);
    element_i:=i;
    zeichne(i);
   end;
 end
 else   begin     // Antwort J
  zeichnung[element_i]^.picked:=true;
  zeichnung[element_i]^.posspicked:=false;
//  info('pick: '+inttostr(element_i));
  zeichne(element_i);
  posspickzahl:=0;
  ignorenextclick:=true;
  inc(pickzahl);
 end;

 if posspickzahl=0 then begin
  for i:=1 to zeichzahl do zeichnung[i]^.posspicked:=false;
  setmodus(pick);
 end;
end;


procedure TForm1.UnpickClick(Sender: TObject);
var i:integer;
begin
for i:=1 to zeichzahl do
 zeichnung[i]^.picked:=false;
zeichneneu(unpick);
setmodus(pick);
end;

procedure TForm1.PickareabuttonClick(Sender: TObject);
begin
 setmodus(pickarea);
 Drawing:=false;
 drawingtool:=dtrectangle;
end;

procedure Tform1.pickareamousemove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    if drawing then begin
    DrawShape(Origin, MovePt, pmNotXor);
    MovePt := Point(X,Y);
    DrawShape(Origin, MovePt, pmNotXor);
    end;
end;

procedure Tform1.pickareamouseDown(Sender: TObject;Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Origin := Point(X, Y);
   MovePt := Origin;
   Drawing:=true;
end;

procedure Tform1.pickareamouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X,Y: Integer);
var x1,y1,x2,y2: double;
    i:integer;

begin
    DrawShape(Origin, MovePt, pmNotXor);
    Drawing:=false;
    ZF.Canvas.pen.style:=pssolid;
    setmodus(pick);
    x1:=screentoworldx(min(origin.x,Movept.x));
    x2:=screentoworldx(max(origin.x,Movept.x));
    y2:=screentoworldy(min(origin.y,Movept.y));
    y1:=screentoworldy(max(origin.y,Movept.y));
    if (x1=x2) or (y1=y2) then exit;
    for i:=1 to zeichzahl do
     with zeichnung[i]^ do
     case typ of
     lin,pf: if (lx1>=x1) and (lx1<=x2) and (lx2>=x1) and (lx2<=x2)
         and (ly1>=y1) and (ly1<=y2) and (ly2>=y1) and (ly2<=y2)
            then picked:=true;
     circ: if (cx-r>=x1) and (cx+r<=x2) and (cy-r>=y1) and (cy+r<=y2)
            then picked:=true;
     txt: if (tx>=x1) and (tx<=x2) and (ty>=y1) and (ty<=y2) then picked:=true;
     end; //case
 zeichneneu(pickbutton);
 pickareabuttonclick(nil);
end;

procedure tform1.pickzaehlen;
 var i:integer;
begin
 pickzahl:=0;
 for i:=1 to zeichzahl do
 if zeichnung[i]^.picked then inc(pickzahl);
end;

procedure Tform1.farbeaendern;
 var i: integer;
begin
 for i:=1 to zeichzahl do
 if zeichnung[i]^.picked then zeichnung[i].farbe:=einst.aktcol;
 form1.zf.SetFocus;
 zeichneneu(nil);
end;

///////////////////////////////////////////////////////
//                                                   //
//    Lschen und Entlschen                         //
//                                                   //
///////////////////////////////////////////////////////




procedure TForm1.DeleteClick(Sender: TObject);
 var i: smallint;
begin
 if zeichzahl=0 then exit;
 aufrumen1click(nil);
{ if messagedlg(s29,mtconfirmation,mbokcancel,0)
             =mrok
    then }
    for i:=1  to zeichzahl do
    if zeichnung[i]^.picked then begin
      zeichnung[i]^.picked:=false;
      zeichnung[i]^.deleted:=true;
      zeichne(i);
    end;
   pickzahl:=0;
   zeichneneu(delete);
end;




procedure TForm1.undeleteClick(Sender: TObject);
var i: smallint;
begin
 if zeichzahl=0 then exit;
     for i:=1  to zeichzahl do
     if zeichnung[i]^.deleted then begin
     zeichnung[i]^.deleted:=false;
     zeichnung[i]^.picked:=true
     end;
statusbar1.Panels[2].text:=inttostr(zeichzahl)+s37;
zeichneneu(nil);
end;



///////////////////////////////////////////////////////
//                                                   //
//    Move                                           //
//                                                   //
///////////////////////////////////////////////////////


procedure Tform1.move_cmousemove(Sender: TObject;
     Shift: TShiftState; X, Y: Integer);
var i:integer;dx,dy:double;
begin
   linienmousemove( Sender,Shift,X,y);
   if not(moving) then exit;
   if (sx(x)=move_x) and (sy(y)=move_y) then exit;
    for i:=1 to zeichzahl do
    if (zeichnung[i]^.typ<>txt) and zeichnung[i]^.picked then zeichne(i);

 dx:=screentoworldx(sx(x))-screentoworldx(move_x);
 dy:=screentoworldy(sy(y))-screentoworldy(move_y);
 for i:=1  to zeichzahl do
  with zeichnung[i]^ do
  if picked then
  case typ of
  lin,pf: begin lx1:=lx1+dx; lx2:=lx2+dx; ly1:=ly1+dy;ly2:=ly2+dy end;
  txt: begin tx:=tx+dx; ty:=ty+dy end;
  circ: begin cx:=cx+dx; cy:=cy+dy end;
  end; //case
    for i:=1 to zeichzahl do
    if (zeichnung[i]^.typ<>txt) and zeichnung[i]^.picked then zeichne(i);
  move_x:=sx(x);move_y:=sy(y);
    //

end;

procedure Tform1.move_cmouseDown(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X, Y: Integer);
begin
  drawing:=false;
  moving:=true;
  move_x:=sx(x);
  move_y:=sy(y);
    //
end;

procedure TForm1.move_cmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);
begin
    //
    ignorenextmove:=true;
    cursor_loeschen;
    moving:=false;
    zeichneneu(nil);
end;



procedure TForm1.MovebuttonClick(Sender: TObject);
begin
setmodus(move_c);
end;

procedure TForm1.MoveClick(Sender: TObject);
begin
moveorg:=cp;
setmodus(move1);
end;

procedure TForm1.Move1Click(Sender: TObject);
var dx,dy:double;
    i:integer;

begin
cursor_loeschen;
dx:=screentoworldx(cp.x)-screentoworldx(moveorg.x);
dy:=screentoworldy(cp.y)-screentoworldy(moveorg.y);
if messagedlg(s31+floattostr(dx)+','+
                    floattostr(dy)+s32,
                    mtconfirmation,mbokcancel,0)
             =mrok
    then for i:=1  to zeichzahl do
  with zeichnung[i]^ do
  if picked then
  case typ of
  lin,pf: begin lx1:=lx1+dx; lx2:=lx2+dx; ly1:=ly1+dy;ly2:=ly2+dy end;
  txt: begin tx:=tx+dx; ty:=ty+dy end;
  circ: begin cx:=cx+dx; cy:=cy+dy end;
  end; //case
  zeichneneu(movebutton);
 setmodus(pick);

end;

///////////////////////////////////////////////////////
//                                                   //
//  Zeichnen von Kurven und Linien                   //
//                                                   //
///////////////////////////////////////////////////////


procedure TForm1.linienmousedown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
  mbleft:  begin
   Drawing := True;
   cursor_loeschen;
   ZF.Canvas.MoveTo(sx(X), sy(Y));
   Origin := Point(sx(X), sy(Y));
   MovePt := Origin;
   cursor_setzen(sx(x),sy(y));
 //  StatusBar1.Panels[0].Text := Format('Origin: (%d, %d)', [sx(X), sy(Y)]);
  end;
  end; {case}
end;

procedure Tform1.linienmouseup(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   if Drawing then

  begin
  if (origin.x<>sx(x)) or (origin.y<>sy(y)) then begin
       inc(zeichzahl);
       new(P);
       zeichnung[zeichzahl]:=P;
       p^.gruppe:=3;
       p^.typ:=lin;
       p^.farbe:=einst.aktcol;
       p^.lx1:=screentoworldx(origin.X);
       p^.ly1:=screentoworldy(origin.y);
       p^.lx2:=screentoworldx(sx(x));
       p^.ly2:=screentoworldy(sy(y));
       p^.ldicke:=breite;
       p^.picked:=false;
       p^.posspicked:=false;
       p^.deleted:=false;
       protform.protokoll.Items.Add(
         Format('\emline{%3.1f}{%3.1f}{1}{%3.1f}{%3.1f}{2} ',
            [p^.lx1,p^.ly1,p^.lx2,p^.ly2])+'%'+inttostr(zeichzahl));

       cursor_loeschen;
       Zeichne(zeichzahl);
       cursor_setzen(sx(x),sy(y));
    end;
    Drawing := False;

  end;
end;



procedure Tform1.linienmousemove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

  if not boxfertig then exit;
  if ignorenextmove then begin
   ignorenextmove:=false;
   exit;
  end;

  with ZF do
  if (x<0) or (y<0)
   or (x>=width) or (y>=height) then {wir sind nicht in panel}
   begin
    releasecapture;
    cursor_loeschen;
    ZF.cursor:=CrArrow;
    exit;
  end;

  ZF.cursor:=crnone;
  if cancapture then setcapture(ZF.handle);
  cp.x:=sx(x);cp.y:=sy(y);
  if (cp.x<>cpa.x) or (cp.y<>cpa.y) then
      begin
      cursor_setzen(cp.x,cp.y);
      cpa:=cp;
      end;

  if Drawing then
  begin
    cursor_loeschen;
    DrawShape(Origin, MovePt, pmNotXor);
    MovePt := Point(sx(X), sy(Y));
    DrawShape(Origin, MovePt, pmNotXor);
    cursor_setzen(cp.x,cp.y);
  end;
end;



procedure TForm1.PfeilMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

  var alpha:double;
      x1,x2,y1,y2: double;

begin
  if not Drawing then exit;
  if not((origin.x<>sx(x)) or (origin.y<>sy(y))) then exit;

  linien1mouseup(Sender,Button,Shift,X,Y);
       x1:=screentoworldx(origin.X);
       y1:=screentoworldy(origin.y);
       x2:=screentoworldx(sx(x));
       y2:=screentoworldy(sy(y));


       if x1=x2 then
   if y2>y1 then alpha:=PI/2 else alpha:=-PI/2
 else
   alpha:=arctan((y1-y2)/(x1-x2));
   if x2<x1 then alpha:=alpha+PI;
       inc(zeichzahl);
       new(P);
       zeichnung[zeichzahl]:=P;
       p^.gruppe:=3;
       p^.farbe:=einst.aktcol;
       p^.typ:=pf;
       p^.lx1:=x2;
       p^.ly1:=y2;
       p^.lx2:=x2+einst.p_lang*cos(alpha+PI+einst.p_winkel);
       p^.ly2:=y2+einst.p_lang*sin(alpha+PI+einst.p_winkel);
       p^.ldicke:=breite;
       p^.picked:=true;
       p^.posspicked:=false;
       p^.deleted:=false;
       inc(zeichzahl);

       new(P);
       zeichnung[zeichzahl]:=P;
       p^.typ:=pf;
       p^.gruppe:=3;
       p^.farbe:=einst.aktcol;
       p^.lx2:=x2;
       p^.ly2:=y2;
       p^.lx1:=x2+einst.p_lang*cos(alpha+PI-einst.p_winkel);
       p^.ly1:=y2+einst.p_lang*sin(alpha+PI-einst.p_winkel);
       p^.ldicke:=breite;
       p^.picked:=true;
       p^.posspicked:=false;
       p^.deleted:=false;

       cursor_loeschen;
       Zeichne(zeichzahl-2);
       Zeichne(zeichzahl-1);
       Zeichne(zeichzahl);
       cursor_setzen(sx(x),sy(y));
       Drawing := False;
end;

procedure TForm1.rechteckmouseup(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

var m:double;
    x1,x2,y1,y2:integer;

begin
 if not Drawing then exit;
  drawing:=false;
  if (origin.x=sx(x)) or (origin.y=sy(y)) then exit;
  x1:=origin.x;
  x2:=x;
  y1:=origin.y;
  y2:=y;

  with p_linieninfo do begin
  _3d:=false;
  p_linieninfo.strichlaenge:=form1.strichlaenge;
  p_linieninfo.zielwinkel:=form1.zielwinkel;
  p_linieninfo.delta_p:=form1.delta_p;
  m:=einst.massstab;   //Abkrzung

  von_text:='0';
  bis_Text:='1.0';
  n_aktuell:=0;
  typ:=kontrolle.itemindex;

  Wertgrenze:=10000;
  Fehler_aufgetreten:=false;
  x_offset:=0;
  y_offset:=0;
  neue_linien_zahl:=0;
  end;

  p_linieninfo.x_text:=
    format('%6.3f + %6.3f * t',
     [screentoworldx(x1)/m,(screentoworldx(sx(x2))-screentoworldx(x1))/m]);
  p_linieninfo.y_text:=
    format('%6.3f',
     [screentoworldy(y1)/m]);
  prolog(p_linieninfo);
  if p_linieninfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;

  p_linieninfo.x_text:=
    format('%6.3f',
     [screentoworldx(sx(x2))/m]);
  p_linieninfo.y_text:=
    format('%6.3f + %6.3f * t',
     [screentoworldy(y1)/m,(screentoworldy(sy(y2))-screentoworldy(y1))/m]);
  prolog(p_linieninfo);
  if p_linieninfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;


  p_linieninfo.x_text:=
    format('%6.3f + %6.3f * t',
     [screentoworldx(sx(x2))/m,-(screentoworldx(sx(x2))-screentoworldx(x1))/m]);
  p_linieninfo.y_text:=
    format('%6.3f',
     [screentoworldy(sy(y2))/m]);
  prolog(p_linieninfo);
  if p_linieninfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;

  p_linieninfo.x_text:=
    format('%6.3f',
     [screentoworldx(x1)/m]);
  p_linieninfo.y_text:=
    format('%6.3f + %6.3f * t',
     [screentoworldy(sy(y2))/m,-(screentoworldy(sy(y2))-screentoworldy(y1))/m]);
  prolog(p_linieninfo);
  if p_linieninfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;

// Jetzt die Elemente aus neue_linien in die Zeichnung bernehmen

   phase:=1;
   phasenzaehler:=0;
   neue_linien_uebernehmen(updown1.Position,updown2.Position,
                          updown3.Position,updown4.Position);

end;

procedure TForm1.linien1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

  var m:double;

begin
   if not Drawing then exit;
  Drawing := False;

  if not((origin.x<>sx(x)) or (origin.y<>sy(y))) then exit;
  with p_linieninfo do begin     //p_linieninfo laden
  _3d:=false;
  p_linieninfo.strichlaenge:=form1.strichlaenge;
  p_linieninfo.zielwinkel:=form1.zielwinkel;
  p_linieninfo.delta_p:=form1.delta_p;
  m:=einst.massstab;
    x_text:=
    format('%6.3f + %6.3f * t',
     [screentoworldx(origin.x)/m,(screentoworldx(sx(x))-screentoworldx(origin.x))/m]);
  y_text:=
    format('%6.3f + %6.3f * t',
  [screentoworldy(origin.y)/m,(screentoworldy(sy(y))-screentoworldy(origin.y))/m]);
  von_text:='0';
  bis_Text:='1.0';
  n_aktuell:=0;
  typ:=kontrolle.ItemIndex;
  Wertgrenze:=10000;
  Fehler_aufgetreten:=false;
  x_offset:=0;
  y_offset:=0;
  neue_linien_zahl:=0;
  end;

  prolog(p_linieninfo);
  if p_linieninfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;
// Jetzt die Elemente aus neue_linien in die Zeichnung bernehmen

   phase:=1;
   phasenzaehler:=0;
   neue_linien_uebernehmen(updown1.Position,updown2.Position,
                          updown3.Position,updown4.Position);
end;




procedure Tform1.cursor_setzen(x,y:integer);
var save_col: TColor;
    altPmMode: TPenMode;
    breite:smallint;

begin
   if cursor_gesetzt then cursor_loeschen;
   statusbar1.panels[1].text:=
        format('(%d,%d)',[round(screentoworldx(x)),round(screentoworldy(y))]);
   altpmmode:=ZF.canvas.Pen.mode;
   save_col:=ZF.canvas.pen.color;
   breite:=ZF.canvas.pen.width;
   ZF.canvas.pen.width:=2;
   ZF.canvas.Pen.mode:=pmnotxor;
   ZF.canvas.pen.color:=curcol;
   ZF.canvas.moveto(x-5,y); ZF.canvas.lineto(x+5,y);
   ZF.canvas.moveto(x,y-5); ZF.canvas.lineto(x,y+5);
   ZF.canvas.pen.color:=save_col;
   ZF.canvas.Pen.mode:=altpmmode;
   ZF.canvas.pen.width:=breite;
   cursor_alt.x:=x;cursor_alt.y:=y;
   cursor_gesetzt:=true;
end;


procedure TForm1.Cursor_loeschen;
var save_col: TColor;
    altPmMode: TPenMode;
    breite:smallint;

begin
If not cursor_gesetzt then exit;
   altpmmode:=ZF.canvas.Pen.mode;
   save_col:=ZF.canvas.pen.color;
   breite:=ZF.canvas.pen.width;
   ZF.canvas.pen.width:=2;
   ZF.canvas.Pen.mode:=pmnotxor;
   ZF.canvas.pen.color:=curcol;
   ZF.canvas.moveto(cursor_alt.x-5,cursor_alt.y);
   ZF.canvas.lineto(cursor_alt.x+5,cursor_alt.y);
   ZF.canvas.moveto(cursor_alt.x,cursor_alt.y-5);
   ZF.canvas.lineto(cursor_alt.x,cursor_alt.y+5);
   ZF.canvas.pen.width:=breite;
   ZF.canvas.pen.color:=save_col;
   ZF.canvas.Pen.mode:=altpmmode;
   cursor_gesetzt:=false;
end;

procedure TForm1.kreismousedown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  drawingtool:=DtEllipse;
  case Button of
  mbleft:  begin
   Drawing := True;
   cursor_loeschen;
   ZF.Canvas.MoveTo(sx(X), sy(Y));
   Origin := Point(sx(X), sy(Y));
   MovePt := Origin;
   cursor_setzen(sx(x),sy(y));
 //  StatusBar1.Panels[0].Text := Format('Origin: (%d, %d)', [sx(X), sy(Y)]);
  end;
  end; {case}
end;

procedure Tform1.kreismouseup(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   if Drawing then

  begin
  if (origin.x<>sx(x)) or (origin.y<>sy(y)) then begin
       inc(zeichzahl);
       new(P);
       zeichnung[zeichzahl]:=P;
       p^.gruppe:=5;
       p^.typ:=circ;
       p^.farbe:=einst.aktcol;
       p^.cx:=screentoworldx(origin.X);
       p^.cy:=screentoworldy(origin.y);
       p^.r:=2*minr(r_max,
          maxr(abs(screentoworldx(origin.X)-screentoworldx(sx(x))),
              abs(screentoworldy(origin.Y)-screentoworldy(sy(y)))));
       p^.cdicke:=breite;
       p^.picked:=false;
       p^.posspicked:=false;
       p^.deleted:=false;
       p^.filled:=(aktmodus=Fkreis);
//       protform.protokoll.Items.Add(
//         Format('\put(%3.1f)(%3.1f){\circle{%3.1f}}',
//            [p^.cx,p^.cy,2*p^.r])+'%'+inttostr(zeichzahl));

       cursor_loeschen;
       Zeichne(zeichzahl);
       cursor_setzen(sx(x),sy(y));
    end;
    Drawing := False;

  end;
end;

procedure Tform1.kreismousemove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var r:integer;

begin

  if not boxfertig then exit;
  if ignorenextmove then begin
   ignorenextmove:=false;
   exit;
  end;

  with ZF do
  if (x<0) or (y<0)
   or (x>=width) or (y>=height) then {wir sind nicht in panel}
   begin
    releasecapture;
    cursor_loeschen;
    ZF.cursor:=CrArrow;
    exit;
  end;

  ZF.cursor:=crnone;
  if cancapture then setcapture(ZF.handle);
  cp.x:=sx(x);cp.y:=sy(y);
  if (cp.x<>cpa.x) or (cp.y<>cpa.y) then
      begin
      cursor_setzen(cp.x,cp.y);
      cpa:=cp;
      end;

  if Drawing then
  begin
    cursor_loeschen;
    r:=min(round(r_max*pmm*zoomfak),
        max(abs(origin.X-movept.X),abs(origin.Y-movept.Y)));

    DrawShape(point(Origin.x-r,origin.y-r),point(origin.x+r,origin.y+r), pmNotXor);
    MovePt := Point(sx(X), sy(Y));
    r:=min(round(r_max*pmm*zoomfak),
        max(abs(origin.X-movept.X),abs(origin.Y-movept.Y)));

    DrawShape(point(Origin.x-r,origin.y-r),point(origin.x+r,origin.y+r), pmNotXor);
    cursor_setzen(cp.x,cp.y);
  end;
end;

procedure Tform1.kreisgrossmouseup(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

var radius, m:double;
    i : integer;

begin
 if (origin.x=sx(x)) and (origin.y=sy(y)) then begin
 drawing:=false;
 setmodus(kreisgross);
 exit;
 end;

 if not Drawing then exit;
 drawing:=false;

   with p_kreisinfo do begin
  _3d:=false;
  m:=einst.massstab;
  p_kreisinfo.strichlaenge:=form1.strichlaenge;
  p_kreisinfo.zielwinkel:=form1.zielwinkel;
  p_kreisinfo.delta_p:=form1.delta_p;
  radius:= maxr(abs(screentoworldx(origin.X)/m-screentoworldx(sx(x))/m),
              abs(screentoworldy(origin.Y)/m-screentoworldy(sy(y))/m));
    x_text:=
    format('%6.3f + %6.3f * cos(t)',
      [screentoworldx(origin.x)/m,radius]);
  y_text:=
    format('%6.3f + %6.3f * sin(t)',
  [screentoworldy(origin.y)/m,radius]);

   Kreisform.showmodal;
   ignorenextmove:=true;
  // setmodus(nichts);
   kreis2.Down:=false;
   cursor_loeschen;

  von_text:=kreisform.vond_edit.Text;
  bis_Text:=kreisform.bisd_edit.Text;
  n_aktuell:=0;
  typ:=kontrolle.ItemIndex;     // 1 ist Richtungskontrolle
  Wertgrenze:=10000;
  Fehler_aufgetreten:=false;
  x_offset:=0;
  y_offset:=0;
  neue_linien_zahl:=0;
  end;

  prolog(p_kreisinfo);
  if p_kreisinfo.Fehler_aufgetreten then exit;
  zflag:=true;
  zeichne_kurve;
  zflag:=false;
// Jetzt die Elemente aus neue_linien in die Zeichnung bernehmen

   phase:=1;
   phasenzaehler:=0;
   neue_linien_uebernehmen(updown1.Position,updown2.Position,
                          updown3.Position,updown4.Position);

end;


procedure TForm1.Kreis2Click(Sender: TObject);
begin
drawingtool:=DtEllipse;
//  if kreis2.down then
      setmodus(kreisgross)
//    else
//      setmodus(nichts);
end;

procedure TForm1.breite_aendern;
var i:integer;
 geaendert:boolean;

begin
 pickzaehlen;
 breite:=linienbreite.ItemIndex-1;
 ZF.canvas.Pen.Width:=einst.dicken[breite];
  cursor_loeschen; ignorenextmove:=true;
  if pickzahl>0 then
    if messagedlg(s33,
         mtconfirmation,[mbyes, mbno],0)=mryes then
  begin
   setmodus(aktmodus);
   geaendert:=false;
   //if (aktmodus=pick) or (aktmodus=pickarea) then
    for i:=1 to zeichzahl do
    if zeichnung[i]^.picked then
     case zeichnung[i]^.typ of
      lin,pf: begin
      if (zeichnung[i]^.ldicke<>breite) and (zeichnung[i]^.ldicke>=0) then
       begin
       geaendert:=true;
       zeichnung[i]^.ldicke:=breite;
       end;
      end;
      circ:  begin
      if (zeichnung[i]^.cdicke<>breite) and (zeichnung[i]^.cdicke>=0) then
       begin
       geaendert:=true;
       zeichnung[i]^.cdicke:=breite;
       end;
      end;
     end; //case
   if geaendert then zeichneneu(nil);
end;
end;


procedure TForm1.LineButtonClick(Sender: TObject);
begin
  DrawingTool := dtLine;
//  if linebutton.down then
      setmodus(linie)
  {  else
      setmodus(nichts);}
end;

procedure TForm1.circbuttonClick(Sender: TObject);
begin
  DrawingTool := dtEllipse;
 // if circbutton.down then
      setmodus(kreis)
   { else
      setmodus(nichts);}
end;

procedure TForm1.FillcircbuttonClick(Sender: TObject);
begin
  DrawingTool := dtellipse;
//  if Fillcircbutton.down then
      setmodus(Fkreis)
 //   else
//      setmodus(nichts);
end;



///////////////////////////////////////////////////////
//                                                   //
//    Einstellungen                                  //
//                                                   //
///////////////////////////////////////////////////////



procedure TForm1.einstellungenClick(Sender: TObject);

var altmodus: modus;

begin
 altmodus:=aktmodus;
 setmodus(nichts);
 cursor_loeschen;
 einstellungen.showmodal;
 ignorenextmove:=true;
 setmodus(altmodus);
 zeichneneu(einstellungen);
end;



procedure TForm1.Gitter(teiler,teiler1:smallint);
var i,j1,j2 :smallint;
begin
//  breite_alt:=breite;
//  breite:=1;
//  standard_alt:=einst.dicken[1];
  drawingtool:=dtline;
  ZF.Canvas.pen.style:=pssolid;
      j1:=round(screentoworldy(1)+0.5);
      j2:=round(screentoworldy(ZF.height)+0.5);
  for i:=j2 to j1 do   begin
    if i mod teiler =0 then begin
      ZF.Canvas.pen.color:=Farbe2;
      ZF.Canvas.pen.width:=weite2;
      paintboxv.canvas.textout(1,
          worldtoscreeny(i)-ZF.canvas.textheight(inttostr(i))div 2,
            inttostr(i));
    end else begin
      ZF.Canvas.pen.color:=Farbe1;
      ZF.Canvas.pen.width:=weite1;
    end;
    if i mod teiler1= 0 then
    drawshape(point((0),worldtoscreeny(i)),
             point((ZF.width),worldtoscreeny(i)),pmcopy);
  end;

      j1:=round(screentoworldx(0)+0.5);
      j2:=round(screentoworldx(ZF.width)-0.5);
  for i:=j1 to j2 do   begin
    if i mod teiler =0 then begin
      ZF.Canvas.pen.color:=Farbe2;
      ZF.Canvas.pen.width:=weite2;
      paintboxh.canvas.textout(
       paintboxv.width+ worldtoscreenx(i)-paintboxh.canvas.textwidth(inttostr(i))div 2,
          1,inttostr(i));
    end else begin
      ZF.Canvas.pen.color:=Farbe1;
      ZF.Canvas.pen.width:=weite1;
    end;
    if i mod teiler1=0 then
    drawshape(point(worldtoscreenx(i),1),
             point(worldtoscreenx(i),ZF.height),pmcopy);
  end;
//  breite:=breite_alt;
//  einst.dicken[1]:=standard_alt;
end;

///////////////////////////////////////////////////////
//                                                   //
//    Ansicht  und Zoom                              //
//                                                   //
///////////////////////////////////////////////////////

procedure TForm1.ProtokollClick(Sender: TObject);
begin
protokoll.Checked:=not(protokoll.checked);
if protokoll.checked then protform.Show else protform.hide;
end;

procedure TForm1.Info(infotext:string);
begin
messagedlg(infotext,mtinformation,[mbok],0);
//protform.protokoll.items.add(infotext);// +format('cp: %d, %d',[cp.x,cp.y]));
end;

procedure TForm1.ZoomAreaButtonClick(Sender: TObject);
begin
 setmodus(zoomarea);
 Drawing:=false;
 drawingtool:=dtrectangle;
end;

procedure Tform1.zoommousemove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    if drawing then begin
    DrawShape(Origin, MovePt, pmNotXor);
    MovePt := Point(X,Y);
    DrawShape(Origin, MovePt, pmNotXor);
    end;
end;

procedure Tform1.zoommouseDown(Sender: TObject;Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Origin := Point(X, Y);
   MovePt := Origin;
   Drawing:=true;
end;

procedure Tform1.zoommouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X,Y: Integer);
var x1,y1,x2,y2, i,j,zoommax:integer; dx,dy:double;

begin
    DrawShape(Origin, MovePt, pmNotXor);
    Drawing:=false;
    ZF.Canvas.pen.style:=pssolid;
    setmodus(nichts);
    zoom_alt:=einst.zoomstufe;
    x1:=min(origin.x,Movept.x);
    x2:=max(origin.x,Movept.x);
    y1:=min(origin.y,Movept.y);
    y2:=max(origin.y,Movept.y);
    if (x1=x2) or (y1=y2) then exit;
    x0_alt:=x0;
    y0_alt:=y0;
    dx:=screentoworldx(x2);
    dy:=screentoworldy(y1);
    x0:=round(screentoworldx(x1));
    y0:=round(screentoworldy(y2));
    zoommax:=0;
    for i:=0 to 8 do
      if round(zooma[i]*pmm*(screentoworldx(x2)-screentoworldx(x1)))
        <ZF.width
       then zoommax:=i;
       j:=zoommax;
    for i:=0 to j do
      if round(zooma[i]*pmm*(screentoworldy(y1)-screentoworldy(y2)))<ZF.height
       then zoommax:=i;
       einst.zoomstufe:=zoommax;
       setze_zoom(einst.zoomstufe);
       zoomfak:=zooma[einst.zoomstufe]; //damit konvertierung stimmt
     x0:=x0-round((screentoworldx(ZF.Width)-dx)/2);
     y0:=y0-round((screentoworldy(0)-dy)/2);
    unzoombutton.Enabled:=true;
    zeichneneu(zoomareabutton);
    end;


procedure TForm1.unzoombuttonClick(Sender: TObject);
begin
 x0:=x0_alt;
 y0:=y0_alt;
 einst.zoomstufe:=zoom_alt;
 setze_zoom(einst.zoomstufe);
 unzoombutton.Enabled:=false;
 zeichneneu(unzoombutton);
end;

///////////////////////////////////////////////////////
//                                                   //
//    Text                                           //
//                                                   //
///////////////////////////////////////////////////////



procedure TForm1.TextbuttonClick(Sender: TObject);
begin
//  if textbutton.down then
      setmodus(Textm)
 //   else
 //     setmodus(nichts);
end;

procedure tform1.textmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);

var erg, textanz_alt:integer;
begin
  inc(zeichzahl);
  new(P);
  zeichnung[zeichzahl]:=P;
  p^.gruppe:=8;
  p^.typ:=txt;
  p^.farbe:=einst.aktcol;
  p^.tx:=screentoworldx(sx(X));
  p^.ty:=screentoworldy(sy(y));
  p^.tadjust:='cc';
  p^.picked:=false;
  p^.posspicked:=false;
  p^.deleted:=false;
  cp.x:=sx(x);cp.y:=sy(y);
  cursor_loeschen;
  textanz_alt:=einst.textanzeige;
  einst.textanzeige:=0;
//  Zeichne(zeichzahl);
  einst.textanzeige:=textanz_alt;
  drawingtool:=dtline;
  ZF.Canvas.pen.color:=clblack;
  ZF.Canvas.Pen.width:=2;
  drawshape(point(sx(x)-3,sy(y)),point(sx(x)+3,sy(y)),pmnotxor);
  drawshape(point(sx(x),sy(y)-3),point(sx(x),sy(y)+3),pmnotxor);
 setmodus(warten);
 textein.Edit2.text:=format('%3.1f',[p^.tx]);
 textein.Edit3.text:=format('%3.1f',[p^.ty]);
// textein.edit1.SetFocus;
// textein.edit1.selectall;
 erg:=textein.ShowModal;
// drawshape(point(sx(x)-3,sy(y)),point(sx(x)+3,sy(y)),pmnotxor);
// drawshape(point(sx(x),sy(y)-3),point(sx(x),sy(y)+3),pmnotxor);
 if erg=mrcancel then begin
  dispose(p);
  dec(zeichzahl);
  setmodus(Textm);
  cursor_loeschen;
  ignorenextmove:=true;
  //zf.invalidate;   // DEBUG
// zeichneneu(nil);
  exit;
 end;
 p^.tinhalt:=pchar(textein.Edit1.text);
 case textein.Ausrichtung.ItemIndex of
  0: p^.tadjust:='tl';
  1: p^.tadjust:='cl';
  2: p^.tadjust:='bl';
  3: p^.tadjust:='tc';
  4: p^.tadjust:='cc';
  5: p^.tadjust:='bc';
  6: p^.tadjust:='tr';
  7: p^.tadjust:='cr';
  8: p^.tadjust:='br';
 end; //case
 protform.protokoll.Items.Add(
    Format('\put(%3.1f,%3.1f)[',[p^.tx,p^.ty])+
     p^.tadjust+']{'+p^.tinhalt+'}' );
 setmodus(textm);
 zeichne(zeichzahl);
 ignorenextmove:=true;
 zf.Invalidate;   //DEBUG
end;

procedure TForm1.TexteditClick(Sender: TObject);
begin
setmodus(texted);
end;

procedure tform1.textedmouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X,Y: Integer);

var i, izahl, erg:integer; dist, wx, wy: double;

begin
 dist:=100000000;
 wx:=screentoworldx(x);
 wy:=screentoworldy(y);
 izahl:=0;
 for i:=1 to zeichzahl do
   if zeichnung[i]^.typ=txt then
    if sqr(wx-zeichnung[i]^.tx)+sqr(wy-zeichnung[i]^.ty) < dist
      then begin
        dist:= sqr(wx-zeichnung[i]^.tx)+sqr(wy-zeichnung[i]^.ty);
        izahl:=i;
      end;
 if izahl=0 then
   begin
     setmodus(nichts);
     exit;
   end;
 zeichne(izahl);
 p:=zeichnung[izahl];
 p^.picked:=true;
 textein.Edit2.text:=format('%3.1f',[p^.tx]);
 textein.Edit3.text:=format('%3.1f',[p^.ty]);
 if p^.tadjust='tl' then textein.Ausrichtung.ItemIndex:=0 else
 if p^.tadjust='cl' then textein.Ausrichtung.ItemIndex:=1 else
 if p^.tadjust='bl' then textein.Ausrichtung.ItemIndex:=2 else
 if p^.tadjust='tc' then textein.Ausrichtung.ItemIndex:=3 else
 if p^.tadjust='cc' then textein.Ausrichtung.ItemIndex:=4 else
 if p^.tadjust='bc' then textein.Ausrichtung.ItemIndex:=5 else
 if p^.tadjust='tr' then textein.Ausrichtung.ItemIndex:=6 else
 if p^.tadjust='cr' then textein.Ausrichtung.ItemIndex:=7 else
 if p^.tadjust='br' then textein.Ausrichtung.ItemIndex:=8;
 textein.Edit1.Text:=p^.tinhalt;
 erg:=textein.ShowModal;
 if erg=mrcancel then
   begin
    p^.picked:=false;
    zeichne(izahl);
    exit;
   end;
 p^.tinhalt:=pchar(textein.Edit1.text);
 case textein.Ausrichtung.ItemIndex of
  0: p^.tadjust:='tl';
  1: p^.tadjust:='cl';
  2: p^.tadjust:='bl';
  3: p^.tadjust:='tc';
  4: p^.tadjust:='cc';
  5: p^.tadjust:='bc';
  6: p^.tadjust:='tr';
  7: p^.tadjust:='cr';
  8: p^.tadjust:='br';
 end; //case
 protform.protokoll.Items.Add(
    Format('\put(%3.1f,%3.1f)[',[p^.tx,p^.ty])+
     p^.tadjust+']{'+p^.tinhalt+'}' );
 setmodus(texted);
 p^.picked:=false;
 zeichne(izahl);
 ignorenextmove:=true;;
end;





procedure TForm1.Gitter1Click(Sender: TObject);
begin
gitter1.Checked:=not gitter1.Checked;
zeichneneu(gitter1);
end;

procedure TForm1.zoommenuclick(Sender: TObject);
var zoomalt: integer;

begin
   zoomalt:=einst.zoomstufe;
   N11.Checked:=false;
   N21.Checked:=false;
   N31.Checked:=false;
   N41.Checked:=false;
   N51.Checked:=false;
   N61.Checked:=false;
   N71.Checked:=false;
   N81.Checked:=false;
   N91.Checked:=false;
 with sender as tMenuitem do
  begin
   checked:=true;
   einst.zoomstufe:=strtoint(caption);
  end;
 if einst.zoomstufe <> zoomalt then zeichneneu(sender);
end;


procedure TForm1.kopieren(Sender:Tobject);
var i: integer;

begin
 if puffzahl>0 then
 for i:=1 to puffzahl do
   dispose(puffer[i]);
 puffzahl:=0;
 //Puffer leeren
 for i:=1 to zeichzahl do
 //markierte in den Puffer kopieren
 with zeichnung[i]^ do
 if picked and not deleted
  then begin
   inc(puffzahl);
   new(puffer[puffzahl]);
   puffer[puffzahl]^:=zeichnung[i]^;
  end;
 end;


procedure TForm1.einfuegen(Sender:Tobject);
var i: integer;

begin
  if puffzahl>0 then
  for i:=1 to puffzahl do begin
    inc(zeichzahl);
    new(zeichnung[zeichzahl]);
    zeichnung[zeichzahl]^:=puffer[i]^;
  end;
  zeichneneu(nil);
  //Puffer einfgen;
  //for i:=1 to 32000 do
  //markierte in den Puffer kopieren
end;

procedure TForm1.ausschneiden(Sender:Tobject);
var i:integer;
    markiert:boolean;

begin
 if zeichzahl=0 then exit;
 markiert:=false;
 for i:=1 to  zeichzahl do
   if (zeichnung[i]^.picked and not zeichnung[i]^.deleted)
          then markiert:=true;
 if not markiert then exit;
 if puffzahl>0 then
 for i:=1 to puffzahl do
   dispose(puffer[i]);
 puffzahl:=0;
 //Puffer leeren
 for i:=1 to zeichzahl do
 //markierte in den Puffer kopieren
 with zeichnung[i]^ do
 if picked and not deleted
  then begin
   inc(puffzahl);
   new(puffer[puffzahl]);
   puffer[puffzahl]^:=zeichnung[i]^;
   zeichnung[i]^.deleted:=true;
  end;
  zeichneneu(nil);
end;

procedure TForm1.setze_zoom(stufe:integer);   //setzt die Zoomstufe im Menu
begin

   N11.Checked:=false;
   N21.Checked:=false;
   N31.Checked:=false;
   N41.Checked:=false;
   N51.Checked:=false;
   N61.Checked:=false;
   N71.Checked:=false;
   N81.Checked:=false;
   N91.Checked:=false;
case einst.zoomstufe of
 1: n11.checked:=true;
 2: n21.checked:=true;
 3: n31.checked:=true;
 4: n41.checked:=true;
 5: n51.checked:=true;
 6: n61.checked:=true;
 7: n71.checked:=true;
 8: n81.checked:=true;
 9: n91.checked:=true;
 end;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);

var modus_alt: modus;
    i:integer;
begin
 if (aktmodus=macro) and (Shift=[]) and(Key=27) then
   begin setmodus(nichts);  exit; end;
 if (aktmodus=macro) and (Shift=[]) and(Key<>17) then
  macroladen(key);
 if (key=VKkeyscan('g')) and (Shift=[ssctrl]) then
   begin; ignorenextmove:=true; cursor_loeschen;gitter1click(nil); exit; end;
 if (key=VKkeyscan('0')) and (Shift=[ssctrl]) then  begin
    Linienbreite.ItemIndex:=0;  breite_aendern; end;
 if (key=VKkeyscan('1')) and (Shift=[ssctrl]) then  begin
    Linienbreite.ItemIndex:=1;  breite_aendern; end;
 if (key=VKkeyscan('2')) and (Shift=[ssctrl]) then  begin
    Linienbreite.ItemIndex:=2;  breite_aendern; end;
 if (key=VKkeyscan('3')) and (Shift=[ssctrl]) then  begin
    Linienbreite.ItemIndex:=3;  breite_aendern; end;

 if  (key=VKkeyscan('z')) and (Shift=[ssctrl]) then undeleteclick(nil);
 if  (key=VKkeyscan('m')) and (Shift=[ssctrl]) then begin
   setmodus(macro) ;   statusbar1.panels[0].text:='macro'; end;
 if  (key=VKkeyscan('r')) and (Shift=[ssctrl]) then
     if FileExists(macroopen.FileName) then setmodus(macroeinfuegen);

 if  (key=VK_ADD) and (Shift=[ssctrl]) and (einst.zoomstufe<8) then
     begin
      cursor_loeschen;
      inc(einst.zoomstufe);
      setze_zoom(einst.zoomstufe);
      zeichneneu(form1);
      cursor_setzen(cursor_alt.x,cursor_alt.y);
     end;
 if  (key=VK_SUBTRACT) and (Shift=[ssctrl]) and (einst.zoomstufe>0) then
     begin
      cursor_loeschen;
      dec(einst.zoomstufe);
      setze_zoom(einst.zoomstufe);
      zeichneneu(form1);
      cursor_setzen(cursor_alt.x,cursor_alt.y);
     end;
 if  (key=VKkeyscan('s')) and (Shift=[ssctrl]) then
   begin
    snapcheck.checked:=not(snapcheck.checked);
    einst.snap:=snapcheck.checked;
   end;
 if (key=VKKeyscan('a')) and (Shift=[ssctrl]) then
     begin
      for i:=1 to zeichzahl do zeichnung[i]^.picked:=true;
      cursor_loeschen;
      zeichneneu(nil);
     end;;
 if (key=VKKeyscan('c')) and (Shift=[ssctrl]) then
    kopieren(nil);
  if (key=VKKeyscan('v')) and (Shift=[ssctrl]) then
  einfuegen(nil);
  if (key=VKKeyscan('x')) and (Shift=[ssctrl]) then
  ausschneiden(nil);
 if  key=VK_Delete then  if not
   (kurvenform.x_edit.Focused or kurvenform.y_edit.focused //or y_edit.focused
    or kurvenform.von.focused or kurvenform.bis.focused) then  Deleteclick(nil);
 if key=VK_escape then begin
     modus_alt:=aktmodus;
     cursor_loeschen;
     Unpickclick(nil);
     setmodus(modus_alt)
     end;
end;


procedure TForm1.Skalieren1Click(Sender: TObject);
var x0,y0,xfaktor,yfaktor: double;
     i: integer;

begin
  if skalierform.showmodal=mrcancel then exit;
  x0:=strtofloat(skalierform.x.text);
  y0:=strtofloat(skalierform.y.text);
  xfaktor:=strtofloat(skalierform.xfaktor.text);
  yfaktor:=strtofloat(skalierform.yfaktor.text);
  for i:=1 to zeichzahl do with zeichnung[i]^ do
    if picked then
    case  typ of
     lin,pf:  begin
           lx1:=x0+(lx1-x0)*xfaktor;
           ly1:=y0+(ly1-y0)*yfaktor;
           lx2:=x0+(lx2-x0)*xfaktor;
           ly2:=y0+(ly2-y0)*yfaktor;
           end;
      circ: begin
            cx:=x0+(cx-x0)*xfaktor;
            cy:=y0+(cy-y0)*yfaktor;
            if filled then
            r:=minr(r_max,r*xfaktor)
            else
            r:=r*xfaktor;
            end;
      txt:  begin
            tx:=x0+(tx-x0)*xfaktor;
            ty:=y0+(ty-y0)*yfaktor;
            end;
    end;
   zeichneneu(nil);
end;



procedure TForm1.Pfeil1Click(Sender: TObject);
begin
Drawingtool:=DtLine;
//  if pfeil1.down then
      setmodus(pfeil)
//    else
//      setmodus(nichts);
end;


procedure TForm1.rechteck1Click(Sender: TObject);
begin
Drawingtool:=Dtrectangle;
//  if rechteck1.down then
      setmodus(rechteck)
//    else
//      setmodus(nichts);
end;

procedure TForm1.KurveClick(Sender: TObject);
var n,n0,n1: integer;
begin
  setmodus(pick);
  kurvenform.showmodal;
  if kurvenform.ModalResult=mrcancel then
  begin
  setmodus(pick);
  exit;
  end;
 zf.SetFocus;
 //p_kurveninfo.x_offset:=strtoint(kurvenform.x_off.text);
 //p_kurveninfo.y_offset:=strtoint(kurvenform.y_off.text);
 n0:=strtoint(kurvenform.n_0.text);
 n1:=strtoint(kurvenform.n_1.text);
 p_kurveninfo.x_text:=kurvenform.x_Edit.Text;
 p_kurveninfo.y_text:=kurvenform.y_Edit.Text;
 p_kurveninfo.z_text:=kurvenform.z_Edit.Text;

 p_kurveninfo.von_text :=kurvenform.von.Text;
 p_kurveninfo.bis_text :=kurvenform.bis.Text;

 //p_kurveninfo.typ:=kurvenform.Kurventyp.ItemIndex;
 p_kurveninfo._3d:=kurvenform.is3d.Checked;
 p_Kurveninfo.wertgrenze:=10000;
 //p_kurveninfo.strichlaenge:=strtofloat(kurvenform.strich_edit.text);

 if n1<n0 then exit;
 //p_kurveninfo.delta_p:=strtofloat(kurvenform.delta.text);
 for n:=n0 to n1 do begin
 p_kurveninfo.n_aktuell:=n;
 prolog(p_kurveninfo);
 if p_kurveninfo.Fehler_aufgetreten then
  begin
  x_offset:=0;
  y_offset:=0;
  exit;
  end;
 neue_linien_zahl:=0;
 zeichne_kurve;

 phase:=1;
 phasenzaehler:=0;
 neue_linien_uebernehmen(
         kurvenform.updown1.Position,kurvenform.updown2.Position,
         kurvenform.updown3.Position,kurvenform.updown4.Position);

 end;
  x_offset:=0;
  y_offset:=0;
 form1.setmodus(pick);

end;



procedure TForm1.Linie2Click(Sender: TObject);
begin
Drawingtool:=DtLine;
//  if linie2.down then
      setmodus(linie1)
//    else
//      setmodus(nichts);
end;

procedure TForm1.snapcheckClick(Sender: TObject);
begin
einst.snap:=snapcheck.checked;
end;

procedure TForm1.SnapboxChange(Sender: TObject);
begin
einst.snapfak:=snapbox.ItemIndex ;
setzesnap;
ZFFocus(nil);
end;



procedure TForm1.gotozeroClick(Sender: TObject);
begin
einstellungen.nullx_edit.text:='-2';
x0:=-2;
einstellungen.nully_edit.Text:='-2';
y0:=-2;
zeichneneu(nil);
end;

procedure TForm1.Clip1Click(Sender: TObject);
begin
clipform.showmodal;

end;

procedure TForm1.Aufrumen1Click(Sender: TObject);
begin
aufraeumen;
statusbar1.Panels[2].text:=inttostr(zeichzahl)+s37;
end;





///////////////////////////////////////////////////////
//                                                   //
//    Dateimenu                                      //
//                                                   //
///////////////////////////////////////////////////////



procedure TForm1.New1Click(Sender: TObject);

var antwort:word;
          i:integer;
begin
  if dirty then
  begin
    antwort:= messagedlg(s38,
                   mtconfirmation,[mbyes,mbno],0);
   if antwort = mryes then
      Speichern1click(sender);
  end;
if zeichzahl>0 then for i:=1 to 32000
   do begin
    dispose(zeichnung[i]);
    zeichnung[i]:=nil;
   end;
  zeichzahl:=0;
  cursor_loeschen;
  zeichneneu(new1);
  currentfile:='';
  currentfile_tec:='';
  currentfile_ps:='';
  setmodus(nichts);
  dirty:=false;
  einstellunit.Einstellungen.Unitlength.text:='1';
  form1.Caption:='TeXCad32';
  savedialog1.filename:='';
end;

procedure TForm1.ImportClick(Sender: TObject);
var i:integer;

begin
 if dirty then if messagedlg(s39,mtwarning,[mbyes,mbno],0)=mrno
     then exit;
    opendialog1.Filter:=s40;
 if opendialog1.Execute then
 begin
   opendialog1.InitialDir:=extractfilepath(opendialog1.Filename);
   savedialog1.InitialDir:=opendialog1.InitialDir;
   if zeichzahl>0 then for i:=1 to zeichzahl
      do dispose(zeichnung[i]);
    zeichzahl:=0;
    cursor_loeschen;
    currentfile:=changefileext(extractfilename(opendialog1.filename),'.tcs');
    form1.caption:='TeXcad 32 - '+currentfile;
    texcadlesen.oeffne(opendialog1.FileName);
    texcadlesen.liesalles;
    texcadlesen.schliesse;
    dirty:=false;
  //  speichern1.Enabled:=true;
    zeichneneu(open1);
 end;
  ignorenextmove:=true;
  setmodus(nichts);
end;

procedure TForm1.Exportierenunter1Click(Sender: TObject);


begin
 ignorenextmove:=true;
 if etyp=tec then begin
 savedialog1.filename:=changefileext(currentfile,'.tec');
 savedialog1.filter:=s41
 end
   else begin
 savedialog1.filter:=s42;
 savedialog1.filename:=changefileext(currentfile,'.tcp');
 end;
 if savedialog1.execute then
 begin;
 currentfile:=changefileext(savedialog1.filename,'.tcs');
 currentfile_ps:=changefileext(currentfile,'.tcp');
 currentfile_tec:=changefileext(currentfile,'.tec');
  Exportieren1click(sender);
    savedialog1.InitialDir:=extractfilepath(currentfile);
 //  end;
 end;
end;

procedure TForm1.Exportieren1Click(Sender: TObject);
var currentfile1: TFileName;
 begin
 if currentfile='' then Exportierenunter1click(sender) else
 begin
 if etyp=tcpps then currentfile1:=changefileext(currentfile,'.tcp')
   else  currentfile1:=changefileext(currentfile,'.tec');
  if fileexists(currentfile1) then
     (if messagedlg(currentfile1+s43,mtwarning,
       [mbyes, mbno],0)=mrno then
       begin
        Exportierenunter1click(sender);
        exit;
        end);
    form1.caption:='TeXcad32 - '+currentfile;
  currentfile_ps:= changefileext(currentfile,'.tcp');
  currentfile_tec:= changefileext(currentfile,'.tec');
  texcadschreiben;
 end;
end;

procedure TForm1.texcadschreiben;
var i,grupp,i1,dicke:integer;
    x_max,y_max:double;
    farbe1:tcolor;

begin
 farbe1:=clblack;
 x_max:=0; y_max:=0;
 mm2p:=72/25.4*strtofloat(einstellunit.Einstellungen.Unitlength.text);
 for i:=1 to zeichzahl do
    with zeichnung[i]^ do
   begin
    if (typ=lin) or (typ=pf) then x_max:=maxr(x_max,maxr(lx1,lx2));
    if (typ=lin) or (typ=pf)  then y_max:=maxr(y_max,maxr(ly1,ly2));
    if typ=circ then x_max:=maxr(x_max,cx+r);
    if typ=circ then y_max:=maxr(y_max,cy+r);
    if typ=txt  then x_max:=maxr(x_max,tx);
    if typ=txt  then y_max:=maxr(y_max,ty);
   end;

   i1:=0;
   for i:=1 to zeichzahl do if not zeichnung[i]^.deleted then inc(i1);
   if i1=0 then
   begin
    messagedlg(s44,mtinformation,[mbok],0);
    exit;
   end;

 if etyp=tec then begin
   assignfile(tc_file,currentfile_tec);
   rewrite(tc_file);
   writeln(tc_file,'%%TeXCad32 V. '+version);
   writeln(tc_file,'\def\dick{'+einstellungen.tex_dick.text+'pt}');
   writeln(tc_file,'\def\normal{'+einstellungen.tex_normal.text+'pt}');
   writeln(tc_file,'\def\duenn{'+einstellungen.tex_duenn.text+'pt}');
   writeln(tc_file,'\unitlength '+einstellunit.einstellungen.unitlength.text+'mm');
   writeln(tc_file,'\def\emline#1#2#3#4#5#6{%');
   writeln(tc_file,'\put(#1,#2){\special{em:moveto}}%');
   writeln(tc_file,'\put(#4,#5){\special{em:lineto}}}');
   dicke:=-2;
   writeln(tc_file,format('\begin{picture}(%5.2f,%5.2f)',[x_max,y_max]));
   for grupp:=0 to 10 do
   for i:=1 to zeichzahl do
    if zeichnung[i]^.gruppe=Grupp then
     with zeichnung[i]^ do
      if not deleted then
      begin
       if zeichnung[i]^.farbe <>farbe1 then begin
        farbe1:=farbe;
        writeln(tc_file,Tcolor2rgbtec(farbe));
       end;
       case typ of
         lin, pf:  if ldicke > -1 then begin
                 if ldicke<> dicke then begin
                  dicke:=ldicke;
                  writeln(tc_file,'\special{em:linewidth '+dicken[dicke]+'}');
                 end;
                 writeln(tc_file,format('\emline{%5.2f}{%5.2f}{1}{%5.2f}{%5.2f}{2}',
                                         [lx1,ly1,lx2,ly2]));
               end;
        circ:  begin
                 if cdicke<> dicke then begin
                  dicke:=cdicke;
                  writeln(tc_file,'\special{em:linewidth '+dicken[dicke]+'}');
                 end;
                 if filled then
                   writeln(tc_file,format('\put(%5.2f,%5.2f){\circle*{%5.2f}}',
                                          [cx,cy,r]))
                 else
                   writeln(tc_file,format('\put(%5.2f,%5.2f){\circle{%5.2f}}',
                                           [cx,cy,r]));
               end;
          txt: begin
          writeln(tc_file,format('\put(%5.2f,%5.2f){\makebox(0,0)[',
                                [tx,ty])+tadjust+']{'+tinhalt+'}}');
                end;
       end; //case
      end;
   writeln(tc_file,'\end{picture}');
   closefile(tc_file);
 end
  else
 begin
   assignfile(ps_file,changefileext(currentfile_ps,'.ps'));
   rewrite(ps_file);
   writeln(ps_file,'%!PS-Adobe-2.0');
   writeln(ps_file,'%%Creator: TeXCad32 V.'+version);
   writeln(ps_file,'/dick {'+einstellungen.tex_dick.text+' setlinewidth} def');
   writeln(ps_file,'/normal {'+einstellungen.tex_normal.text+' setlinewidth} def');
   writeln(ps_file,'/duenn {'+einstellungen.tex_duenn.text+' setlinewidth} def');
   writeln(ps_file,'normal');


   assignfile(tcp_file,currentfile_ps);
   rewrite(tcp_file);writeln(tcp_file,'%%TeXCad32 V. '+version);
   writeln(tcp_file,'\unitlength '+einstellunit.einstellungen.unitlength.text+'mm');

   dicke:=-2;
   writeln(tcp_file,format('\begin{picture}(%5.2f,%5.2f)',[x_max,y_max]));
   writeln(tcp_file,'\ifpdf');
   writeln(tcp_file,'\put(0,0){\includegraphics{'
        +changefileext(extractfilename(currentfile),'.pdf')+'}}');
   writeln(tcp_file,'\else');
   writeln(tcp_file,'\put(0,0){\special{psfile='
      +changefileext(extractfilename(currentfile),'.ps')+'}}');
   writeln(tcp_file,'\fi');

   for grupp:=0 to 10 do
   for i:=1 to zeichzahl do
    if zeichnung[i]^.gruppe=Grupp then
     with zeichnung[i]^ do
      if not deleted then
        begin
        if zeichnung[i]^.farbe <>farbe1 then begin
        farbe1:=farbe;
        writeln(ps_file,Tcolor2rgbps(farbe));
       end;

       case typ of
         lin:  begin
                 if ldicke<> dicke then begin
                  dicke:=ldicke;
                  writeln(ps_file,dicken_ps[dicke]);
                 end;
                 writeln(ps_file,format('%5.2f %5.2f moveto',[mm2p*lx1,mm2p*ly1]));
                 writeln(ps_file,format('%5.2f %5.2f lineto',[mm2p*lx2,mm2p*ly2]));
                 writeln(ps_file,'stroke');
               end;
          pf:  if (i<zeichzahl) then if zeichnung[i+1]^.typ=pf then begin
                 writeln(ps_file,format('%5.2f %5.2f moveto',[mm2p*lx1,mm2p*ly1]));
                 writeln(ps_file,format('%5.2f %5.2f lineto',[mm2p*lx2,mm2p*ly2]));
                 writeln(ps_file,format('%5.2f %5.2f lineto',
                    [mm2p*zeichnung[i+1]^.lx1,mm2p*zeichnung[i+1]^.ly1]));
                 writeln(ps_file,'closepath');
                 writeln(ps_file,'fill');
               end;
        circ:  begin
                 if cdicke<> dicke then begin
                  dicke:=cdicke;
                  writeln(ps_file,dicken_ps[dicke]);
                 end;
                 if filled then
                   begin
                   writeln(ps_file,format('%5.2f %5.2f %5.2f 0 360 arc',
                                           [mm2p*cx,mm2p*cy,mm2p*r/2]));
                   writeln(ps_file,'fill');
                   end
                    else begin
                   writeln(ps_file,format('%5.2f %5.2f %5.2f 0 360 arc',
                                           [mm2p*cx,mm2p*cy,mm2p*r/2]));
                   writeln(ps_file,'stroke');
                   end
               end;
          txt: begin
          writeln(tcp_file,format('\put(%5.2f,%5.2f){\makebox(0,0)[',
                                [tx,ty])+tadjust+']{'+tinhalt+'}}');
                end;
       end; //case
     end;
   writeln(tcp_file,'\end{picture}');
   closefile(tcp_file);
   closefile(ps_file);
 end;
 setmodus(nichts);
 end;

procedure TForm1.Macroschreiben;
begin
end;



procedure TForm1.Speichern1Click(Sender: TObject);
begin
 if currentfile='' then Speichernunter1click(sender) else
 begin
   sourceschreiben;
  dirty:=false;
 end;
end;

procedure TForm1.Speichernunter1Click(Sender: TObject);
begin
 ignorenextmove:=true;
 if savedialog1.initialdir ='' then
    savedialog1.initialdir:=extractfilepath(paramstr(0));
    savedialog1.filter:=s45;
 if savedialog1.execute then
 begin;
  currentfile:=savedialog1.filename;
  if fileexists(currentfile) then
   (if messagedlg(currentfile+s46,mtwarning,
       [mbyes, mbno],0)=mrno then
       begin
        Speichernunter1click(sender);
        exit;
        end);
    form1.caption:='TeXcad32 - '+currentfile;
    Speichern1click(sender);
    savedialog1.InitialDir:=extractfilepath(currentfile);
 end;
end;

procedure TForm1.TecexpalsClick(Sender: TObject);
begin
etyp:=tec;
exportierenunter1click(nil);
end;

procedure TForm1.Tecexp1Click(Sender: TObject);
begin
etyp:=tec;
exportieren1click(nil);
end;

procedure TForm1.TcpPsExport1Click(Sender: TObject);
begin
etyp:=tcpps;
exportieren1click(nil);
end;

procedure TForm1.TcpPsExportals1Click(Sender: TObject);
begin
etyp:=tcpps;
exportierenunter1click(nil);
end;


procedure TForm1.Open1Click(Sender: TObject);
var i: integer;

begin
   if dirty then if messagedlg(s39,mtwarning,[mbyes,mbno],0)=mrno
     then exit;
    opendialog1.Filter:=s45;
    if opendialog1.Execute then
 begin
   opendialog1.InitialDir:=extractfilepath(opendialog1.Filename);
   savedialog1.InitialDir:=opendialog1.InitialDir;
   if zeichzahl>0 then for i:=1 to zeichzahl
      do begin
      dispose(zeichnung[i]);
      zeichnung[i]:=nil;
      end;
    zeichzahl:=0;
    cursor_loeschen;
    currentfile:=changefileext(extractfilename(opendialog1.filename),'.tcs');
    form1.caption:='TeXcad32 '+extractfilename(opendialog1.FileName);
    sourcelesen;
    dirty:=false;
  //  speichern1.Enabled:=true;
    zeichneneu(open1);
 end;
  ignorenextmove:=true;
  setmodus(nichts);
end;

procedure TForm1.sourceschreiben;

var i,j,laenge:integer;
    s_file: file;
    ch:char;

procedure schreib(s:string);
 var i:integer;
begin
 i:=length(s);
 blockwrite(s_file,i,sizeof(i));
 if i>0 then for i:=1 to length(s) do blockwrite(s_file,s[i],1);
end;

begin
   aufraeumen;
   if zeichzahl=0 then
   begin
    messagedlg(s44,mtinformation,[mbok],0);
     exit;
   end;

   assignfile(s_file,changefileext(currentfile,'.tcs'));
   rewrite(s_file,1);
   schreib('TEXCAD42  ');

   with einst do begin
   linieunsichtbar:=einstellungen.updownunsichtbar.position;
   linieduenn:=einstellungen.Updownduenn.position;
   linienormal:=einstellungen.Updownstandard.position;;
   liniedick:=einstellungen.Updowndick.position;
   {duenn, normal oder dick, index fr Liniendicke}
   unitlength:=einstellungen.Unitlength.text;
   tex_unsichtbar:=einstellungen.edit2.text;
   tex_duenn:=einstellungen.TeX_duenn.text;
   tex_normal:=einstellungen.tex_normal.text;
   tex_dick:=einstellungen.tex_dick.text;
   //Clipform
   clipaktiv:=clipform.Clipaktiv.checked;
   cl:=clip.cl;
   cr:=clip.cr;
   co:=clip.co;
   cu:=clip.cu;
   //Kurvenform
   //massstabedit:=Kurvenunit.Kurvenform.massstabedit.Text;
   x_off:=Kurvenunit.Kurvenform.x_off.Text;
   y_off:=Kurvenunit.Kurvenform.y_off.Text;
   end;
   blockwrite(s_file,einst,sizeof(einst));
   blockwrite(s_file,zeichzahl,sizeof(zeichzahl));
   for i:=1 to zeichzahl do with zeichnung[i]^ do begin
     blockwrite(s_file, typ,sizeof(typ));
     blockwrite(s_file, picked, sizeof(picked));
     blockwrite(s_file, posspicked, sizeof(posspicked));
     blockwrite(s_file, deleted, sizeof(deleted));
     blockwrite(s_file, farbe, sizeof(farbe));
     blockwrite(s_file, Gruppe, sizeof(Gruppe));
      case typ of
        lin,pf:  begin
          blockwrite(s_file,lx1,sizeof(lx1));
          blockwrite(s_file,ly1,sizeof(ly1));
          blockwrite(s_file,lx2,sizeof(lx2));
          blockwrite(s_file,ly2,sizeof(ly2));
          blockwrite(s_file,ldicke,sizeof(ldicke));
        end;
        txt: begin
          blockwrite(s_file,tx,sizeof(tx));
          blockwrite(s_file,ty,sizeof(ty));
          blockwrite(s_file,tadjust[1],1);
          blockwrite(s_file,tadjust[2],1);
          laenge:=length(tinhalt);
          blockwrite(s_file,laenge,sizeof(laenge));
          for j:=1 to laenge do begin
           ch:=tinhalt[j];
           blockwrite(s_file,ch,1);
          end;
        end;
        circ: begin
          blockwrite(s_file,cx,sizeof(cx));
          blockwrite(s_file,cy,sizeof(cy));
          blockwrite(s_file,r,sizeof(r));
          blockwrite(s_file,cdicke,sizeof(cdicke));
          blockwrite(s_file,filled,sizeof(filled));
          end;
   end;  {case}
  end;  {with begin}


   closefile(s_file);
end;

Procedure TForm1.sourcelesen;

var s_file: file;
    t:string;

function lies: string;
var s: char;
    i,l:integer;
    t:string;

begin
  blockread(s_file,l,sizeof(l));
  t:='';
  for i:=1 to l do begin
  blockread(s_file,s,1);
  t:=t+s;
  lies:=t;
  end;
end;

procedure einstlesen;
begin
   blockread(s_file,einst,sizeof(einst));
   blockread(s_file,zeichzahl,sizeof(zeichzahl));
  with einst do begin
   einstellungen.updownunsichtbar.position:=linieunsichtbar;
   einstellungen.Updownduenn.position:=linieduenn;
   einstellungen.Updownstandard.position:=linienormal;
   einstellungen.Updowndick.position:=liniedick;
   {duenn, normal oder dick, index fr Liniendicke}
   einstellungen.Unitlength.text:=unitlength;
   einstellungen.edit2.text:=tex_unsichtbar;
   einstellungen.TeX_duenn.text:=tex_duenn;
   einstellungen.tex_normal.text:=tex_normal;
   einstellungen.tex_dick.text:=tex_dick;
   //Clipform
   clipform.Clipaktiv.checked:=clipaktiv;
   clip.cl:=cl;
   clip.cr:=cr;
   clip.co:=co;
   clip.cu:=cu;
   //Kurvenform
   //Kurvenunit.Kurvenform.massstabedit.Text:=massstabedit;
   Kurvenunit.Kurvenform.x_off.Text:=x_off;
   Kurvenunit.Kurvenform.y_off.Text:=y_off;
   end;
end;

procedure _40lesen;
var i:integer;
begin
   einstlesen;
   for i:=1 to zeichzahl do begin
    new(P);
    zeichnung[i]:=P;
   blockread(s_file,p^,elementgross);
   end;
end; //_40lesen


procedure _42lesen;
var i,j:integer;
    laenge: integer;
    ch:char;

begin
 einstlesen;
 for i:=1 to zeichzahl do begin
  new(P);
  zeichnung[i]:=P;
  with p^ do begin
  blockread(s_file, typ,sizeof(typ));
  blockread(s_file, picked, sizeof(picked));
  blockread(s_file, posspicked, sizeof(posspicked));
  blockread(s_file, deleted, sizeof(deleted));
  blockread(s_file, farbe, sizeof(farbe));
  blockread(s_file, Gruppe, sizeof(Gruppe));
   case typ of
     lin,pf:  begin
       blockread(s_file,lx1,sizeof(lx1));
       blockread(s_file,ly1,sizeof(ly1));
       blockread(s_file,lx2,sizeof(lx2));
       blockread(s_file,ly2,sizeof(ly2));
       blockread(s_file,ldicke,sizeof(ldicke));
     end;
     txt: begin
       blockread(s_file,tx,sizeof(tx));
       blockread(s_file,ty,sizeof(ty));
       tadjust:='cc';
       blockread(s_file,tadjust[1],1);
       blockread(s_file,tadjust[2],1);
       blockread(s_file,laenge,sizeof(laenge));
       tinhalt:='';
       for j:=1 to laenge do begin
        blockread(s_file,ch,1);
        tinhalt:=tinhalt+ch;
       end;
     end;
     circ: begin
       blockread(s_file,cx,sizeof(cx));
       blockread(s_file,cy,sizeof(cy));
       blockread(s_file,r,sizeof(r));
       blockread(s_file,cdicke,sizeof(cdicke));
       blockread(s_file,filled,sizeof(filled));
       end;
   end;

  end;
 end;
end;

begin
   assignfile(s_file,changefileext(currentfile,'.tcs'));
   reset(s_file,1);
   t:=lies;
   if t='TEXCAD42  ' then _42lesen else(
   if t='TEXCAD40  ' then _40lesen else
     begin
    messagedlg(s47,mtinformation,[mbok],0);
    savedialog1.filename:='';
    currentfile:='';
    form1.Caption:='TeXCad32';
    exit;
   end);

   closefile(s_file);
   dirty:=false;
   zeichneneu(nil);
end;





procedure Tform1.setzefarbe(f:tcolor);
begin
 einst.aktcol:=f;
 zf.canvas.Pen.Color:=f;
 zf.canvas.brush.color:=f;
end;


procedure TForm1.Label1Click(Sender: TObject);
begin
 if colordialog1.execute then
 begin
  label1.Color:=colordialog1.Color;
  einst.aktcol:=colordialog1.Color;
  pickzaehlen;
  if pickzahl>0 then
    if messagedlg(s48,
         mtconfirmation,[mbyes, mbno],0)=mryes then form1.farbeaendern;
 end;
 zf.canvas.Pen.Color:=colordialog1.Color;
 zf.canvas.Brush.Color:=colordialog1.Color;
end;

procedure TForm1.LinienbreiteChange(Sender: TObject);
begin
 breite_aendern
end;



///////////////////////////////////////////////////////
//                                                   //
//      Kurvenzeichnen                               //
//                                                   //
///////////////////////////////////////////////////////


procedure tform1.formelfehler(s:string;q,para:double);
begin
messagedlg( Format(s62,
[round(q),para]),mterror,[mbok],0);
//fehler_aufgetreten:=true;
end;

procedure TForm1.Auswertefehler(s:string);
begin
messagedlg(s63+s,mterror,[mbok],0);
//form1.kurveninfo.fehler_aufgetreten:=true;
end;

procedure Tform1.wert_zu_gross;
begin;
messagedlg(s64,mtinformation,[mbok],0);
zu_gross:=false;
end;


function TForm1.x(p:extended):extended;
 var x1:extended;
begin
   if _3d then
     (if not x_vorne then
       x1:=Berechne(FormelX,p,q)+y_faktor*cos_a*Berechne(FormelY,p,q)
       else
       x1:=Berechne(FormelY,p,q)-y_faktor*cos_a*Berechne(FormelX,p,q))
    else
      x1:=Berechne(FormelX,p,q);
   if abs(x1)>wertgrenze then begin
    zu_gross:=true;
    x:=0;
   end
    else
   x:=x1;
end;

function tform1.y(p:extended):extended;
var y1: extended;
begin
    if _3d then
     (if not x_vorne then
       y1:=Berechne(FormelZ,p,q)+y_faktor*sin_a*Berechne(FormelY,p,q)
       else
       y1:=Berechne(FormelZ,p,q)-y_faktor*sin_a*Berechne(FormelX,p,q))
    else
      y1:=Berechne(FormelY,p,q);
   if abs(y1)>wertgrenze then begin
     zu_gross:=true;
     y:=0;
    end
   else y:=y1;
      //   if fnr=13 then begin formelfehler;  exit end;
end;

function tform1.z(p:extended):extended;
begin
   z:=Berechne(FormelZ,p,q);
end;



procedure TForm1.prolog(var kurveninfo:kurveninfotyp);
  //bertrgt die Parameter
var Dummy: extended;

begin
 zu_gross:=false;
 q:=kurveninfo.n_aktuell;
 Voneingabe:=kurveninfo.von_text;
 Biseingabe:=kurveninfo.bis_text;
 //massstab:=kurveninfo.massstab;
 XEingabe:=kurveninfo.x_text;
 YEingabe:=kurveninfo.y_text;
 ZEingabe:=kurveninfo.z_text;
 _3d:=kurveninfo._3d;
 x_vorne:=kurveninfo.x_vorne;
 z_strichlaenge:=kurveninfo.strichlaenge;
 z_zielwinkel:=kurveninfo.zielwinkel;
 z_delta_p:=kurveninfo.delta_p;
 wertgrenze:=kurveninfo.wertgrenze;

 kurveninfo.fehler_aufgetreten:=false;

 FormelV:=Baueformel(VonEingabe,Fpos,Fnr);
 paramstart:=berechne(FormelV,dummy,q);
 FormelB:=Baueformel(Biseingabe,Fpos,Fnr);
 paramend:=berechne(FormelB,dummy,q);
 Fnr:=0;

 FormelX:=Baueformel(XEingabe,Fpos,Fnr);
  IF Fnr>0 then begin Auswertefehler(s65);
  kurveninfo.Fehler_aufgetreten:=true; exit; end;
 FormelY:=Baueformel(YEingabe,Fpos,Fnr);
  IF Fnr>0 then begin Auswertefehler(s54);
  kurveninfo.Fehler_aufgetreten:=true; exit; end;
 if _3d then begin
  FormelZ:=Baueformel(ZEingabe,Fpos,Fnr);
  IF Fnr>0 then begin Auswertefehler(s55);
  kurveninfo.Fehler_aufgetreten:=true;exit; end;
 end;

 LK:= (kurveninfo.typ=0);
 RK:= (kurveninfo.typ=1);
 KK:= (kurveninfo.typ=2);

 if rk then
 begin  //anfangsrichtung erzeugen
   r_alt_x:=x(paramstart+startschritt)-x(paramstart);
   r_alt_y:=y(paramstart+startschritt)-y(paramstart);
 end;
end;  {prolog}


procedure tform1.zeichne_kurve;

var fertig,schrittok,phaseok, erstes:boolean;
    disthilf,distalt,schritthilf,
    xplotalt,xplotneu,yplotalt,yplotneu,
    xalt,yalt,xneu,yneu,
    schritt,schrittalt,para,paraneu:extended;
    schrittzaehler:integer;
    P: ptr_obj_type;


function dist(delta:double):extended;  {berechnet den Abstand zum letzten Punkt}
begin
   paraneu:=para+delta;
   xneu:=x(paraneu);
   yneu:=y(paraneu);
   dist:=massstab*sqrt((xneu-xalt)*(xneu-xalt)+(yneu-yalt)*(yneu-yalt));
end;  {dist}

function winkel(a1,a2,b1,b2:extended): extended;  //Winkel
var temp: Extended;
begin
 temp:=(a1*b1+a2*b2)/sqrt((a1*a1+a2*a2)*(b1*b1+b2*b2));
 if abs(temp)>0.999 then temp:=0.999;  // Gegen berlauf
 winkel:=arccos(temp);
end;

function winkel1(d:extended):extended;   //(winkeldifferenz)
begin
 winkel1:=winkel(r_alt_x,r_alt_y,x(para+d+startschritt)-x(para+d),
                                 y(para+d+startschritt)-y(para+d));
end;

begin {zeichne}

   schritt:=0.1;
   para:=paramstart;
   schrittalt:=0.0;   //nur fr LK und KK

   xalt:=x(para);
   if fnr=13 then begin formelfehler(s56,q,para);  exit end;
   yalt:=y(para);
   if fnr=13 then begin formelfehler(s57,q,para);  exit end;
   xplotalt:=xalt*massstab;
   yplotalt:=yalt*massstab;
   fertig:=false;
   erstes:=true;

   repeat
      schrittzaehler:=0;
      if para+schritt>paramend-0.001 then begin
         schritt:=paramend-para-0.00001;
      end
    else begin
      if LK then
        while  (not zu_gross)
            and(abs(dist(schritt)-z_strichlaenge) > 0.1*z_strichlaenge) do begin
           if schrittalt>paramend-para  then schrittalt:=paramend-para-0.001;
           schritthilf:=schritt;
           disthilf:=dist(schritthilf);
           distalt:=dist(schrittalt);
           schritt:=schrittalt+
              (z_strichlaenge-distalt)/(disthilf-distalt)*(schritthilf-schrittalt);
           schrittzaehler:=schrittzaehler+1;
           if schrittzaehler>50 then begin
              Formelfehler(s58,q,para);
              exit;
           end;
           schrittalt:=schritthilf;
        end;

       if KK then schritt:=delta_p;

       if RK then
       begin
        schritt:=startschritt;
        repeat
          schritt:=schritt*schrittfaktor;
          schrittzaehler:=schrittzaehler+1;
          if schrittzaehler>50 then begin
               Formelfehler(s58,q,para);
              exit;
          end;
protform.protokoll.Items.Add(
     Format('%9.6f, %9.6f  ',[para,schritt]));

        until (abs(winkel1(schritt))>z_zielwinkel) or (para+schritt>paramend)
          or zu_gross;
       end;
      end;

      para:=para+schritt;
      if para>paramend-0.001 then begin
         para:=paramend;
         fertig:=true;
      end;
      if zu_gross then begin
       wert_zu_gross;
       fertig:=true;
       exit;
      end;
      xneu:=x(para);
   if fnr=13 then begin formelfehler(s56,q,para);  exit end;
      yneu:=y(para);
   if fnr=13 then begin formelfehler(s57,q,para);  exit end;
      xplotneu:=xneu*massstab;
      yplotneu:=yneu*massstab;


      inc(neue_linien_zahl);
      neue_linien[neue_linien_zahl].x1:=xplotalt+x_offset;
      neue_linien[neue_linien_zahl].x2:=xplotneu+x_offset;
      neue_linien[neue_linien_zahl].y1:=yplotalt+y_offset;
      neue_linien[neue_linien_zahl].y2:=yplotneu+y_offset;

      r_alt_x:=xneu-xalt;
      r_alt_y:=yneu-yalt;
      xalt:=xneu;
      yalt:=yneu;
      xplotalt:=xplotneu;
      yplotalt:=yplotneu;

      if para>paramend-0.001 then fertig:=true;
   until fertig;

end; {zeichne}



procedure TForm1.KontrolleChange(Sender: TObject);
begin
   case kontrolle.ItemIndex of
   0: begin
       strichlangedit.visible:=true;
       winkeldiffedit.visible:=false;
       deltaedit.visible:=false;
      end;
   1: begin
       strichlangedit.visible:=false;
       winkeldiffedit.visible:=true;
       deltaedit.visible:=false;
      end;
   2: begin
       strichlangedit.visible:=false;
       winkeldiffedit.visible:=false;
       deltaedit.visible:=true;;
      end;
   end; //case
end;

procedure TForm1.DeltaeditChange(Sender: TObject);
var h:double;
begin
if lies_real(deltaedit,h) then delta_p:= h;
end;

procedure TForm1.StrichlangeditChange(Sender: TObject);
var h:double;
begin
if lies_real(strichlangedit,h) then strichlaenge:= h;
end;


procedure TForm1.WinkeldiffeditChange(Sender: TObject);
var winkel_grad:double;
begin
if lies_real(winkeldiffedit,winkel_grad)
   then zielwinkel:=1/360*(2*Pi)*Winkel_grad;
end;


procedure Tform1.neue_linien_uebernehmen(p1,p2,p3,p4:integer);
var i:integer;

function clip_ok:boolean;

begin
 clip_ok:=true;
 if not clipform.clipaktiv.checked then exit;

with neue_linien[i] do begin

 if not((y1<clip.co) and (y2<clip.co)) then
 if (y1>=clip.co) and (y2>=clip.co) then
   clip_ok:=false
   else (if y1>=clip.co then begin
    x1:=x1+(x2-x1)*(clip.co-y1)/(y2-y1);
    y1:=clip.co;
   end else begin
    x2:=x1+(x2-x1)*(clip.co-y1)/(y2-y1);
    y2:=clip.co;
   end);

 if not((y1>clip.cu) and (y2>clip.cu)) then
 if (y1<=clip.cu) and (y2<=clip.cu) then
   clip_ok:=false
   else (if y1<=clip.cu then begin
    x1:=x1+(x2-x1)*(clip.cu-y1)/(y2-y1);
    y1:=clip.cu;
   end else begin
    x2:=x1+(x2-x1)*(clip.cu-y1)/(y2-y1);
    y2:=clip.cu;
   end);

 if not((x1<clip.cr) and (x2<clip.cr)) then
 if (x1>=clip.cr) and (x2>=clip.cr) then
   clip_ok:=false
   else (if x1>=clip.cr then begin
    y1:=y1+(y2-y1)*(clip.cr-x1)/(x2-x1);
    x1:=clip.cr;
   end else begin
    y2:=y1+(y2-y1)*(clip.cr-x1)/(x2-x1);
    x2:=clip.cr;
   end);

 if not((x1>clip.cl) and (x2>clip.cl)) then
 if (x1<=clip.cl) and (x2<=clip.cl) then
   clip_ok:=false
   else (if x1<=clip.cl then begin
    y1:=y1+(y2-y1)*(clip.cl-x1)/(x2-x1);
    x1:=clip.cl;
   end else begin
    y2:=y1+(y2-y1)*(clip.cl-x1)/(x2-x1);
    x2:=clip.cl;
   end);
 end //with
end;


begin
   phasemax[1]:=p1;
   phasemax[2]:=p2;
   phasemax[3]:=p3;
   phasemax[4]:=p4;

  if neue_linien_zahl>0 then
    for i:=1 to neue_linien_zahl do begin


if clip_ok  then begin
          inc(zeichzahl);
          inc(pickzahl);
          new(P);
          zeichnung[zeichzahl]:=P;
          p^.gruppe:=3;
          p^.typ:=lin;
          p^.farbe:=einst.aktcol;
          p^.lx1:=neue_linien[i].x1;
          p^.ly1:=neue_linien[i].y1;
          p^.lx2:=neue_linien[i].x2;
          p^.ly2:=neue_linien[i].y2;
          p^.ldicke:=breite;
          p^.picked:=true;
          p^.posspicked:=false;
          p^.deleted:=false;

     phaseok:=false;    {Phasenzaehler erhhen}
      repeat
         if phasenzaehler < phasemax[phase] then begin
            phasenzaehler:=phasenzaehler+1;
            phaseok:=true
         end else begin
            phasenzaehler:=0;
            if phase=4 then phase:=1 else phase:=phase+1;
         end;
      until phaseok;

      if not ((phase=1) or (phase=3))
        then  p^.ldicke:=-1;
         zeichne(form1.zeichzahl);
    end;
 end;
    if (phasemax[2]+phasemax[4]>0) or clipform.clipaktiv.checked
    then begin
    cursor_loeschen;
    zeichneneu(nil);
    end;
end;


procedure TForm1.StatusBar1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 if x>360 then clipform.showmodal;
end;

procedure TForm1.ZeigeClip;
begin
with clipform do
if clipaktiv.Checked then
 statusbar1.panels[3].text:=
 Format(s59,[cu,co,cl,cr])
  else
 statusbar1.panels[3].text:=s60;
end;

procedure TForm1.KurvenwahlClick(Sender: TObject);
 var i:integer;
begin
 setmodus(randwahl);
 pickzaehlen;
 if Pickzahl>0 then
   if messagedlg(format(s61,[pickzahl]),
                      mtconfirmation,[mbyes, mbno],0)=mrno
                      then setmodus(nichts)
   else  begin
   for i:=1 to zeichzahl do zeichnung[i]^.picked:=false;
   zeichneneu(nil);
   zeichnung[1]^:=zeichnung[2]^;
   end;
end;



///////////////////////////////////////////////////////
//                                                   //
//      macros                                       //
//                                                   //
///////////////////////////////////////////////////////




procedure TForm1.macrospeichern1Click(Sender: TObject);
var mf:TFileName;
begin
 pickzaehlen;
 if pickzahl=0 then begin
   showmessage('Nicht markiert'); exit; end;
   if not macrosave.Execute then exit;
   if extractfileext(macrosave.filename)='' then
      macrosave.filename:=
           changefileext(macrosave.filename,'.tcm');
   if FileExists(macrosave.filename) then if
     messagedlg(macrosave.filename+s43,mtconfirmation,[mbyes,mbno],0)=mrno then exit;
//   showmessage('Klicken fr Bezugspunkt');
   setmodus(macro_click);
end;

procedure TForm1.MacroClick(Sender: TObject);
var i,j,laenge:integer;
    m_file: file;
    d:double;

procedure schreib(s:string);
 var i:integer;
begin
 i:=length(s);
 blockwrite(m_file,i,sizeof(i));
 if i>0 then for i:=1 to length(s) do blockwrite(m_file,s[i],1);
end;

begin
 assignfile(m_file,macrosave.filename);
 rewrite(m_file,1);
 blockwrite(m_file,pickzahl,sizeof(pickzahl));
 d:=screentoworldx(sx(cp.x));
 blockwrite(m_file,d,sizeof(d));
 d:=screentoworldy(sy(cp.y));
 blockwrite(m_file,d,sizeof(d));
    for i:=1 to zeichzahl do
    if zeichnung[i]^.picked and not zeichnung[i]^.deleted then
     with zeichnung[i]^ do begin
     blockwrite(m_file, typ,sizeof(typ));
     blockwrite(m_file, picked, sizeof(picked));
     blockwrite(m_file, posspicked, sizeof(posspicked));
     blockwrite(m_file, deleted, sizeof(deleted));
     blockwrite(m_file, farbe, sizeof(farbe));
     blockwrite(m_file, Gruppe, sizeof(Gruppe));
      case typ of
        lin,pf:  begin
          blockwrite(m_file,lx1,sizeof(lx1));
          blockwrite(m_file,ly1,sizeof(ly1));
          blockwrite(m_file,lx2,sizeof(lx2));
          blockwrite(m_file,ly2,sizeof(ly2));
          blockwrite(m_file,ldicke,sizeof(ldicke));
        end;
        txt: begin
          blockwrite(m_file,tx,sizeof(tx));
          blockwrite(m_file,ty,sizeof(ty));
          blockwrite(m_file,tadjust[1],1);
          blockwrite(m_file,tadjust[2],1);
          laenge:=length(tinhalt);
          blockwrite(m_file,laenge,sizeof(laenge));
          for j:=1 to laenge do begin
           ch:=tinhalt[j];
           blockwrite(m_file,ch,1);
          end;
        end;
        circ: begin
          blockwrite(m_file,cx,sizeof(cx));
          blockwrite(m_file,cy,sizeof(cy));
          blockwrite(m_file,r,sizeof(r));
          blockwrite(m_file,cdicke,sizeof(cdicke));
          blockwrite(m_file,filled,sizeof(filled));
          end;
   end;  {case}
  end;  {with begin}
closefile(m_file);
setmodus(nichts);
end;



procedure TForm1.macroladen1Click(Sender: TObject);
begin
  if not Macroopen.execute then exit;
  Macroopen.InitialDir:=extractfilepath(Macroopen.FileName);
  setmodus(macroeinfuegen);
end;


procedure TForm1.Macroeinfuegenclick(Sender: TObject);

var m_file: file;
    t:string;
    i,j, maczahl:integer;
    laenge: integer;
    dx,dy:double;
    ch:char;

function lies: string;
var s: char;
    i,l:integer;
    t:string;

begin
  blockread(m_file,l,sizeof(l));
  t:='';
  for i:=1 to l do begin
  blockread(m_file,s,1);
  t:=t+s;
  lies:=t;
  end;
end;

begin
   if extractfileext(macroopen.filename)='' then
   changefileext(macroopen.filename,'.tcm');

   assignfile(m_file,macroopen.filename);
   reset(m_file,1);
   blockread(m_file,maczahl,sizeof(maczahl));
   blockread(m_file,dx,sizeof(dx));
   dx:=screentoworldx(sx(cp.x))-dx;
   blockread(m_file,dy,sizeof(dy));
   dy:=screentoworldy(sy(cp.y))-dy;

 for i:=1 to maczahl do begin
  new(P);
  inc(zeichzahl);
  zeichnung[zeichzahl]:=P;
  with p^ do begin
  blockread(m_file, typ,sizeof(typ));
  blockread(m_file, picked, sizeof(picked));
  blockread(m_file, posspicked, sizeof(posspicked));
  blockread(m_file, deleted, sizeof(deleted));
  blockread(m_file, farbe, sizeof(farbe));
  blockread(m_file, Gruppe, sizeof(Gruppe));
   case typ of
     lin,pf:  begin
       blockread(m_file,lx1,sizeof(lx1));
       blockread(m_file,ly1,sizeof(ly1));
       blockread(m_file,lx2,sizeof(lx2));
       blockread(m_file,ly2,sizeof(ly2));
       blockread(m_file,ldicke,sizeof(ldicke));
       lx1:=lx1+dx; lx2:=lx2+dx;ly1:=ly1+dy;ly2:=ly2+dy;
     end;
     txt: begin
       blockread(m_file,tx,sizeof(tx));
       blockread(m_file,ty,sizeof(ty));

       tadjust:='cc';
       blockread(m_file,tadjust[1],1);
       blockread(m_file,tadjust[2],1);
       blockread(m_file,laenge,sizeof(laenge));
       tinhalt:='';
       for j:=1 to laenge do begin
        blockread(m_file,ch,1);
        tinhalt:=tinhalt+ch;
       end;
     end;
     circ: begin
       blockread(m_file,cx,sizeof(cx));
       blockread(m_file,cy,sizeof(cy));
       blockread(m_file,r,sizeof(r));
       blockread(m_file,cdicke,sizeof(cdicke));
       blockread(m_file,filled,sizeof(filled));
       cx:=cx+dx;cy:=cy+dy;
       end;
   end;

  end;
 end;
   closefile(m_file);
   zeichneneu(nil);
   setmodus(move_c);
end;

procedure TForm1.macroladen(Key:word);
 var info:TSearchrec;
     found: integer;
     tcm_file: TFileName;
begin
 tcm_file:=macroopen.initialdir+'\'+char(key)+'*.tcm';
 found:= findfirst(tcm_file,faReadOnly,info);
 if found<>0 then begin sysutils.beep; setmodus(nichts); exit; end;
 macroopen.filename:=macroopen.initialdir+'\'+info.Name;
 setmodus(Macroeinfuegen);
end;

procedure TForm1.Drehen1Click(Sender: TObject);
var x0,y0,cos_a,sin_a,x1,y1: double;
     i: integer;

begin
  if drehform.showmodal=mrcancel then exit;
  cos_a:=cos(drehform.winkel);
  sin_a:=sin(drehform.winkel);
  x0:=drehform.x_0;
  y0:=drehform.y_0;
  for i:=1 to zeichzahl do with zeichnung[i]^ do
    if picked then
    case  typ of
     lin,pf:  begin
           x1:=x0+(lx1-x0)*cos_a-(ly1-y0)*sin_a;
           y1:=y0+(lx1-x0)*sin_a+(ly1-y0)*cos_a;
           lx1:=x1;ly1:=y1;
           x1:=x0+(lx2-x0)*cos_a-(ly2-y0)*sin_a;
           y1:=y0+(lx2-x0)*sin_a+(ly2-y0)*cos_a;
           lx2:=x1;ly2:=y1;
           end;
      circ: begin
            x1:=x0+(cx-x0)*cos_a-(cy-y0)*sin_a;
            y1:=y0+(cx-x0)*sin_a+(cy-y0)*cos_a;
            cx:=x1;cy:=y1;
            end;
      txt:  begin
            x1:=x0+(tx-x0)*cos_a-(ty-y0)*sin_a;
            y1:=y0+(tx-x0)*sin_a+(ty-y0)*cos_a;
            tx:=x1;ty:=y1;
            end;
    end;
   cursor_loeschen;
   ignorenextmove:=true;
   zeichneneu(nil);
end;


end.
