#!/bin/sh
#TexPict  -*- TCL -*- Created: ramsan Aug-1998, Modified: ramsan Sep-1999
# 	$Id: TexPict.tcl,v 1.12 1999/09/27 16:10:16 ramsan Exp $	


# the next line restarts using wish \
	exec wish8.0 "$0" "$@"

############################################################################
##
##   TexPict. A program to create easy drawings to include into latex
##   documents.
##
##   This program has been developed by Ramon Rib    ( RAMSAN )
##   for any question or suggestion you can mail to:
##   ramsan@cimne.upc.es
##   http://gatxan.cimne.upc.es/texpict
##
##   This program can be used without any permission. If any change is made,
##   it should be clearly described inside the file.
##
############################################################################


set TexPriv(Version) 1.2

#
#  You can change your preferences in this function
#

proc SetPreferences {} {
    global TexPriv

    # =0 thinlines; =1 thicklines; =2 dashedlines
    set TexPriv(Thicklines) 0
    
    # = latex,eepic,any
    set TexPriv(LatexMode) eepic

    # =0 no snap; =1 snap
    set TexPriv(SnapToPoint) 1

    # to write in latex picture: pt = 1/72in ; in = inch; cm = centimeter
    set TexPriv(unitstype) cm

    # distance around point or line to snap it.
    set TexPriv(SnapDistance) 6

    # distance to select entities pressing over them.
    set TexPriv(CloseEnough) 6

    # Message to display in the bottom of the window.
    set TexPriv(message) "Press mouse rightbutton over buttons for help"

    # When creating a circle by radius, default value first time
    set TexPriv(CircleRadius) 2

    # Fonts used all around the code
    font create BigFont -family helvetica -size 16 -weight bold
    font create NormalFontGUI -family helvetica -size 10
    option add *font NormalFontGUI
    
    # to change these fonts size, use the variable below
    set TexPriv(NormalFontSize) 12
    font create NormalFont -family helvetica -size $TexPriv(NormalFontSize)
    font create ScriptFont -family helvetica -size \
	    [expr int(.8*$TexPriv(NormalFontSize))]
    font create SymbolFont -family symbol -size $TexPriv(NormalFontSize)
    
}

proc SetOptions {} {
    global tcl_platform

    option add *Entry*BorderWidth 1
    if { $tcl_platform(platform) != "windows" } {
	option add *Scrollbar*Width 10
	option add *Scrollbar*BorderWidth 2
    }
    option add *Menu*TearOff 0
  
    if { $tcl_platform(platform) != "windows" } {
	option add *background AntiqueWhite3
	option add *Button*background bisque3
	option add *Menubutton*background bisque3
	option add *Menu*background bisque3
	option add *Button*foreground black
	option add *Entry*background thistle
	option add *DisabledForeground grey60
	option add *HighlightBackground AntiqueWhite3
    }
}

if { $tcl_platform(platform)  == "unix" } {
    set tmpdir /tmp
} else { set tmpdir $env(TEMP) }

proc CreateBitmaps {} {
    global TexPriv tmpdir

set TexPriv(select) [image create bitmap -data {
#define select16x16_width 16
#define select16x16_height 16
static unsigned char select16x16_bits[] = {
   0x00, 0x00, 0xf0, 0x7f, 0x10, 0x40, 0xd0, 0x5f, 0x10, 0x58, 0x10, 0x54,
   0x10, 0x52, 0x10, 0x51, 0x90, 0x50, 0x40, 0x50, 0x20, 0x50, 0x10, 0x40,
   0xc8, 0x7f, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(line) [image create bitmap -data {
#define line16x16_width 16
#define line16x16_height 16
static unsigned char line16x16_bits[] = {
   0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00,
   0x80, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10,
   0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(vector) [image create bitmap -data {
#define vector16x16_width 16
#define vector16x16_height 16
static unsigned char vector16x16_bits[] = {
   0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00,
   0x40, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x22, 0x00, 0x34, 0x00, 0x38,
   0x00, 0x3c, 0x00, 0x3e, 0x00, 0xc0, 0x00, 0xc0};
}]

set TexPriv(vectorinv) [image create bitmap -data {
#define vector16x16_width 16
#define vector16x16_height 16
static unsigned char vector16x16_bits[] = {
   0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x78, 0x00, 0x38, 0x00,
   0x58, 0x00, 0x88, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08,
   0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00};
}]

set TexPriv(text) [image create bitmap -data {
#define text16x16_width 16
#define text16x16_height 16
static unsigned char text16x16_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0x42, 0x08, 0x40, 0x00, 0x40, 0x00,
   0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0xf7,
   0x40, 0x49, 0x40, 0x4b, 0x40, 0x55, 0x40, 0x57};
}]

set TexPriv(textbox) [image create bitmap -data {
#define textbox16x16_width 16
#define textbox16x16_height 16
static unsigned char textbox16x16_bits[] = {
   0xff, 0xff, 0x01, 0x80, 0xfd, 0x81, 0x25, 0x81, 0x21, 0x80, 0x21, 0x80,
   0x21, 0x80, 0x21, 0x80, 0x21, 0x80, 0xa1, 0xfb, 0xa1, 0xa4, 0xa1, 0xa5,
   0xa1, 0xaa, 0xa1, 0xab, 0x01, 0x80, 0xff, 0xff};
}]

set TexPriv(circlem) [image create bitmap -data {
#define circle16x16_width 16
#define circle16x16_height 16
static unsigned char circle16x16_bits[] = {
   0x00, 0x20, 0x00, 0x60, 0xf0, 0xe1, 0x08, 0x62, 0x04, 0x24, 0x02, 0x08,
   0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x02, 0x08,
   0x04, 0x04, 0x08, 0x02, 0xf0, 0x01, 0x00, 0x00};
}]

set TexPriv(circle) [image create bitmap -data {
#define circle16x16_width 16
#define circle16x16_height 16
static unsigned char kk_bits[] = {
   0x00, 0x00, 0xc0, 0x07, 0x20, 0x08, 0x10, 0x10, 0x08, 0x20, 0x04, 0x40,
   0x04, 0x40, 0x04, 0x40, 0x04, 0x40, 0x04, 0x40, 0x08, 0x20, 0x10, 0x10,
   0x20, 0x08, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x00};
}]


set TexPriv(circlefm) [image create bitmap -data {
#define circle16x16_width 16
#define circle16x16_height 16
static unsigned char circle16x16_bits[] = {
   0x00, 0x20, 0x00, 0x60, 0xf0, 0xe1, 0xf8, 0x63, 0xfc, 0x27, 0xfe, 0x0f,
   0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xfe, 0x0f,
   0xfc, 0x07, 0xf8, 0x03, 0xf0, 0x01, 0x00, 0x00};
}]

set TexPriv(circlef) [image create bitmap -data {
#define circle16x16_width 16
#define circle16x16_height 16
static unsigned char kk_bits[] = {
   0x00, 0x00, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f,
   0xfc, 0x7f, 0xfc, 0x7f, 0xfc, 0x7f, 0xfc, 0x7f, 0xf8, 0x3f, 0xf0, 0x1f,
   0xe0, 0x0f, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x00};
}]


set TexPriv(boxm) [image create bitmap -data  {
#define box16x16_width 16
#define box16x16_height 16
static unsigned char box16x16_bits[] = {
   0x00, 0x20, 0x00, 0x60, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x20, 0x00, 0x00,
   0xfe, 0x1f, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10, 0x02, 0x10,
   0x02, 0x10, 0x02, 0x10, 0xfe, 0x1f, 0x00, 0x00};
}]

set TexPriv(box) [image create bitmap -data  {
#define box16x16_width 16
#define box16x16_height 16
static unsigned char kk_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0x04, 0x20, 0x04, 0x20,
   0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0x04, 0x20, 0xfc, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(filledboxm) [image create bitmap -data {
#define box16x16_width 16
#define box16x16_height 16
static unsigned char box16x16_bits[] = {
   0x00, 0x20, 0x00, 0x60, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x20, 0x00, 0x00,
   0xfe, 0x1f, 0xfe, 0x1f, 0xfe, 0x1f, 0xfe, 0x1f, 0xfe, 0x1f, 0xfe, 0x1f,
   0xfe, 0x1f, 0xfe, 0x1f, 0xfe, 0x1f, 0x00, 0x00};
}]

set TexPriv(filledbox) [image create bitmap -data {
#define box16x16_width 16
#define box16x16_height 16
static unsigned char kk_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f,
   0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(erase) [image create bitmap -data {
#define erase16x16_width 16
#define erase16x16_height 16
static unsigned char erase16x16_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x61, 0x80, 0x50, 0x40, 0x48,
   0x20, 0x44, 0x10, 0x22, 0x08, 0x11, 0x84, 0x08, 0x42, 0x04, 0x7e, 0x02,
   0x42, 0x01, 0xc2, 0x00, 0x7e, 0x00, 0x00, 0x00};
}]

set TexPriv(curve) [image create bitmap -data {
#define curve_width 16
#define curve_height 16
static unsigned char curve_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0xf0, 0x1c,
   0x10, 0x10, 0x08, 0x30, 0x0c, 0x60, 0x04, 0x40, 0x06, 0x80, 0x02, 0x80,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(thinline) [image create bitmap -data {
#define thinline_width 16
#define thinline_height 16
static unsigned char thickline_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x0b, 0xb0, 0x3a,
   0xa0, 0x0b, 0xa0, 0x08, 0xa0, 0x18, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(thickline) [image create bitmap -data {
#define thickline_width 16
#define thickline_height 16
static unsigned char thinline_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x0b, 0xa0, 0x3a,
   0x90, 0x0b, 0x88, 0x08, 0xbc, 0x18, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x7f,
   0xfe, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(dashedline) [image create bitmap -data {
#define dashedline_width 16
#define dashedline_height 16
static unsigned char dashedline_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

set TexPriv(latex) [image create bitmap -data {
    #define latex16x16_width 16
    #define latex16x16_height 16
    static unsigned char latex16x16_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0xa2, 0xbf, 0x52, 0x45, 0x52, 0x4d, 0x72, 0x45, 0x5e, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]
	
set TexPriv(eepic) [image create bitmap -data {
    #define eepic16x16_width 16
    #define eepic16x16_height 16
    static unsigned char eepic16x16_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xd7, 0x11, 0x55,
	0x33, 0x57, 0x11, 0x51, 0x77, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]
	
set TexPriv(any) [image create bitmap -data {
    #define any16x16_width 16
    #define any16x16_height 16
    static unsigned char any16x16_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
}]

# Very dirty trick to load a bitmap from a file
set TexPriv(dashed) [file join $tmpdir TexPictDashed[pid]]
set f [open $TexPriv(dashed) w]
puts $f {
#define dashed_width 12
#define dashed_height 1
static unsigned char dashed_bits[] = {
   0x3f, 0x00};
}
close $f
set TexPriv(dashed) "@$TexPriv(dashed)"
set TexPriv(dashedv) [file join $tmpdir TexPictDashedv[pid]]
set f [open $TexPriv(dashedv) w]
puts $f {
#define dashedv_width 1
#define dashedv_height 16
static unsigned char dashedv_bits[] = {
   0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};
}
close $f
set TexPriv(dashedv) "@$TexPriv(dashedv)"

}


proc WarnWin { text { par .}} {

    if { $par == "."} {
	set w .__WarnWin
    } else {
	set w $par.__WarnWin
    }
    tk_dialog  $w Warning $text warning 0 OK
}

proc WarnWinText { text } {

    set w .__warnwintext 
    if { ![winfo exists $w] } {
	toplevel $w
	wm title $w "WARNING"
	pack [text $w.t] -fill both -expand yes
	pack [button $w.close -text Close -command "destroy $w"]
    }
    $w.t insert end "$text\n"
    update
}



proc Quit {} {
    global tmpdir

    foreach i [glob -nocomplain [file join $tmpdir texpict[pid].*]] {
	catch {
	    file delete $i
	}
    }
    file delete [file join $tmpdir TexPictDashed[pid]]
    file delete [file join $tmpdir TexPictDashedv[pid]]
    destroy .
}

proc CreateElapsedMenu { m buts bitmaps names  } {
    global TexPriv

    set inum 0
 
    set b [lindex [lindex $bitmaps 0] 0]

    # trick: field text is used to store the command
    menubutton $buts.$b -image $TexPriv($b) -menu $buts.$b.m \
	    -direction right -relief raised
    menu $buts.$b.m -tearoff 0
    set inum 0
    foreach i $bitmaps {
	set menubitmap [lindex $i 0]
	set otherbitmap [lindex $i 1]
	if { $otherbitmap == "" } { set otherbitmap $menubitmap }

	if { ![catch { $m.create index [lindex $names $inum] }] } {
	    set comm [list $m.create invoke [lindex $names $inum] ]
	} else {
	    set comm [list $m.modify invoke [lindex $names $inum] ]
	}
	if { $inum == 0 } {
	    $buts.$b conf -text $comm
	}
	$buts.$b.m add command -image $TexPriv($otherbitmap) -command \
		"$comm ; $buts.$b conf -image $TexPriv($menubitmap) \
		-text [list $comm]" \
		-columnbreak 1  -hidemargin 1
	incr inum
    }

    set TexPriv(openingmenu) {}
    bind $buts.$b <1> {
	%W conf -relief sunken
	set TexPriv(openingmenu) [after 500 [list \
		if {$tkPriv(inMenubutton) != ""} {
	    %W conf -relief raised
	    set TexPriv(openingmenu) {}
	    tkMbPost $tkPriv(inMenubutton) %X %Y
	} ]]
	    break
    }
    bind $buts.$b <ButtonRelease-1> {
	if { $TexPriv(openingmenu) != {} } {
	    %W conf -relief raised
	    after cancel $TexPriv(openingmenu)
	    eval [%W cget -text]
	} else { tkMbButtonUp %W }
	set TexPriv(openingmenu) {}
    }
    bind $buts.$b <B1-Leave> {
	if { $TexPriv(openingmenu) != {} } {
	    %W conf -relief raised
	    after cancel $TexPriv(openingmenu)
	    set TexPriv(openingmenu) {}
	}
    }
    return $buts.$b
}

proc SetUpFunc {} {
    global TexPriv argv0

    SetOptions
    SetPreferences

    wm title . "Tex pictures"

    set x [expr int([winfo screenwidth .]/40)]
    set y [expr int([winfo screenheight .]/40)]
    set w [expr int([winfo screenwidth .]/2)]
    set h [expr int([winfo screenheight .]/1.8)]

    wm geom . ${w}x${h}-${x}+${y}
    set TexPriv(image) ""

    . conf -menu .mainmenu
    set m .mainmenu

    menu $m

    $m add cascade -menu $m.file -label Files -u 0
    menu $m.file -tearoff 0
    $m.file add command -label New -command "NewDraw .c" -acc "Ctrl-n" -u 0
    bind . <Control-n> "$m.file invoke New"
    $m.file add command -label ViewDVI \
	    -command "PreviewDVI .c" -acc "Ctrl-w" -u 0
    bind . <Control-w> "$m.file invoke ViewDVI"
    $m.file add command -label "Write postscript file" \
	    -command "PrintPostscript .c" -u 0
    $m.file add command -label "Add image" \
	    -command "AddImage .c" -u 0 -acc "Ctrl-a"
    bind . <Control-a> "$m.file invoke {Add image}"
    $m.file add command -label Quit \
	    -command Quit -acc "Ctrl-q" -u 0
    bind . <Control-q> "$m.file invoke Quit"
    wm protocol . WM_DELETE_WINDOW "$m.file invoke Quit"

    $m add cascade -menu $m.edit -label Edit -u 0
    menu $m.edit -tearoff 0
    $m.edit add command -label Cut \
	    -command "CopyToClipBoard .c cut" -acc "Ctrl-x" -u 0
    bind . <Control-x> "$m.edit invoke Cut"
    $m.edit add command -label Copy \
	    -command "CopyToClipBoard .c" -acc "Ctrl-c" -u 1
    bind . <Control-c> "$m.edit invoke Copy"
    $m.edit add command -label Paste \
	    -command "GetFromClipBoard .c" -acc "Ctrl-v" -u 0
    bind . <Control-v> "$m.edit invoke Paste"

    $m add cascade -menu $m.create -label Create -u 0
    menu $m.create -tearoff 0
    $m.create add command -label Line -command "CreateLine .c" -u 0
    $m.create add command -label Vector -command "CreateLine .c yes" -u 0
    $m.create add command -label "Vector inv" -command "CreateLine .c yesinv" -u 7
    $m.create add command -label "Bezier curve" -command "CreateBezier .c" -u 0
    $m.create add command -label Text -command "Createtext .c" -u 0
    $m.create add command -label "Text box" -command "CreateTextBox .c" -u 1
    $m.create add command -label Circle -command "CreateCircle .c" -u 0
    $m.create add command -label "Filled circle" \
	    -command "CreateCircle .c yes" -u 0
    $m.create add command -label "Circle radius" \
	    -command "EnterCircleRadius" -u 2
    $m.create add command -label "Filled circle radius" \
	    -command "EnterCircleRadius yes"
    $m.create add command -label Box -command "CreateBox .c" -u 1
    $m.create add command -label "Filled box" -command "CreateBox .c yes" -u 1

    $m add cascade -menu $m.modify -label Modify -u 0
    menu $m.modify -tearoff 0
    $m.modify add command -label Delete \
	    -command "DeleteItems .c" -acc Del -u 0
    bind . <Delete> "$m.modify invoke Delete"
    $m.modify add command -label Select \
	    -command "BeginSelect .c" -u 0

    $m.modify add command -label Zoom \
	    -command "EnterZoomFactor" -u 0 -acc F3
    bind . <F3> "$m.modify invoke Zoom"
    bind . <3> {
	SetZoom [expr [lindex $TexPriv(ZoomFactor) 1]/2.0] [cx %x] [cy %y]
    }
    bind . <Shift-3> {
	SetZoom [expr [lindex $TexPriv(ZoomFactor) 1]*2.0] [cx %x] [cy %y]
	break
    }

    $m.modify add command -label "Modify entity" \
	    -command "ModifyOneEntity" -u 0 -acc Ctrl-m
    bind . <Control-m> "$m.modify invoke {Modify entity}"

    $m add cascade -menu $m.options -label Options -u 0
    menu $m.options -tearoff 0

    $m.options add radio -label "Thin lines" -var TexPriv(Thicklines) -value 0 -u 0
    $m.options add radio -label "Thick lines" -var TexPriv(Thicklines) -value 1 -u 1
    $m.options add radio -label "Dashed lines" -var TexPriv(Thicklines) -value 2 -u 0

    trace var TexPriv(Thicklines) w "ChangingThickLinesVar ;#"

    $m.options add radio -label latex -var TexPriv(LatexMode) -value latex -u 0
    $m.options add radio -label eepic -var TexPriv(LatexMode) -value eepic -u 0
    $m.options add radio -label any -var TexPriv(LatexMode) -value any -u 0

    $m.options add check -label "Snap to point/line" -var TexPriv(SnapToPoint) \
	    -onvalue 1 -offvalue 0 -acc "Ctrl-t" -u 0
    bind . <Control-t> "$m.options invoke {Snap to point/line}"
    set TexPriv(SnapToPoint) 1

    trace var TexPriv(SnapToPoint) w "SearchClosePointsFinish ;#"

    $m add cascade -menu $m.help -label help -u 0
    menu $m.help -tearoff 0
    $m.help add command -label About -command DisplayAbout -u 0
    $m.help add command -label Help -command "DisplayHelp #initial" -u 0 \
	    -acc "Ctrl-h"
    bind . <Control-h> "$m.help invoke Help"
    $m.help add command -label "Write HTML Help" -command "PrintHTMLHelp" -u 0
    $m.help add command -label "Write Text Help" -command "PrintTextHelp" -u 1

    frame .buts -relief ridge -bd 2

    CreateBitmaps
    set bitmaps "select line vector vectorinv curve text textbox \
	    {{circlem circle} {circlefm circlef} } {{boxm box} \
	    {filledboxm filledbox}} erase"
    set names "Select Line Vector {Vector inv} {Bezier curve} Text {Text box} \
	    {Circle {Filled circle}} {Box {Filled box}} Delete"
    set help [list \
	    "When in selection mode, entities can be selected individually\n\
	    or with a box. Then, they can be moved or deleted.\n\
	    Key 'Shift' increases selection and also restricts angle.\n\
	    Key 'Ctrl' duplicate.\n\
	    Key 'Del' erases already selected entities.\n\
	    Key 'ESC' changes from any mode to 'select' mode."\
	    "Straight lines are created dragging the mouse.\n\
	    Key 'Shift' restricts angle."\
	    "Vector is created dragging, with cap at the end.\n\
	    Key 'Shift' restricts angle."\
	    "Vector is created dragging, with cap at the beginning.\n\
	    Key 'Shift' restricts angle."\
	    "A cuadratic bezier curve defined by 3 points can be created."\
	    "Text can be entered. When pressing 'Enter', another line is begun.\
	    To finish, press 'ESC' or any other button or mouse."\
	    "A box is created dragging. Text can be entered inside.\n\
	          Note: To select the textbox press in the border a\
		  little outside of it.\n\
	    Ctrl-h   enters superindexes.\n\
	    Ctrl-l   enters subindexes.\n\
	    Ctrl-g   enters greek letters.\n\
	    Tab         returns to normal mode.\n\
                  Note: One superindex after one subindex\
            or viceversa, appear correct in the latex file."\
	    "One circle or filled circle is created from center dragging.\n\
	    To change from one to another press the button for some time."\
	    "One rectangle or filled rectangle is created dragging.\n\
	    To change from one to another press the button for some time.\n\
	    Key 'Shift' forces square."\
	    "Entities can be deleted picking them or selecting with a box.\n\
	    Key 'Del' erases already selected entities."\
	    "Thin, thick or dashed lines are applied to selection and \
	    become the default.\n\
	         Note: In Latex or eepic mode, some entities do not accept\
		       dashed option."\
	    "Operating mode. Depending on the mode, some restrictions are applied\
	    to the drawing and written latex code is different.\n\
	    Latex mode:    many geometric restrictions. Code is compatible.\n\
	    eepic mode:    better. eepic style files are needed.\n\
	      -   mode:    no restrictions. Cannot generate code for latex."  
   	    ]

    for { set i 0 } { $i < 10 } { incr i } {
	set b [lindex $bitmaps $i]

	if { [llength $b] > 1 } {
	    set butname [CreateElapsedMenu $m .buts $b [lindex $names $i]]
	} else {
	    if { ![catch { $m.create index [lindex $names $i] }] } {
		set comm [list $m.create invoke [lindex $names $i]]
	    } else {
		set comm [list $m.modify invoke [lindex $names $i]]
	    }
	    set butname [button .buts.$b -image $TexPriv($b) \
		    -command $comm]
	}
	grid $butname -row [expr $i+1] -col 1 -sticky n
	grid rowconf .buts [expr $i+1] -weight 0
	TexHelp $butname [lindex $help $i]
    }

    menubutton .buts.thick -image $TexPriv(thinline) -menu .buts.thick.m \
	    -relief raised 
    menu .buts.thick.m -tearoff 0
    .buts.thick.m add command -image $TexPriv(thinline) \
	    -command "set TexPriv(Thicklines) 0" -hidemargin 1
    .buts.thick.m add command -image $TexPriv(thickline) \
	    -command "set TexPriv(Thicklines) 1" -hidemargin 1
    .buts.thick.m add command -image $TexPriv(dashedline) \
	    -command "set TexPriv(Thicklines) 2" -hidemargin 1
    grid .buts.thick -row [expr $i+1] -col 1 -sticky n
    grid rowconf .buts [expr $i+1] -weight 0
    TexHelp .buts.thick [lindex $help $i]
    incr i

    menubutton .buts.latex -image $TexPriv(eepic) -menu .buts.latex.m \
	    -relief raised 
    menu .buts.latex.m -tearoff 0
    .buts.latex.m add command -image $TexPriv(latex) \
	    -command "set TexPriv(LatexMode) latex" -hidemargin 1
    .buts.latex.m add command -image $TexPriv(eepic) \
	    -command "set TexPriv(LatexMode) eepic" -hidemargin 1
    .buts.latex.m add command -image $TexPriv(any) \
	    -command "set TexPriv(LatexMode) any" -hidemargin 1
    set TexPriv(LatexMode) eepic

    trace var TexPriv(LatexMode) w "TraceLatexMode ;#"
    proc TraceLatexMode {} {
	global TexPriv
	.buts.latex conf -image $TexPriv($TexPriv(LatexMode))
    }

    grid .buts.latex -row [expr $i+1] -col 1 -sticky n
    grid rowconf .buts [expr $i+1] -weight 0
    TexHelp .buts.latex [lindex $help $i]
    incr i

    grid rowconf .buts $i -weight 1

    frame .f0 -relief ridge -bd 2
    canvas .c  -bg white -highlightthickness 0 \
	    -closeenough $TexPriv(CloseEnough) -xscrollcommand ".xscroll set" \
	    -yscrollcommand ".yscroll set"
    scrollbar .xscroll -relief sunken -command ".c xview" -orient horizontal 
    scrollbar .yscroll -relief sunken -command ".c yview"

    frame .f -relief sunken -bd 2
    label .f.e -textvariable TexPriv(mode) -width 10 \
	    -relief groove -bd 1 -anchor w
    TexHelp .f.e "This is the current working mode.\n\
	    If it is 'select' entities can be moved or deleted.\n\
	    Other modes are for creating entities."

    label .f.e2 -textvariable TexPriv(ZoomFactor) -width 10 \
	    -relief groove -bd 1 -anchor w

    TexHelp .f.e2 "This is the viewing zoom factor.\n\
	    Pressing mouse left button twice, it can be changed.\n\
	    Key 'F3' also changes the zoom.\n\
	    Press right-mouse, shift-right-mouse over the painting."

    bind .f.e2 <Double-1> EnterZoomFactor

    label .f.e3 -bd 0 -highlightthickness 0 -textvar TexPriv(message)

    grid .f.e .f.e2 .f.e3  -sticky ew 
    grid columnconf .f 2 -weight 1

    grid .buts -row 1 -col 1 -sticky ns
    grid .c -in .f0 -sticky nsew -row 1 -col 1
    grid .f0 -row 1 -col 2 -sticky nsew
    grid rowconf .f0 1 -weight 1
    grid columnconf .f0 1 -weight 1
    grid .f -row 2 -col 1 -columnspan 2 -sticky ew
    grid columnconf . 2 -weight 1
    grid rowconf . 1 -weight 1

    trace variable TexPriv(mode) w ChangeMode
    set TexPriv(selected) ""
    BeginSelect .c
    bind . <Escape> "BeginSelect .c"

    focus -force .

    # to debug
    bind all <F2> { auto_reset ; source $argv0 ; WarnWin "Functions reset"}

}

proc ChangeMode { name1 name2 op } {
    global TexPriv

    catch {
	if { $TexPriv(creatingobj) } {
	    .c delete $TexPriv(creatingobj)
	}
	foreach i $TexPriv(tmpobj) {
	    .c delete $i
	}
    }
    foreach i [bind .c] {
	bind .c $i ""
    }
    foreach i [.c bind all] {
	.c bind all $i ""
    }
    ClearSelectedItems
    CheckTmpWins
    .c conf -cursor ""
    set TexPriv(lastcursor) ""
    bind .c <Motion>  ""
    focus -force .
}

proc CheckTmpWins {} {
    global TexPriv
    if { [winfo exists .c.entry] } {
	set text [.c.entry get]
	set font [.c.entry cget -font]
	set x [expr [lindex [.c coords \
		$TexPriv(entryid)] 0]+1]
	set y [expr [lindex [.c coords $TexPriv(entryid)] 1]+1]
	if { $TexPriv(textid) == "" } {
	    .c create text $x $y -text $text -font $font \
		    -anchor nw
	} else {
	    .c itemconf $TexPriv(textid) -text $text
	}
	destroy .c.entry
	.c delete $TexPriv(entryid)
    }
}

proc ClearSelectedItems {} {
    global TexPriv

    foreach i $TexPriv(selected) {
	if { ([.c type $i] == "oval" &&  [.c itemcget $i -fill] == "") || \
		([.c type $i] == "rectangle"  &&  [.c itemcget $i -fill] == "") } {
	    .c itemconf $i -outline black
	} elseif { [.c type $i] == "window" } {
	    set win [.c itemcget $i -window]
	    $win conf -highlightcolor black
	} else {
	    .c itemconf $i -fill black
	}
	.c bind $i <B1-Motion> ""
	.c bind $i <Shift-B1-Motion> ""
	.c bind $i <ButtonRelease-1> ""
    }
    set TexPriv(selected) ""

    foreach i $TexPriv(tmpobj) {
	.c del $i
    }
}

proc CopySelectedItems {} {
    global TexPriv

    foreach i $TexPriv(selected) {
	set new [eval [concat .c create [.c type $i] [.c coords $i]]]
	.c lower $new $i
	foreach j [.c itemconf $i] {
	    if { [lindex $j 0] == "-window" } { continue }
	    if { [lindex $j 0] == "-tags" } { continue }
  	    .c itemconf $new [lindex $j 0] [lindex $j 4]
	}
	if { ([.c type $new] == "oval" &&  [.c itemcget $new -fill] == "") || \
		([.c type $new] == "rectangle"  &&  [.c itemcget $new -fill] == "")} {
	    .c itemconf $new -outline black
	} elseif { [.c type $new] == "window" } {
	    set oldtext [.c itemcget $i -window]
	    set newtext [CreateTextForBox $new $oldtext]
	    lower $newtext $oldtext
	    .c itemconf $new -window $newtext 
	    $oldtext conf -highlightcolor black
	} else {
	    .c itemconf $new -fill black
	}
    }
    
}

proc AddToSelectedItems { items } {
    global TexPriv

    foreach id $items {
	.c raise $id
	if { ([.c type $id] == "oval" &&  [.c itemcget $id -fill] == "") || \
		( [.c type $id] == "rectangle"  &&  [.c itemcget $id -fill] == "") } {
	    .c itemconf $id -outline red
	} elseif { [.c type $id] == "window" } {
	    set win [.c itemcget $id -window]
	    $win conf -highlightcolor red
	    set x [expr [lindex [.c coords $id] 0]+[.c itemcget $id -width]]
	    set y [expr [lindex [.c coords $id] 1]+[.c itemcget $id -height]]
	    set rect [.c create rectangle [expr $x-2] \
		    [expr $y-2] [expr $x+2] [expr $y+2] -fill red -outline red]
	    .c bind $rect <1> "set TexPriv(icx) $x ; set TexPriv(icy) $y ; break"
	    .c bind $rect <B1-Motion> "ResizeText \[cx %x] \[cy %y] $id $rect"
	    lappend TexPriv(tmpobj) $rect
	    focus $win
	} elseif { [.c type $id] == "line" && [.c itemcget $id -smooth] == 1} {
	    if { [llength $items] == 1 } {

		set rect [.c create rectangle \
			[expr [lindex [.c coords $id] 2]-2] \
			[expr [lindex [.c coords $id] 3]-2] \
			[expr [lindex [.c coords $id] 2]+2] \
			[expr [lindex [.c coords $id] 3]+2] \
			-fill red -outline red]
		
		set l1 [.c create line [lindex \
			[.c coords $id] 0] [lindex [.c coords $id] 1] \
			[lindex [.c coords $id] 2] [lindex [.c coords $id] 3] \
			-fill red]
		set l2 [.c create line [lindex \
			[.c coords $id] 2] [lindex [.c coords $id] 3] \
			[lindex [.c coords $id] 4] [lindex [.c coords $id] 5] \
			-fill red]
		lappend TexPriv(tmpobj) $rect
		lappend TexPriv(tmpobj) $l1
		lappend TexPriv(tmpobj) $l2
		.c raise $rect
		.c lower $l1
		.c lower $l2
		.c bind $rect <B1-Motion> "ResizeBezier \[cx %x] \[cy %y] $id \
			$rect $l1 $l2"
	    }
	    .c itemconf $id -fill red
	} else {
	    .c itemconf $id -fill red
	}
	lappend TexPriv(selected) $id

	.c bind $id <1> {
	    set TexPriv(initmovementx) [cx %x]
	    set TexPriv(initmovementy) [cy %y]
	}

  	.c bind $id <B1-Motion> "ItemMotion \[cx %x] \[cy %y]"
	.c bind $id <Shift-B1-Motion> "ItemMotion \[cx %x] \[cy %y] ortho"
  	.c bind $id <ButtonRelease-1> ".c conf -cursor dotbox"
#	.c bind $id <Control-1> "CopySelectedItems ;break"
    }
}

proc NewDraw { c } {
    set ret [tk_dialog  .newdraw "" "Are you sure to delete everything?" \
	    question 0 OK Cancel]
    if { $ret == 1 } { return }
    .c delete all
    BeginSelect $c
}

proc PrintPostscript { c } {
    global tmpdir

    BeginSelect $c
    set types {
	{{Postscript Files}       {.ps}   }
	{{EPS Files}      {.eps}         }
	{{All Files}        *             }
    }

    set file [tk_getSaveFile -parent .c -defaultextension .ps \
	    -initialdir $tmpdir -initialfile tmp.ps -title "Save postscript" \
	    -filetypes $types]
    if { $file != "" } {
	.c postscript -file $file
    }
}

proc FindBoundingBox { filename } {

    if { [file extension $filename] == ".gz"} {
	set filename [file root $filename].bb
    }
    set f [open $filename r]
    while { ![eof $f] } {
	gets $f aa
	if { [regexp \
		{%%BoundingBox:[ ]+([0-9]+)[ ]+([0-9]+)[ ]+([0-9]+)[ ]+([0-9]+)} \
		$aa {} bbllx bblly bburx bbury] } { break }
    }
    close $f
    return "$bbllx $bblly $bburx $bbury"
}

proc AddImage { c } {
    global TexPriv tcl_platform

    BeginSelect $c

    if { $tcl_platform(platform) != "windows" } {
	set types {
	    {{Postscript Files}       {.ps .eps}   }
	    {{gzziped Postscript} {.ps.gz .eps.gz}   }
	    {{All Files}        *             }
	}
    } else {
	set types {
	    {{GIF Files}       {.gif}   }
	    {{All Files}        *             }
	}
    }
    
    set file [tk_getOpenFile -parent .c  \
	    -title "Add image" \
	    -filetypes $types]
    if { $file != "" } {
	set cur [$c cget -cursor]
	$c conf -cursor watch
	update
	SetZoom 1.0
	AddImageF $c $file
	$c conf -cursor $cur
    }
}

proc AddImageF { c file { factor 1 } } {
    global TexPriv

    if { $TexPriv(image) != "" } {
	set im [$c itemcget $TexPriv(imageid) -image]
	image del $im
	$c del $TexPriv(imageid)
	set TexPriv(image) ""
    }

    if { [file ext $file] == ".gif" } {
	set im [image create photo -file $file]
    } else {
	foreach "bbllx bblly bburx bbury" [FindBoundingBox $file] {}
	foreach i "bbllx bblly bburx bbury" {
	    set $i [expr round([subst $$i]*[tk scaling])]
	}
	set res [expr 72*[tk scaling]]
	if { [file extension $file] == ".gz" } {
	    set f [open "|gunzip -c $file | gs -sDEVICE=ppmraw -r$res -dNOPAUSE -q \
		    -sOutputFile=/tmp/texpict[pid].ppm -" w]
	} else {
	    set f [open "|gs -sDEVICE=ppmraw -r$res -dNOPAUSE -q \
		    -sOutputFile=/tmp/texpict[pid].ppm $file" w]
	}
	puts $f quit
	close $f
	set im0 [image create photo -file /tmp/texpict[pid].ppm]
	file delete /tmp/texpict[pid].ppm
	set im [image create photo]
	if { $bburx > [image width $im0] } { set bburx [image width $im0] }
	if { $bbury > [image height $im0] } { set bbury [image height $im0] }
	if { $factor == 1 } {
	    $im copy $im0 -from $bbllx [expr [image height $im0]-$bblly] \
		    $bburx [expr [image height $im0]-$bbury]
	} elseif { $factor < 1 } {
	    $im copy $im0 -from $bbllx [expr [image height $im0]-$bblly] \
		    $bburx [expr [image height $im0]-$bbury] \
		    -zoom [expr int(1.0/$factor)]
	} else {
	    $im copy $im0 -from $bbllx [expr [image height $im0]-$bblly] \
		    $bburx [expr [image height $im0]-$bbury] \
		    -subsample [expr int($factor)]
	}
	image delete $im0
    }
    set w [image width $im]
    set h [image height $im]
    set imid [$c create image 0 0 -anchor nw -image $im]
    
    if { $factor == 1 } {
	$c conf -width $w -height $h -scrollregion ""

	set top [winfo toplevel $c]
	wm geom $top ""
	#    wm geom $top +[winfo x $top]+[winfo y $top]
    }
    $c lower $imid 
    set TexPriv(image) $file
    set TexPriv(imageid) $imid
}

proc DeleteItems { c { maintaindeletemode no } } {
    global TexPriv

    set inum [llength $TexPriv(selected)]
    foreach i $TexPriv(selected) {
	.c delete $i
    }
    set TexPriv(selected) ""
    if { $inum == 0 || $maintaindeletemode != "no" } {
	set TexPriv(mode) delete
    } else { set TexPriv(mode) select }
    BeginSelect $c no
}

set TexPriv(lastcursor) ""

proc SearchClosePoints { x y {novalid "" } } {
    global TexPriv
    set distmin2 1e5
    set lineclose ""

    set bb $TexPriv(SnapDistance)

    if { $TexPriv(SnapToPoint) == 0 } { return "$x $y" }

    foreach i [.c find overlapping [expr $x-$bb] [expr $y-$bb] \
	    [expr $x+$bb] [expr $y+$bb]] {
	set noval 0
	foreach j $TexPriv(tmpobj) {
	    if { $i == $j } { set noval 1 ; break }
	}
	if { $noval } { continue }
	if { $i == $novalid } { continue }
	if { [.c type $i] == "window" } { continue }
	set coords [.c coords $i]
	if { [.c type $i] == "rectangle" } {
	    lappend coords [lindex $coords 0]
	    lappend coords [lindex $coords 3]
	    lappend coords [lindex $coords 2]
	    lappend coords [lindex $coords 1]
	}  elseif { [.c type $i] == "oval" } {
	    set coords "[expr int(([lindex $coords 0]+[lindex $coords 2])/2)] \
		    [expr int(([lindex $coords 1]+[lindex $coords 3])/2)]"
	}
	if { ([.c type $i] == "line" && [.c itemcget $i -smooth] == 0) || \
		[.c type $i] == "rectangle" } { 
	    set lineclose $i
	}
	foreach "xtest ytest" $coords {
	    set d2 [expr ($xtest-$x)*($xtest-$x)+($ytest-$y)*($ytest-$y)]
	    if { $d2 < $distmin2 } {
		set distmin2 $d2
		set xmin $xtest ; set ymin $ytest
	    }
	}
    }
    if { [expr sqrt($distmin2)] < $bb } { 
	if { [.c cget -cursor] != "circle" && [.c cget -cursor] != "bottom_tee" } {
	    set TexPriv(lastcursor) [.c cget -cursor]
	}
	.c conf -cursor circle
	return "$xmin $ymin"
    } elseif { $lineclose != "" } {
	set x1 [lindex [.c coords $lineclose] 0]
	set y1 [lindex [.c coords $lineclose] 1]
	set x2 [lindex [.c coords $lineclose] 2]
	set y2 [lindex [.c coords $lineclose] 3]
	if { [.c type $lineclose] == "rectangle" } { 
	    if { [expr abs($x-$x1)] <= $bb } {
		set x2 $x1
	    } elseif { [expr abs($y-$y1)] <= $bb } {
		set y2 $y1
	    } elseif { [expr abs($x-$x2)] <= $bb } {
		set x1 $x2
	    } else { set y1 $y2 }
	}
	set l [expr sqrt(($x1-$x2)*($x1-$x2)+($y1-$y2)*($y1-$y2))]
	if { $l > 0 } {
	    set ca [expr sqrt(($x1-$x)*($x1-$x)+($y1-$y)*($y1-$y))]
	    set cb [expr (($x2-$x1)*($x-$x1)+($y2-$y1)*($y-$y1))/$l]
	    set xnew [expr $x1+($x2-$x1)/$l*$cb]
	    set ynew [expr $y1+($y2-$y1)/$l*$cb]
	    if { [.c cget -cursor] != "circle" && \
		    [.c cget -cursor] != "bottom_tee" } {
		set TexPriv(lastcursor) [.c cget -cursor]
	    }
	    .c conf -cursor bottom_tee
	    return "$xnew $ynew"
	}
    }
    if { $TexPriv(lastcursor) != [.c cget -cursor] } {
	.c conf -cursor $TexPriv(lastcursor)
    }
    return "$x $y"
}

proc SearchClosePointsFinish {} {
    global TexPriv
    if { $TexPriv(lastcursor) != [.c cget -cursor] } {
	.c conf -cursor $TexPriv(lastcursor)
    }
}

proc LineMotion { x2 y2 { ortho no } } {
    global TexPriv

    foreach "x2 y2" [SearchClosePoints $x2 $y2 $TexPriv(creatingobj) ] {}

    if { $TexPriv(creatingobj) == "" } {
	if { $TexPriv(arrow) == "no" } {
	    set TexPriv(creatingobj) [.c create line $x2 $y2 $x2 $y2]
	} elseif { $TexPriv(arrow) == "yes" } {
	    set TexPriv(creatingobj) [.c create line $x2 $y2 $x2 $y2 -arrow last]
	} else {
	    set TexPriv(creatingobj) [.c create line $x2 $y2 $x2 $y2 -arrow first]
	}
	set TexPriv(icx) $x2
	set TexPriv(icy) $y2
    }
    set x1 $TexPriv(icx)
    set y1 $TexPriv(icy)
    
    if { $ortho != "no" } {
	set l [expr sqrt(($x1-$x2)*($x1-$x2)+($y1-$y2)*($y1-$y2))]
	if { $l > 0 } {
	    set cos [expr abs(double($x2-$x1)/$l)]
	    if { $cos > 0.92387953251128674 } {
		set y2 $y1
	    } elseif { $cos < 0.38268343236508984 } {
		set x2 $x1
	    } else {
		set signx [expr ($x2>$x1)?1:-1]
		set signy [expr ($y2>$y1)?1:-1]
		set x2 [expr $x1+$signx*$l*0.70710678118654757]
		set y2 [expr $y1+$signy*$l*0.70710678118654757]
	    }
	}
    } elseif { $TexPriv(LatexMode) == "any" || \
	    ($TexPriv(LatexMode) == "eepic" && \
	    [.c itemcget $TexPriv(creatingobj) -arrow] == "none") } {
	# nothing
    } else {
	if { [.c itemcget $TexPriv(creatingobj) -arrow] == "none" } {
	    set ret [ReturnAngleAndLength $x1 $y1 $x2 $y2]
	} else {
	    set ret [ReturnAngleAndLength $x1 $y1 $x2 $y2 yes]
	}
	set x2 [lindex $ret 3]
	set y2 [lindex $ret 4]
    }

    .c coords $TexPriv(creatingobj) $x1 $y1 $x2 $y2
}

proc FinishLine { x y { ortho no } } {
    global TexPriv

    bind .c <B1-Motion> ""
    bind .c <Shift-B1-Motion> ""
    bind .c <ButtonRelease-1> ""
    bind .c <Shift-ButtonRelease-1> ""
    LineMotion $x $y $ortho
    ChangingThicklines $TexPriv(creatingobj)
    set TexPriv(creatingobj) ""
}

proc cx { x } {
    set totalw [lindex [.c cget -scrollregion] 2]
    if { $totalw == "" } { set totalw [winfo width .c] }
    set leftx [lindex [.c xview] 0]
    return [expr $totalw*$leftx+$x]
}

proc cy { y } {
    set totalh [lindex [.c cget -scrollregion] 3]
    if { $totalh == "" } { set totalh [winfo height .c] }
    set lefty [lindex [.c yview] 0]
    return [expr $totalh*$lefty+$y]
}

proc CreateLine { c { arrow no } } {
    global TexPriv
    if { $arrow == "no" } {
	set TexPriv(mode) line
    } elseif { $arrow == "yes" } {
	set TexPriv(mode) vector
    } else { set TexPriv(mode) "vector inv" }
    set TexPriv(arrow) $arrow
    $c conf -cursor plus
    set TexPriv(lastcursor) plus
    bind $c <Motion> "SearchClosePoints \[cx %x] \[cy %y]"
    
    bind $c <1> {
	LineMotion [cx %x] [cy %y]
	bind .c <B1-Motion> "LineMotion \[cx %%x] \[cy %%y] ; break"
	bind .c <Shift-B1-Motion> "LineMotion \[cx %%x] \[cy %%y] yes ; break"
	bind .c <ButtonRelease-1> "FinishLine \[cx %%x] \[cy %%y]"
	bind .c <Shift-ButtonRelease-1> "FinishLine \[cx %%x] \[cy %%y] yes ; break"
    }
}

proc ResizeBezier { x y id rect l1 l2 } {

    .c coords $rect [expr $x-2] [expr $y-2] [expr $x+2] [expr $y+2]
    .c coords $id [lindex [.c coords $id] 0] [lindex [.c coords $id] 1] $x $y \
	    [lindex [.c coords $id] 4] [lindex [.c coords $id] 5]
    .c coords $l1 [lindex [.c coords $id] 0] [lindex [.c coords $id] 1] $x $y
    .c coords $l2 $x $y [lindex [.c coords $id] 4] [lindex [.c coords $id] 5]
}

proc BezierMotion { x y { ispoint no} } {
    global TexPriv

    foreach "x y" [SearchClosePoints $x $y $TexPriv(creatingobj) ] {}

    if { $TexPriv(creatingobj) == "" } {
	set TexPriv(creatingobj) [.c create line $x $y $x $y -smooth 1]
    }

    set c [.c coords $TexPriv(creatingobj)]
    set l [llength $c]

    eval [concat .c coords $TexPriv(creatingobj) [lrange $c 0 [expr $l-3]] $x $y]

    if { $l > 4 } {
	set tmpobj [lindex $TexPriv(tmpobj) 1]
	set ctmp [.c coords $tmpobj]
	set ltmp [llength $ctmp]
	eval [concat .c coords $tmpobj [lrange $ctmp 0 [expr $ltmp-3]] $x $y]
    }

    if { [string match yes* $ispoint] } {
	set x1 [lindex [.c coords $TexPriv(creatingobj)] [expr $l-4]]
	set y1 [lindex [.c coords $TexPriv(creatingobj)] [expr $l-3]]
	set x2 [lindex [.c coords $TexPriv(creatingobj)] [expr $l-2]]
	set y2 [lindex [.c coords $TexPriv(creatingobj)] [expr $l-1]]
	set len [expr sqrt(($x1-$x2)*($x1-$x2)+($y1-$y2)*($y1-$y2))]
	if { $len < 5 && ![string match *force $ispoint] } { return }
	if { $l == 4 } {
	    eval [concat .c coords $TexPriv(creatingobj) $c $x $y]
	    set com [concat .c create line $c]
	    set TexPriv(tmpobj) [eval $com]
	    lappend TexPriv(tmpobj) [.c create line $x $y $x $y]
	} else {
	    foreach i $TexPriv(tmpobj) {
		.c delete $i
	    }
	    bind .c <1> {
		BezierMotion [cx %x] [cy %y]
		bind .c <1> "BezierMotion \[cx %%x] \[cy %%y] yesforce"
		bind .c <ButtonRelease-1> "BezierMotion \[cx %%x] \[cy %%y] yes"
		bind .c <Motion> "BezierMotion \[cx %%x] \[cy %%y]"
	    }
	    bind .c <Motion> "SearchClosePoints \[cx %x] \[cy %y]"
	    bind .c <ButtonRelease-1> ""
	    ChangingThicklines $TexPriv(creatingobj)
	    set TexPriv(creatingobj) ""
	}
    }
}

proc CreateBezier { c } {
    global TexPriv

    set TexPriv(mode) "Bezier curve"

    $c conf -cursor plus 
    set TexPriv(lastcursor) plus
    bind $c <Motion> "SearchClosePoints \[cx %x] \[cy %y]"
    bind $c <1> {
	BezierMotion [cx %x] [cy %y]
	bind .c <1> "BezierMotion \[cx %%x] \[cy %%y] yesforce"
	bind .c <ButtonRelease-1> "BezierMotion \[cx %%x] \[cy %%y] yes"
	bind .c <Motion> "BezierMotion \[cx %%x] \[cy %%y]"
    }
}

proc CircleMotion { x2 y2 } {
    global TexPriv

    if { $TexPriv(creatingobj) == "" } {
	foreach "x2 y2" [SearchClosePoints $x2 $y2 ] {}
	if { [lindex $TexPriv(arrow) 0] == "no" } {
	    set TexPriv(creatingobj) [.c create oval \
		    $x2 $y2 $x2 $y2 -fill ""]
	} else {
	    set TexPriv(creatingobj) [.c create oval \
		    $x2 $y2 $x2 $y2 -fill black]
	}
	set TexPriv(icx) $x2
	set TexPriv(icy) $y2
	.c conf -cursor plus
	set TexPriv(lastcursor) plus
	bind .c <Motion> ""
    }

    set cx $TexPriv(icx)
    set cy $TexPriv(icy)
    set r [expr sqrt(($x2-$cx)*($x2-$cx)+($y2-$cy)*($y2-$cy))]
    if { $TexPriv(LatexMode) == "latex" } {
	if { $TexPriv(arrow) == "no" } {
	    set rmax [PtToPix 20]
	} else {
	    set rmax [PtToPix 7.5]
	}
	if { $r > $rmax } { set r $rmax }
    }
    set x1 [expr $cx-$r]
    set y1 [expr $cy-$r]
    set x2 [expr $cx+$r]
    set y2 [expr $cy+$r]
    .c coords $TexPriv(creatingobj) $x1 $y1 $x2 $y2
}

proc ConvertCircleToRadius { i r } {
    set x [lindex [.c coords $i] 0]
    set y [lindex [.c coords $i] 1]
    .c coords $i [expr $x-$r] [expr $y-$r] [expr $x+$r] [expr $y+$r] 
}

proc CreateCircle { c { filled no } } {
    global TexPriv
    if { $filled == "no" } {
	set TexPriv(mode) circle
    } elseif { $filled == "yes" } {
	set TexPriv(mode) Fcircle
    } elseif { [lindex $filled 0] == "no" } {
	set TexPriv(mode) "circle [lindex $filled 1]"
    } else {
	set TexPriv(mode) "Fcircle [lindex $filled 1]"
    }
    set TexPriv(arrow) $filled
    $c conf -cursor plus 
    set TexPriv(lastcursor) plus
    bind $c <Motion> "SearchClosePoints \[cx %x] \[cy %y]"

    bind .c <1> {
	if { $TexPriv(arrow) == "no" || $TexPriv(arrow) == "yes" } {
	    CircleMotion [cx %x] [cy %y]
	    bind .c <B1-Motion> "CircleMotion \[cx %%x] \[cy %%y]"
	}
	bind .c <ButtonRelease-1> {
	    bind .c <B1-Motion> ""
	    bind .c <ButtonRelease-1> ""
	    CircleMotion [cx %%x] [cy %%y]
	    if { $TexPriv(arrow) != "no" && $TexPriv(arrow) != "yes" } {
		ConvertCircleToRadius $TexPriv(creatingobj) [lindex $TexPriv(arrow) 1]
	    }
	    ChangingThicklines $TexPriv(creatingobj)
	    set TexPriv(creatingobj) ""
	    set TexPriv(lastcursor) plus
	    bind .c <Motion> {SearchClosePoints [cx %%%%x] [cy %%%%y]}
	}
    }
}

proc BoxMotion { x2 y2 {what no} } {
    global TexPriv

    foreach "x2 y2" [SearchClosePoints $x2 $y2 $TexPriv(creatingobj) ] {}

    if { $TexPriv(creatingobj) == "" } {
    	set TexPriv(creatingobj) [.c create rectangle $x2 $y2 $x2 $y2]
	if { $TexPriv(arrow) != "no" } { 
	    .c itemconf $TexPriv(creatingobj) -fill black
	}
	set TexPriv(icx) $x2
	set TexPriv(icy) $y2
    }
    set x1 $TexPriv(icx)
    set y1 $TexPriv(icy)

    if { [string match shift* $what] } {
	set y2 [expr $y1+$x2-$x1]
    }
    .c coords $TexPriv(creatingobj) $x1 $y1 $x2 $y2

    if { [string match *end* $what] } {
	bind .c <B1-Motion> ""
	bind .c <ButtonRelease-1> ""
	if { ![string match *text $what] } {
	    ChangingThicklines $TexPriv(creatingobj)
	    set TexPriv(creatingobj) ""
	} else {
	    ContinueCreatingTextbox
	}
    }
}

proc CreateBox { c { filled no } {isfortext no} } {
    global TexPriv

    if { $isfortext == "no" } {
	set TexPriv(isfortext) no
	if { $filled == "no" } {
	    set TexPriv(mode) box
	} else { set TexPriv(mode) Fbox }
    } else { set TexPriv(isfortext) yes }
    set TexPriv(arrow) $filled
    $c conf -cursor plus
    set TexPriv(lastcursor) plus
    bind $c <Motion> "SearchClosePoints \[cx %x] \[cy %y]"
    bind $c <1> {
	BoxMotion [cx %x] [cy %y]
	bind .c <B1-Motion> "BoxMotion \[cx %%x] \[cy %%y]"
	bind .c <Shift-B1-Motion> "BoxMotion \[cx %%x] \[cy %%y] shift; break"
	if { $TexPriv(isfortext) == "no" } {
	    bind .c <ButtonRelease-1> "BoxMotion \[cx %%x] \[cy %%y] end; break"
	    bind .c <Shift-ButtonRelease-1> "BoxMotion \[cx %%x] \[cy %%y] shiftend;\
		    break"
	} else {
	    bind .c <ButtonRelease-1> "BoxMotion \[cx %%x] \[cy %%y] endtext; break"
	    bind .c <Shift-ButtonRelease-1> "BoxMotion \[cx %%x] \
		    \[cy %%y] shiftendtext; break"
	}
    }
}

proc CreateTextBox { c } {
    global TexPriv
    set TexPriv(mode) "Text box"
    CreateBox $c no yes
}

proc tkTextInsertWithTag {w s tag} {
    if {($s == "") || ([$w cget -state] == "disabled")} {
	return
    }
    catch {
	if {[$w compare sel.first <= insert]
		&& [$w compare sel.last >= insert]} {
	    $w delete sel.first sel.last
	}
    }
    $w insert insert $s $tag
    $w see insert
}

proc ResizeText { x y textid rectid } {
    global TexPriv
    

    set oldw [.c itemcget $textid -width]
    set oldh [.c itemcget $textid -height]
    set neww [expr $oldw+$x-$TexPriv(icx)]
    if { $neww < 10 } { set neww 10 }
    set newh [expr $oldh+$y-$TexPriv(icy)]
    if { $newh < 10 } { set newh 10 }
    .c itemconf $textid -width $neww -height $newh


    set x [expr [lindex [.c coords $textid] 0]+[.c itemcget $textid -width]]
    set y [expr [lindex [.c coords $textid] 1]+[.c itemcget $textid -height]]

    .c coords $rectid [expr $x-2] [expr $y-2] [expr $x+2] [expr $y+2] 

    set TexPriv(icx) $x
    set TexPriv(icy) $y

}

proc CreateTextForBox { winid { copyfrom "" } } {

    set i 0
    while { [winfo exists .c.text$i] } { incr i }
    text .c.text$i -highlightthickness 2 -bg [.c cget -bg] -bd 0 \
	    -font NormalFont -wrap word

    bind .c.text$i <Alt-KeyPress> {# nothing }
    bind .c.text$i <Meta-KeyPress> {# nothing}
    bind .c.text$i <Control-KeyPress> {# nothing}
    bind .c.text$i <Escape> {# nothing}
    bind .c.text$i <KP_Enter> {# nothing}

    bind .c.text$i <1> "BeginSelect .c"

    proc ApplyTextBinding { text tag {highlow 0} } {
	global TexPriv
	set letters [concat $TexPriv(normalletters) \
		[string toupper $TexPriv(normalletters) ]]
	if { $highlow } {
	    append letters { 0 1 2 3 4 5 6 7 8 9 less equal greater at colon \
		    semicolon question space exclam quotedbl dollar percent \
		    ampersand quoteright parenleft parenright \
		    asterisk plus comma minus period slash bracketleft backslash \
	            bracketright asciicircum underscore questiondown \
		    ccedilla} 
	}
	foreach j  $letters {
	    if { $j != "h" && $j != "l" && $j != "g" && \
		    $j != "H" && $j != "L" && $j != "G" } {
		bind $text <Control-KeyPress-$j> {# nothing }
	    }
	    bind $text <Alt-KeyPress-$j> {# nothing }
	    bind $text <Meta-KeyPress-$j> {# nothing }
	    if { $highlow } {
		bind $text <KP_Enter> "ApplyTextBinding $text {} ; break"
		bind $text <Return> "ApplyTextBinding $text {} ; break"
	    }
	    if { $tag != "" } {
		bind $text <KeyPress-$j> "\
			tkTextInsertWithTag %W %A $tag ;\
			break \
			"
	    } else { bind $text <KeyPress-$j> "" }
	}
    }

    bind .c.text$i <Control-h> "ApplyTextBinding .c.text$i hightag 1 ; break"
    bind .c.text$i <Control-l> "ApplyTextBinding .c.text$i lowtag 1 ; break"
    bind .c.text$i <Control-g> "ApplyTextBinding .c.text$i greektag ; break"
    bind .c.text$i <Tab> "ApplyTextBinding .c.text$i {} 1 ; break"

    bind .c.text$i <FocusIn> ".c.text$i conf -highlightthickness 2"
    bind .c.text$i <FocusOut> ".c.text$i conf -highlightthickness 0"
    


    set ls [font metrics NormalFont -linespace]
    .c.text$i tag conf hightag -font ScriptFont -offset [expr int($ls*.5)]
    .c.text$i tag conf lowtag -font ScriptFont -offset [expr -1*int($ls*.4)]
    .c.text$i tag conf greektag -font SymbolFont

    if { $copyfrom != "" } {
	set lasttag ""
	foreach "key value idx" [$copyfrom dump -tag -text 1.0 "end-1c"] {
	    switch $key {
		text {
		    switch $lasttag {
			"" {
			    .c.text$i ins $idx $value
			}
			hightag - lowtag - greektag {
			    .c.text$i ins $idx $value $lasttag
			}
		    }
		}
		tagon { set lasttag $value }
		tagoff { set lasttag "" }
	    }
	}
    }
    return .c.text$i
}

set TexPriv(normalletters) "a     b    c   d     e       f   g     h   i    j \
	k     l      m  n  o p  q     r   s     t   u       v        w     x  \
	y   z"
set TexPriv(greekletters)  "alpha beta chi delta epsilon phi gamma eta iota varphi \
	kappa lambda mu nu o pi theta rho sigma tau upsilon varpi    omega xi \
	psi zeta"

set TexPriv(greekupletters) "-    -    chi Delta -       Phi Gamma -   -    vartheta\
	-     Lambda -  -  - Pi Theta -P  Sigma -   Upsilon varsigma Omega Xi \
	Psi -"

proc mapgreekchar { a } {
    global TexPriv

    set pos [lsearch $TexPriv(normalletters) [string tolower $a]]
    if { $pos == -1 } {
	WarnWin "Greek character '$a' is not understood"
	return ""
    }
    if { [string comp $a a] >=0 } {
	set res \\[lindex $TexPriv(greekletters) $pos]{}
    } else {
	set res [lindex $TexPriv(greekupletters) $pos]
	if {$res == "-"} {
	    set res \\mathit\{$a\}
	} elseif { [string match -* $res] } {
	    set res \\mathit\{[string range $res 1 end]\}
	} else { set res \\$res{} }
    }
    return $res
}

proc mapfromtextogreek { a } {
    global TexPriv

    set pos [lsearch $TexPriv(greekletters) $a]
    set isup 0
    if { $pos == -1 } {
	set pos [lsearch $TexPriv(greekupletters) $a]
	set isup 2
    }
    if { $pos == -1 } {
	set pos [lsearch $TexPriv(normalletters) [string tolower $a]]
	set isup 2
    }
    if { $pos == -1 } {
	WarnWin "Latex math char '$a' is not understood"
	return ""
    }
    set res [lindex $TexPriv(normalletters) $pos]
    
    if { $isup } { set res [string toupper  $res] }
    return $res
}

proc EncodeTextForLatex { textwidget } {

    set text ""
    set lasttag ""
    foreach "key value idx" [$textwidget dump -tag -text 1.0 "end-1c"] {
	switch $key {
	    text {
		regsub -all {[$]} $value {\\$} value
		switch $lasttag {
		    "" {
			regsub -all "\n" $value {\\newline{}} value
			append text $value
		    }
		    hightag {
			append text \$^\{$value\}\$
		    }
		    lowtag {
			append text \$_\{$value\}\$
		    }
		    greektag {
			append text \$
			for { set i 0 } { $i < [string length $value]} {incr i} {
			    append text [mapgreekchar [string index $value $i]]
			}
			append text \$
		    }
		}
	    }
	    tagon { set lasttag $value }
	    tagoff { set lasttag "" }
	}
    }
    regsub -all {\$_{([^\}]*)}\$\$\^{([^\}]*)}} $text {$_{\1}^{\2}} text
    regsub -all {\$\^{([^\}]*)}\$\$_{([^\}]*)}} $text {$^{\1}_{\2}} text
    return $text
}

proc DecodeTextForLatex { text textwidget } {
 
    regsub -all {\\newline{}} $text "\n" text
    $textwidget ins 1.0 $text

    set idx 1.0
    while 1 {
	set idx [$textwidget search -regexp -nocase -count endpos -- \
		{\$(\^|_){([^$]*)}\$} $idx end]
	if { $idx == "" } { break }
	set idxlast [$textwidget index "$idx+$endpos c"]
	set tt [$textwidget get $idx $idxlast]
	$textwidget del $idx $idxlast
	regexp {\$(\^|_){([^$]*)}\$} $tt {} what ttt
	if { $what == "^" } {
	    $textwidget ins $idx $ttt hightag
	} else { $textwidget ins $idx $ttt lowtag }
    }

    set idx 1.0
    while 1 {
	set idx [$textwidget search -regexp -nocase -count endpos -- \
		{(^|[^\\])\$([^$]*)\$} $idx end]
	if { $idx == "" } { break }
	set idxlast [$textwidget index "$idx+$endpos c"]
	set tt [$textwidget get $idx $idxlast]
	regexp -nocase {(^|[^\\])\$([^$]*)\$} $tt {} before tt
	if { $before != "" } {
	    set idx [$textwidget index $idx+1c]
	}
	$textwidget del $idx $idxlast
	while { [regexp {^\\([^\}]*)\{([^\}]*)\}(.*)$} $tt {} letter arg tt] } {
	    if { $arg != "" } {
		$textwidget ins $idx [mapfromtextogreek $arg] greektag
	    } else {
		$textwidget ins $idx [mapfromtextogreek $letter] greektag
	    }
	    set idx [$textwidget index $idx+1c]
	}
    }

    set idx 1.0
    while 1 {
	set idx [$textwidget search -exact \\$ $idx end]
	if { $idx == "" } { break }
	$textwidget del $idx
    }

    
}


proc ContinueCreatingTextbox {} {
    global TexPriv

    set coords [.c coords $TexPriv(creatingobj)]
    .c del $TexPriv(creatingobj)
    set TexPriv(creatingobj) ""
    if { $coords == "" } { return }
    set w [expr int(abs([lindex $coords 2]-[lindex $coords 0]))]
    set h [expr int(abs([lindex $coords 3]-[lindex $coords 1]))] 
    if { $w < 10 || $h < 10 } { return }
    set x [lindex $coords 0]
    if { [lindex $coords 2] < $x } { set x [lindex $coords 2] }
    set y [lindex $coords 1]
    if { [lindex $coords 3] < $y } { set y [lindex $coords 3] }
    set win [.c create window $x $y]
    set txt [CreateTextForBox $win]
    .c itemconf $win -window $txt -anchor nw -width $w -height $h
    BeginSelect .c

}

proc ChangingThickLinesVar {} {
    global TexPriv

    switch $TexPriv(Thicklines) {
	0 { .buts.thick conf -image $TexPriv(thinline) }
	1 { .buts.thick conf -image $TexPriv(thickline) }
	2 { .buts.thick conf -image $TexPriv(dashedline) }
    }
    ChangingThicklines
}

proc AddStippleToLine { i } {
    global TexPriv
    if { [expr abs([lindex [.c coords $i] 0]-[lindex [.c coords $i] 2])] > \
	    [expr abs([lindex [.c coords $i] 1]-[lindex [.c coords $i] 3])] } {
	.c itemconf $i -width 1 -stipple $TexPriv(dashed)
    } else {
	.c itemconf $i -width 1 -stipple $TexPriv(dashedv)
    }
}

proc ChangingThicklines { {items "" } } {
    global TexPriv

    if { $items == "" } {
	set itemsc $TexPriv(selected)
    } else { set itemsc $items }

    foreach i $itemsc {
	if { [.c type $i] != "text" } {
	    switch $TexPriv(Thicklines) {
		0 { .c itemconf $i -width 1 -stipple ""}
		1 { .c itemconf $i -width 2 -stipple ""}
		2 {
		    switch [.c type $i] {
			line {
			    AddStippleToLine $i
			}
			rectangle {
			    set ll {0 1 2 1  2 1 2 3  2 3 0 3  0 3 0 1 }
			    set ipos [lsearch $TexPriv(selected) $i]
			    set TexPriv(selected) [lreplace $TexPriv(selected) \
				    $ipos $ipos]
			    foreach "x1 y1 x2 y2" $ll {
				set l [.c create line [lindex [.c coords $i] $x1] \
					[lindex [.c coords $i] $y1] \
					[lindex [.c coords $i] $x2] \
					[lindex [.c coords $i] $y2]]
				AddStippleToLine $l
				set TexPriv(selected) [lreplace $TexPriv(selected) \
					$ipos -1 $l]
			    }
			    .c delete $i
			}
			default {
			    .c itemconf $i -width 1
			}
		    }
		}
	    }
	}
    }
}

proc ItemMotion { x y { what no } } {
    global TexPriv

    if { [llength $TexPriv(selected)] == 1 && \
	    ([.c type $TexPriv(selected)] == "oval" || \
	[.c type $TexPriv(selected)] == "rectangle") } {
	foreach "xn yn" [SearchClosePoints $x $y $TexPriv(selected)] {}
	if { [expr ($x-$xn)*($x-$xn)+($y-$yn)*($y-$yn)] != 0 } {
	    set TexPriv(icx) [expr ([lindex [.c coords $TexPriv(selected)] 0]+\
		    [lindex [.c coords $TexPriv(selected)] 2])/2]
	    set TexPriv(icy) [expr ([lindex [.c coords $TexPriv(selected)] 1]+\
		    [lindex [.c coords $TexPriv(selected)] 3])/2]
	    set x $xn ; set y $yn
	}
    }

    if { $what == "ortho" } {
	set x1 $TexPriv(initmovementx)
	set y1 $TexPriv(initmovementy)
	set l [expr sqrt(($x1-$x)*($x1-$x)+($y1-$y)*($y1-$y))]
	if { $l > 0 } {
	    set cos [expr abs(double($x-$x1)/$l)]
	    if { $cos > 0.70710678118654757 } {
		set y $y1
	    } else {
		set x $x1
	    }
	}
    }

    foreach i $TexPriv(selected) {
	.c move $i [expr $x-$TexPriv(icx)] [expr $y-$TexPriv(icy)]
    }
    foreach i $TexPriv(tmpobj) {
	.c move $i [expr $x-$TexPriv(icx)] [expr $y-$TexPriv(icy)]
    }
    set TexPriv(icx) $x
    set TexPriv(icy) $y
}

proc SelRectangle { x y { theend no } } {
    global TexPriv
    if { $theend == "no" } {
	.c coords $TexPriv(selrectangle) $TexPriv(icx) $TexPriv(icy) $x $y
    } else {
	set x1 [expr ($TexPriv(icx)<=$x)?$TexPriv(icx):$x]
	set y1 [expr ($TexPriv(icy)<=$y)?$TexPriv(icy):$y]
	set x2 [expr ($TexPriv(icx)>$x)?$TexPriv(icx):$x]
	set y2 [expr ($TexPriv(icy)>$y)?$TexPriv(icy):$y]
	.c delete $TexPriv(selrectangle)
	foreach i [.c find overlapping $x1 $y1 $x2 $y2] {
	    if { [.c type $i] == "image" } { continue }
	    AddToSelectedItems $i
	}
	if { $TexPriv(mode) == "delete" } { DeleteItems .c yes}
    }
}

proc SetSelection { c x y {what no} } {
    global TexPriv
    set TexPriv(icx) $x
    set TexPriv(icy) $y
    set TexPriv(initmovementx) $x
    set TexPriv(initmovementy) $y

    set id [.c find withtag current]
    if { [lsearch -exact $TexPriv(tmpobj) $id] != -1 } { return }
    if { $id != "" && [$c type $id] == "image" } { set id "" }
    if { $id == "" } {
	CheckTmpWins
	if { ![string match add* $what] } { ClearSelectedItems }
	set TexPriv(selrectangle) [.c create rectangle $x $y $x $y \
		-outline red]
	bind .c <B1-Motion> "SelRectangle \[cx %x] \[cy %y]"
	bind .c <ButtonRelease-1> {
	    SelRectangle [cx %x] [cy %y] yes
	    bind .c <B1-Motion> ""
	    bind .c <ButtonRelease-1> ""
	}
	return
    }
    set isin [expr [lsearch $TexPriv(selected) $id] != -1]
    if { [llength $TexPriv(selected)] == 1 && $isin \
	    && [$c type $id] == "text" } { 
	Modifytext $c $id
	bind .c <1>  "SetSelection $c \[cx %x] \[cy %y]"
	return
    }

    if { !$isin } {
	if { ![string match add* $what] } { ClearSelectedItems }
	AddToSelectedItems [.c find withtag current]
    }

    if { [string match *copy $what] } "CopySelectedItems"

    if { $TexPriv(mode) == "delete" } { DeleteItems $c yes}
}

proc BeginSelect { c { selname yes} } {
    global TexPriv
    if { $selname == "yes" } {
	set TexPriv(mode) select
    }
    ClearSelectedItems
    .c conf -cursor dotbox
    bind .c <1>  "SetSelection $c \[cx %x] \[cy %y]"
    bind .c <Shift-1>  "SetSelection $c \[cx %x] \[cy %y] add; break"
    bind .c <Control-1>  "SetSelection $c \[cx %x] \[cy %y] copy; break"
    bind .c <Control-Shift-1>  "SetSelection $c \[cx %x] \[cy %y] addcopy; break"
}

proc BeginCreatingText { x y } {
    global TexPriv
    CheckTmpWins
    entry .c.entry -bd 0 -highlightthickness 0 \
	    -width 50 -font NormalFont -bg [.c cget -bg]
    .c.entry del 0 end
    set TexPriv(entryid) [.c create window $x $y -window .c.entry \
	    -anchor nw]
    set TexPriv(textid) ""
    focus .c.entry
    bind .c.entry <Return> "BeginCreatingText $x [expr $y+\
	    [font metrics NormalFont -linespace]]"
}


proc Createtext { c } {
    global TexPriv
    set TexPriv(mode) text
    bind $c <1> "BeginCreatingText \[cx %x] \[cy %y]"
}

proc Modifytext { c id } {
    global TexPriv
    set TexPriv(mode) text

    set x1 [expr [lindex [$c coords $id] 0]-1]
    set y1 [expr [lindex [$c coords $id] 1]-1]
    set text [$c itemcget $id -text]
    set font [$c itemcget $id -font]

    entry .c.entry -bd 0 -highlightthickness 0 -font $font \
	    -width 50 -bg [.c cget -bg]
    .c.entry del 0 end
    .c.entry insert end $text
    set TexPriv(entryid) [.c create window $x1 $y1 -window .c.entry \
	    -anchor nw]
    set TexPriv(textid) $id
    focus .c.entry
}

proc SelectionHandler { offset maxBytes } {
    global TexPriv
    return [string range $TexPriv(data) $offset [expr $offset+$maxBytes-1]]
}

proc CopyToClipBoard { c {what copy} } {
    global TexPriv tcl_platform
    BeginSelect $c
    
    if { $TexPriv(LatexMode) == "any" } {
	WarnWin [join [list "You should set the option 'Latex eepic or any' " \
		"to 'Latex or eepic' in order to copy the latex " \
		"picture code"] ""]
	return
    }
    
    CopyToVariable $c $what
    if { $tcl_platform(platform) == "windows" } {
	clipboard clear 
	clipboard append $TexPriv(data)
    } else {
	selection handle . SelectionHandler
	selection own .
    }
}

set TexPriv(unitsf) 1

proc PixToUnit { num } {
    global TexPriv
    set zf [lindex $TexPriv(ZoomFactor) 1]
    set retval [expr $zf*$TexPriv(unitsf)*$num/[tk scaling]]
    if { $retval < 1.0 } {
	return [format %.3f $retval]
    } else { return [format %.2f $retval] }
}

proc UnitToPix { num } {
    global TexPriv
    set zf [lindex $TexPriv(ZoomFactor) 1]
    return [expr $num*[tk scaling]/$TexPriv(unitsf)/double($zf)]
}

proc PtToPix { num } {
    global TexPriv
    set zf [lindex $TexPriv(ZoomFactor) 1]
    return [expr  $TexPriv(ZoomFactor)*$num*[tk scaling]/double($zf)]
}

proc CopyToVariable { c what} {
    global TexPriv tcl_platform

    switch $TexPriv(unitstype) {
	pt { set TexPriv(unitsf) 1 }
	in { set TexPriv(unitsf) [expr 1.0/72.0] }
	cm { set TexPriv(unitsf) [expr 2.54/72.0] }
    }
    set TexPriv(data) ""
    if { [$c cget -scrollr] != "" } {
	set w [lindex [$c cget -scrollr] 2]
	set h [lindex [$c cget -scrollr] 3]
    } else {
	set w [winfo width $c]
	set h [winfo height $c]
    }

    set wunit [PixToUnit $w]
    set hunit [PixToUnit $h]

    append TexPriv(data) "\\setlength\{\\unitlength\}\{1$TexPriv(unitstype)\}\n"
    append TexPriv(data) "\\begin{picture}($wunit,$hunit)\n"

    if { $TexPriv(image) != "" } {
	if { $tcl_platform(platform) == "windows" } {
	    set xinit -6
	    set yinit -3
	    append TexPriv(data) "\\put($xinit,[expr $hunit-$yinit]){ \
		    \\special{language \
		    \"Scientific Word\";type \"GRAPHIC\"; \
		    maintain-aspect-ratio TRUE; \
		    display \"USEDEF\";valid_file \"F\"; \
		    width ${wunit}pt;height ${hunit}pt;\
		    depth 0pt;\
		    filename '$TexPriv(image)';file-properties \"XNPEU\";}}\n"
	} else {
	    set imagew [expr .992*$wunit] ;#empiric factor
	    set imageh [expr .999*$hunit]
	    if { $imagew > 1.0 } { set imagew [format %.3f $imagew] }
	    if { $imageh > 1.0 } { set imageh [format %.3f $imageh] }
	    set file $TexPriv(image)
	    if { [file extension $file] == ".gz" } {
		set file [file root $file]
	    }
	    append TexPriv(data) [join [list "\\put(0,0)\{\\psfig" \
		    "\{file=$file,width=$imagew\\unitlength," \
		    "height=$imageh\\unitlength\}\}\n"] ""]
	}
    }

    set TexPriv(currentthicklines) 0
    foreach i [$c find all] {
	switch [$c type $i] {
	    line {
		CopyLines $c $i $h
	    }
	    text { 
		CopyText $c $i $h
	    }
	    oval {
		CopyCircle $c $i $h
	    }
	    rectangle {
		CopyBox $c $i $h
	    }
	    window {
		CopyTextBox $c $i $h
	    }
	}
	if { $what != "copy" } {
	    $c delete $i
	}
    }
    if { $what != "copy" } { set TexPriv(image) "" }
    append TexPriv(data) "\\end{picture}\n"
    
}

proc WriteThickness { c i } {
    global TexPriv
    set width [$c itemcget $i -width]
    if { $width == 1 && $TexPriv(currentthicklines) == 1 } {
	append TexPriv(data) "\\thinlines\n"
	set TexPriv(currentthicklines) 0
    } elseif { $width == 2 && $TexPriv(currentthicklines) == 0} {
	append TexPriv(data) "\\thicklines\n"
	set TexPriv(currentthicklines) 1
    }
}

proc CopyLines {c i h } {
    global TexPriv

    set x1 [lindex [$c coords $i] 0]
    set y1 [lindex [$c coords $i] 1]
    set x2 [lindex [$c coords $i] 2]
    set y2 [lindex [$c coords $i] 3]

    set l [expr sqrt(($x1-$x2)*($x1-$x2)+($y1-$y2)*($y1-$y2))]
    if { $l <5 } { return }

    WriteThickness $c $i
    
    set x [PixToUnit $x1]
    set y [PixToUnit [expr $h-$y1]]

    if { $TexPriv(LatexMode) != "latex" && [llength [$c coords $i]] == 4 && \
	    [$c itemcget $i -arrow] == "none"} {
	set x2u [PixToUnit $x2]
	set y2u [PixToUnit [expr $h-$y2]]
	if { [$c itemcget $i -stipple] == "" } {
	    append TexPriv(data) "\\drawline($x,$y)($x2u,$y2u)\n"
	} else {
	    append TexPriv(data) "\\drawline\[-100]($x,$y)($x2u,$y2u)\n"
	}
	return
    }

    set ret [ReturnAngleAndLength $x1 $y1 $x2 $y2]
    set l [PixToUnit [lindex $ret 0]]
    set xr [lindex $ret 1]
    set yr [expr -1*[lindex $ret 2]]

    if { [llength [$c coords $i]] == 6 } {
	set x3 [lindex [$c coords $i] 4]
	set y3 [lindex [$c coords $i] 5]
	set xc2 [PixToUnit $x2]
	set yc2 [PixToUnit [expr $h-$y2]]
	set xc3 [PixToUnit $x3]
	set yc3 [PixToUnit [expr $h-$y3]]
	if { [$c itemcget $i -stipple] == "" } {
	    append TexPriv(data) "\\qbezier($x,$y)($xc2,$yc2)($xc3,$yc3)\n"
	} else {
	    append TexPriv(data) "\\qbezier\[40]($x,$y)($xc2,$yc2)($xc3,$yc3)\n"
	}
    } elseif { [$c itemcget $i -arrow] == "none" } {
	append TexPriv(data) "\\put($x,$y){\\line($xr,$yr){$l}}\n"
    } elseif { [$c itemcget $i -arrow] == "last" } {
	append TexPriv(data) "\\put($x,$y){\\vector($xr,$yr){$l}}\n"
    } else {
	set xx [PixToUnit $x2]
	set yy [PixToUnit [expr $h-$y2]]
	set mxr [expr -$xr] ; set myr [expr -$yr]
	append TexPriv(data) "\\put($xx,$yy){\\vector($mxr,$myr){$l}}\n"
    }
}

proc CopyText {c i h } {
    global TexPriv
    set x1 [lindex [$c coords $i] 0]
    set y1 [lindex [$c coords $i] 1]
    
    set x [PixToUnit $x1]
    set y [PixToUnit [expr $h-$y1-[font metrics NormalFont -ascent]]]
    set text [$c itemcget $i -text]

    append TexPriv(data) "\\put($x,$y){\\rmfamily $text}\n"
    
}

proc CopyTextBox { c i h } {

    global TexPriv
    set x1 [lindex [$c coords $i] 0]
    set y1 [lindex [$c coords $i] 1]
    
    set x [PixToUnit $x1]
    set y [PixToUnit [expr $h-$y1-[font metrics NormalFont -ascent]]]
    set win [$c itemcget $i -window]

    set text [EncodeTextForLatex $win]
    set w [PixToUnit [$c itemcget $i -width]]

    append TexPriv(data) "\\put($x,$y){\\parbox\[t]{$w\\unitlength}{$text}}\n"
}

proc CopyCircle {c i h } {
    global TexPriv
    
    WriteThickness $c $i

    set x1 [lindex [$c coords $i] 0]
    set y1 [lindex [$c coords $i] 1]
    set x2 [lindex [$c coords $i] 2]
    set y2 [lindex [$c coords $i] 3]
    
    set x [PixToUnit [expr ($x1+$x2)/2.0]]
    set y [PixToUnit [expr $h-($y1+$y2)/2.0]]
    set d [PixToUnit [expr abs($x1-$x2)]]

    if { [$c itemcget $i -fill] == "" } {
	append TexPriv(data) "\\put($x,$y){\\circle{$d}}\n"
    } else {
	append TexPriv(data) "\\put($x,$y){\\circle*{$d}}\n"
    }
}

proc CopyBox {c i h } {
    global TexPriv

    WriteThickness $c $i

    set x1 [lindex [$c coords $i] 0]
    set y1 [lindex [$c coords $i] 1]
    set x2 [lindex [$c coords $i] 2]
    set y2 [lindex [$c coords $i] 3]
    
    set x [PixToUnit [expr ($x1<$x2)?$x1:$x2]]
    set y [PixToUnit [expr $h-(($y1>$y2)?$y1:$y2)]]
    set width [PixToUnit [expr abs($x1-$x2)]]
    set height [PixToUnit [expr abs($y1-$y2)]]

    if { [$c itemcget $i -fill] != "" } {
	append TexPriv(data) "\\put($x,$y){\\rule{$width\\unitlength}{$height\\unitlength}}\n"
    } else {
	append TexPriv(data) "\\put($x,$y){\\framebox($width,$height)}\n"
    }
}


# returns l xr yr x2 y2
proc ReturnAngleAndLength { x1 y1 x2 y2 { vec no } } {

    set l [expr sqrt(($x1-$x2)*($x1-$x2)+($y1-$y2)*($y1-$y2))]
    set signx [expr ($x2>$x1)?1:-1]
    set signy [expr ($y2>$y1)?1:-1]
    set xr [expr abs($x2-$x1)]
    set yr [expr abs($y2-$y1)]

    if { $vec == "no" } {
	set max 6 ; set maxtan 11 ; set mintan 0.08
    } else {
	set max 4 ; set maxtan 8 ; set mintan 0.12
    }
    if { $xr == 0 || [expr double($yr)/$xr] > $maxtan } {
	set besti 0 ; set bestj 1
	set xr 0
	set yr $l
    } elseif { $yr == 0 || [expr double($yr)/$xr] < $mintan } {
	set besti 1 ; set bestj 0
	set xr $l
	set yr 0
    } else {
	set mindist 1e5
	set tan [expr double($yr)/$xr]
	for { set i 1 } { $i <= $max } { incr i } {
	    for { set j 1 } { $j <= $max } { incr j } {
		if { [expr abs($tan-double($j)/$i)] < $mindist } {
		    set besti $i
		    set bestj $j
		    set mindist [expr abs($tan-double($j)/$i)]
		}
	    }
	}
	set angle [expr atan(double($bestj)/$besti)]
	set xr [expr $l*cos($angle)]
	set yr [expr $l*sin($angle)]
	set l $xr
    }
    

    return "$l [expr $signx*$besti] [expr $signy*$bestj] \
	    [expr $x1+$signx*$xr] [expr $y1+$signy*$yr]"

}


proc PreviewDVI { c } {
    global TexPriv tcl_platform global tmpdir
    BeginSelect $c

    if { [$c cget -scrollr] != "" } {
	set w [expr int([lindex [$c cget -scrollr] 2])]
	set h [expr int([lindex [$c cget -scrollr] 3])]
    } else {
	set w [winfo width $c]
	set h [winfo height $c]
    }

    set wunit [expr int([PixToUnit $w])]
    set hunit [expr int([PixToUnit $h])]
 
    catch { unset TexPriv(data) }

    if { $TexPriv(LatexMode) == "any" } {
	WarnWin [join [list "You should set the option 'Latex eepic or any' " \
		"to 'Latex or eepic' in order to preview the latex " \
		"picture code"] ""]
	return
    }

    CopyToVariable $c copy
    if { ![info exists TexPriv(data)] } { return }


    set file [file join $tmpdir texpict[pid].tex]
    set filedvi [file join $tmpdir texpict[pid].dvi]
    set fd [open $file w]
 
    
    puts $fd "\\documentclass\[12pt]{article}"
    if { $TexPriv(image) != "" } {
	puts $fd "\\usepackage{psfig}"
    }
    if { $TexPriv(LatexMode) == "eepic" } {
	if { $tcl_platform(platform) != "windows" } {
	    puts $fd "\\usepackage{epic,eepic}"
	} else {
	    puts $fd "\\usepackage{epic,eepicemu}"
	}
    }
    puts $fd "\\begin{document}"
    puts $fd [concat "This line is written just before the picture "\
	    "environment.\\linebreak"]
    puts $fd $TexPriv(data)
    puts $fd "This line is written just after the picture environment."
    puts $fd "\\end{document}"
    close $fd
    set olddir [pwd]
    cd $tmpdir
    if { $tcl_platform(platform) != "windows" } {
	exec latex "\\nonstopmode\\input{$file}"
	if { $TexPriv(xdviwhat) == "none" } {
	    WarnWin "You do not have 'xdvi' properly installed on your system"
	    return
	} elseif { $TexPriv(xdviwhat) < 22 } {
	    exec xdvi -expert -geometry [expr $w+100]x[expr $h+130]  \
		    $filedvi &
	} else {
	    # option -allowshell is to permit to include compressed EPS
	    # images into the document
	    exec xdvi -expert -geometry [expr $w+100]x[expr $h+130] -allowshell \
		    $filedvi &
	}
    } else {
	if { [catch {
	    exec c:/swp25/tex/initex32.exe \&latex texpict[pid].tex
	}] } {
	    WarnWin [concat "Failed to run 'c:/swp25/tex/initex32.exe'. "\
	    "You need to install Scientific Workplace and/or correct the path "\
	    "in the 'TexPict.tcl' file."]
	    cd $olddir
	    return
	}
	if { [catch {
	    exec c:/swp25/tex/dvigdi32.exe $filedvi &
	}] } {
	    WarnWin [list "Failed to run 'c:/swp25/tex/dvigdi32.exe'. "\
	    "You need to install Scientific Workplace and/or correct the path "\
	    "in the 'TexPict.tcl' file."]
	}
    }
    cd $olddir
}

proc GetFromClipBoard { c } {
    global TexPriv tcl_platform
    BeginSelect $c

    set cur [$c cget -cursor]
    $c conf -cursor watch
    update

    if { $tcl_platform(platform) == "windows" } {
	set TexPriv(data) [selection get -selection CLIPBOARD]
    } else {
	set TexPriv(data) [selection get]
    }   
    SetZoom 1.0
    AddItemsFromVariable $c

    $c conf -cursor $cur
}


proc AddItemsFromVariable { c } {
    global TexPriv

    set setlengthr {^[^\\]*\\setlength\{\\unitlength\}\{([^\{\}]*)\}(.*)}
    set pictr {^[^\\]*\\begin\{picture\}\(([^(,]*),([^)]*)\)(.*)}
    set endr {^[^\\]*\\end\{picture\}(.*)}
    set putr {^[^\\]*\\put\(([^(,]*),([^)]*)\)\{([^
]*)\}(.*)}
    set liner {^[^\\]*\\line\(([^(,]*),([^)]*)\)\{([^{}]*)\}}
    set vecr {^[^\\]*\\vector\(([^(,]*),([^)]*)\)\{([^{}]*)\}}
    set boxr {^[^\\]*\\framebox\(([^(,]*),([^)]*)\)}
    set textr {^[^\\]*\\(rmfamily|sl|slshape)[ ]*(.*)}
    set parboxr {^[^\\]*\\parbox\[t\]\{(.*)\\unitlength\}\{(.*)\}}
    set ruler {^[^\\]*\\rule\{(.*)\\unitlength\}\{(.*)\\unitlength\}}
    set imager {^[^\\]*\\psfig\{[ ]*file=([^,]*),.*\}}
    set circler {^[^\\]*\\circle([*]?)\{([^{}]*)\}}
    set qbezierr {^[^\\]*\\qbezier(\[[^]]*\])?\(([^(,]*),([^)]*)\)\(([^(,]*),([^)]*)\)\(([^(,]*),([^)]*)\)(.*)}
    set thinlinesr {^[^\\]*\\(thicklines|thinlines)(.*)}
    set drawliner {^[^\\]*\\drawline(\[[^]]*\])?\(([^(,]*),([^)]*)\)\(([^(,]*),([^)]*)\)(.*)}
    set dashliner {^[^\\]*\\dashline\{[^\}]*\}\(([^(,]*),([^)]*)\)\(([^(,]*),([^)]*)\)(.*)}
    set commentsr {^[^ ]*%[^
]*(.*)}

    set h [winfo height $c]
    set TexPriv(currentwidth) 1

    while 1 {
	if { [regexp $setlengthr $TexPriv(data) \
		trash unitlength rest] } {
	    if { [regexp {([0-9.]*)pt} $unitlength {} num] } {
		set TexPriv(unitsf) [expr 1.0/$num]
	    } elseif { [regexp {([0-9.]*)cm} $unitlength {} num] } {
		set TexPriv(unitsf) [expr 2.534/(72*$num)]
	    } elseif { [regexp {([0-9.]*)in} $unitlength {} num] } {
		set TexPriv(unitsf) [expr 1.0/(72*$num)]
	    } else {
		WarnWin "Unknown unit in: '$unitlength'"
	    }
	    set TexPriv(data) $rest
	} elseif { [regexp $pictr $TexPriv(data) \
		trash twidth theight rest] } {
	    set w [UnitToPix $twidth]
	    set h [UnitToPix $theight]

	    $c conf -width [expr $w-2*[$c cget -bd]] \
		    -height [expr $h-2*[$c cget -bd]] -scrollregion ""

	    wm geom . ""
	    set geompos +[winfo x .]+[winfo y .]
	    wm geom . $geompos

	    set TexPriv(data) $rest
	} elseif { [regexp $endr $TexPriv(data) \
		trash rest] } {
	    set TexPriv(data) $rest
	} elseif { [regexp $putr $TexPriv(data) trash x y \
		comm rest] } {
	    if { [regexp $liner $comm trash s1 s2 l] } {
		set x1 [UnitToPix $x]
		set y1 [expr $h-[UnitToPix $y]]
		set dx [UnitToPix $l]
		if { $s1 == 0 } {
		    set x2 $x1
		    set y2 [expr $y1-$s2*$dx]
		} else {
		    set signx [expr ($s1>0)?1:-1]
		    set signy [expr ($s2>=0)?-1:1]
		    set tan [expr abs(double($s2)/$s1)]
		    set x2 [expr $x1+$signx*$dx]
		    set y2 [expr $y1+$signy*$dx*$tan]

		}
		$c create line $x1 $y1 $x2 $y2 -width $TexPriv(currentwidth)
	    } elseif { [regexp $vecr $comm trash \
		    s1 s2 l] } {
		set x1 [UnitToPix $x]
		set y1 [expr $h-[UnitToPix $y]]
		set dx [UnitToPix $l]
		if { $s1 == 0 } {
		    set x2 $x1
		    set y2 [expr $y1-$s2*$dx]
		} else {
		    set signx [expr ($s1>0)?1:-1]
		    set signy [expr ($s2>=0)?-1:1]
		    set tan [expr abs(double($s2)/$s1)]
		    set x2 [expr $x1+$signx*$dx]
		    set y2 [expr $y1+$signy*$dx*$tan]

		}
		$c create line $x1 $y1 $x2 $y2 -arrow last \
			-width $TexPriv(currentwidth)
	    } elseif { [regexp $textr $comm trash trash2 text] } {
		set x1 [UnitToPix $x]
		set y1 [expr $h-[UnitToPix $y]-[font metrics NormalFont -ascent]]
		$c create text $x1 $y1 -text $text \
			-font NormalFont -anchor nw
	    } elseif { [regexp $parboxr $comm trash widthr text] } {
		set x1 [UnitToPix $x]
		set y1 [expr $h-[UnitToPix $y]-[font metrics NormalFont -ascent]]
		set width [UnitToPix $widthr]
		set win [.c create window $x1 $y1]
		set txt [CreateTextForBox $win]
		$txt conf -highlightthickness 0

		DecodeTextForLatex $text $txt

  		regexp {^([^.]*)} [$txt index "end"] {} nlines
		set lineheight [font metrics [$txt cget -font] -linespace]
  		set height [expr $nlines*$lineheight]
		$c itemconf $win -window $txt -anchor nw -width $width \
			-height $height
		update idletasks
		set nlinesbase $nlines
		while { [$txt dlineinfo end-1c] == "" } {
		    incr nlines
		    set height [expr int(($nlines+.5)*$lineheight)]
		    $c itemconf $win -height $height
		    update idletasks
		    if { $nlines > $nlinesbase+10 } { break }
		}
	    } elseif { [regexp $circler $comm trash fill d] } {
		set cx [UnitToPix $x]
		set cy [expr $h-[UnitToPix $y]]
		set r  [UnitToPix [expr $d/2.0]]
		set x1 [expr $cx-$r]
		set y1 [expr $cy-$r]
		set x2 [expr $cx+$r]
		set y2 [expr $cy+$r]

		if { $fill == "" } {
		    $c create oval $x1 $y1 $x2 $y2 \
			    -fill "" -width $TexPriv(currentwidth)
		} else {
		    $c create oval $x1 $y1 $x2 $y2 \
			    -fill black
		}
	    } elseif { [regexp $ruler $comm trash width height] } {
		set cx [UnitToPix $x]
		set cy [expr $h-[UnitToPix $y]]
		set widthc [UnitToPix $width]
		set heightc [UnitToPix $height]
		$c create rectangle $cx $cy [expr $cx+$widthc] [expr $cy-$heightc] \
			-fill black
	    } elseif { [regexp $boxr $comm trash width height] } {
		set cx [UnitToPix $x]
		set cy [expr $h-[UnitToPix $y]]
		set widthc [UnitToPix $width]
		set heightc [UnitToPix $height]
		$c create rectangle $cx $cy [expr $cx+$widthc] [expr $cy-$heightc] \
			-width $TexPriv(currentwidth)
	    } elseif { [regexp $imager $comm trash file] } {
		if { ![file exists $file] && [file exists $file.gz] && \
			[file exists $file.bb] } {
		    set file $file.gz
		}
		AddImageF $c $file
	    } else {
		WarnWinText "unknown line inside put: '$comm'"
	    }
	    set TexPriv(data) $rest
	} elseif { [regexp $qbezierr $TexPriv(data) {} \
		dashed xc1 yc1 xc2 yc2 xc3 yc3 rest] } {
	    set x1 [UnitToPix $xc1]
	    set y1 [expr $h-[UnitToPix $yc1]]
	    set x2 [UnitToPix $xc2]
	    set y2 [expr $h-[UnitToPix $yc2]]
	    set x3 [UnitToPix $xc3]
	    set y3 [expr $h-[UnitToPix $yc3]]
	    set l [$c create line $x1 $y1 $x2 $y2 $x3 $y3 -smooth 1  \
		    -width $TexPriv(currentwidth)]
	    if { $dashed != "" } { AddStippleToLine $l }
	    set TexPriv(data) $rest
	} elseif { [regexp $drawliner $TexPriv(data) {} \
		dashed xc1 yc1 xc2 yc2 rest] } {
	    set x1 [UnitToPix $xc1]
	    set y1 [expr $h-[UnitToPix $yc1]]
	    set x2 [UnitToPix $xc2]
	    set y2 [expr $h-[UnitToPix $yc2]]

	    set l [$c create line $x1 $y1 $x2 $y2 \
		    -width $TexPriv(currentwidth)]
	    if { $dashed != "" } { AddStippleToLine $l }
	    set TexPriv(data) $rest
	} elseif { [regexp $dashliner $TexPriv(data) {} \
		xc1 yc1 xc2 yc2 rest] } {
	    set x1 [UnitToPix $xc1]
	    set y1 [expr $h-[UnitToPix $yc1]]
	    set x2 [UnitToPix $xc2]
	    set y2 [expr $h-[UnitToPix $yc2]]

	    set l [$c create line $x1 $y1 $x2 $y2 \
		    -width $TexPriv(currentwidth)]
	    AddStippleToLine $l
	    set TexPriv(data) $rest
	} elseif { [regexp $thinlinesr $TexPriv(data) {} \
		what rest] } {
	    if { $what == "thicklines" } {
		set TexPriv(currentwidth) 2
	    } else { set TexPriv(currentwidth) 1 }
	    set TexPriv(data) $rest
	} elseif { [regexp $commentsr $TexPriv(data) {} \
		rest] } {
	    set TexPriv(data) $rest
	} else {
	    if { ![regexp "^(\[ \1]|\n|\t)*$" $TexPriv(data)] } {
		regexp "^(\[^\n]*)" $TexPriv(data) {} badline
		if { [regexp {[^ ]} $badline] } {
		    WarnWinText "Unknown line '$badline'. Skipping"
		}
		if { ![regexp "\n(.*)" $TexPriv(data) {} TexPriv(data)] } {
		    set TexPriv(data) ""
		}
	    } else { break }
	}
    }
}


set TexPriv(ZoomFactor) "zoom: 1.0"
set TexPriv(ZoomCenterx) 0.0
set TexPriv(ZoomCentery) 0.0

proc SetZoom { absfactor { x 0 } {y 0} } {
    global TexPriv

    if { $absfactor < .05 || $absfactor > 20 } {
	WarnWin "Zoom factor must be between 0.05 to 20"
	focus -force .c
	return
    }

    if { $TexPriv(image) != "" } {
	set inv 0
	if { $absfactor < 1 } { set inv 1 ; set absfactor [expr 1.0/$absfactor] }
	set absfactor [expr int($absfactor)]
	if { $inv } { set absfactor [expr 1.0/$absfactor] }
    }

    set factor [expr [lindex $TexPriv(ZoomFactor) 1]/double($absfactor)]
    if { $factor == 1 } { return }
    set TexPriv(ZoomFactor) "zoom: [format %.2f $absfactor]"
    set region [.c cget -scrollregion]
    if { $region == "" } { set region "0 0 [winfo width .c] [winfo height .c]" }

    set realw [lindex $region 2]
    set realh [lindex $region 3]

    set xper [expr $x/double($realw)]
    set yper [expr $y/double($realh)]

    .c conf -scrollregion "0 0 [expr $realw*$factor] [expr $realh*$factor]"
    .c xview moveto [expr $xper-$absfactor/2.0]
    .c yview moveto [expr $yper-$absfactor/2.0]

    foreach i [.c find all]  {
	.c scale $i 0 0 $factor $factor
	if { [.c type $i] == "image" } {
	    set cur [.c cget -cursor]
	    .c conf -cursor watch
	    update
	    AddImageF .c $TexPriv(image) $absfactor
	    .c conf -cursor $cur
	}
    }
    font configure NormalFont -size [expr int($TexPriv(NormalFontSize)/$absfactor)]
    font configure ScriptFont -family helvetica -size \
	    [expr int(.8*$TexPriv(NormalFontSize)/$absfactor)]
    font configure SymbolFont -family symbol -size \
	    [expr int($TexPriv(NormalFontSize)/$absfactor)]

    if { $absfactor < 1.0 } {
	grid .buts -row 1 -col 1 -sticky ns -rowspan 2
	grid .f0 -row 1 -col 2 -sticky nsew
	grid .yscroll -row 1 -col 3 -sticky ns
	grid .xscroll -row 2 -col 2 -sticky ew
	grid .f -row 3 -col 1 -columnspan 3 -sticky ew
    } else {
	grid forget .yscroll .xscroll
	grid .buts -row 1 -col 1 -sticky ns
	grid .f0 -row 1 -col 2 -sticky nsew
	grid .f -row 2 -col 1 -columnspan 2 -sticky ew
	
	if { $absfactor > 1 } {
	    grid forget .f0
	    grid .f0 -row 1 -col 2
	    set region [.c cget -scrollregion]
	    .c conf -width [lindex $region 2]
	    .c conf -height [lindex $region 3]
	}
    }
    if { $absfactor == 1.0 } {
	.c conf -scrollregion ""
	.c xview moveto 0
	.c yview moveto 0
    }
    focus -force .c
}

proc EnterZoomFactor {} {
    global TexPriv

    toplevel .zf

    wm title .zf "Zoom factor"
    wm geom  .zf "+[expr [winfo x .]+40]+[expr [winfo y .]+40]"

    label .zf.l -text "Enter new zoom factor\nFrom 0.05 to 20" \
	    -font BigFont
    set width [font measure BigFont "Enter new zoom factor"]
    label .zf.l2 -text "Zoom can be also achieved with right-mouse\
	    or shift-right-mouse." -font NormalFontGUI -wraplength $width
    set TexPriv(ZoomFactorTmp) [lindex $TexPriv(ZoomFactor) 1]
    entry .zf.e -relief sunken -textvariable TexPriv(ZoomFactorTmp)
    focus .zf.e
    .zf.e sel from 0
    .zf.e sel to end
    button .zf.ok -text OK -command {destroy .zf  ; SetZoom $TexPriv(ZoomFactorTmp)}
    button .zf.cancel -text Cancel -command "destroy .zf"

    grid .zf.l -columnspan 2 
    grid .zf.l2 -columnspan 2 
    grid .zf.e -columnspan 2 -sticky ew
    grid .zf.ok .zf.cancel -padx 3 -pady 3

    bind .zf.e <Return> {
	.zf.ok conf -relief sunken
	after 300
	.zf.ok conf -relief raised
	.zf.ok invoke
    }
    bind .zf.e <Escape> ".zf.cancel invoke"
}

proc EnterCircleRadius { { filled no } } {
    global TexPriv

    toplevel .cr

    wm title .cr "Enter circle by radius"
    wm geom  .cr "+[expr [winfo x .]+40]+[expr [winfo y .]+40]"

    label .cr.l -text "Enter radius of the circle" \
	    -font BigFont
    entry .cr.e -relief sunken -textvariable TexPriv(CircleRadius)
    focus .cr.e
    .cr.e sel from 0
    .cr.e sel to end
    button .cr.ok -text OK -command "\
	    destroy .cr  ; CreateCircle .c \"$filled \$TexPriv(CircleRadius)\""
    button .cr.cancel -text Cancel -command "destroy .cr"

    grid .cr.l -columnspan 2 
    grid .cr.e -columnspan 2 -sticky ew
    grid .cr.ok .cr.cancel -padx 3 -pady 3

    bind .cr.e <Return> {
	.cr.ok conf -relief sunken
	after 300
	.cr.ok conf -relief raised
	.cr.ok invoke
    }
    bind .cr.e <Escape> ".cr.cancel invoke"
}

proc ModifyOneEntityDo { baseentry inum ent } {
    
    set comm ".c coords $ent "
    for { set i 1 } { $i <= $inum } { incr i } {
	append comm "[${baseentry}x$i get] [${baseentry}y$i get] "
    }
    eval $comm
}

proc ModifyOneEntity {} {
    global TexPriv

    if { [llength $TexPriv(selected)] == 0 } {
	WarnWin "It is necessary to select previously one entity"
	return
    }
    if { [llength $TexPriv(selected)] > 1 } {
	WarnWin "Only one entity can be selected"
	return
    }
    toplevel .moe

    wm title .moe "Modify entity"
    wm geom  .moe "+[expr [winfo x .]+40]+[expr [winfo y .]+40]"

    label .moe.l -text "Enter new coordinates" \
	    -font BigFont
    
    grid .moe.l -columnspan 2
    set inum 0
    foreach "x y" [.c coords $TexPriv(selected)] {
	incr inum
	label .moe.lx$inum -text x$inum:
	entry .moe.ex$inum -relief sunken
	 .moe.ex$inum ins end $x
	grid .moe.lx$inum .moe.ex$inum

	label .moe.ly$inum -text y$inum:
	entry .moe.ey$inum -relief sunken
	.moe.ey$inum ins end $y
	grid .moe.ly$inum .moe.ey$inum
	
    }

    focus .moe.ex1
    grab .moe
    wm transient .moe .

    frame .moe.f
    button .moe.f.ok -text OK -command "ModifyOneEntityDo .moe.e $inum \
	    $TexPriv(selected) ; destroy .moe" -u 0
    button .moe.f.cancel -text Cancel -command "destroy .moe" -u 0

    grid .moe.f.ok .moe.f.cancel -padx 3 -pady 3

    grid .moe.f -columnspan 2
    grid columnconf .moe 2 -weight 1

    bind .moe <Return> {
	.moe.f.ok conf -relief sunken
	after 300
	.moe.f.ok conf -relief raised
	.moe.f.ok invoke
    }
    bind .moe <Escape> ".moe.f.cancel invoke"
}

set TexPriv(HelpSystem) .helpsystem

proc DisplayTexHelp { w text but x y } {
    global TexPriv

    catch { 
	destroy $TexPriv(HelpSystem)
    }

    set tag ""
    if { [llength $w] == 2 } {
	set tag [lindex $w 1]
	set w [lindex $w 0]
    }

    if { $y < [expr [winfo screenheight $w]/2.0] } {
	set y +$y
    } else {
	set y -[expr [winfo screenheight $w]-$y]
    }
    if { $x < [expr [winfo screenwidth $w]/2.0] } {
	set x +$x
    } else {
	set x -[expr [winfo screenwidth $w]-$x]
    }

    toplevel $TexPriv(HelpSystem)
    wm overrideredirect $TexPriv(HelpSystem) 1
    wm geom $TexPriv(HelpSystem) $x$y
    label $TexPriv(HelpSystem).l -relief ridge -bg white -fg black \
	    -justify left -text $text -wraplength 10c
    pack $TexPriv(HelpSystem).l

    if { $tag == "" } {
	bind $w <ButtonRelease-$but> " \
		catch { destroy $TexPriv(HelpSystem) } ; \
		bind $w <ButtonRelease-$but> {}"
    } else {
	$w tag bind $tag <ButtonRelease-$but> " \
		catch { destroy $TexPriv(HelpSystem) } ; \
		$w tag bind $tag <ButtonRelease-$but> {}"
    }   
}

proc TexHelp { wlist args } {
    foreach w $wlist {
	set text [join $args]
	set tag ""
	if { [llength $w] == 2 } {
	    set tag [lindex $w 1]
	    set w [lindex $w 0]
	}
	if { $tag == "" } {
	    bind $w <ButtonPress-2> \
		    "[list DisplayTexHelp $w $text 2 %X %Y]; break"
	    bind $w <ButtonPress-3> \
		    "[list DisplayTexHelp $w $text 3 %X %Y]; break"
	    foreach i [winfo children $w] {
		TexHelp $i $text
	    }
	} else {
	    $w tag bind $tag <ButtonPress-2> \
		    "[list DisplayTexHelp $w $text 2 %X %Y]; break"
	    $w tag bind $tag <ButtonPress-3> \
		    "[list DisplayTexHelp $w $text 3 %X %Y]; break"
	}
    }
}


set TexHelpPriv(allhelpnames) "initial download requirements advan/disadvan \
	interachelp workmodes snaptopoint copypaste addimage viewdvi \
	customizing emacs author changes"

set TexHelpPriv(initial) "\
<title>Help system for Tex Pictures</title>\
<h2>Overview</h2>\
Tex Pictures is a program to create easy drawings to include in latex\
documents in both Unix and MS Windows.\
It is possible also to save them as postscript.\n\
Some of the most interesting features are:\
<p>\
<h4>-<a href=\"#download\">Download and execute.</a></h4>\n\
<h4>-<a href=\"#requirements\">Requirements.</a></h4>\n\
<h4>-<a href=\"#advan/disadvan\">Advantages/Disadvantages.</a></h4>\n\
<h4>-<a href=\"#interachelp\">Interactive help.</a></h4>\n\
<h4>-<a href=\"#workmodes\">Working modes.</a></h4>\n\
<h4>-<a href=\"#snaptopoint\">Snap to point/line.</a></h4>\n\
<h4>-<a href=\"#copypaste\">Cut, Copy and Paste.</a></h4>\n\
<h4>-<a href=\"#addimage\">Add image.</a></h4>\n\
<h4>-<a href=\"#viewdvi\">View DVI.</a></h4>\n\
<h4>-<a href=\"#customizing\">Customizing.</a></h4>\n\
<h4>-<a href=\"#emacs\">Emacs users.</a></h4>\n\
<h4>-<a href=\"#author\">Author.</a></h4>\n\
<h4>-<a href=\"#changes\">Changes.</a></h4>\n\
"

set TexHelpPriv(download) "\
<h2>Download and execute</h2>\
Current version is $TexPriv(Version)\
<h4>Download tar.gz format (UNIX): \
<a href=\"http://gatxan.cimne.upc.es/texpict/TexPict.tar.gz\">TexPict.tar.gz.</a></h4>\
<h4>Download zip format (Windows): \
<a href=\"http://gatxan.cimne.upc.es/texpict/TexPict.zip\">TexPict.zip.</a></h4>\
<p>TexPict oficial web page is: <a href=\"http://gatxan.cimne.upc.es/texpict\">\
http://gatxan.cimne.upc.es/texpict.</a>\
<p>The .tar.gz version should be untarred with something like:\
gunzip -c TexPict.tar.gz | tar xvf -\
<p>To execute the program:\
<h4>- Unix</h4> Check the first few lines of the executable file\
to see if the command: 'exec wish8.0 ...' points to your wish. Check
the permissions 'chmod ugo+x TexPict.tcl' and execute.\
<h4>- Windows</h4>If you have Tcl-Tk properly installed, there are several\
methods: Click twice on it; drop it over the wish icon; create a link to\
the file and modify the link execution path to\
 'c:\...\wish8.0 c:\...\TexPict.tcl'.\
<p>Enjoy!\
<p><a href=\"#initial\">Return.</a> \
" 


set TexHelpPriv(requirements) "\
<h2>Requirements</h2>\
To run TexPrict properly it is necessary:
<h4>- Tcl-Tk</h4>It has been tested with Tcl-Tk v8.0\
To obtain it check: \
<a href=\"http://www.tcltk.com\">http://www.tcltk.com</a>\
<h4>- gs -the postscript displayer-</h4> (only for Unix).\
It is necessary only if EPS are to be displayed in the program.\
<h4>- epic.sty eepic.sty eepicemu.sty</h4>These latex style files \
are not necessary\
but if used, the quality of the final drawing improves and there are\
less geometric restrictions.
<h4>- xdvi (Unix) SWP (Windows) </h4> Only necessary if previews\
of the drawings after running latex are needed. CAUTION: xdvi is called\
with option -allowshell. Old version may not support this option. In this\
 case, erase the option from the code. It is only necessary for gzziped\
 images. Contact author for more information.

<p>For any question or suggestion mail to:\
<a href=\"mailto:ramsan@cimne.upc.es\">ramsan@cimne.upc.es</a>.\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(advan/disadvan) "\
<h2>Advantages and Disadvantages</h2>\
Next lines try to define why use or not use\
TextPict.
<h2>Advantages</h2>\
<h4>- Easy.</h4> Very easy to use.\
<h4>- Useful.</h4>Specially useful for UNIX where there are not many nice\
utilities.\
<h4>- Annotate images.</h4>Useful to annotate one EPS or GIF image and \
include the figure and the annotations inside the latex document.\
<h4>- One latex file.</h4>Pictures are included inside the latex document.\
They are VERY small and avoid too many files.\
<h4>- Later edition.</h4>You can edit later the figure that you have pasted\
in your latex document. Just select it, and paste inside TexPict. In this\
way, one drawing from 3 month ago can be edited. With a EPS or GIF\
file it would be no possible.\
<h4>- Customization.</h4> You can modify the Tcl-Tk source code to adapt the\
 program to your requirements.\
<h2>Disadvantages</h2>\
<h4>- Previous installations.</h4>You need to have Tcl-Tk installed on your\
 system.\
<h4>- Very complex drawings</h4>TexPict is not powerful enough to make very\
complex drawings.\
<h4>- PS and images.</h4>When writing postscript files,the background image\
will not be included in the ps file.\
It cannot include either the 'Text box'.\
<h4>- Latex limitations.</h4>Latex mode have some geometric limitations. eepic\
 mode needs the style files and a good DVI driver.\
<h4>- Latex knowledge.</h4>User should have a little bit of latex knowledge.\
<h2>Conclusions</h2>\
The typical scientific document or PhD thesis, have 80% of the drawings\
that are easy schemes. They can be created with TexPict and avoid disk usage\
and many files. Some other images are made with another program and need to\
be annotated. It can be made with TexPict. Finally, a few, very few images\
should be made with another program. TexPict works properly with latex or\
with Scientific Workplace.\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(interachelp) "\
<h2>Interactive help</h2>\
It is possible to obtain some help about any button\
by pressing mouse button 2 or 3 over that button or label.\
<p><a href=\"#initial\">Return.</a>\
"
set TexHelpPriv(workmodes) "\
<h2>Working modes</h2>\
There are 3 working modes:
<h4>-Latex mode</h4>\
When copying and pasting the drawing, a picture\
environment is created fully compatible with any latex\
installation. It has many geometric restrictions like: a\
finite number of slopes for lines and vectors; small\
radius for circles.\n\
<h4>-eepic mode</h4>\
To make it work with latex it is necessary to have the epic\
and the eepic packages installed. This means to have the files\
epic.sty, eepic.sty and eepicemu.sty in the working directory or in the latex\
installation. It is also necessary to include the packages in the following\
way: '\\usepackage{epic,eepic}'.\
With this mode, the geometric restrictions are much better.\n\
If working with Scientific Workplace, that line is inserted in:\
'File DocumentInfo Preamble'. Note that probably you will have to use:\
'\\usepackage{epic,eepicemu}' that is a emulation for drivers that do\
not support the style 'eepic'.
<h4>-Any mode</h4>\
It has no geometric restrictions but the resulting drawing cannot be pasted\
in a latex document. It can be useful when writing postscript files.\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(snaptopoint) "\
<h2>Snap to point</h2>\
If this option is set, when creating entities\
or moving circles, if the mouse is close to the end\
point of one existing entity, the cursor changes and\
one circle-like cursor appears. It means that the exact\
end point of the existing entity will be chosen.\
If the cursor is over one straight line, it changes to one\
angle and one point over the line is chosen.\
<p>To change the snap option in the middle of one operation,\
use 'Ctrl-t'.\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(copypaste) "\
<h2>Cut, Copy and Paste</h2>\
Commands 'Cut' and 'Copy', copy to the clipboard or X-selection,\
the latex commands necessary to recreate the figure. Please,\
remember the <a href=\"#workmodes\">eepic</a> problem.\
The usual way of working is to draw the painting, copy to clipboard\
and finally, paste to your latex document.\n\
If working with Scientific Workplace, the Paste must be done inside\
a 'Insert field TeX'\n\
Command 'Paste', can read again the information written with the\
other commands. So, After doing 'Cut' 'Paste', the drawing shouldn't\
change. Commands to select before pasting inside TexPict go from:
<p>\\setlength...\
<p>...\
<p>\\end{picture}\
<p>Latex commands should not be changed too much to make everything work.\
<h4>Note:</h4>Remember the line to write at the beginning of the file if\
you are in <a href=\"#workmodes\">eepic</a> mode.
<p>The size of the picture environment copied from TexPict will be equal\
to the size of TexPict window (only for zoom=1). So it is better to resize\
the window when the zoom is set to 1. When adjusting the image in the latex\
document, if the size is not correct, it can be changed in the command:\
<p>\\setlength{\\unitlength}{1cm}\
<p>For example, to make the picture smaller set:\
<p>\\setlength{\\unitlength}{.7cm}\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(addimage) "\
<h2>Add figure</h2>\
It is possible to add one image read from a file.\
In Unix, the format must be EPS (encapsulated postscript)\
and in Windows it can be gif. Note: To be able to read EPS\
in Unix, it is necessary to have the 'gs' program installed.\
This image will be included in the latex file. Note: when\
including files in Unix, the psfig package is used, so it is\
necessary one line at the beginning of the latex file of the form:\
'\\usepackage{psfig}'.\
<p>Option 'Write Postscript file' cannot print this image.\
<h4>Note for TeXperts:</h4>\
It is possible to use gzziped EPS files in UNIX. To do so, xdvi must\
be a new version (option -allowshell), and style file 'psfig.sty' must\
be modified a little bit. Contact author to obtain the modified\
 'psfig.sty' file.
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(viewdvi) "\
<h2>View DVI</h2>\
This option runs latex on the current drawing\
and opens a DVI previewer (xdvi for Unix and SWP\
for Windows). The drawing will appear in the DVI\
previewer. Please, remember the <a href=\"#workmodes\">eepic</a>\
problem. Especially, in 'eepic' mode, the files 'epic.sty' and\
others must be installed in the latex distribution or must be copied\
in the temporal directory.\
<p><a href=\"#initial\">Return.</a>\
"

set TexHelpPriv(customizing) "\
<h2>Customizing</h2>\
You can change the source Tcl-Tk to fit your needs.\
You should not redistribute your changes. At least, if\
you do, write clearly everywhere the changes you have made.\
If the changes are valuable, please send a copy to the mantainer.\
<p> The easiest thing to change is to set the preferences to your needs.\
To do so, just modify the function 'SetPreferences' at the beginning of\
the file.\
<p>A useful key when doing changes is F2. With this key, the TCL source\
file and the TCL library files are reloaded. So, it is possible to check\
one change in the TCL code without leaving the program.\
<p><a href=\"#initial\">Return.</a>\
"

set func1 {[?\C-r ?\\ ?b ?e ?g ?i ?n ?\{ ?f ?i ?g ?u ?r ?e ?\} \
	down down down ?\C-y ?\C-  ?\C-s ?\\ ?c ?a ?p ?t ?i ?o ?n ?\C-a ?\C-w]}
set func2 {[?\C-r ?\\ ?s ?e ?t ?l ?e ?n ?g ?t ?h ?\{ ?\\ ?u ?n ?i ?t ?l ?e ?n ?g \
	?t ?h ?\C-a ?\C-  ?\C-s ?\\ ?e ?n ?d ?\{ ?p ?i ?c ?t ?u ?r ?e ?\} ?\M-w]}

set TexHelpPriv(emacs) "\
<h2>Emacs users</h2>\
If you add the following to your .emacs file:\
<p>(fset 'insert-new-picture\
<p> $func1 )\
<p>(fset 'copy-picture\
<p> $func2 )\
<p>(global-set-key \"\\C-c\\C-y\" 'insert-new-picture)\
<p>(global-set-key \"\\C-c\\M-w\" 'copy-picture)\
<p>You will have two new useful options. Having the cursor in the middle\
of an existing picture, after doing 'copy' in TexPict, the first function\
will paste the new picture and remove the old one at the same time. The\
second function, selects the region around the existing picture in emacs and\
copy it to the X-selection. Later, you can do a 'paste' inside TexPict.\
<p><a href=\"#initial\">Return.</a>\
"
set TexHelpPriv(author) "\
<h2>Author</h2>\
Ramon Rib (I programmed it to be able to write my PhD thesis.).\
<p>web page: <a href=\"http://gatxan.cimne.upc.es/ramsan\">\
http://gatxan.cimne.upc.es/ramsan</a>\
<p>mail: <a href=\"mailto:ramsan@cimne.upc.es\">\
ramsan@cimne.upc.es</a>
<p>If I have been able to do most of my PhD drawings with TexPict,\
you also can...\
<p><a href=\"#initial\">Return.</a>\
"


set TexHelpPriv(changes) "\
<h2>Changes from 1.0 to 1.2</h2>\
<p>-. Text is exported better positioned.\
<p>-. Small gap between cursor and drawn line corrected.\
<p>-. Implemented entering a circle by radius.\
<p>-. Bitmap submenus without the subsubmenu arrow.\
<p>-. Option -allowshell is controlled by checking xdvi version.\
<p><a href=\"#initial\">Return.</a>\
"


set TexHelpStackPriv(current) 0
set TexHelpStackPriv(last) 0

proc DisplayHelp { page {addtostack yes} } {
    global TexHelpPriv TexHelpStackPriv

    if { [string match #* $page] } {
	set page [string range $page 1 end]
    } else {
	WarnWin "Check the URL: $page"
	return
    }

    if { $addtostack == "yes" } {
	incr TexHelpStackPriv(current)
	set TexHelpStackPriv(last) $TexHelpStackPriv(current)
	set TexHelpStackPriv($TexHelpStackPriv(current)) $page
    }

    set w .c.help
    set t $w.f.t
    if { ![winfo exists .c.help] } {
	toplevel $w
	wm title $w "Tex pictures help"

	set p [winfo toplevel [winfo parent $w]]
	wm geom $w +[expr [winfo x $p]+20]+[expr [winfo y $p]+20]


	frame $w.f
	text $w.f.t -width 50 -height 25 -yscroll "$w.f.yscroll set" \
		-padx 5 -wrap word
	scrollbar $w.f.yscroll -relief sunken -command "$w.f.t yview"
	pack $w.f.yscroll -side right -fill y
	pack $w.f.t  -expand yes -fill both -anchor nw
	$w.f.t conf -state disabled
	button $w.b -text Close -command "destroy $w" -u 0
	bind $w <Alt-c> "$w.b invoke ; break"
	pack $w.f -side top -fill both -expand 1
	pack $w.b -side bottom
	$t conf -cursor ""
	focus $t
	
	bind $w <Alt-Left> {
	    if { $TexHelpStackPriv(current) > 1 } {
		incr TexHelpStackPriv(current) -1
		DisplayHelp #$TexHelpStackPriv($TexHelpStackPriv(current)) no
	    }
	}
	bind $w <Alt-Right> {
	    if { $TexHelpStackPriv(current) < $TexHelpStackPriv(last) } {
		incr TexHelpStackPriv(current) 1
		DisplayHelp #$TexHelpStackPriv($TexHelpStackPriv(current)) no
	    }
	}
    } else { raise $w }
    
    $w.f.t conf -state normal
    $t del 1.0 end
    regsub -all {<p>} $TexHelpPriv($page) \n\n aa
    $t ins 1.0 $aa

    set currentidx 1.0
    while 1 {
	set currentidx [$t search -regexp -nocase -count endpos -- \
		{<[ ]*a[ ]*href="([^"]*)"[ ]*>([^<]*)<[ ]*/a[ ]*>} $currentidx end]
	if { $currentidx == "" } { break }
	set endpos [$t index "$currentidx+${endpos}c"]
	set text [$t get $currentidx $endpos]
	$t del $currentidx $endpos
	regexp -nocase {<[ ]*a[ ]*href="([^"]*)"[ ]*>([^<]*)<[ ]*/a[ ]*>} $text \
		{} ref name
	$t ins $currentidx $name hyper$currentidx
	$t tag conf hyper$currentidx -foreground blue
	$t tag bind hyper$currentidx <Enter> "\
	    set TexPriv(cursor) \[$t cget -cursor] ;\
	    $t conf -cursor hand2 ;\
	    "
	$t tag bind hyper$currentidx <Leave> "\
		$t conf -cursor \$TexPriv(cursor)"


	$t tag bind hyper$currentidx <1> "DisplayHelp $ref"

	set currentidx [$t index "$currentidx +1c"]
    }
    set idx 1.0
    while 1 {
	set idx [$t search -regexp -nocase -count endpos -- \
		{<[ ]*(title|h1|h2|h3|h4)[ ]*>} $idx end]
	if { $idx == "" } { break }
	set idxspace [$t index "$idx-1c"]
	while { $idxspace > 1.0 && [$t get $idxspace] == " " } {
	    set idxspace [$t index "$idxspace-1c"]
	}
	if { [$t get $idxspace] != "\n" } {
	    $t ins $idx \n
	    set idx [$t index $idx+1c]
	}
	
	set endpos [$t index "$idx+${endpos}c"]
	set text [$t get $idx $endpos]
	$t del $idx $endpos
	regexp -nocase {<[ ]*(title|h1|h2|h3|h4)[ ]*>} $text {} level
	set level [string tolower $level]

	set idxend [$t search -regexp -nocase -count endpos -- \
		"<\[ ]*/${level}\[ ]*>" $idx end]
	if { $idxend == "" } {
	    WarnWin "error: </$level> not found after position $idx"
	    break
	}
	$t del $idxend "$idxend+${endpos}c"

	set idxspace [$t index "$idxend"]
	while { $idxspace < [$t index end]  && [$t get $idxspace] == " " } {
	    set idxspace [$t index "$idxspace+1c"]
	}
	if { [$t get $idxspace] != "\n" } {
	    $t ins $idxend \n
	}
	$t tag add title$idx $idx $idxend
	set font [$t cget -font] 

	switch $level {
	    title { 
		set size [expr int([font actual $font -size]*1.8)]
		set jus center
		set sp [expr $size*1]
	    }
	    h1 - h2 - h3 {
		set size [expr int([font actual $font -size]*1.2)]
		set jus left
		set sp [expr $size*1]
	    }
	    h4 {
		set size [expr int([font actual $font -size]*1)]
		set jus left
		set sp [expr $size*.4]
	    }
	}
	
	$t tag conf title$idx -font "[font actual $font -family] $size bold" \
		-justify $jus -spacing1 $sp -spacing2 $sp \
		-spacing3 $sp
	set idx $idxend
    }


    $w.f.t conf -state disabled
}

proc PrintHTMLHelp {} {

    set types {
	{{HTML files}       {.html .htm}   }
	{{All Files}        *             }
    }
    
    set file [tk_getSaveFile -parent .c  \
	    -title "Save HTML help" \
	    -filetypes $types]
    if { $file == "" } { return }
    PrintHTMLHelpF $file
}

proc PrintHTMLHelpF { file } {
    global TexHelpPriv

    set fd [open $file w]
    foreach i $TexHelpPriv(allhelpnames) {
	puts $fd "<a name=\"$i\"></a>"
	puts $fd $TexHelpPriv($i)
    }
    close $fd
}

proc PrintTextHelp {} {

    set types {
	{{All Files}        *             }
    }
    
    set file [tk_getSaveFile -parent .c  \
	    -title "Save Text help" \
	    -filetypes $types]
    if { $file == "" } { return }
    PrintTextHelpF $file
}

proc PrintTextHelpF { file } {
    global TexHelpPriv
    
    set fd [open $file w]
    foreach i $TexHelpPriv(allhelpnames) {
	set help $TexHelpPriv($i)
	regsub -all {Return.} $help {} help
	regsub -all {<a[^>]*>} $help {} help
	regsub -all {</a[^>]*>} $help {} help
	regsub -all {<p[^>]*>} $help \n help
	
	regsub -all {\[} $help {\[} help
	regsub -all {<title[^>]*>([^<]*)</title[^>]*>} $help \
		"\n\[string toupper [list \\1]]\n" help
	regsub -all {<h2[^>]*>([^<]*)</h2[^>]*>} $help \
		"\n\[string toupper [list \\1]]\n" help
	regsub -all {</?h[^>]*>} $help \n help
	set help [subst $help]

	set idx 0
	while 1 {
	    if { [string length [string range $help $idx end]] <=70 } { break }
	    set idxnew [string first \n [string range $help $idx end]]
	    if { $idxnew == -1 || $idxnew > 70 } {
		set idxnew [expr 70 + [string first " " [string range $help \
			[expr $idx+70] end]]]
		set help [string range $help 0 [expr $idx+$idxnew]]\n[string range $help \
			[expr $idx+$idxnew+1] end]
		
	    }
	    set idx [expr $idx+$idxnew+1]
	}

	puts $fd $help
    }
    close $fd
}

proc DisplayAbout {} {
    global TexPriv
    set w .c.about

    toplevel $w
    wm title $w "Tex pictures about"
    
    set p [winfo toplevel [winfo parent $w]]
    wm geom $w +[expr [winfo x $p]+20]+[expr [winfo y $p]+20]


    label $w.l1 -text "Tex pictures v$TexPriv(Version)" \
	    -font "helvetica 18 bold underline"
    label $w.l2 -text "Program to create latex pictures and postscript"

    label $w.l3 -image $TexPriv(ramsan)

    label $w.l4 -text "By Ramon Rib -------- RAMSAN\nramsan@cimne.upc.es" \
	    -font "helvetica 12 bold" -justify left

    grid $w.l1
    grid $w.l2
    grid $w.l3
    grid $w.l4
    button $w.close -text close -command "destroy $w"
    grid $w.close

}

proc WarnWin { text { par .gid}} {

    set w .__WarnWin
    tk_dialog  $w Warning $text warning 0 OK
}

######################################################################
######################################################################


if { ![info exists isinit] } {
    set TexPriv(creatingobj) ""
    set TexPriv(tmpobj) ""
    set TexPriv(image) ""


    if { $argc >= 1 } {
	if { $argc > 1 || [lindex $argv 0] != "--write-help-files" } {
	    wm withdraw .
	    puts "Usage: '$argv0' or '$argv0 \[--write-help-files]'"
	    exit
	}
	PrintHTMLHelpF TexPict.html
	PrintTextHelpF README
	wm withdraw .
	puts "Written files: TexPict.html and README"
	exit
    }


	set TexPriv(xdviwhat) none
    if { $tcl_platform(platform) != "windows" } {
	catch {
	    set xdviver [exec xdvi -version]
	    regexp -nocase {version[ ]*([0-9.]+)} $xdviver {} vernum
	    set TexPriv(xdviwhat) $vernum
	}

    }


    SetUpFunc
    set isinit 0
}
incr isinit ;#this var is used when sourceing the file again to debug

set TexPriv(ramsan) [image create bitmap -data {
#define ramsan_width 279
#define ramsan_height 226
static char ramsan_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x00,
 0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
 0x07,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x20,0x30,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x0e,0x00,0x00,0x10,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x10,0x40,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x08,0x80,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,
 0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0xe8,0x81,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,
 0x00,0x00,0x00,0xe8,0x83,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0xe8,0x83,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0xf0,0x43,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x81,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,
 0x00,0x00,0x00,0xe0,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x70,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x1e,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x60,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x09,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0x06,
 0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x42,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa1,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x58,0x00,
 0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc0,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x24,0x00,0x00,0x00,0x00,0x00,0x00,
 0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x22,0x00,
 0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,
 0x00,0x00,0x10,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x05,0x00,0x00,0x00,0x00,0x00,0xe0,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x04,0x00,
 0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc8,0x04,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x04,0x00,0x00,0x00,0x00,0x00,0x04,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x04,0x00,
 0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc8,0x02,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x04,0x00,0x00,0x00,0x00,0x1c,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0xc8,0x04,0x00,
 0x00,0x00,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
 0x00,0x00,0xd0,0x04,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x18,0x00,0x00,0x00,0x80,0x01,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x19,0x00,
 0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
 0x00,0x00,0x20,0x21,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x04,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x42,0x00,0x00,0x00,0x06,0x00,0x00,
 0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x42,0x00,
 0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x85,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x03,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9a,0x00,0x00,0x40,0x00,0x00,0x00,
 0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x01,
 0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x24,0x06,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x58,0x08,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x58,0x08,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0xa0,0x10,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x11,0x80,0x00,0x00,0x00,0x00,
 0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x11,
 0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x40,0x26,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x26,0x80,0x00,0x00,0x00,0x00,
 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x26,
 0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x80,0x46,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x48,0x80,0x01,0x00,0x00,0x00,
 0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x49,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x80,0x48,0x00,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
 0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x48,0x00,0x7c,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x48,
 0x00,0x80,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x80,0x48,0x00,0x00,0x00,0x10,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x48,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x48,
 0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x40,0x28,0x00,0x00,0x00,0x00,0xf0,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x28,0x00,0x00,0x00,0x00,0xf0,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x1e,
 0x00,0x00,0x00,0x00,0x0c,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x18,0x07,0x00,0x00,0x00,0x80,0x03,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc6,0x01,0x00,0x00,0x00,0x60,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xe1,0x00,
 0x00,0x00,0x00,0x1c,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc0,0xe1,0x00,0x00,0x00,0x00,0x1c,0xc0,0x03,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x3c,0x00,0x00,0x00,0x00,0x03,0x30,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x1e,0x00,
 0x00,0x00,0xe0,0x00,0x0c,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0xc4,0x03,0x00,0x00,0x00,0x18,0x80,0x03,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0xe3,0x00,0x00,0x00,0x00,0x06,0x60,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x80,0xd0,0x00,0x00,
 0x00,0xc0,0x01,0x1c,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x80,0xd0,0x00,0x00,0x00,0xc0,0x01,0x1c,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x40,0x28,0x00,0x00,0x00,0x30,0x00,0x03,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x20,0x14,0x00,0x00,
 0x00,0x0e,0xe0,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x18,0x0b,0x00,0x00,0xc0,0x01,0x1c,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x98,0x04,0x00,0x00,0x38,0x80,0x03,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x84,0x04,0x00,0x00,
 0x06,0x60,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x84,0x04,0x00,0x00,0x06,0x60,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x44,0x04,0x00,0xc0,0x01,0x1c,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x44,0x03,0x00,0x30,
 0x00,0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x42,0x03,0x00,0x0e,0xc0,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x22,0x03,0x80,0x01,0x38,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x22,0x03,0x80,0x01,
 0x38,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0xa2,0x00,0x60,0x00,0x06,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0xa2,0x00,0x1c,0xc0,0x01,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0xa2,0xc0,0x03,0x30,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x22,0xc3,0x00,0x0e,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x22,0xc3,0x80,0x01,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x22,0xc3,0x80,0x01,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x22,0xc3,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x22,0xc3,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x22,0xc3,0x01,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x22,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x22,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
 0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,0xff,
 0xff,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,
 0x80,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00};
}]