---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              césure des mots, motifs de césure, hyphenation, coupure de mots
---

# Que signifie l'erreur : "Improper `\hyphenation` will be flushed" ?

- **Message** : `Improper \hyphenation`
- **Origine** : TeX

Lorsque vous souhaitez spécifier une exception de coupure avec `\hyphenation`, 
il faut s'assurer que l'argument ne contient que des lettres,
 et des traits d'union (`-`) pour indiquer les points de coupure. Ceci, 
 sous peine d'obtenir le message suivant en LaTeX :


```text
! Improper \hyphenation will be flushed.
\leavevmode ->\unhbox
                      \voidb@x
<*> \hyphenation{Ji-m\'e
                        -nez}
```

Il dispsoe d'un équivalent en TeX :

```text
! Improper \hyphenation will be flushed.
\'#1->{
       \accent 19 #1}
<*> \hyphenation{Ji-m\'e
                        -nez}
```

Comme mentionné dans la question 
"[](/3_composition/langues/cesure/la_cesure_ne_fonctionne_pas)", les "mots" 
contenant un commande de type `\⟨accent⟩` ne peuvent pas être coupés 
en fin de ligne. Par conséquent, tout mot de ce type est considéré 
comme incorrect dans une commande `\hyphenation{}`. Le problème est que 
les caractères accentués sont des glyphes dans certaines fontes (ils sont 
alors permis) mais d'autres codages de fontes produisent 
des constructions complexes exigeant la primitive `\accent`. Par exemple, 
si vous utilisez l'encodage `T1`, `\"u` est un glyphe unique. Ainsi, 
le cas suivant sera valide :

```{noedit}
\usepackage[T1]{fontenc}
\hyphenation{T\"ur-stop-per}
```

La même exception de coupure utilisée avec le codage par défaut `OT1` 
aurait produit cette erreur.

La solution au problème consiste donc à utiliser une police de caractères 
qui contient le caractère accentué ; ainsi l'accent est "caché" aux mécanismes
de césure et tout se passe bien.

Pour les utilisateurs de LaTeX, c'est très facile : il suffit d'utiliser 
`\usepackage[T1]{fontenc}`, et les commandes de lettres accentuées 
telles que le `\'e` dans `\hyphenation{Ji-m\'e-nez}` deviennent automatiquement
un seul caractère accentué avant que ne se déclenche l'algorithme de coupure de mots.

Le *LaTeX Companion*, en page 463, donne une explication des différences 
de caractères dans les codages principaux.


:::{sources}
- [Improper `\hyphenation will be flushed](faquk:FAQ-badhyph)
- [FAQ erreurs - Lettre I](https://latex.developpez.com/faq/erreurs?page=I), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::