"""
/*
 * AnalizaToo.py   It parses a Too.tex file producing html files for
 * browsing them.
 *
 * Copyright (C) Manuel Gutierrez Algaba, 1999
 *
 * This program is free software; you can redistribute it and/or modif
y
 * it under the terms of the GNU General Public License as published b
y
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
*
*/
For new submissions : irmina@ctv.es
"""
"""
Este programa analiza un fichero Too.tex y genera una serie 
de indices.

"""
import re 

#r =  re.compile("\s*def\s+(?P<nom>[\w_]+)")
#rr =  re.compile("\s*class\s+(?P<nom>[\w_]+)")

class AnalizaToo:
    def __init__(self, fichero, indice):
	"""
	indice :numero para crear cada uno de los ficheros
	"""
	self.contador_articulos = 0 # Para la base de datos de articulos
	self.base_articulos = {}
	self.indice = indice
	f = open(fichero, "r")
	self.lines = f.readlines()
	f.close()
	self.en_articulo = 0
	self.dict_indices = {}
	self.RE_indice = re.compile("[^{]*{(?P<des>[^{}]*)}{(?P<nom>.*)")
	self.un_indice = re.compile("\\\index{(?P<nom>[^}]*)}}?")
	self.espacios =re.compile("\s*")
	self.indiceg= re.compile("\\\index[^\s{]+")
	self.lineas_temp = []
	self.indices_asociados = []
	self.articulos_asociados_a_indices={}
	self.respuestas = []
	self.alguno = 0
	# este es el nombre de los ficheros
	self.teencontrex= "TeEncontreX" 
	# este sirve para el indice, para que diff nos genere
	# todos los articulos por nombre 
	self.teencontrexReal = "TeEncontreX" 

    def analiza(self):
	for i in self.lines:
	    if self.es_un_indice(i):
		self.procesa_indice(i)
		continue
	    if i[0:5]=="\\jiji":
		if not self.alguno:
		    self.alguno = 1
		    self.respuestas = []
		    self.lineas_temp = []	
		    continue
	    if i[0:5]=="\\jiji":
		self.asocia_con_respuesta()
		self.asocia_indices()
		continue
	    if i[0:5]=='\\jaja':
		self.asocia_con_respuesta()
		continue
	    if self.tiene_indices(i):
		continue
	    self.filtra_linea(i)

    def filtra_linea(self, i):
	" quitamos verb, ponemos acentos y eso..."
	self.lineas_temp.append(i[:])

    def asocia_con_respuesta(self):
	"""
	cada una de las respuestas sobre un tema y la pregunta
	inicial son dividas en varias partes, esta funcion une
	todo en respuestas
	"""
	self.respuestas.append(self.lineas_temp[:])
	self.lineas_temp=[]

    def asocia_indices(self):
	#print "asociando indices", self.respuestas, self.indices_asociados
	copia =self.asocia_base_articulos( self.respuestas[:])
	asociado = {}
	for i in self.indices_asociados:
	    for j in self.dict_indices[i]:
		if  re.search("AT", j):
		    continue
		try:
		    asociado[j]
		except KeyError:
		    asociado[j]=1

	for j in asociado.keys():
	    #print "asociando", j
	    try:
		self.articulos_asociados_a_indices[j].append(( asociado.keys()[:], copia))
	    except KeyError:
		self.articulos_asociados_a_indices[j]=[( asociado.keys()[:], copia)]

	self.respuestas=[]
	self.indices_asociados =[]

    def asocia_base_articulos(self, a):
	self.contador_articulos = self.contador_articulos + 1
	self.base_articulos[self.contador_articulos]= a
	return self.contador_articulos
	
    def imprime_indices_articulos(self):
	print self.articulos_asociados_a_indices.keys()
	for i in self.articulos_asociados_a_indices.keys():
	    print i,">>\n", self.articulos_asociados_a_indices

    def es_un_indice(self, i):
	return i[0:18]=='\\newcommand{\\index'

    def procesa_indice(self, i):
	m = self.RE_indice.match(i)
	indeses = m.group('nom')
	nombre = m.group('des')

	while 1:
	    el = self.un_indice.match(indeses)
	    if el is None:
		return
	    inde = el.group('nom')
	    indeses = indeses[len(inde)+len('\\index{}'):]
	    try:
		self.dict_indices[nombre].append(inde)
	    except:
		self.dict_indices[nombre]=[inde]

    def tiene_indices(self, i):
	t = i[:]
	adev = 0
	while 1:
	    m = self.espacios.match(t)
	    if not m is None:
		t = t[m.end(0):]
	    m = self.indiceg.match(t)
	    if not m is None :
		self.indices_asociados.append(m.group(0))
		t = t[m.end(0):]
		adev = 1
	    else:
		return adev
	
    def imprime_todos_indices(self):
	for i in self.dict_indices.keys():
	    print i, self.dict_indices[i]
    def expande_macroindice(self):
	self.dict_min_indices = []
	for i in  self.dict_indices.keys():
	    self.dict_min_indices = self.dict_min_indices + self.dict_indices[i]
    def escribe_html_palabra_clave(self,  pal):
	"""
	palabra clave cuya pagina queremos crear
	"""
	inf = self.articulos_asociados_a_indices[pal] 
	print inf
	# generamos la primera pagina
	f = open(self.teencontrex+pal+".html","w")
	self.genera_cabecera(f, pal)
	"""
	[(['tabla', 'cuadro', 'rput', 'pstricks', 'box'], 2), (['imagenes', 'centrado', 'tabla', 'tama\\~no', 'box', 'cuadro'], 6), (['color', 'tabla', 'cuadro', 'box'], 9), (['tabla', 'cuadro', 'columnas', 'box'], 28)]

	"""
	f.write("Estos son los articulos disponibles<BR>")
	for articulo in inf:
	    palabras_clave, articul = articulo
	    f.write("Articulo ")
	    self.genera_TeXen(f,str(articul))
	    f.write(":")
	    for una_palabra_clave in palabras_clave:
		f.write(" ")
		#print una_palabra_clave
		self.genera_TeXen(f,una_palabra_clave)
		f.write(" ")
	    f.write("<BR> ")
	self.genera_enlace(f, "\n<BR>Al indice principal", self.teencontrex+ ".html")
	self.genera_pie(f)
	f.close()

    def genera_cabecera(self, fic, tema):
	fic.write('''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
	<HTML>
	<HEAD><TITLE>TeEncontreX:'''+ tema + '''  </TITLE></HEAD>
	<BODY BACKGROUND="" BGCOLOR="#FFFFFF" TEXT="#000000" LINK="#0000FF" ALINK="#0000FF" VLINK="#808080"> <H1>'''+ tema  +"</H1>")

    def genera_pie(self, fic):
	fic.write("</BODY> </HTML>")

    def genera_articulo(self, num):
	inf = self.base_articulos[num]
	#print inf
	f = open(self.teencontrex+str(num)+".html","w")
	self.genera_cabecera(f, "Articulo "+ str(num))
	i = 0
	for subarticulos in inf:
	    f.write("Parte : ")
	    self.genera_TeXen(f,str(num)+"."+str(i))
	    self.genera_subarticulo(subarticulos, str(num)+"."+str(i) )
	    f.write("<BR> ")
	    i = i + 1
	self.genera_pie(f)
	f.close()

    def genera_subarticulo(self, subart, nombre):
	f = open(self.teencontrex+nombre+".html","w")
	self.genera_cabecera(f, "Sub Articulo "+ nombre)
	for linea in subart:
	    f.write("<PRE>"+linea+"</PRE>")
	self.genera_pie(f)
	f.close()


    def genera_TeXen(self,f,  nombre_enlace):
	self.genera_enlace(f, nombre_enlace, self.teencontrexReal+nombre_enlace+".html")

    def genera_enlace(self, f, nombre_enlace, enlace_html):
	f.write('\n<A HREF="' + enlace_html+'">'+nombre_enlace + '</A>')


    def genera_cuerpo(self, fic, cu):
	fic.write("<PRE>"+ cu + "</PRE>")
	
    def genera_listado_conceptos(self):
	f = open(self.teencontrex+".html","w")
	f.write("""<H1>Bienvenidos a TeEncontreX.</H1> <BR>
	Navega hasta que encuentres tu solucion<BR> """)
	f.write("""Surf until you find your solution, some articles
	are in English, another in Spanish, others will be in German...
	<BR>""")
	import time
	f.write("Version : ")
	f.write(time.asctime(time.localtime(time.time()))) 
	f.write("<BR>")
	l = self.articulos_asociados_a_indices.keys()
	l.sort()
	f.write("Exactly "+ str(len(l)) + " concepts! and " + str(self.contador_articulos) + " articles" )
	f.write(""" <TABLE WIDTH="100" BORDER="8" CELLPADDING="4" CELLSPACING="5">
	<CAPTION>Lista/tabla de conceptos</CAPTION>""")

	contador = 0 
	for i in l :
	    if  re.search("AT", i):
		continue
	    if contador % 7 == 0:
		if contador == 0:
		    f.write("<TR>")
		else:
		    f.write( "</TR>\n<TR>")
	    f.write ("<TD>")
	    self.genera_enlace(f, i, self.teencontrex+i+".html")
	    f.write ("</TD>")

	    self.escribe_html_palabra_clave(i)
	    contador = contador + 1
	f.write("</TR></TABLE>\n")
	f.write('''<a href="http://es.nedstat.net/cgi-bin/viewstat?name=TeEncontreX">
	<img src="http://es.nedstat.net/cgi-bin/nedstat.gif?name=TeEncontreX"
	border=0 alt="" width=22 height=22></a> ''')	
	self.genera_enlace(f, "<BR>A pyttex", "pyttex.htm")
	self.genera_enlace(f, "<BR>A TeEncontreXIntro", "TeEncontreXIntro.html")
	self.genera_enlace(f, "<BR><H2>SOURCES! </H2>", "TeEncontreX_Sources.html")
	self.genera_enlace(f, "<BR><H3>Want to add some data? </H3>", "TeEncontreX_ADD.html")
	
	self.genera_pie(f)
	f.close()

    def genera_articulos(self):
	l = self.base_articulos.keys()
	l.sort()
	for i in l:
	    self.genera_articulo(i)

def hazlo():
    a=AnalizaToo("Too.tex", 0)
    # al llegar aqui cada articulo tiene una serie de macroindices
    # asociado y se encuentra divido en varias partes
    # ahora lo l'ogico es expandir cada macroindice y encontrar
    # los articulos asociados a cada indice
    # por ultimo hay que ordenar los indices y generar una pagina
    # para cada uno y para cada articulo generar una serie de 
    # enlaces a los otros sitios donde est'a asociado
    a.analiza()
    a.imprime_todos_indices()
    #print a.dict_indices['\indexcaja']
    #print a.articulos_asociados_a_indices['cuadro']
    #a.imprime_indices_articulos()
    #a.expande_macroindice()
    #a.escribe_html_palabra_clave('cuadro')
    #a.genera_articulo(2)
    a.genera_listado_conceptos()
    a.genera_articulos()

if __name__=='__main__':
    hazlo()
