/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class Bib2GlsDualEntry
extends Bib2GlsEntry {
    private boolean isprimary = true;

    public Bib2GlsDualEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualentry");
    }

    public Bib2GlsDualEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    public boolean isPrimary() {
        return this.isprimary;
    }

    public boolean hasTertiary() {
        return false;
    }

    @Override
    public String getFallbackValue(String string) {
        String string2 = super.getFallbackValue(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equals("descriptionplural")) {
            string2 = this.getFieldValue("description");
            if (string2 == null) {
                return string2;
            }
            String string3 = this.getResource().getDualPluralSuffix();
            return string3 == null ? string2 : string2 + string3;
        }
        if (string.equals("symbolplural")) {
            string2 = this.getFieldValue("symbol");
            if (string2 == null) {
                string2 = this.getFallbackValue("symbol");
            }
            if (string2 == null) {
                return string2;
            }
            String string4 = this.getResource().getDualPluralSuffix();
            return string4 == null ? string2 : string2 + string4;
        }
        if (string.equals("longplural")) {
            string2 = this.getFieldValue("long");
            if (string2 == null) {
                return string2;
            }
            String string5 = this.getResource().getDualPluralSuffix();
            return string5 == null ? string2 : string2 + string5;
        }
        if (string.equals("shortplural")) {
            string2 = this.getFieldValue("short");
            if (string2 == null) {
                string2 = this.getFallbackValue("short");
            }
            if (string2 == null) {
                return string2;
            }
            String string6 = this.getResource().getDualShortPluralSuffix();
            return string6 == null ? string2 : string2 + string6;
        }
        return null;
    }

    public HashMap<String, String> getMappings() {
        return this.getResource().getDualEntryMap();
    }

    public String getFirstMap() {
        return this.getResource().getFirstDualEntryMap();
    }

    public boolean backLink() {
        return this.getResource().backLinkFirstDualEntryMap();
    }

    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualEntry(this.bib2gls, this.getEntryType());
    }

    @Override
    protected Vector<String> processSpecialFields(boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException, Bib2GlsException {
        vector = super.processSpecialFields(bl, stringArray, string, vector);
        for (String string2 : Bib2Gls.DUAL_SPECIAL_FIELDS) {
            vector = this.processField(string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    public Bib2GlsEntry createDual() {
        Object object;
        Object object2;
        String string;
        Object object3;
        GlsResource glsResource = this.getResource();
        String string2 = glsResource.getDualPrefix();
        String string3 = this.getOriginalId();
        Bib2GlsDualEntry bib2GlsDualEntry = this.createDualEntry();
        bib2GlsDualEntry.setId(string2, string3);
        bib2GlsDualEntry.setBase(this.getBaseFile());
        bib2GlsDualEntry.isprimary = false;
        HashMap<String, String> hashMap = this.getMappings();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (this.backLink()) {
            string4 = this.getFirstMap();
            string5 = hashMap.get(string4);
        }
        Object object4 = this.getKeySet().iterator();
        while (object4.hasNext()) {
            object3 = this.getKey(object4.next());
            string = hashMap.get(object3);
            object2 = this.getField((String)object3);
            object = this.getFieldValue((String)object3);
            if (object2 == null || object == null || ((String)object3).equals("alias")) continue;
            object2 = (BibValueList)((BibValueList)object2).clone();
            if (string == null) {
                if (((String)object3).equals("parent")) {
                    object = glsResource.flipLabel((String)object);
                }
                bib2GlsDualEntry.putField((String)object3, (BibValueList)object2);
                bib2GlsDualEntry.putField((String)object3, (String)object);
                continue;
            }
            if (string.equals("alias")) continue;
            bib2GlsDualEntry.putField(string, (BibValueList)object2);
            bib2GlsDualEntry.putField(string, (String)object);
        }
        object4 = glsResource.getDualSortField();
        if (!((String)object4).equals("sort")) {
            object3 = this.getField("sort");
            string = hashMap.get("sort");
            if (object3 != null && string != null) {
                object3 = (BibValueList)((BibValueList)object3).clone();
                object2 = this.getFieldValue("sort");
                bib2GlsDualEntry.putField(string, (BibValueList)object3);
                bib2GlsDualEntry.putField(string, (String)object2);
            }
        }
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            string = object3.next();
            object2 = this.getFieldValue(string);
            if (object2 == null) {
                object2 = this.getFallbackValue(string);
                object = this.getFallbackContents(string);
                if (object2 != null) {
                    this.putField(string, (String)object2);
                    if (object != null) {
                        this.putField(string, (BibValueList)((BibValueList)object).clone());
                    }
                }
            }
            object = hashMap.get(string);
            if (string4 != null && string6 == null && ((String)object).equals(string4)) {
                string6 = string;
            }
            if (bib2GlsDualEntry.getFieldValue((String)object) != null) continue;
            object2 = this.getFallbackValue(string);
            if (object2 == null) {
                this.bib2gls.verbose(this.bib2gls.getMessage("message.no.fallback", this.getEntryType(), string));
                continue;
            }
            BibValueList bibValueList = this.getFallbackContents(string);
            if (bibValueList != null) {
                bib2GlsDualEntry.putField((String)object, (BibValueList)bibValueList.clone());
            }
            bib2GlsDualEntry.putField((String)object, (String)object2);
        }
        if (string6 != null) {
            object3 = this.getFieldValue(string6);
            this.putField(string6, String.format("\\bibglshyperlink{%s}{%s}", object3, bib2GlsDualEntry.getId()));
        }
        if (string5 != null) {
            object3 = bib2GlsDualEntry.getFieldValue(string5);
            bib2GlsDualEntry.putField(string5, String.format("\\bibglshyperlink{%s}{%s}", object3, this.getId()));
        }
        if ((object3 = glsResource.getDualField()) != null) {
            bib2GlsDualEntry.putField((String)object3, this.getId());
            this.putField((String)object3, bib2GlsDualEntry.getId());
        }
        return bib2GlsDualEntry;
    }

    @Override
    public void writeInternalFields(PrintWriter printWriter) throws IOException {
        for (String string : Bib2Gls.DUAL_SPECIAL_FIELDS) {
            String string2 = this.getFieldValue(string);
            if (string2 == null) continue;
            printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", this.getId(), string, string2);
        }
    }
}

