/*
    Copyright (C) 2013-2022 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.latex;

import java.io.IOException;

import com.dickimawbooks.texparserlib.*;

public class TrivListDec extends Declaration
{
   public TrivListDec()
   {
      this("trivlist");
   }

   public TrivListDec(String name)
   {
      super(name);
   }

   @Override
   public Object clone()
   {
      return new TrivListDec(getName());
   }

   @Override
   public boolean canExpand()
   {
      return false;
   }

   @Override
   public TeXObjectList expandonce(TeXParser parser, TeXObjectList stack)
     throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandonce(TeXParser parser)
     throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandfully(TeXParser parser, TeXObjectList stack)
     throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandfully(TeXParser parser)
     throws IOException
   {
      return null;
   }

   @Override
   public void process(TeXParser parser) throws IOException
   {
      setup(parser, parser);
      ((LaTeXParserListener)parser.getListener()).startList(this);
   }

   @Override
   public void process(TeXParser parser, TeXObjectList stack) throws IOException
   {
      setup(parser, stack);
      ((LaTeXParserListener)parser.getListener()).startList(this);
   }

   public void setup(TeXParser parser, TeXObjectList stack) throws IOException
   {
      parser.putControlSequence(true, new GenericCommand(true, "@itemlabel"));

      ControlSequence cs = parser.getListener().getControlSequence("@nmbrlistfalse");

      if (parser == stack || stack == null)
      {
         cs.process(parser);
      }
      else
      {
         cs.process(parser, stack);
      }
   }

   @Override
   public void end(TeXParser parser, TeXObjectList stack)
    throws IOException
   {
      ((LaTeXParserListener)parser.getListener()).endList(this);
   }

   @Override
   public boolean isModeSwitcher()
   {
      return false;
   }

   public boolean isInLine()
   {
      return false;
   }
}
