/*
  This is the file bitmap.h of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/

/* this file will be included in ttf.h */


#ifndef __TTF_BITMAP_H
#define __TTF_BITMAP_H

#define BITMAP_ONE_BIT      1
#define BITMAP_TWO_BIT      2
#define BITMAP_FOUR_BIT     4 
#define BITMAP_ONE_BYTE     8
#define BITMAP_TWO_BYTES    0x10
#define BITMAP_THREE_BYTES  0x20
#define BITMAP_FOUR_BYTES   0x40

typedef struct {
  double point;
  USHORT x_res, y_res;
  USHORT xsize, ysize, xpoint;
  BYTE *map;
  BYTE mode;
  int color;
} BITMAP;

#define BITMAP_len(b) ((b)->xsize * (b)->ysize)
BITMAP *BITMAP_Init(double point, int x_resolution, int y_resolution,
                    int mode, USHORT pixel_xsize, USHORT pixel_ysize);
void BITMAP_color(BITMAP *bit, int color);
#define BITMAP_map(bit)     ((bit)->map)
#define BITMAP_xpoint(bit)  ((bit)->xpoint)
#define BITMAP_ypoint(bit)  ((bit)->ysize)
void BITMAP_done(BITMAP *bit);

#endif /* __TTF_BITMAP_H */


/* end of bitmap.h */
