h01138
s 00000/00000/00384
d R 6.1 91/12/09 22:39:43 root 6 5
c (1) Fixed bug where 'c'c & 's' in Hebrew mode reversed English strings.  
c (2) Fixed bug where if you typed ^X while editing in a 'c' command, vi.iv might  
c     append the contents of another line to the current line.  
c (3) Preserve & recover now work with vi.iv.
e
s 00023/00005/00361
d D 5.1 90/04/24 14:33:51 haim 5 4
c (1) 'c & 's commands no longer reverse English strings while in Hebrew mode.
c *** CHANGED *** 91/12/09 20:59:42 haim
c (1) Fixed bug where directions of secondary language strings would
c be reversed if cancelled a command sequence (e.g., 'c', 'd', 'y').
c [function operate in ex_voper.c]
c (2) Fixed bug where substitute command would sometimes result in a
c segmentation fault.  [function subschang in ex_re.c]
c (3) Added other checks for null pointers [especially in ex_RL.c]
e
s 00000/00000/00366
d D 4.1 90/02/09 09:58:48 haim 4 3
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
c termcap defintion to vi100iv.
c (2) Added use of TERMIV, EXINITIV, & .exrciv.
c *** CHANGED *** 90/02/09 10:21:39 haim
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
e
s 00000/00000/00366
d D 3.1 90/01/01 14:15:51 haim 3 2
c Fixed the following bugs: [1] echoing previous lines during insert
c mode, [2] cursor stuck in corner when inserting LR text in RL view,
c [3] prints "ERROR" instead of correct messages.
c Also deleted unused entries from termcap.
e
s 00093/00009/00273
d D 2.1 89/12/27 09:21:27 haim 2 1
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:08:49 haim
c 
e
s 00282/00000/00000
d D 1.1 89/12/26 15:05:56 haim 1 0
c Inherited by Haim Roman from Yael Dubinsky approximately 10/1989.  Yael 
c started the installation on the Technion Computer Science computers, 
c but had to leave before completing the installation.
c *** CHANGED *** 89/12/26 15:18:43 haim
c date and time created 89/12/26 15:05:56 by haim
e
u
U
f e 0
t
T
I 1
D 2
/*
E 2
I 2
/*============================================================
 * FILE: ex_get.c	Input routines for command mode
 *------------------------------------------------------------
 * EDIT HISTORY:
 * 11/1989	HAIM ROMAN, COMPUTER SCI. DEPT., TECHNION
 * (1) Added comments
 *
 * ??/198?	URI HABASHA, COMPUTER SCI. DEPT., TECHNION
 * (1) Changed for vi.iv (to run on a VAX)
 *------------------------------------------------------------
 * DESCRIPTION:
 *
 * Input routines for command mode.
 * Since we translate the end of reads into the implied ^D's
 * we have different flavors of routines which do/don't return such.
 *------------------------------------------------------------
E 2
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
I 2
 *============================================================
 * INCLUDE FILES & EXTERNAL DATA DECLARATIONS
 *============================================================
E 2
 */
D 2

E 2
#ifndef lint
static char *sccsid = "@(#)ex_get.c	7.6 (Berkeley) 6/7/85";
#endif not lint

#include "ex.h"
#include "ex_tty.h"
#include "ex_RL.h"

D 2
/*
 * Input routines for command mode.
 * Since we translate the end of reads into the implied ^D's
 * we have different flavors of routines which do/don't return such.
 */
static	bool junkbs;
E 2
I 2
static	bool junkbs;	/* maybe this should be static local to checkjunk */
E 2
short	lastc = '\n';

I 2
/*=================================================================
* FUNCTIONS
*=================================================================
*/

E 2
ignchar()
{
	ignore(getchar());
}

getchar()
{
	register int c;

	do
D 5
		c = getcd();
E 5
I 5
		c = getcd();	/* get next char of user command */
E 5
	while (!globp && c == CTRL(d));
	return (c);
}

I 5
/*---------------------------------------------------------------
 * getcd -- get next character from user's command, skipping junk
 * characters & doing necessary conversions.
 *
 * This routine calls 'getach' to actually get characters.  See that 
 * function for external variables used.
 *---------------------------------------------------------------
 */
E 5
getcd()
{
	register int c;

again:
D 5
	c = getach();
E 5
I 5
	c = getach();	/* get next character from user's command */
E 5
	if (c == EOF)
		return (c);
			/* (c) . CHANGED  by Uri habusha for vi.iv */
D 5
	c = ascspec(c);
E 5
I 5
	c = ascspec(c);	/* convert special characters (for vi.iv) */

	/* if in command mode... */
E 5
	if (!inopen)
I 5
		
		/*
		 * if have reached the end of input, convert the last
		 * character of the user command to newline.
		 */
E 5
		if (!globp && c == CTRL(d))
			setlastchar('\n');
I 2
		/*
		 * else if a backspace, write error message saying
D 5
		 * that it is being discarded
E 5
I 5
		 * that it is being discarded & get the next character.
E 5
		 */
E 2
		else if (junk(c)) {
			checkjunk(c);
			goto again;
		}
	return (c);
}

peekchar()
{

	if (peekc == 0)
		peekc = getchar();
	return (peekc);
}

peekcd()
{
	if (peekc == 0)
		peekc = getcd();
	return (peekc);
}

I 2
/*---------------------------------------------------------
* getach -- get a character
* 
* This function returns value of the next character from the user
D 5
* command.  It can take the character froma number of sources, in the
E 5
I 5
* command.  It can take the character from a number of sources, in the
E 5
* following priority:
* 
* 	the peek-ahead character (variable 'peekc')
* 	buffer pointed to by 'globp'
* 	buffer pointed to by 'input'
* 
* If no character can be found in any of these buffers, characters are
* read from the standard input & placed in input's buffer.
* 
* The character gotten is returned as the function's value, & (unless
* taken from the peek-ahead character) is stored in the variable
* 'lastc'.
* 
* EXTERNAL VARIABLES:
* -------------------
* peekc (in/out) --  peek-ahead character.  0 = there is no peek-ahead
* 	character.  If the function takes the character from
* 	here, it sets this variable to 0.
* globp (in/out) -- 0 = no string in its buffer; any other value
* 	indicates that it points to a character string.  If
* 	the function takes the character from here, it
* 	increments globp to point at the next character of the
* 	string.  The string must end with a null.
I 5
*	If globp points to a null string (one possibility is that it
*	originally pointed to a non-null string, but we've reached the
*	end of the string), then globp is set to the NULL pointer.
E 5
* input (in/out) -- same structure as globp.
* lastc (out) -- set the character gotten, unless it is gotten from the
* 	peek-ahead character.
* intty (in) -- true if command input comes from a terminal.
* ---------------------------------------------------------------------
*/
E 2
getach()
{
	register int c;
	static char inline[BUFSIZ];
	struct stat statb;

I 2
	/* if there is a peek-ahead character, get the character from
	 * there 
	 */

E 2
	c = peekc;
	if (c != 0) {
		peekc = 0;
		return (c);
	}
I 2

	/* if there is a character in globp's buffer, get the
	 * character from there 
	 */

E 2
	if (globp) {
		if (*globp)
			return (*globp++);
		globp = 0;
		return (lastc = EOF);
	}
I 2

	/* if there is a character in input's buffer, get the
	 * character from there.  The label 'top' is used by the sections
	 * of the function that read from standard input.  After reading
	 * & putting the characters in input's buffer, they jump up to
	 * here 
	 */

E 2
top:
	if (input) {
		if (c = *input++) {
			/* (c) . CHANGED  by Uri habusha for vi.iv */
			if (c = ascspec(c))
				return (lastc = c);
			goto top;
		}
		input = 0;
	}
I 2

E 2
	flush();
I 2

	/* else we need to read from standard input.  Do this section
	 * if standard input is a terminal
	 */

E 2
	if (intty) {
		c = read(0, inline, sizeof inline - 4);
		if (c < 0)
			return (lastc = EOF);
		if (c == 0 || inline[c-1] != '\n')
			inline[c++] = CTRL(d);
		if (inline[c-1] == '\n')
D 2
			noteinp();
E 2
I 2
			noteinp();  /* calculate approximate new
				       screenline positions */
E 2
		inline[c] = 0;
		for (c--; c >= 0; c--)
			if (inline[c] == 0)
				/* (c) . CHANGED  by Uri habusha for vi.iv */
				inline[c] = QUOTE;
		input = inline;
		goto top;
	}
I 2

	/* if we've gotten this far, then we read from standard input,
	 * but standard input is NOT a terminal 
	 */

E 2
	c = read(0, inline, sizeof inline - 1);
	if(c <= 0)
		return(lastc = EOF);
	inline[c] = '\0';
	input = inline;
	goto top;
}

/*
 * Input routine for insert/append/change in command mode.
 * Most work here is in handling autoindent.
 */
static	short	lastin;

gettty()
{
	register int c = 0;
	register char *cp = genbuf;
	char hadup = 0;
	int numbline();
	extern int (*Pline)();
	int offset = (Pline == numbline ? 8 : 0);
	int ch;

	if (intty && !inglobal) {
		if (offset) {
			holdcm = 1;
			printf("  %4d  ", lineDOT() + 1);
			flush();
			holdcm = 0;
		}
		if (value(AUTOINDENT) ^ aiflag) {
			holdcm = 1;
#ifdef LISPCODE
			if (value(LISP))
				lastin = lindent(dot + 1);
#endif
			tab(lastin + offset);
			while ((c = getcd()) == CTRL(d)) {
				if (lastin == 0 && isatty(0) == -1) {
					holdcm = 0;
					return (EOF);
				}
				lastin = backtab(lastin);
				tab(lastin + offset);
			}
			switch (c) {

			case '^':
			case '0':
				ch = getcd();
				if (ch == CTRL(d)) {
					if (c == '0')
						lastin = 0;
					if (!OS) {
				/* (c) . CHANGED  by Uri habusha for vi.iv */
						putchar(BQ);
						putchar(SQ);
						putchar(BQ);
					}
					tab(offset);
					hadup = 1;
					c = getchar();
				} else
					ungetchar(ch);
				break;

			case '.':
				if (peekchar() == '\n') {
					ignchar();
					noteinp();
					holdcm = 0;
					return (EOF);
				}
				break;

			case '\n':
				hadup = 1;
				break;
			}
		}
		flush();
		holdcm = 0;
	}
	if (c == 0)
		c = getchar();
	while (c != EOF && c != '\n') {
		if (cp > &genbuf[LBSIZE - 2])
			error("Input line too long");
		*cp++ = c;
		c = getchar();
	}
	if (c == EOF) {
		if (inglobal)
			ungetchar(EOF);
		return (EOF);
	}
	*cp = 0;
	cp = linebuf;
	if ((value(AUTOINDENT) ^ aiflag) && hadup == 0 && intty && !inglobal) {
		lastin = c = smunch(lastin, genbuf);
		for (c = lastin; c >= value(TABSTOP); c -= value(TABSTOP))
			*cp++ = '\t';
		for (; c > 0; c--)
			*cp++ = ' ';
	}
	CP(cp, genbuf);
	if (linebuf[0] == '.' && linebuf[1] == 0)
		return (EOF);
	return (0);
}

/*
 * Crunch the indent.
 * Hard thing here is that in command mode some of the indent
 * is only implicit, so we must seed the column counter.
 * This should really be done differently so as to use the whitecnt routine
 * and also to hack indenting for LISP.
 */
smunch(col, ocp)
	register int col;
	char *ocp;
{
	register char *cp;

	cp = ocp;
	for (;;)
		switch (*cp++) {

		case ' ':
			col++;
			continue;

		case '\t':
			col += value(TABSTOP) - (col % value(TABSTOP));
			continue;

		default:
			cp--;
			CP(ocp, cp);
			return (col);
		}
}

char	*cntrlhm =	"^H discarded\n";

checkjunk(c)
	char c;
{

	if (junkbs == 0 && c == '\b') {
		write(2, cntrlhm, 13);
		junkbs = 1;
	}
}

line *
setin(addr)
	line *addr;
{

	if (addr == zero)
		lastin = 0;
	else
		getline(*addr, ishef), lastin = smunch(0, linebuf);
}
E 1
