h07595
s 00069/00010/00687
d R 6.1 91/12/09 22:40:16 root 6 5
c (1) Fixed bug where 'c'c & 's' in Hebrew mode reversed English strings.  
c (2) Fixed bug where if you typed ^X while editing in a 'c' command, vi.iv might  
c     append the contents of another line to the current line.  
c (3) Preserve & recover now work with vi.iv.
e
s 00020/00006/00677
d D 5.1 90/04/24 14:34:35 haim 5 4
c (1) 'c & 's commands no longer reverse English strings while in Hebrew mode.
c *** CHANGED *** 91/12/09 21:00:10 haim
c (1) Fixed bug where directions of secondary language strings would
c be reversed if cancelled a command sequence (e.g., 'c', 'd', 'y').
c [function operate in ex_voper.c]
c (2) Fixed bug where substitute command would sometimes result in a
c segmentation fault.  [function subschang in ex_re.c]
c (3) Added other checks for null pointers [especially in ex_RL.c]
e
s 00000/00000/00683
d D 4.1 90/02/09 09:59:37 haim 4 3
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
c termcap defintion to vi100iv.
c (2) Added use of TERMIV, EXINITIV, & .exrciv.
c *** CHANGED *** 90/02/09 10:22:32 haim
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
e
s 00084/00016/00599
d D 3.1 90/01/01 14:16:33 haim 3 2
c Fixed the following bugs: [1] echoing previous lines during insert
c mode, [2] cursor stuck in corner when inserting LR text in RL view,
c [3] prints "ERROR" instead of correct messages.
c Also deleted unused entries from termcap.
e
s 00000/00000/00615
d D 2.1 89/12/27 09:22:04 haim 2 1
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:09:20 haim
c 
e
s 00615/00000/00000
d D 1.1 89/12/26 15:06:20 haim 1 0
c Inherited by Haim Roman from Yael Dubinsky approximately 10/1989.  Yael 
c started the installation on the Technion Computer Science computers, 
c but had to leave before completing the installation.
c *** CHANGED *** 89/12/26 15:19:02 haim
c date and time created 89/12/26 15:06:20 by haim
e
u
U
f e 0
t
T
I 1
D 3
/*
E 3
I 3
/*==============================================================
 * ex_vops2.c -- visual mode operations
 *---------------------------------------------------------------
 * EDIT HISTORY:
 *
 * 31/12/89	HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
 * (1) Made change to fix bug of cursor staying in lower right corner
 * of screen when inserting LR text in RL view.  Look for string "((( HR".
 *
 * 11/1989		HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
 * (1) Added Comments
 *--------------------------------------------------------------
E 3
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
I 3
 *------------------------------------------------------------------
 * DESCRIPTION:
 *
 * Low level routines for operations sequences,
 * and mostly, insert mode (and a subroutine
 * to read an input line, including in the echo area.)
 *=================================================================
 * INCLUDE FILES & DATA DECLARATIONS
 *================================================================
E 3
 */

#ifndef lint
static char *sccsid = "@(#)ex_vops2.c	6.8 (Berkeley) 6/7/85";
#endif not lint

#include "ex.h"
#include "ex_tty.h"
#include "ex_vis.h"
#include "ex_RL.h"

D 3
/*
 * Low level routines for operations sequences,
 * and mostly, insert mode (and a subroutine
 * to read an input line, including in the echo area.)
 */
E 3
extern char	*vUA1, *vUA2;		/* mjm: extern; also in ex_vops.c */
extern char	*vUD1, *vUD2;		/* mjm: extern; also in ex_vops.c */

D 3
/*
E 3
I 3
/*======================================================================
 * FUNCTIONS
 *=====================================================================
E 3
 * Obleeperate characters in hardcopy
 * open with \'s.
 */
bleep(i, cp)
	register int i;
	char *cp;
{

	i -= column(cp);
	do
		putchar(BSQ);
	while (--i >= 0);
	rubble = 1;
}

/*
 * Common code for middle part of delete
 * and change operating on parts of lines.
 */
vdcMID(del)
	bool del;
{
	register char *cp;
	char *wcp, *cup;
	bool helpf = 0;

	wcp = wcursor, cup = cursor;
	setlf(&helpf);
	squish();
	setLAST();
	if (FIXUNDO)
		vundkind = VCHNG, CP(vutmp, linebuf);
	if (wcursor < cursor && (!isecondlang || del))
		cp = wcursor, wcursor = cursor, cursor = cp;
	if (wcp < cup && (!isecondlang || del))
		cp = wcp, wcp = cup, cup = cp;
	vUD1 = vUA1 = vUA2 = cursor; vUD2 = wcursor;
	helpf = column(wcursor - 1);
	if (ishef){
		changseclan(linebuf, Mdirect);
		wcursor = wcp, cursor = cup;
	}
	return (helpf);
}

/*
 * Take text from linebuf and stick it
 * in the VBSIZE buffer BUF.  Used to save
 * deleted text of part of line.
 */
takeout(BUF)
	char *BUF;
{
	register char *cp;

	if (wcursor < linebuf)
		wcursor = linebuf;
	if (cursor == wcursor) {
		beep();
		return;
	}
	if (wcursor < cursor) {
		cp = wcursor;
		wcursor = cursor;
		cursor = cp;
	}
	setBUF(BUF);
	if ((BUF[0] & (QUOTE|TRIM)) == OVERBUF)
		beep();
}

/*
 * Are we at the end of the printed representation of the
 * line?  Used internally in hardcopy open.
 */
ateopr()
{
	register int i, c;
	register char *cp = vtube[destline] + destcol;

	for (i = WCOLS - destcol; i > 0; i--) {
		c = *cp++;
		if (c == 0)
			return (1);
		if (c != ' ' && !spechar(c))
			return (0);
	}
	return (1);
}

D 5
/*
 * Append.
E 5
I 5
/*-----------------------------------------------------------
 * vappend.
E 5
 *
 * This routine handles the top level append, doing work
 * as each new line comes in, and arranging repeatability.
 * It also handles append with repeat counts, and calculation
 * of autoindents for new lines.
I 5
 * It also displays the inserted text to the screen (search for string
 * "printf.*genbuf").
 *
 * ARGUMENTS:
 * ----------
 * ch (in) -- user-command character (?)
 * cnt (in) -- repeat-count for command (?)
 * indent (in) --
 * isp (in) --
 *---------------------------------------------------------------
E 5
 */
bool	vaifirst;
bool	gobbled;
char	*ogcursor;

vappend(ch, cnt, indent, isp)
	int ch;		/* mjm: char --> int */
	int cnt, indent;
	bool isp;
{
	register int i;
	register char *gcursor;
	bool escape, SINdirect = INdirect;
	bool globflag = 0, chlk = 0;
	int repcnt, savedoomed;
	short oldhold = hold;
	int oldmask;

	/*
D 5
	 * Before a move in hardopen when the line is dirty
E 5
I 5
	 * Before a move in hardopen (i.e., harcopy terminal in open
	 * mode) when the line is dirty
E 5
	 * or we are in the middle of the printed representation,
	 * we retype the line to the left of the cursor so the
	 * insert looks clean.
	 */
	if (ch != 'o' && state == HARDOPEN && (rubble || !ateopr())) {
		rubble = 1;
		gcursor = cursor;
		i = *gcursor;
		*gcursor = ' ';
		wcursor = gcursor;
		vmove();
		*gcursor = i;
	}
	vaifirst = indent == 0;

	/*
	 * Handle replace character by (eventually)
	 * limiting the number of input characters allowed
	 * in the vgetline routine.
	 */
	if (ch == 'r')
		repcnt = 2;
	else
		repcnt = 0;

	/*
	 * If an autoindent is specified, then
	 * generate a mixture of blanks to tabs to implement
	 * it and place the cursor after the indent.
	 * Text read by the vgetline routine will be placed in genbuf,
	 * so the indent is generated there.
	 */
	if (value(AUTOINDENT) && indent != 0) {
		gcursor = genindent(indent);
		*gcursor = 0;
		vgotoCL(qcolumn(cursor - 1, genbuf));
	} else {
		gcursor = genbuf;
		*gcursor = 0;
		if (ch == 'o'){
			vfixcurs();
			if (ishef){
				*linebuf = (Mdirect ? 0202 : 2);
				*(linebuf+1) = 0;
			}
		}
	}

	/*
	 * Prepare for undo.  Pointers delimit inserted portion of line.
	 */
	vUA1 = vUA2 = cursor;
	/*
	 *    Before doing insert print in the echo area
	 * the  insert mode.
	 */
	if (ch != 'r' && !isp)
		if (INdirect)
			prmsg(0, "RL INSERT MODE.");
		else
			prmsg(0, "LR INSERT MODE.");
	/* 
	 * (c) . ADD for vi.iv by uri habusha.
D 5
	 * If we arraiev here it's meen that we are in insert
	 * mode. If the insert mode is diffrant than display
E 5
I 5
	 * If we arrive here it means that we are in insert
	 * mode. If the insert mode is differant than display
E 5
	 * direction we must set it to be equal .
	 */
	chadir();
	/*
	 * If we are not in a repeated command and a ^@ comes in
	 * then this means the previous inserted text.
	 * If there is none or it was too long to be saved,
	 * then beep() and also arrange to undo any damage done
	 * so far (e.g. if we are a change.)
	 */
	chLR = 0;
	if ((vglobp && *vglobp == 0) || peekbr()) {
		if ((INS[0] & (QUOTE|TRIM)) == OVERBUF) {
			beep();
			if (!splitw)
				ungetkey('u');
			doomed = 0;
			hold = oldhold;
			return;
		}
		/*
		 * Unread input from INS.
		 * An escape will be generated at end of string.
		 * Hold off n^^2 type update on dumb terminals.
		 */
		vglobp = INS;
		globflag = 1;
		hold |= HOLDQIK;
	} else if (vglobp == 0)
		/*
		 * Not a repeated command, get
		 * a new inserted text for repeat.
		 */
		INS[0] = 0;

	/*
	 * For wrapmargin to hack away second space after a '.'
	 * when the first space caused a line break we keep
	 * track that this happened in gobblebl, which says
	 * to gobble up a blank silently.
	 */
	gobblebl = 0;

	oldmask = sigblock(sigmask(SIGWINCH));
	/*
	 * Text gathering loop.
	 * New text goes into genbuf starting at gcursor.
	 * cursor preserves place in linebuf where text will eventually go.
	 */
	if (*cursor == 0 || state == CRTOPEN)
		hold |= HOLDROL;
	for (;;) {
		if (ch == 'r' && repcnt == 0)
			escape = 0;
		else {
			gcursor = vgetline(repcnt, gcursor, &escape, ch, 1);

			/*
			 * After an append, stick information
			 * about the ^D's and ^^D's and 0^D's in
			 * the repeated text buffer so repeated
			 * inserts of stuff indented with ^D as backtab's
			 * can work.
			 */
			if (HADUP)
				addtext("^");
			else if (HADZERO)
				addtext("0");
			while (CDCNT > 0)
				addtext("\204"), CDCNT--;
			if (gobbled)
				addtext(" ");
			addtext(ogcursor);
		}
		repcnt = 0;

		/*
		 * Smash the generated and preexisting indents together
		 * and generate one cleanly made out of tabs and spaces
		 * if we are using autoindent.
		 */
		if (!vaifirst && value(AUTOINDENT)) {
			i = fixindent(indent);
			if (!HADUP)
				indent = i;
			gcursor = strend(genbuf);
		}

		/*
		 * Limit the repetition count based on maximum
		 * possible line length; do output implied
		 * by further count (> 1) and cons up the new line
		 * in linebuf.
		 */
		chlk = escape == *svalue(CHLK) || escape == CTRL(r);
		cnt = vmaxrep(ch, cnt, chlk);
		/* (c) . ADD by Uri habusha for vi.iv . Date :29/1/88 */
		if (cnt > 0)
			cntchar = cnt * strlen(genbuf);
		else
			cntchar = strlen(genbuf);
		if (ishef){
			changseclan(linebuf, Mdirect);
			curlbuf();
			CP(gcursor + 1, cursor + 1);
		} else
			CP(gcursor + 1, cursor);
		do {
			CP(cursor, genbuf);
			if (cnt > 1) {
				int oldhold = hold;

				Outchar = vinschar;
				hold |= HOLDQIK;
I 5

				/* !!! OUTPUT INSERTED TEXT TO SCREEN !!! */
E 5
				printf("%s", genbuf);
I 5

E 5
				hold = oldhold;
				Outchar = vputchar;
			}
			cursor += gcursor - genbuf;
		} while (--cnt > 0);
D 3
		endim();
E 3
I 3
		endim();	/* end insert mode */
E 3
		if (escape != '\n')
			CP(cursor, gcursor + 1);

		if (ishef && escape != *svalue(CHLK)) {
			if (cursor > linebuf) 
				cursor--;
			setshcurs();
		}

		vUA2 = cursor;
		/*
		 * If doomed characters remain, clobber them,
		 * and reopen the line to get the display exact.
		 */
		if (state != HARDOPEN) {
			DEPTH(vcline) = 0;
			savedoomed = doomed;
			if (doomed > 0) {
				register int cind = cindent();

				physdc(cind, cind + doomed);
				doomed = 0;
			}
			if (!ishef || escape != *svalue(CHLK)){
				setprflag();
				i = vreopen(LINE(vcline), lineDOT(), vcline);
				prflag = 0;
				destcol += wmore;
			}
#ifdef TRACE
			if (trace)
				fprintf(trace, "restoring doomed from %d to %d\n", doomed, savedoomed);
#endif
			if (ch == 'R')
				if (chlk)
					ch = (ishef ? 'R' : 'a');
				if (ch == 'R')
					doomed = savedoomed;
		}

		/*
		 * All done unless we are continuing on to another line.
		 */
		if (escape != '\n' && !chlk)
			break;
		if (chlk) {
			if (ishef)
				if (ch != 'R')
					selbuf(1);
				else {
		/*			changseclan(linebuf, Mdirect);
					markcurs();
		*/
					selbuf(0);
				}
			if (escape == CTRL(r))
				cursor -= cntchar;
			if (cursor[0] && (*cursor & TRIM) != 2)
				vfixcurs();
			else
				vcursaft(cursor);
			gcursor = genbuf;
			*gcursor = 0;
			if(!INdirect)
				if (!HF)
					prmsg(1, "LR INSERT MODE . PLEASE MANUALLY FLIP TERMINAL TO LATIN MODE");
				else
					prmsg(0, "LR INSERT MODE");
			else
				if (!HN){
					prmsg(1, "RL INSERT MODE . PLEASE MANUALLY FLIP TERMINAL TO HEBREW MODE");
					chLR = 1;
				} else
					prmsg(0, "RL INSERT MODE");
			continue;
		}

		/*
		 * Set up for the new line.
		 * First save the current line, then construct a new
		 * first image for the continuation line consisting
		 * of any new autoindent plus the pushed ahead text.
		 */
D 3
		killU();
E 3
I 3
		killU();	/* set up so that there is no "current
				 * line" for the "U" cmd to refer to.
				 */
E 3
		addtext(gobblebl ? " " : "\n");
		vsave();
		cnt = 1;
		if (value(AUTOINDENT)) {
#ifdef LISPCODE
			if (value(LISP))
				indent = lindent(dot + 1);
			else
#endif
			     if (!HADUP && vaifirst)
				indent = whitecnt(linebuf);
			vaifirst = 0;
			strcLIN(vpastwh(gcursor + 1));
			gcursor = genindent(indent);
			*gcursor = 0;
			if (gcursor + strlen(linebuf) > &genbuf[LBSIZE - 2])
				gcursor = genbuf;
			CP(gcursor, linebuf);
		} else {
			CP(genbuf, gcursor + 1);
			gcursor = genbuf;
		}

		/*
		 * If we started out as a single line operation and are now
		 * turning into a multi-line change, then we had better yank
		 * out dot before it changes so that undo will work
		 * correctly later.
		 */
		if (FIXUNDO && vundkind == VCHNG) {
			vremote(1, yank, 0);
			undap1--;
		}

		/*
		 * Now do the append of the new line in the buffer,
		 * and update the display.  If slowopen
		 * we don't do very much.
		 */
		vdoappend(genbuf);
		vundkind = VMANYINS;
		vcline++;
		if (state != VISUAL)
			vshow(dot, NOLINE);
		else {
			i += LINE(vcline - 1);
			vopen(dot, i);
			if (value(SLOWOPEN))
				vscrap();
			else
				vsync1(LINE(vcline));
		/*
		 * (c) . ADD by Uri habusha for vi.iv .Date : 27/1/88  *
		 *  After creating a new line the printing direction is*
		 *  change . we want to return to the previus direction*
I 3
		 *
		 *	The indentation indicates that Uri's code
		 *	should lie outside the "if (state...." block,
		 *	but it is inside it.  Which is correct?
		 *	(Haim Roman 11/1989)
E 3
	         */
		chadir();
		flusho();
		}
		strcLIN(gcursor);
		*gcursor = 0;
		cursor = linebuf;
I 3
/* Modified by Uri Habusha for vi.iv */
E 3
		if (ishef)
			selbuf(0);
		if (INdirect)
			prmsg(0, "RL INSERT MODE");
		else
			prmsg(0, "LR INSERT MODE");
D 3
		if (INdirect == Mdirect)
E 3
I 3
		/* - - - - - - - - 
		 * Removed the following condition, so that the
		 * vgotoCL is executed unconditionally.  Uri told me
		 * that he inserted the condition to avoid having to do
		 * unecessary operations, but this caused a bug where
		 * if you were inserting LR text while in RL view, the
		 * cursor stayed in the lower right corner of the screen
D 5
		 * until you pressed ESC.
E 5
I 5
		 * until you pressed ESC.	[Haim Roman]
E 5
		 *		((( HR 31/12/89 )))
		 * - - - - - - --
		 */
		/* if (INdirect == Mdirect) */
E 3
			vgotoCL(qcolumn(cursor - 1, genbuf));
	}

	/*
	 * All done with insertion, position the cursor
	 * and sync the screen.
	 */
	if (globflag && SINdirect != INdirect){
		INdirect = SINdirect;
		chadir();
D 3
		vclrech();
E 3
I 3
		/* vclrech(); */
		vclrech(0);	/* argument added 11/1989 by Haim
		Roman */
E 3
	}
	hold = oldhold;
	if (cursor > linebuf && !ishef)
		cursor--;
	if (state != HARDOPEN)
		vsyncCL();
	else if (cursor > linebuf)
		back1();
	doomed = 0;
	wcursor = cursor;
	if ((INdirect != Mdirect) && ((wcursor[0] & TRIM ) == '\t')){
		int x = wcursor[0];
		*wcursor = 'x';
		vmove();
		*wcursor = x;
	}
	else
		vmove();
	(void)sigsetmask(oldmask);
}

/*
 * Subroutine for vgetline to back up a single character position,
 * backwards around end of lines (vgoto can't hack columns which are
 * less than 0 in general).
 */
back1()
{

	vgoto(destline - 1, WCOLS + destcol - 1);
}

int	vgetsplit();
char	*vsplitpt;

/*
 * Append the line in buffer at lp
 * to the buffer after dot.
 */
vdoappend(lp)
	char *lp;
{
	register int oing = inglobal;

D 3
	vsplitpt = lp;
E 3
I 3
	vsplitpt = lp;	/* set up for call to vgetsplit */
E 3
	inglobal = 1;
	ignore(append(vgetsplit, dot));
	inglobal = oing;
}

D 3
/*
 * Subroutine for vdoappend to pass to append.
E 3
I 3
/*---------------------------------------------------------------
 * vgetsplit -- a get-line function that "vdoappend" passes to "append".
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * When "vdoappend" calls "append", this will be the function that
 * "append" uses to get a line.  Getting a line means copying it to
 * the "linebuf" buffer.
 *
 * VALUE RETURNED BY FUNCTION:
 * ---------------------------
 * 0 = this function got a line.
 * EOF = there was no line for this function to get.
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * none
 *
 * EXTERNAL VARIABLES:   (might be #define definitions)
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * *vsplitpt (in/out) -- the line to "get".  If the pointer = 0, then
 *	there is NO line to "get".
 *-------------------------------------------------------------------
E 3
 */
vgetsplit()
{

	if (vsplitpt == 0)
		return (EOF);
D 3
	strcLIN(vsplitpt);
	vsplitpt = 0;
E 3
I 3
	strcLIN(vsplitpt);	/* copy line at "vsplitpt" to "linebuf" */
	vsplitpt = 0;	/* This statement means that this function
			 * gets at most 1 line every time "vdoappend"
			 * calls "append".
			 */
E 3
	return (0);
}

/*
 * Vmaxrep determines the maximum repetitition factor
 * allowed that will yield total line length less than
 * LBSIZE characters and also does hacks for the R command.
 */
vmaxrep(ch, cnt, chlk)
	char ch;
	register int cnt;
	bool chlk;
{
	register int len, replen;

	if (cnt > LBSIZE - 2)
		cnt = LBSIZE - 2;
	replen = strlen(genbuf);
	if (ch == 'R') {
		if (!ishef && (INdirect != Mdirect && !chlk) || (INdirect == Mdirect && chlk))
			Rcomrl(replen);
		else{
			len = strlen(cursor);
			if (replen < len)
				len = replen;
			if (ishef){
				setshcurs();
				if (len < replen )
					cursor[1] = 0;
				else
					CP(cursor + 1, cursor + len + 1);
				setshcurs();
			}else
				CP(cursor, cursor + len);
			vUD2 += len;
		}
	}
	len = strlen(linebuf);
	if (len + cnt * replen <= LBSIZE - 2)
		return (cnt);
	cnt = (LBSIZE - 2 - len) / replen;
	if (cnt == 0) {
		vsave();
		error("Line too long");
	}
	return (cnt);
}

/* 
 *	rcomrl does hacks fo the R command in rl direction
 */
Rcomrl(replen)
	register int 	replen;
{
	register int	len; 

	cursor++;
	len = strlen(linebuf) - strlen(cursor);
	if (replen < len)
		len = replen;
	CP(cursor - len,cursor);
	cursor -=len;
	vUD2 -=len;
}
E 1
