/*============================================================
 * FILE: ex_get.c	Input routines for command mode
 *------------------------------------------------------------
 * EDIT HISTORY:
 * 11/1989	HAIM ROMAN, COMPUTER SCI. DEPT., TECHNION
 * (1) Added comments
 *
 * ??/198?	URI HABASHA, COMPUTER SCI. DEPT., TECHNION
 * (1) Changed for vi.iv (to run on a VAX)
 *------------------------------------------------------------
 * DESCRIPTION:
 *
 * Input routines for command mode.
 * Since we translate the end of reads into the implied ^D's
 * we have different flavors of routines which do/don't return such.
 *------------------------------------------------------------
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *============================================================
 * INCLUDE FILES & EXTERNAL DATA DECLARATIONS
 *============================================================
 */
#ifndef lint
static char *sccsid = "@(#)ex_get.c	7.6 (Berkeley) 6/7/85";
#endif not lint

#include "ex.h"
#include "ex_tty.h"
#include "ex_RL.h"

static	bool junkbs;	/* maybe this should be static local to checkjunk */
short	lastc = '\n';

/*=================================================================
* FUNCTIONS
*=================================================================
*/

ignchar()
{
	ignore(getchar());
}

getchar()
{
	register int c;

	do
		c = getcd();	/* get next char of user command */
	while (!globp && c == CTRL(d));
	return (c);
}

/*---------------------------------------------------------------
 * getcd -- get next character from user's command, skipping junk
 * characters & doing necessary conversions.
 *
 * This routine calls 'getach' to actually get characters.  See that 
 * function for external variables used.
 *---------------------------------------------------------------
 */
getcd()
{
	register int c;

again:
	c = getach();	/* get next character from user's command */
	if (c == EOF)
		return (c);
			/* (c) . CHANGED  by Uri habusha for vi.iv */
	c = ascspec(c);	/* convert special characters (for vi.iv) */

	/* if in command mode... */
	if (!inopen)
		
		/*
		 * if have reached the end of input, convert the last
		 * character of the user command to newline.
		 */
		if (!globp && c == CTRL(d))
			setlastchar('\n');
		/*
		 * else if a backspace, write error message saying
		 * that it is being discarded & get the next character.
		 */
		else if (junk(c)) {
			checkjunk(c);
			goto again;
		}
	return (c);
}

peekchar()
{

	if (peekc == 0)
		peekc = getchar();
	return (peekc);
}

peekcd()
{
	if (peekc == 0)
		peekc = getcd();
	return (peekc);
}

/*---------------------------------------------------------
* getach -- get a character
* 
* This function returns value of the next character from the user
* command.  It can take the character from a number of sources, in the
* following priority:
* 
* 	the peek-ahead character (variable 'peekc')
* 	buffer pointed to by 'globp'
* 	buffer pointed to by 'input'
* 
* If no character can be found in any of these buffers, characters are
* read from the standard input & placed in input's buffer.
* 
* The character gotten is returned as the function's value, & (unless
* taken from the peek-ahead character) is stored in the variable
* 'lastc'.
* 
* EXTERNAL VARIABLES:
* -------------------
* peekc (in/out) --  peek-ahead character.  0 = there is no peek-ahead
* 	character.  If the function takes the character from
* 	here, it sets this variable to 0.
* globp (in/out) -- 0 = no string in its buffer; any other value
* 	indicates that it points to a character string.  If
* 	the function takes the character from here, it
* 	increments globp to point at the next character of the
* 	string.  The string must end with a null.
*	If globp points to a null string (one possibility is that it
*	originally pointed to a non-null string, but we've reached the
*	end of the string), then globp is set to the NULL pointer.
* input (in/out) -- same structure as globp.
* lastc (out) -- set the character gotten, unless it is gotten from the
* 	peek-ahead character.
* intty (in) -- true if command input comes from a terminal.
* ---------------------------------------------------------------------
*/
getach()
{
	register int c;
	static char inline[BUFSIZ];
	struct stat statb;

	/* if there is a peek-ahead character, get the character from
	 * there 
	 */

	c = peekc;
	if (c != 0) {
		peekc = 0;
		return (c);
	}

	/* if there is a character in globp's buffer, get the
	 * character from there 
	 */

	if (globp) {
		if (*globp)
			return (*globp++);
		globp = 0;
		return (lastc = EOF);
	}

	/* if there is a character in input's buffer, get the
	 * character from there.  The label 'top' is used by the sections
	 * of the function that read from standard input.  After reading
	 * & putting the characters in input's buffer, they jump up to
	 * here 
	 */

top:
	if (input) {
		if (c = *input++) {
			/* (c) . CHANGED  by Uri habusha for vi.iv */
			if (c = ascspec(c))
				return (lastc = c);
			goto top;
		}
		input = 0;
	}

	flush();

	/* else we need to read from standard input.  Do this section
	 * if standard input is a terminal
	 */

	if (intty) {
		c = read(0, inline, sizeof inline - 4);
		if (c < 0)
			return (lastc = EOF);
		if (c == 0 || inline[c-1] != '\n')
			inline[c++] = CTRL(d);
		if (inline[c-1] == '\n')
			noteinp();  /* calculate approximate new
				       screenline positions */
		inline[c] = 0;
		for (c--; c >= 0; c--)
			if (inline[c] == 0)
				/* (c) . CHANGED  by Uri habusha for vi.iv */
				inline[c] = QUOTE;
		input = inline;
		goto top;
	}

	/* if we've gotten this far, then we read from standard input,
	 * but standard input is NOT a terminal 
	 */

	c = read(0, inline, sizeof inline - 1);
	if(c <= 0)
		return(lastc = EOF);
	inline[c] = '\0';
	input = inline;
	goto top;
}

/*
 * Input routine for insert/append/change in command mode.
 * Most work here is in handling autoindent.
 */
static	short	lastin;

gettty()
{
	register int c = 0;
	register char *cp = genbuf;
	char hadup = 0;
	int numbline();
	extern int (*Pline)();
	int offset = (Pline == numbline ? 8 : 0);
	int ch;

	if (intty && !inglobal) {
		if (offset) {
			holdcm = 1;
			printf("  %4d  ", lineDOT() + 1);
			flush();
			holdcm = 0;
		}
		if (value(AUTOINDENT) ^ aiflag) {
			holdcm = 1;
#ifdef LISPCODE
			if (value(LISP))
				lastin = lindent(dot + 1);
#endif
			tab(lastin + offset);
			while ((c = getcd()) == CTRL(d)) {
				if (lastin == 0 && isatty(0) == -1) {
					holdcm = 0;
					return (EOF);
				}
				lastin = backtab(lastin);
				tab(lastin + offset);
			}
			switch (c) {

			case '^':
			case '0':
				ch = getcd();
				if (ch == CTRL(d)) {
					if (c == '0')
						lastin = 0;
					if (!OS) {
				/* (c) . CHANGED  by Uri habusha for vi.iv */
						putchar(BQ);
						putchar(SQ);
						putchar(BQ);
					}
					tab(offset);
					hadup = 1;
					c = getchar();
				} else
					ungetchar(ch);
				break;

			case '.':
				if (peekchar() == '\n') {
					ignchar();
					noteinp();
					holdcm = 0;
					return (EOF);
				}
				break;

			case '\n':
				hadup = 1;
				break;
			}
		}
		flush();
		holdcm = 0;
	}
	if (c == 0)
		c = getchar();
	while (c != EOF && c != '\n') {
		if (cp > &genbuf[LBSIZE - 2])
			error("Input line too long");
		*cp++ = c;
		c = getchar();
	}
	if (c == EOF) {
		if (inglobal)
			ungetchar(EOF);
		return (EOF);
	}
	*cp = 0;
	cp = linebuf;
	if ((value(AUTOINDENT) ^ aiflag) && hadup == 0 && intty && !inglobal) {
		lastin = c = smunch(lastin, genbuf);
		for (c = lastin; c >= value(TABSTOP); c -= value(TABSTOP))
			*cp++ = '\t';
		for (; c > 0; c--)
			*cp++ = ' ';
	}
	CP(cp, genbuf);
	if (linebuf[0] == '.' && linebuf[1] == 0)
		return (EOF);
	return (0);
}

/*
 * Crunch the indent.
 * Hard thing here is that in command mode some of the indent
 * is only implicit, so we must seed the column counter.
 * This should really be done differently so as to use the whitecnt routine
 * and also to hack indenting for LISP.
 */
smunch(col, ocp)
	register int col;
	char *ocp;
{
	register char *cp;

	cp = ocp;
	for (;;)
		switch (*cp++) {

		case ' ':
			col++;
			continue;

		case '\t':
			col += value(TABSTOP) - (col % value(TABSTOP));
			continue;

		default:
			cp--;
			CP(ocp, cp);
			return (col);
		}
}

char	*cntrlhm =	"^H discarded\n";

checkjunk(c)
	char c;
{

	if (junkbs == 0 && c == '\b') {
		write(2, cntrlhm, 13);
		junkbs = 1;
	}
}

line *
setin(addr)
	line *addr;
{

	if (addr == zero)
		lastin = 0;
	else
		getline(*addr, ishef), lastin = smunch(0, linebuf);
}
