/* 
  hzfont version 1.0

  Copyright (C) 1989    Fung Fung Lee (lee@umunhum.stanford.edu)

  Hanzi bitmap format:
  The bitmap of each hanzi is scanned from left to right, and top to bottom.
  For the NxN/8 bytes belonging to a N dot hanzi, the MSB of the first byte
  is the upper left bit; the LSB of the last byte is the lower right bit.

  This program is free for general distribution.  

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>

extern char fontdir[], hzfont[];
extern int hzbyte;

#define GB0 0x2121	/* starting code of GB1 symbols */
#define GB1 0x3021	/* starting code of GB1 hanzi */
#define GB2 0x5821	/* starting code of GB2 hanzi */
#define GBU 0x7821	/* starting code of GB user defined hanzi */
#define GBX 0x7921	/* starting code of my own GB extension */
#define GBXe 0x7A7E	/* ending code of my own GB extension */

#define GBbegin GB0
#define GBend   GBXe
#define GBbox   0x2175	/* ? GB "blank box" code */

#define HB(code)	(((code)&0xff00) >> 8)
#define	LB(code)	((code)&0x00ff)

int indexSize;		/* total number of GB codes in range */
char Font0[80], Font[80], Font1[80], Font2[80], FontX[80];
char *bitmap, *bitmap0, *bitmap1, *bitmap2, *bitmapX;
int bn0, bn1, bn2, bnX, bn;

int GB2Index();
char *HZbitmap();
loadHZfont();


int GB2Index(code)
     unsigned int code;
{
  return ((HB(code) - 0x21) * 0x5E + (LB(code)) - 0x21);
}


char *HZbitmap(code)
     unsigned int code ;
{    
    char *ptr;

    if ((code >= GBbegin) && (code <= GBend))
      ptr = bitmap + GB2Index(code) * hzbyte;
    else
      {
	ptr = bitmap + GB2Index(GBbox) * hzbyte;
        fprintf(stderr, "Error: GB code out of range: %x\n", code);
      }
    return ptr;
}


loadHZfont()
{
    FILE *f;
    char *fname;
    char *calloc();

    indexSize = GB2Index(GBend) + 1;
    bn0 = (GB2Index(GB1)-GB2Index(GB0)) * hzbyte;
    bn1 = (GB2Index(GB2)-GB2Index(GB1)) * hzbyte;
    bn2 = (GB2Index(GBU)-GB2Index(GB2)) * hzbyte;
    bnX = (GB2Index(GBXe)-GB2Index(GBX)+1) * hzbyte;
    bn  = (GB2Index(GBend)-GB2Index(GBbegin)+1) * hzbyte;
    if ((bitmap = calloc(bn, 1)) == NULL)
      {
	fprintf(stderr, "Can't allocate enough memory.\n");
	exit(1);
      }
    bitmap0 = bitmap;
    bitmap1 = bitmap + (GB2Index(GB1)-GB2Index(GB0)) * hzbyte;
    bitmap2 = bitmap + (GB2Index(GB2)-GB2Index(GB0)) * hzbyte;
    bitmapX = bitmap + (GB2Index(GBX)-GB2Index(GB0)) * hzbyte;

    strcpy(Font, fontdir);
    strcat(Font, hzfont);
    strcpy(Font0, Font);
    strcat(Font0, ".0");
    strcpy(Font1, Font);
    strcat(Font1, ".1");
    strcpy(Font2, Font);
    strcat(Font2, ".2");
    strcpy(FontX, Font);
    strcat(FontX, ".X");

    if ((f = fopen(Font0, "r")) == 0)
    {
	fprintf(stderr, "Can't open font file %s\n", Font0);
	exit(1);
    }
    if (fread(bitmap0, 1, bn0, f) != bn0)
    {
#if EXACT
	fprintf(stderr, "Error in reading font file %s\n", Font0);
	exit(1);
#endif
    }
    fclose(f);
    if ((f = fopen(Font1, "r")) == 0)
    {
	fprintf(stderr, "Can't open font file %s\n", Font1);
	exit(1);
    }
    if (fread(bitmap1, 1, bn1, f) != bn1)
    {
#if EXACT
	fprintf(stderr, "Error in reading font file %s\n", Font1);
	exit(1);
#endif
    }
    fclose(f);
    if ((f = fopen(Font2, "r")) == 0)
    {
	fprintf(stderr, "Can't open font file %s\n", Font2);
	exit(1);
    }
    if (fread(bitmap2, 1, bn2, f) != bn2)
    {
#if EXACT
	fprintf(stderr, "Error in reading font file %s\n", Font2);
	exit(1);
#endif
    }
    fclose(f);
    if ((f = fopen(FontX, "r")) == 0)
    {
	fprintf(stderr, "Can't open font file %s\n", FontX);
	return;
#ifdef XGB
	exit(1);
#endif
    }
    if (fread(bitmapX, 1, bnX, f) != bnX)
    {
#ifdef XGB
	fprintf(stderr, "Error in reading font file %s\n", FontX);
	exit(1);
#endif
    }
    fclose(f);
}
