/* VTparse()
 * finput()
 * splitted from charproc.c
 *
 */

#include <X11/copyright.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>

#include <stdio.h>
#include <X11/Xos.h>
#ifndef CRAY
#include <sgtty.h>
#endif
#include <ctype.h>
#include <errno.h>
#include <setjmp.h>
#if defined(macII) || defined(CRAY)
#undef FIOCLEX					/* redefined from sgtty.h */
#undef FIONCLEX					/* redefined from sgtty.h */
#endif
#include "ptyx.h"
#include "VTparse.h"
#include "data.h"
#include <X11/Xutil.h>
#include "error.h"
#include "main.h"
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include "menu.h"

#ifdef NEW_HANZI
#include "hzinput.h"
extern HZinputTable *cHZtbl;
#endif /* NEW_HANZI */

#define	DEFAULT		-1
#define	TEXT_BUF_SIZE	256
#define TRACKTIMESEC	4L
#define TRACKTIMEUSEC	0L

#ifdef HANZI
extern	int nparam;
extern	ANSI reply;
extern	int param[]; /* [NPARAM]; */

extern	jmp_buf vtjmpbuf;
#endif/*HANZI*/

#ifdef NEW_HANZI
extern	unsigned char hz_text_buf[] ; /* [2] */
extern	unsigned char *hz_text_ptr ;
extern	unsigned char pending_char ;
extern	int pending_cnt;
int	isInsertHanzi ;
		/* when insert hz_char,
		 * if line is feed,
		 * then isInsertHanzi == 1
		 */
int	insertchar;
		/* when insert char,
		 * if last char of line is hz_char,
		 * then insertchar == 1
		 */
#endif /* NEW_HANZI */

extern int groundtable[];
extern int csitable[];
extern int dectable[];
extern int eigtable[];
extern int esctable[];
extern int iestable[];
extern int igntable[];
extern int scrtable[];
extern int scstable[];

#ifdef HANZI
#define doinput()               (0xff & (bcnt-- > 0 ? *bptr++ : in_put()))

#else /* HANZI */
#define doinput()               (bcnt-- > 0 ? *bptr++ : in_put())
#endif /* HANZI */

VTparse()
{
	register TScreen *screen = &term->screen;
	register int *parsestate = groundtable;
	register unsigned int c;
	register unsigned char *cp;
	register int row, col, top, bot, scstype;
#ifdef HANZI
        register unsigned char *ucp;
#endif /* HANZI */

	extern int bitset(), bitclr(), finput(), TrackMouse();

	if(setjmp(vtjmpbuf))
		parsestate = groundtable;
#ifdef HANZI
        hz_text_ptr = hz_text_buf ;
        pending_char = insertchar = 0;
        pending_cnt =  isInsertHanzi = 0;
        for(c = doinput(); ; c = doinput()) {
                /* if pending_cnt then
                        	## 1st Hanzi byte has been saved
                        if c < 0x80 then	## ignore c
                                bcnt -- ;
                                top -- ;
                                bptr ++ ;
                                continue ;
                        else	## c IS 2nd Hanzi byte
                                pending_cnt = 0 ;
                                doCtext();
                                ucp = bptr ;
                        end if
                        continue
                   end if
                 */

	    if (insertchar &&  screen->hz_do_wrap ) {
	    	if (c & 0x80) {
	    		insertchar = 0;
	    		screen->hz_do_wrap = 0;
	    		continue;
	    	}
	    }
	    if ((pending_cnt == 1) && (c & 0x80)) {
	    	*hz_text_ptr++ = c;
	    	if ( isInsertHanzi ) {
	    		screen->cur_col--;
	    		doCtext (screen, term->flags, hz_text_buf, hz_text_ptr) ;
	    		isInsertHanzi = 0;
	    	}
	    	else
	    		doCtext (screen, term->flags, hz_text_buf, hz_text_ptr) ;
	    	pending_cnt = 0 ;
	    	hz_text_ptr = hz_text_buf;
	    	if ( screen->hz_do_wrap )
	    		insertchar = 1;
	    	continue;
	    }
#ifdef NEW_HANZI
	    else {	/* pending_cnt != 1 || !(c & 0x80) */
	    	pending_cnt = 0 ;
	    	hz_text_ptr = hz_text_buf;
	    }
#endif/*NEW_HANZI*/

	    if (c & 0x80) {
	    	*--bptr = c;
	    	bcnt++;
	    	top = bcnt > TEXT_BUF_SIZE ? TEXT_BUF_SIZE : bcnt;
	    	ucp = (unsigned char *)bptr;

#ifdef	NEW_HANZI
		if (screen->HZ_encoding == 0) {
	    	    while ((top > 0) && (*ucp & 0x80)) {
	    		top--, bcnt--, ucp++;
	    		pending_cnt++;
	    	    }
		} else {
	    	    while ((top > 0) && (*ucp & 0x80)) {
	    		top--, bcnt--, ucp++;
	    		pending_cnt++;

			if (top > 0) {	/* 2nd byte not checked */
	    		    top--, bcnt--, ucp++;
	    		    pending_cnt++;
			}
	    	    }
		}
#else	/* NEW_HANZI */
	    	while (top > 0 && (c = *ucp & 0xff) >= 0x80) {
	    		top--, bcnt--, ucp++;
	    		pending_cnt++;
	    	}
#endif	/* NEW_HANZI */
	    
	    	if (pending_cnt == 1) {
	    		c = screen->buf[ 2 * screen->cur_row][ screen->max_col];
	    		if (c)
	    			isInsertHanzi = 1;
	    		if ( screen->hz_do_wrap )
	    			insertchar = 1;
	    		*hz_text_ptr++ = *(ucp - 1) ;
	    	}
	    
	    	if ( pending_cnt > 1 )
	    		doCtext(screen, term->flags,  bptr, ucp);
	    
	    	bptr = (Char *) ucp;
	    } else {
                switch (parsestate[c &= 0x7f]) {
#else /* HANZI */
        for( ; ; )
                switch (parsestate[c = doinput()]) {
#endif /* HANZI */
		 case CASE_PRINT:
			/* printable characters */
#ifdef HANZI
			if ( screen->hz_do_wrap )
				insertchar = 1;
#endif /* HANZI */
			top = bcnt > TEXT_BUF_SIZE ? TEXT_BUF_SIZE : bcnt;
			cp = bptr;
			*--bptr = c;
#ifdef HANZI
			while(top > 0 && ! (*cp & 0x80) && isprint(*cp) ) {
#else /* HANZI */
			while(top > 0 && isprint(*cp & 0x7f)) {
#endif /* HANZI */
				top--;
				bcnt--;
				cp++;
			}
			if(screen->curss) {
				dotext(screen, term->flags,
				 screen->gsets[screen->curss], bptr, bptr + 1);
				screen->curss = 0;
				bptr++;
			}
			if(bptr < cp)
				dotext(screen, term->flags,
				 screen->gsets[screen->curgl], bptr, cp);
			bptr = cp;
			break;

		 case CASE_GROUND_STATE:
			/* exit ignore mode */
			parsestate = groundtable;
			break;

		 case CASE_IGNORE_STATE:
			/* Ies: ignore anything else */
			parsestate = igntable;
			break;

		 case CASE_IGNORE_ESC:
			/* Ign: escape */
			parsestate = iestable;
			break;

		 case CASE_IGNORE:
			/* Ignore character */
			break;

		 case CASE_BELL:
			/* bell */
			Bell();
			break;

		 case CASE_BS:
			/* backspace */
			CursorBack(screen, 1);
			break;

		 case CASE_CR:
			/* carriage return */
			CarriageReturn(screen);
			break;

		 case CASE_ESC:
			/* escape */
			parsestate = esctable;
			break;

		 case CASE_VMOT:
			/*
			 * form feed, line feed, vertical tab
			 */
			Index(screen, 1);
			if (term->flags & LINEFEED)
				CarriageReturn(screen);
			if (screen->display->qlen > 0 ||
			    GetBytesAvailable (screen->display->fd) > 0)
			  xevents();
			break;

		 case CASE_TAB:
			/* tab */
			screen->cur_col = TabNext(term->tabs, screen->cur_col);
			if (screen->cur_col > screen->max_col)
				screen->cur_col = screen->max_col;
			break;

		 case CASE_SI:
			screen->curgl = 0;
			break;

		 case CASE_SO:
			screen->curgl = 1;
			break;

		 case CASE_SCR_STATE:
			/* enter scr state */
			parsestate = scrtable;
			break;

		 case CASE_SCS0_STATE:
			/* enter scs state 0 */
			scstype = 0;
			parsestate = scstable;
			break;

		 case CASE_SCS1_STATE:
			/* enter scs state 1 */
			scstype = 1;
			parsestate = scstable;
			break;

		 case CASE_SCS2_STATE:
			/* enter scs state 2 */
			scstype = 2;
			parsestate = scstable;
			break;

		 case CASE_SCS3_STATE:
			/* enter scs state 3 */
			scstype = 3;
			parsestate = scstable;
			break;

		 case CASE_ESC_IGNORE:
			/* unknown escape sequence */
			parsestate = eigtable;
			break;

		 case CASE_ESC_DIGIT:
			/* digit in csi or dec mode */
			if((row = param[nparam - 1]) == DEFAULT)
				row = 0;
			param[nparam - 1] = 10 * row + (c - '0');
			break;

		 case CASE_ESC_SEMI:
			/* semicolon in csi or dec mode */
			param[nparam++] = DEFAULT;
			break;

		 case CASE_DEC_STATE:
			/* enter dec mode */
			parsestate = dectable;
			break;

		 case CASE_ICH:
			/* ICH */
			if((row = param[0]) < 1)
				row = 1;
			InsertChar(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_CUU:
			/* CUU */
			if((row = param[0]) < 1)
				row = 1;
			CursorUp(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_CUD:
			/* CUD */
			if((row = param[0]) < 1)
				row = 1;
			CursorDown(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_CUF:
			/* CUF */
			if((row = param[0]) < 1)
				row = 1;
			CursorForward(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_CUB:
			/* CUB */
			if((row = param[0]) < 1)
				row = 1;
			CursorBack(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_CUP:
			/* CUP | HVP */
			if((row = param[0]) < 1)
				row = 1;
			if(nparam < 2 || (col = param[1]) < 1)
				col = 1;
			CursorSet(screen, row-1, col-1, term->flags);
			parsestate = groundtable;
			break;

		 case CASE_ED:
			/* ED */
			switch (param[0]) {
			 case DEFAULT:
			 case 0:
				ClearBelow(screen);
				break;

			 case 1:
				ClearAbove(screen);
				break;

			 case 2:
				ClearScreen(screen);
				break;
			}
#ifdef HANZI
			HZi_ReshowInputArea (screen);
#endif/*HANZI*/
			parsestate = groundtable;
			break;

		 case CASE_EL:
			/* EL */
			switch (param[0]) {
			 case DEFAULT:
			 case 0:
				ClearRight(screen);
				break;
			 case 1:
				ClearLeft(screen);
				break;
			 case 2:
				ClearLine(screen);
				break;
			}
			parsestate = groundtable;
			break;

		 case CASE_IL:
			/* IL */
			if((row = param[0]) < 1)
				row = 1;
			InsertLine(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_DL:
			/* DL */
			if((row = param[0]) < 1)
				row = 1;
			DeleteLine(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_DCH:
			/* DCH */
			if((row = param[0]) < 1)
				row = 1;
			DeleteChar(screen, row);
			parsestate = groundtable;
			break;

		 case CASE_TRACK_MOUSE:
		 	/* Track mouse as long as in window and between
			   specified rows */
			TrackMouse(param[0], param[2]-1, param[1]-1,
			 param[3]-1, param[4]-2);
			break;

		 case CASE_DECID:
			param[0] = -1;		/* Default ID parameter */
			/* Fall through into ... */
		 case CASE_DA1:
			/* DA1 */
			if (param[0] <= 0) {	/* less than means DEFAULT */
				reply.a_type   = CSI;
				reply.a_pintro = '?';
				reply.a_nparam = 2;
				reply.a_param[0] = 1;		/* VT102 */
				reply.a_param[1] = 2;		/* VT102 */
				reply.a_inters = 0;
				reply.a_final  = 'c';
				unparseseq(&reply, screen->respond);
			}
			parsestate = groundtable;
			break;

		 case CASE_TBC:
			/* TBC */
			if ((row = param[0]) <= 0) /* less than means default */
				TabClear(term->tabs, screen->cur_col);
			else if (row == 3)
				TabZonk(term->tabs);
			parsestate = groundtable;
			break;

		 case CASE_SET:
			/* SET */
			modes(term, bitset);
			parsestate = groundtable;
			break;

		 case CASE_RST:
			/* RST */
			modes(term, bitclr);
			parsestate = groundtable;
			break;

		 case CASE_SGR:
			/* SGR */
			for (row=0; row<nparam; ++row) {
				switch (param[row]) {
				 case DEFAULT:
				 case 0:
					term->flags &= ~(INVERSE|BOLD|UNDERLINE);
					break;
				 case 1:
				 case 5:	/* Blink, really.	*/
					term->flags |= BOLD;
					break;
				 case 4:	/* Underscore		*/
					term->flags |= UNDERLINE;
					break;
				 case 7:
					term->flags |= INVERSE;
				}
			}
			parsestate = groundtable;
			break;

		 case CASE_CPR:
			/* CPR */
			if ((row = param[0]) == 5) {
				reply.a_type = CSI;
				reply.a_pintro = 0;
				reply.a_nparam = 1;
				reply.a_param[0] = 0;
				reply.a_inters = 0;
				reply.a_final  = 'n';
				unparseseq(&reply, screen->respond);
			} else if (row == 6) {
				reply.a_type = CSI;
				reply.a_pintro = 0;
				reply.a_nparam = 2;
				reply.a_param[0] = screen->cur_row+1;
				reply.a_param[1] = screen->cur_col+1;
				reply.a_inters = 0;
				reply.a_final  = 'R';
				unparseseq(&reply, screen->respond);
			}
			parsestate = groundtable;
			break;

		 case CASE_DECSTBM:
			/* DECSTBM */
			if((top = param[0]) < 1)
				top = 1;
			if(nparam < 2 || (bot = param[1]) == DEFAULT
			   || bot > screen->max_row + 1
			   || bot == 0)
				bot = screen->max_row+1;
			if (bot > top) {
				if(screen->scroll_amt)
					FlushScroll(screen);
				screen->top_marg = top-1;
				screen->bot_marg = bot-1;
				CursorSet(screen, 0, 0, term->flags);
			}
			parsestate = groundtable;
			break;

		 case CASE_DECREQTPARM:
			/* DECREQTPARM */
			if ((row = param[0]) == DEFAULT)
				row = 0;
			if (row == 0 || row == 1) {
				reply.a_type = CSI;
				reply.a_pintro = 0;
				reply.a_nparam = 7;
				reply.a_param[0] = row + 2;
				reply.a_param[1] = 1;	/* no parity */
				reply.a_param[2] = 1;	/* eight bits */
				reply.a_param[3] = 112;	/* transmit 9600 baud */
				reply.a_param[4] = 112;	/* receive 9600 baud */
				reply.a_param[5] = 1;	/* clock multiplier ? */
				reply.a_param[6] = 0;	/* STP flags ? */
				reply.a_inters = 0;
				reply.a_final  = 'x';
				unparseseq(&reply, screen->respond);
			}
			parsestate = groundtable;
			break;

		 case CASE_DECSET:
			/* DECSET */
			dpmodes(term, bitset);
			parsestate = groundtable;
			if(screen->TekEmu)
				return;
			break;

		 case CASE_DECRST:
			/* DECRST */
			dpmodes(term, bitclr);
			parsestate = groundtable;
			break;

		 case CASE_DECALN:
			/* DECALN */
			if(screen->cursor_state)
				HideCursor();
			for(row = screen->max_row ; row >= 0 ; row--) {
				bzero(screen->buf[2 * row + 1],
				 col = screen->max_col + 1);
				for(cp = (unsigned char *)screen->buf[2 * row] ; col > 0 ; col--)
					*cp++ = (unsigned char) 'E';
			}
                        ScrnRefresh(screen, 0, 0, screen->max_row + 1,
                         screen->max_col + 1, False);
			parsestate = groundtable;
#ifdef NEW_HANZI
			/* printf( "CASE_DECALN\n" ); */
#endif/*NEW_HANZI*/
			break;

		 case CASE_GSETS:
			screen->gsets[scstype] = c;
			parsestate = groundtable;
			break;

		 case CASE_DECSC:
			/* DECSC */
			CursorSave(term, &screen->sc);
			parsestate = groundtable;
			break;

		 case CASE_DECRC:
			/* DECRC */
			CursorRestore(term, &screen->sc);
			parsestate = groundtable;
			break;

		 case CASE_DECKPAM:
			/* DECKPAM */
			term->keyboard.flags |= KYPD_APL;
			update_appkeypad();
			parsestate = groundtable;
			break;

		 case CASE_DECKPNM:
			/* DECKPNM */
			term->keyboard.flags &= ~KYPD_APL;
			update_appkeypad();
			parsestate = groundtable;
			break;

		 case CASE_IND:
			/* IND */
			Index(screen, 1);
			if (screen->display->qlen > 0 ||
			    GetBytesAvailable (screen->display->fd) > 0)
			  xevents();
			parsestate = groundtable;
			break;

		 case CASE_NEL:
			/* NEL */
			Index(screen, 1);
			CarriageReturn(screen);
			
			if (screen->display->qlen > 0 ||
			    GetBytesAvailable (screen->display->fd) > 0)
			  xevents();
			parsestate = groundtable;
			break;

		 case CASE_HTS:
			/* HTS */
			TabSet(term->tabs, screen->cur_col);
			parsestate = groundtable;
			break;

		 case CASE_RI:
			/* RI */
			RevIndex(screen, 1);
			parsestate = groundtable;
			break;

		 case CASE_SS2:
			/* SS2 */
			screen->curss = 2;
			parsestate = groundtable;
			break;

		 case CASE_SS3:
			/* SS3 */
			screen->curss = 3;
			parsestate = groundtable;
			break;

		 case CASE_CSI_STATE:
			/* enter csi state */
			nparam = 1;
			param[0] = DEFAULT;
			parsestate = csitable;
			break;

		 case CASE_OSC:
			/* do osc escapes */
			do_osc(finput);
			parsestate = groundtable;
			break;

		 case CASE_RIS:
			/* RIS */
			VTReset(TRUE);
			parsestate = groundtable;
			break;

		 case CASE_LS2:
			/* LS2 */
			screen->curgl = 2;
			parsestate = groundtable;
			break;

		 case CASE_LS3:
			/* LS3 */
			screen->curgl = 3;
			parsestate = groundtable;
			break;

		 case CASE_LS3R:
			/* LS3R */
			screen->curgr = 3;
			parsestate = groundtable;
			break;

		 case CASE_LS2R:
			/* LS2R */
			screen->curgr = 2;
			parsestate = groundtable;
			break;

		 case CASE_LS1R:
			/* LS1R */
			screen->curgr = 1;
			parsestate = groundtable;
			break;

		 case CASE_XTERM_SAVE:
			savemodes(term);
			parsestate = groundtable;
			break;

		 case CASE_XTERM_RESTORE:
			restoremodes(term);
			parsestate = groundtable;
			break;
		} /*switch*/
#ifdef HANZI
        } /* if (c & 0x80) {...} else {...} */
    } /* for(c = doinput(); ; c = doinput())*/
#endif /* HANZI */
}

finput()
{
	return(doinput());
}

#ifdef NEW_HANZI
/**************************************************************
 * The following for drawing in HanZi Input area,
 * i.e. HZInputWindow:
 */

HZ_XDrawImageStringMix (display, d, gc, hzgc, x, y, string, length, fontwidth)
    Display *display;
    Drawable d;
    GC gc, hzgc;
    int x, y;
    char *string;
    register int length;
    int fontwidth;
{
    register char *ptr = string;
    register int i;

    /* fontwidth is used to compute the width of the string.
     * A more orthogonal way than this is to XQueryTextExtend using gc/hzgc.
     */
    while (length) {
	char *sptr;

	/*
	 * Draw substrings as long as possible to avoid overhead.
	 * But if HZ fontwidth is not 2 * (normal fontwidth), we have to
	 * draw them one by one. Suck. I am not going to do this. -YGZ
	 */
	sptr = ptr;
	i = 0;
	while (!(*ptr & 0x80) && length) {
	    ptr++; i++; length --;
	}
	if (ptr != sptr) {
	    XDrawImageString (display, d, gc, x, y, sptr, i);
	    x += fontwidth * i;
	}

	sptr = ptr;
	i = 0;
	while ((*ptr & 0x80) && length) {
	    if (--length) {
		ptr++; ptr++; i++; length--;
		/* should check 2nd byte according to GB or BIG5 */
	    } else
		break;
	}
	if (ptr != sptr) {
	    XDrawImageString16 (display, d, hzgc, x, y, sptr, i);
	    x += (fontwidth * 2) * i;
	}
    }
}

HZi_ShowPrompt( screen )
 TScreen *screen ;
{
 Window prompt_window ;
 int	xLine ;
 int	yLine ;
 GC	currentGC ;

	prompt_window = TextWindow(screen) ;

	yLine = screen->hzInputWindow.pro_yRuleLine ;

	/* special value of x
	 * not depends on screen->hzInputWindow.pro_col
	 */
	xLine = screen->scrollbar ;

	currentGC = screen->hz_normalGC ;

	XDrawLine( screen->display,
		prompt_window,
		currentGC,
		xLine,
		yLine,
		term->core.width,
		yLine ); 

	HZ_XDrawImageStringMix (screen->display,
		prompt_window,
		screen->normalGC, screen->hz_normalGC,
		xLine + screen->border,
		yLine + 1 + screen->hzInputWindow.f_ascent,
		(char *)cHZtbl->prompt, cHZtbl->lenPrompt,
		FontWidth(screen) );

#ifdef PONG
	XFlush( screen->display );
#endif
}

HZi_ClearHzInput( screen )
	TScreen * screen ;
/*
 * REQUIRE: dpyInbufLen properly set
 *
 * Clear from the end of current HZ input display buffer till
 * the Right Hand Side of window.
 */
{
 extern int dpyInbufLen;
 Window window = TextWindow( screen );
 int y = screen->hzInputWindow.pro_yRuleLine + 1;
 int x = screen->scrollbar + screen->border +
	 (cHZtbl->lenPrompt + dpyInbufLen) * FontWidth(screen) ;

    XClearArea (screen->display,
		window,
		x,
		y, /* line top, not line bottom */
		0,		/* term->core.width - x, */
		screen->hzInputWindow.f_height,
		False );	/* no Expose event */
#ifdef PONG
	XFlush( screen->display );
#endif
}

HZi_ReshowUserInput( screen )
	TScreen * screen ;
/*
 * (Re-)Show the current string of user HZ input.
 *
 * No need XFlush() as must be some procedure(s)
 * which has XFlush() follows this procedure.
 */
{
 Window window ;
 int y ;
 int x ;
 extern int dpyInbufLen;
 extern Char dpyInbuf[];

    if (dpyInbufLen == 0)
	return;
    window = TextWindow( screen );
    y = screen->hzInputWindow.pro_yRuleLine + 1 + screen->hzInputWindow.f_ascent;
    x = screen->scrollbar + screen->border +
		(cHZtbl->lenPrompt * FontWidth(screen));
    HZ_XDrawImageStringMix (screen->display,
		window,
		screen->normalGC, screen->hz_normalGC,
		x, y,
		(char *)dpyInbuf, dpyInbufLen,
		FontWidth(screen) );
}

HZi_ClearInputChoice( screen )
	TScreen * screen ;
/*
 * Not REQUIRE: screen->hzInputWindow.pro_col has value of
 *			current HZ input column no.
 * because x is calculated explicitly
 */
{
 Window prompt_window ;
 int	x ;
 int	y ;

	prompt_window = TextWindow(screen) ;
	y = screen->hzInputWindow.pro_yRuleLine + 1 + screen->hzInputWindow.f_height ;

	/* special value of x
	 * not depends on screen->hzInputWindow.pro_col
	 */
 	x = screen->scrollbar + screen->border ;

	/* ClearArea at top of line of char (not bottom) :
	 * y + height_of_1_line - height_of_the_line == y
	 */
	XClearArea( screen->display,
		prompt_window,
		x,
		y,
		0, /* term->core.width - x, /* => term->core.width - x */
		screen->hzInputWindow.f_height,
		FALSE );	/* no Expose event */
#ifdef PONG
	XFlush( screen->display );
#endif
}

HZi_ShowInputChoices (screen)
	TScreen * screen ;
{
    extern Char    dpyChoices[];
    extern int     dpyChoicesLen;
    Window prompt_window ;
    int	x ;
    int	y ;

    prompt_window = TextWindow(screen) ;

    /* special value of y is
     * 2 text lines below start y of HZ input area
     * -- each Input Choice is shown at 2nd text line.
     */
    y = screen->hzInputWindow.pro_yRuleLine + 1 +
	screen->hzInputWindow.f_height + screen->hzInputWindow.f_ascent ;

    /* special value of x: start from the border */
    x = screen->scrollbar + screen->border ;

    HZ_XDrawImageStringMix (screen->display,
			prompt_window,
			screen->normalGC, screen->hz_normalGC,
			x, y,
			(char *)dpyChoices, dpyChoicesLen,
			FontWidth (screen) );
#ifdef PONG
	XFlush( screen->display );
#endif
}

/* Temporally display one line of message on the 2nd row of the input area */ 
HZi_ShowMesg (screen, mesgstr)
    TScreen *screen ;
    char *mesgstr;
{
    int	x, y;

	HZi_ClearInputChoice( screen );

	/* special value of y is
	 * 2 text lines below start y of HZ input area
	 * -- each Input Choice is shown at 2nd text line.
	 */
	y = screen->hzInputWindow.pro_yRuleLine + 1 +
		screen->hzInputWindow.f_height + screen->hzInputWindow.f_ascent ;
 	x = screen->scrollbar + screen->border ;

	HZ_XDrawImageStringMix (screen->display,
		TextWindow(screen),
		screen->normalGC, screen->hz_normalGC,
		x, y,
		mesgstr, strlen (mesgstr),
		FontWidth (screen) );
}

HZi_ClearArea( screen )
 TScreen *screen ;
/*
 * Clear whole HZ input area
 */
{
 Window prompt_window ;
 int	xLine ;
 int	yLine ;

	prompt_window = TextWindow(screen) ;
	yLine = screen->hzInputWindow.pro_yRuleLine ;

	/* special value of x
	 * not depends on screen->hzInputWindow.pro_col
	 */
	xLine = screen->scrollbar ;

	XClearArea( screen->display,
		prompt_window,
		xLine,
		yLine,
		0, /* HZInputWindowWidth(screen), /* term->core.width, */
		0, /* HZInputWindowHeight(screen), /* 0 => window's full height - yLine, */
		FALSE );	/* no Expose event */
}

HZi_ReshowInputArea( screen )
 TScreen *screen ;
{
    HZi_ClearArea (screen);
    HZi_ShowPrompt (screen);
    HZi_ReshowUserInput (screen);
    HZi_ShowInputChoices (screen);
}

#endif/*NEW_HANZI*/
