# This file is part of the CJK package for LaTeX2e.
#
# $Id: li.mak,v 1.5 1997/06/25 02:43:30 d791013 Exp $

# Part of makefile, included by the Makefile of ntu2cjk.

# ------------- user-defined ---------------


# Directories:
# ============

#   the TeX root 
TEXDIR = /usr/local/lib/texmf

#   dir. where the file psfonts.map is taken from and installed to again.
#   It doesn't matter if there is no psfonts.map in $(PSMAPDIR).
PSMAPDIR = $(TEXDIR)/dvips

#   the directory where the created .tfm files are installed.
TFMDIR = $(TEXDIR)/fonts/tfm/ntuttf/li

#   the GS dir,
GSDIR = /usr/local/lib/ghostscript

#   the GS home dir where the file Fontmap is taken from and installed to
#   again.
#   It doesn't matter if there is no Fontmap in $(GSMAPDIR); in this case
#   the makefile will create one for all fonts being created smoothly.
GSMAPDIR = $(GSDIR)/3.53

#   GS font dir where the created CJK PostScript fonts are installed.
GSFONTDIR = $(TEXDIR)/fonts/type1/ntuttf/li


# Font Specific:
# ==============

#   Uncomment the line below if you want to use the 'pmC' font encoding with
#   CJK package. (Or, you want to generate Type 0 PostScript font.)
#PMC = -p

#   Uncomment the line below if you are using dvips 5.66 or higher and
#   expecting use of the partially downloading feature. (recommanded)
#DOWNLOAD = -d

#   Create extended fonts (1.2 times width)? See README for more information.
#   possible options are "NO" and "YES".
#EXTENDED_FONTS = YES

#   The NTU TrueType font.
FONTSRC = /usr/local/lib/ntuttf/ttf/b5li.ttf

#   Prefix of the font files. 
#     The output font files will be $FONTFL[01-55].pfb
FONTFL = b5li

ifeq ($(EXTENDED_FONTS),YES)
#   prefix for the extended fonts (width is 1.2 times the normal font)
FONTxFL = b5lix
endif

#   Prefix for the FontName. 
#     The FontName used in the Type 1 fonts will be $FONTNAME[01-55]
FONTNAME = LiSu

#   Prefix of the UniqueID number for Type 1 fonts.
#     The true UniqueID numbers will be $(FONTUID)[001-055].
#     I personally use the following font UID prefix (no special rules) 
#     for different fonts:
#		family		UID-prefix	Fontname-prefix
#		=====		==========	===============
#		kai		4701		KaiSu
#		ming		4702		MingTi
#		li		4703		LiSu
#		hei		4704		HeiTi
#		fs		4705		FangSong
#		yuan		4706		YuanTi
#		jixi		4707		JiXi
#		...
#     You should change these prefixes for your own use. Or just as above.  
FONTUID = 4703

ifeq ($(PMC),)
  #   CJK sub-font planes [01-55] (compressed)
  PLANES = \
    01 02 03 04 05 06 07 08 09 10 \
    11 12 13 14 15 16 17 18 19 20 \
    21 22 23 24 25 26 27 28 29 30 \
    31 32 33 34 35 36 37 38 39 40 \
    41 42 43 44 45 46 47 48 49 50 \
    51 52 53 54 55
else
  #   Big-5 sub-font planes [A1-FE]
  PLANES = \
       a1 a2 a3 a4 a5 a6 a7 a8 a9 aa ab ac ad ae af \
    b0 b1 b2 b3 b4 b5 b6 b7 b8 b9 ba bb bc bd be bf \
    c0 c1 c2 c3 c4 c5 c6 c7 c8 c9 ca cb cc cd ce cf \
    d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 da db dc dd de df \
    e0 e1 e2 e3 e4 e5 e6 e7 e8 e9 ea eb ec ed ee ef \
    f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 fa fb fc fd fe  
endif


# Commands:
# =========

#   the install command
INSTALL = cp

#   the copy command
CP = cp

#   converting from font source to ps font
SRCTOPS = ntu2ps $(PMC)

# Others:
# =======

# comment out the next line if you don't want to calculate the (probably) 
# correct %%VMusage field in the Type 1 PS fonts.
VM_MODIFY = YES

# ------------- user-defined ---------------


