unit tc_draw;

{$I options.inc}

interface

uses graph,mouse,tc_glob;

procedure get_text(obj_ptr:ptr_obj_type; var ende:boolean);
procedure draw;
procedure get_slope(dx,dy:real; var sxp,syp:integer;vector:boolean);

implementation

{$ifopt N+}
 type real=extended;
{$endif}

type angle_table=record
        x,y:integer;
        angle:real;
     end;


const line_angles:array[1..25]of angle_table=(
         (x:0; y:1; angle:90.0),
         (x:1; y:0; angle:0.0),
         (x:1; y:1; angle:45.0),
         (x:1; y:2; angle:63.434948822922010648),
         (x:1; y:3; angle:71.565051177077989351),
         (x:1; y:4; angle:75.963756532073521417),
         (x:1; y:5; angle:78.690067525979786913),
         (x:1; y:6; angle:80.537677791974382609),
         (x:2; y:1; angle:26.565051177077989351),
         (x:2; y:3; angle:56.309932474020213086),
         (x:2; y:5; angle:68.198590513648188229),
         (x:3; y:1; angle:18.434948822922010648),
         (x:3; y:2; angle:33.690067525979786913),
         (x:3; y:4; angle:53.130102354155978703),
         (x:3; y:5; angle:59.036243467926478582),
         (x:4; y:1; angle:14.036243467926478588),
         (x:4; y:3; angle:36.869897645844021297),
         (x:4; y:5; angle:51.340191745909909396),
         (x:5; y:1; angle:11.309932474020213086),
         (x:5; y:2; angle:21.801409486351811770),
         (x:5; y:3; angle:30.963756532073521417),
         (x:5; y:4; angle:38.659808254090090604),
         (x:5; y:6; angle:50.194428907734805993),
         (x:6; y:1; angle:9.4623222080256173906),
         (x:6; y:5; angle:39.805571092265194006));
      arrow_angles:array[1..13]of angle_table=(
         (x:0; y:1; angle:90.0),
         (x:1; y:0; angle:0.0),
         (x:1; y:1; angle:45.0),
         (x:1; y:2; angle:63.434948822922010648),
         (x:1; y:3; angle:71.565051177077989351),
         (x:1; y:4; angle:75.963756532073521417),
         (x:2; y:1; angle:26.565051177077989351),
         (x:2; y:3; angle:56.309932474020213086),
         (x:3; y:1; angle:18.434948822922010648),
         (x:3; y:2; angle:33.690067525979786913),
         (x:3; y:4; angle:53.130102354155978703),
         (x:4; y:1; angle:14.036243467926478588),
         (x:4; y:3; angle:36.869897645844021297));
      rad2deg=57.295779513082320877;

procedure get_text(obj_ptr:ptr_obj_type; var ende:boolean);
{GH}
var inh:string;
    buf:pointer;
    bufsize:word;
    wahl:integer;
begin
with obj_ptr^ do begin
   setviewport(0,0,max_x,65,clipon); bufsize:=imagesize(0,0,max_x,65);
   getmem(buf,bufsize); getimage(0,0,max_x,65,buf^);
   clearviewport; line(0,65,max_x,65);
   case art of
    txt   :outtextxy(0,0,'Text:');
    putaux:outtextxy(0,0,'Parameter fr das PUT-Kommando:');
    box   :outtextxy(0,0,'BoxText:');
   end;
   if inhalt=nil
   then inh:=''
   else inh:=inhalt^;
   get_str(12,inh,ende);
   if not ende
   then
    if inh=''
    then begin
       if art=txt
       then ende:=true;
       if inhalt<>nil
       then inhalt^:='';
    end else begin
      if inhalt=nil then new(inhalt); inhalt^:=inh;
      if art <> putaux
      then begin
       funk[0]:='HORIZONTAL ADJ.';
       funk[1]:='Left';
       funk[2]:='Right';
       funk[3]:='Center';
       case adjust[1] of
          'l':wahl:=1; 'r':wahl:=2; 'c':wahl:=3;
       end;
       menu(3,wahl);
       case wahl of
          0:ende:=true;
          1:adjust[1]:='l'; 2:adjust[1]:='r'; 3:adjust[1]:='c';
       end;
       if not ende then begin
          funk[0]:='VERTICAL. ADJ.';
          funk[1]:='Top';
          funk[2]:='Bottom';
          funk[3]:='Center';
          case adjust[2] of
             't':wahl:=1; 'b':wahl:=2; 'c':wahl:=3;
          end;
          menu(3,wahl);
          case wahl of
             0:ende:=true;
             1:adjust[2]:='t'; 2:adjust[2]:='b'; 3:adjust[2]:='c';
          end;
       end;
      end;
   end;
   setviewport(0,0,max_x,65,clipon);
   putimage(0,0,buf^,normalput); freemem(buf,bufsize);
   pict_port;
end;
end; {get_text}

procedure text_put(textmode:boolean);
{JW,GH}
var x,y:integer;
    text_ptr:ptr_obj_type;
    ende:boolean;
begin
   new(text_ptr); message('Reference-point:'); pict_port;
   with text_ptr^ do begin
      if textmode
       then art:=txt
       else art:=putaux;
      inhalt:=nil; adjust:='cc'; next:=nil; picked:=false;
      get_point(x,y,x_pos,y_pos,ende);
      if not ende then begin
         get_text(text_ptr,ende);
         if not ende then begin
            if textmode
             then draw_text(text_ptr)
             else draw_unknown_put(text_ptr);
            if root=nil
             then root:=text_ptr
             else cur_obj^.next:=text_ptr;
            cur_obj:=text_ptr;
         end else dispose(text_ptr);
      end else dispose(text_ptr);
   end; {with}
message('');
end; {text_put}

procedure box_put(dashed,filled:boolean);
{GH}
var box_ptr:ptr_obj_type;
    stop,ende:boolean;
    stat,x1,y1,w,h,dum1,dum2:integer;
    xd1,xd2,yd1,yd2:real;
begin
new(box_ptr); message('Lower left corner:'); pict_port;
with box_ptr^ do begin
   art:=box; inhalt:=nil; adjust:='cc'; w:=0; h:=0;
   dash:=dashed; solid:=filled; picked:=false; next:=nil;
   get_point(x1,y1,x_pos,y_pos,ende);
end;
if dashed then setlinestyle(dashedln,0,normwidth);
if not ende then with box_ptr^ do begin
   message('Upper right corner:'); pict_port;
   put_cursor; stop:=false; setwritemode(xorput);
   repeat
      stat:=mouse_stat(true);
      case stat of
      0: if (m_xpos<>curs_x) or (m_ypos<>curs_y) then begin
         put_cursor; rectangle(x1,y1,x1+w,y1-h);
         curs_x:=m_xpos; curs_y:=m_ypos;
         w:=curs_x-x1; if w<0 then w:=0;
         h:=y1-curs_y; if h<0 then h:=0;
         put_cursor; rectangle(x1,y1,x1+w,y1-h);
      end;
      -1,13: begin {linke Taste, ENTER}
         width:=wx-x_pos; height:=wy-y_pos;
         put_cursor; stop:=true;
      end;
      -2,27: begin {rechte Taste, ESC}
         put_cursor; ende:=true; stop:=true;
      end;
      ord('P'): toggle_snap;
      end;
   until stop;
end;
if dashed and (not ende) then begin
   msg_line:=msg_line+6;
   message('Dash-length,'); message('First point:');
   pict_port; get_point(dum1,dum2,xd1,yd1,ende);
   if not ende then begin
      message('Second point:'); pict_port; get_point(dum1,dum2,xd2,yd2,ende);
      box_ptr^.dash_dimen:=sqrt(sqr(xd1-xd2)+sqr(yd1-yd2));
   end;
end;
if (not ende) and (not filled) then begin
   get_text(box_ptr,ende); pict_port;
   if not ende then draw_box_text(box_ptr);
end;
if ende then with box_ptr^ do begin
   setwritemode(xorput); rectangle(x1,y1,x1+w,y1-h); dispose(box_ptr);
end else begin
   if filled then bar(x1,y1,x1+w,y1-h);
   if root=nil then root:=box_ptr else cur_obj^.next:=box_ptr;
   cur_obj:=box_ptr;
end;
if dashed then setlinestyle(solidln,0,normwidth);
setwritemode(normalput); message('');
end; {box_put}

procedure get_slope(dx,dy:real; var sxp,syp:integer;vector:boolean);
{JW,GH}
var d,d1,angle:real;
    i,s:integer;
begin
   if dx=0 then begin
      sxp:=0;
      if dy<0 then syp:=-1 else syp:=1;
   end else begin
      angle:=arctan(abs(dy)/abs(dx))*rad2deg;
      s:=0; d:=180;
      if vector then begin
         for i:=1 to 13 do begin
            d1:=abs(angle-arrow_angles[i].angle);
            if d1<d then begin
               s:=i; d:=d1;
            end;
         end;
         if dx<0 then sxp:=-arrow_angles[s].x
            else sxp:=arrow_angles[s].x;
         if dy<0 then syp:=-arrow_angles[s].y
            else syp:=arrow_angles[s].y;
      end else begin
         for i:=1 to 25 do begin
            d1:=abs(angle-line_angles[i].angle);
            if d1<d then begin
               s:=i; d:=d1;
            end;
         end;
         if dx<0 then sxp:=-line_angles[s].x
            else sxp:=line_angles[s].x;
         if dy<0 then syp:=-line_angles[s].y
            else syp:=line_angles[s].y;
      end;
   end;
end; {get_slope}

procedure line_put(vector:boolean);
{JW,GH}
var stat,x1,y1,x2,y2,x3,y3:integer;
    stop,ende:boolean;
    line_ptr:ptr_obj_type;

label redo;

begin
new(line_ptr); message('First point:'); pict_port;
with line_ptr^ do begin
   next:=nil; h_slope:=0; v_slope:=0; len:=0; picked:=false;
   if vector then begin
      art:=vec; em:=opt.steigung{false};
   end else begin
      art:=lin; em:=opt.steigung;
   end;
   get_point(x1,y1,x_pos,y_pos,ende); x2:=x1; y2:=y1; x3:=x1; y3:=y1;
end;
redo: if not ende then with line_ptr^ do begin
   message('Second point:'); pict_port;
   put_cursor; stop:=false; setwritemode(xorput);
   repeat
      stat:=mouse_stat(true);
      case stat of
      0: if (m_xpos<>curs_x) or (m_ypos<>curs_y) then begin
         put_cursor; curs_x:=m_xpos; curs_y:=m_ypos; put_cursor;
         if not em then begin
            get_slope(wx-x_pos,wy-y_pos,h_slope,v_slope,vector);
            if abs(h_slope)>=abs(v_slope) then begin
               x3:=curs_x; y3:=y1-round(v_mag*((wx-x_pos)*(v_slope/h_slope)));
            end else begin
               y3:=curs_y; x3:=x1+round(h_mag*((wy-y_pos)*(h_slope/v_slope)));
            end;
            if (x2<>x3) or (y2<>y3) then begin
               line(x1,y1,x2,y2); x2:=x3; y2:=y3;
               line(x1,y1,x2,y2);
            end;
         end else begin
            line(x1,y1,x2,y2); x2:=curs_x; y2:=curs_y;
            line(x1,y1,x2,y2);
         end;
      end;
      -1,13: begin {linke Taste, ENTER}
         put_cursor; stop:=true;
      end;
      -2,27: begin {rechte Taste, ESC}
         put_cursor; ende:=true; stop:=true;
      end;
      ord('P'): toggle_snap;
      end;
   until stop;
end;
if ende then begin
   line(x1,y1,x2,y2); dispose(line_ptr);
end else begin
   with line_ptr^ do begin
      {'width' und 'height' werden hier fr den Endpunkt missbraucht}
      if not em then begin
         if abs(h_slope)>=abs(v_slope) then begin
            width:=wx;
            if h_slope<>0 then
               height:=y_pos+(wx-x_pos)*(v_slope/h_slope)
            else height:=y_pos;
         end else begin
            height:=wy; width:=x_pos+(wy-y_pos)*(h_slope/v_slope);
         end;
      end else begin
         width:=wx; height:=wy;
      end;
      len:=abs(width-x_pos); if len=0 then len:=abs(height-y_pos);
      if vector then circle(x2,y2,3);
      if root=nil then root:=line_ptr else cur_obj^.next:=line_ptr;
      cur_obj:=line_ptr;
   end;
   new(line_ptr);
   with line_ptr^ do begin
      next:=nil; h_slope:=0; v_slope:=0; len:=0; picked:=false;
      if vector then begin
         art:=vec; em:=opt.steigung{false};
      end else begin
         art:=lin; em:=opt.steigung;
      end;
      x1:=x2; y1:=y2; x3:=x2; y3:=y2;
      x_pos:=cur_obj^.width; y_pos:=cur_obj^.height;
      message(''); goto redo;
   end;
end;
setwritemode(normalput);message('');
end; {line_put}

procedure circ_put(filled:boolean);
{GH}
var stat,x,y:integer;
    dx,dy,max_rad:real;
    circ_ptr:ptr_obj_type;
    stop,ende:boolean;
begin
if filled then max_rad:=2.6{mm} else max_rad:=7{mm};
new(circ_ptr); message('Center-point:'); pict_port;
with circ_ptr^ do begin
   rad:=0; fill:=filled; art:=circ; next:=nil; picked:=false;
   get_point(x,y,x_pos,y_pos,ende);
end;
work_obj:=circ_ptr;
if not ende then with work_obj^ do begin
   message('Radius:'); pict_port;
   put_cursor; stop:=false;
   repeat
      stat:=mouse_stat(true);
      case stat of
      0: if (m_xpos<>curs_x) or (m_ypos<>curs_y) then begin
         put_cursor; curs_x:=m_xpos; curs_y:=m_ypos;
         setcolor(0); circle(x,y,round(h_mag*rad));
         dx:=x_pos-wx; dy:=y_pos-wy; rad:=sqrt(sqr(dx)+sqr(dy));
         if filled and (rad>max_rad) then rad:=max_rad;
         setcolor(color); circle(x,y,round(h_mag*rad));
         put_cursor;
      end;
      -1,13: begin {linke Taste, ENTER}
         put_cursor; stop:=true;
      end;
      -2,27: begin {rechte Taste, ESC}
         put_cursor; ende:=true; stop:=true;
      end;
      ord('P'): toggle_snap;
      end;
   until stop;
end;
if ende then with work_obj^ do begin
   setcolor(0); circle(x,y,round(h_mag*rad));
   setcolor(color); dispose(work_obj);
end else begin
   if work_obj^.fill then with work_obj^ do
      fillellipse(x,y,round(h_mag*rad),round(v_mag*rad));
   if root=nil then root:=work_obj else cur_obj^.next:=work_obj;
   cur_obj:=work_obj;
end;
message('');
work_obj:=nil;
end; {circ_put}

procedure oval_put(entire:boolean);
{GH}
var oval_ptr:ptr_obj_type;
    wahl,stat,x,y:integer;
    stop,ende:boolean;
begin
new(oval_ptr); ende:=false;
with oval_ptr^ do begin
   part:='';
   if not entire then begin
      funk[0]:='WHICH TYPE OF OVAL'; wahl:=9;
      funk[1]:='Left Half';
      funk[2]:='Right Half';
      funk[3]:='Top Half';
      funk[4]:='Bottom Half';
      funk[5]:='Left  Top Quarter';
      funk[6]:='Right Top Quarter';
      funk[7]:='Left  Bottom Quarter';
      funk[8]:='Right Bottom Quarter';
      funk[9]:='Entire';
      menu(9,wahl);
      case wahl of
         0: begin
            dispose(oval_ptr); exit;
         end;
         1: part:='l';
         2: part:='r';
         3: part:='t';
         4: part:='b';
         5: part:='lt';
         6: part:='rt';
         7: part:='lb';
         8: part:='rb';
         9: part:='';
      end; {case}
   end;
end;
if not ende then with oval_ptr^ do begin
   message('Lower left corner:'); pict_port;
   width:=0; height:=0; next:=nil; art:=oval; picked:=false;
   get_point(x,y,lux,luy,ende); x_pos:=lux; y_pos:=luy;
end;
if not ende then with oval_ptr^ do begin
   message('Upper right corner:'); pict_port;
   put_cursor; stop:=false;
   work_obj:=oval_ptr;
   repeat
      stat:=mouse_stat(true);
      case stat of
      0: if (m_xpos<>curs_x) or (m_ypos<>curs_y) then begin
         put_cursor; curs_x:=m_xpos; curs_y:=m_ypos;
         setcolor(0); draw_oval(oval_ptr);
         if curs_x>x then width:=wx-lux else width:=0;
         if curs_y<y then height:=wy-luy else height:=0;
         setcolor(color); draw_oval(oval_ptr);
         put_cursor;
      end;
      -1,13: begin {linke Taste, ENTER}
         put_cursor; stop:=true;
      end;
      -2,27: begin {rechte Taste, ESC}
         put_cursor; ende:=true; stop:=true;
      end;
      ord('P'): toggle_snap;
      end;
   until stop;
   end;
if not ende then with oval_ptr^ do begin
   x_pos:=lux+width/2; y_pos:=luy+height/2;
   if root=nil then root:=oval_ptr else cur_obj^.next:=oval_ptr;
   cur_obj:=oval_ptr;
end else begin
   setcolor(0); draw_oval(oval_ptr); dispose(oval_ptr); setcolor(color);
end;
message('');
work_obj:=nil;
end; {oval_put}

procedure bezier_put(vector:boolean);
{JW,GH}
var bez_ptr:ptr_obj_type;
    x1,y1,x2,y2,x3,y3,mx,my,stat:integer;
    ende:boolean;
begin
  new(bez_ptr);
  message('First point:');pict_port;
  with bez_ptr^ do begin
    get_point(x1,y1,x_pos,y_pos,ende);
  end;
  if ende
  then dispose(bez_ptr)
  else begin
   setwritemode(xorput);
   while not ende do begin
    with bez_ptr^ do begin
     if vector
     then
      art:=bezvec
     else
      art:=bezier;
     next:=nil; picked:=false;
     putpixel(x1,y1,color);
     message('Second point:');
     pict_port;
     get_point(x2,y2,xx_pos,yy_pos,ende);
    end;
    work_obj:=bez_ptr;
    with work_obj^ do begin
     if ende then begin
        putpixel(x1,y1,0); dispose(work_obj);
     end else begin
        putpixel(x2,y2,color);
        mx:=(x1+x2) div 2;
        my:=(y1+y2) div 2;
        curs_x:=mx;
        curs_y:=my;
        message('Third point:'); pict_port; put_cursor;
        x3:=x2; y3:=y2; width:=wx; height:=wy;
        num:=4*round(pythagoras(x_pos-width,y_pos-height)+
                     pythagoras(width-xx_pos,height-yy_pos));
        repeat
             stat:=mouse_stat(true);
             case stat of
             0: if (m_xpos<>curs_x) or (m_ypos<>curs_y) then begin
                SetColor(0);
                put_cursor; draw_bezier(work_obj);
                curs_x:=m_xpos; curs_y:=m_ypos; put_cursor;
                x3:=curs_x; y3:=curs_y;
{   wx:=x0+m_xpos/h_mag; wy:=y0+(m_y-m_ypos)/v_mag;}
                width :=x0+(mx+(curs_x-mx)*2)/h_mag;
                height:=y0+(m_y-(my+(curs_y-my)*2))/v_mag;
                num:=4*round(pythagoras(x_pos-width,y_pos-height)+
                             pythagoras(width-xx_pos,height-yy_pos));
                SetColor(color);
                draw_bezier(work_obj);
                end;
             -1,13:
                put_cursor; {linke Taste, ENTER}
             -2,27: begin {rechte Taste, ESC}
                put_cursor; ende:=true;
             end;
             ord('P'): toggle_snap;
             end; {case}
          until ende or (stat=-1) or (stat=13);
          if ende {or ((x2=x3) and (y2=y3))} then begin
             putpixel(x1,y1,0);putpixel(x2,y2,0);
             SetColor(0);
             draw_bezier(work_obj);
             dispose(work_obj);
          end else begin
             if root=nil then root:=work_obj else cur_obj^.next:=work_obj;
             cur_obj:=work_obj;
             if not vector
             then begin
              work_obj:=nil;
              new(bez_ptr);
              x1:=x2;
              y1:=y2;
              bez_ptr^.x_pos:=cur_obj^.xx_pos;
              bez_ptr^.y_pos:=cur_obj^.yy_pos;
              message('');
             end
             else
              ende:=true;
          end;
       end; {else}
      end;{while}
    end; {else}
   end;
  SetColor(color);
  setwritemode(normalput);
  message('');
  work_obj:=nil;
end; {bezier_put}

procedure draw;
{JW,GH}
var ende:boolean;
    menu_wahl:integer;
begin
ende:=false; menu_wahl:=1;
while not ende do begin
   funk[0]:='DRAW';
   funk[1]:='Text';
   funk[2]:='Framebox';
   funk[3]:='Dashbox';
   funk[4]:='Filled Box';
   funk[5]:='Line';
   funk[6]:='Vector';
   funk[7]:='Circle';
   funk[8]:='Filled Circle';
   funk[9]:='Put';
   funk[10]:='Oval';
   funk[11]:='Bezier-Chain';
   funk[12]:='Bezier-Vector';
   menu(12,menu_wahl);
   if menu_wahl>0 then saved:=false;
   case menu_wahl of
      0: ende:=true;
      1: text_put(true);
      2: box_put(false,false);
      3: box_put(true,false);
      4: box_put(false,true);
      5: line_put(false);
      6: line_put(true);
      7: circ_put(false);
      8: circ_put(true);
      9: text_put(false);
      10:oval_put(false);
      11:bezier_put(false);
      12:bezier_put(true)
   end; {case}
end; {while}
end; {draw}

end. {unit tc_draw}
