// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: defs.h,v 1.22 91/02/22 15:58:55 hmgr Exp $

// Header file for a C++ TeX DVI filter.
// Strangely enough, this file should be device-INdependent.
// 
// by Parag Patel


// This program takes as input the DVI file generated by TeX or LaTeX
// and converts it to a device-specific format that is used to actually
// typeset (print) the document.  The device-specific info should be in
// the files "dev.h" and "dev.c".  The HP2686 LaserJet+ is currently
// supported, but others should be fairly easy to add, unless the code
// isn't as device-indenpendent as it was intended to be.
//
// The DVI file format is described in the book "TeX: The Program" by
// Donald E. Knuth (of course) pp. 234-243.  This program also uses the
// GF (Generic Font) format files to determine what to download to the
// device/printer. This format is described in the book
// "METAFONT: The Program" by Donald E. Knuth pp. 484-489.  Both these
// books should be used to determine exactly what the code is supposed
// to be doing.  The various number formats are also described in
// these books.


// some standard include files
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#ifndef __ZTC__
#   include <sys/param.h>
#   include <unistd.h>
#endif
#if !defined(BSD) && !defined(__ZTC__)
#   include <values.h>
#endif

#ifdef __ZTC__
    extern "C" int getopt(int, const char**, const char*);
#   define	NUMOPENFILES 7
#endif

#ifdef MSDOS
#   define	PATHSEP	';'
#   define	F_READ	"rb"
#endif
#ifndef PATHSEP
#    define	PATHSEP	':'
#endif

#ifndef	NUMOPENFILES
#   define	NUMOPENFILES 5
#endif
#ifndef MAXLONG
#   define MAXLONG 0x7FFFFFFFL
#endif
#ifndef MAXPATHLEN
#   define MAXPATHLEN 64
#endif
#ifndef SEEK_SET
#   define SEEK_SET 0
#   define SEEK_CUR 1
#   define SEEK_END 2
#endif
#ifndef _NFILE
#   define _NFILE 20
#endif
#ifndef F_READ
// for fopen(), because of POS-ICKS adding "rb" instead of "rt"
#   define	F_READ	"r"
#endif

// handy macros for large switch statements
#define Case break;case
#define Default break;default


// DVI-file specific id and tail filler bytes
const int ID = 2;
const int FILLER = 223;

// DVI file opcodes - thoroughly described in "TeX: The Program"
enum opcodes
{
	SET0 = 0,		// typeset range of characters
	SET127 = 127,

	SET1 = 128,		// typeset char and move cursor
	SET2 = 129,
	SET3 = 130,
	SET4 = 131,
	SETRULE = 132,		// typeset a rule & move cursor

	PUT1 = 133,		// just typeset a character
	PUT2 = 134,
	PUT3 = 135,
	PUT4 = 136,
	PUTRULE = 137,		// typeset rule

	NOOP = 138,

	BOP = 139,		// Beginning Of Page
	EOP = 140,		// End Of Page
	PUSH = 141,		// push internal DVI stack
	POP = 142,		// pop DVI stack

	RIGHT1 = 143,		// move cursor right/left
	RIGHT2 = 144,
	RIGHT3 = 145,
	RIGHT4 = 146,

	W0 = 147,		// move right/left using W DVI var
	W1 = 148,
	W2 = 149,
	W3 = 150,
	W4 = 151,

	X0 = 152,		// move right/left using X var
	X1 = 153,
	X2 = 154,
	X3 = 155,
	X4 = 156,

	DOWN1 = 157,		// move cursor down/up
	DOWN2 = 158,
	DOWN3 = 159,
	DOWN4 = 160,

	Y0 = 161,		// move down/up using Y var
	Y1 = 162,
	Y2 = 163,
	Y3 = 164,
	Y4 = 165,

	Z0 = 166,		// move down/up using Z var
	Z1 = 167,
	Z2 = 168,
	Z3 = 169,
	Z4 = 170,

	FONT0 = 171,		// use a new font - range version
	FONT63 = 234,

	FNT1 = 235,		// use a new font
	FNT2 = 236,
	FNT3 = 237,
	FNT4 = 238,

	XXX1 = 239,		// special - user defined
	XXX2 = 240,
	XXX3 = 241,
	XXX4 = 242,

	FNTDEF1 = 243,		// define a font
	FNTDEF2 = 244,
	FNTDEF3 = 245,
	FNTDEF4 = 246,

	PRE = 247,		// preamble
	POST = 248,		// start of postamble
	POSTPOST = 249,		// end of postamble
};


// this describes which pages exist in the DVI file
struct pageinfo
{
    long page;
    long section;
    long loc;
};

// this describes which pages (or page ranges) that we wish to print
struct pagespec
{
    long page, endpage;
    long section, endsection;
};


// other include files for this program
#include "boolean.h"
#include "bitvec.h"
#include "darray.h"
#include "dev.h"
#include "font.h"
#include "dirs.h"

// all other misc externs are here to keep 'em together
#include "extern.h"
