// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: extern.h,v 1.25 91/05/17 16:28:17 hmgr Exp $

// externs for various LaserJet+ DVI filter functions
//
// by Parag Patel

// misc. dynamic array types
declare_array(Pageinfo, pageinfo);
declare_array(Pagespec, pagespec);

class fontptr
{
public:
    font *ptr;
    fontptr() { ptr = NULL; }
    operator font*() { return ptr; }
    font *operator->() { return ptr; }
    font *operator=(font *p) { return ptr = p; }
};
declare_array(Fontlist, fontptr);

// globals.C
extern char *fontpath;
extern char *dviinput;
extern int debuglevel;
extern boolean verbose;
extern boolean dochecksum;
extern char *devname;
extern boolean reverse;
extern boolean landscape;
extern boolean duplexv;
extern boolean duplexh;
extern boolean duparg;
extern long usermag;
extern font *currfont;
extern Fontlist fontlist;
extern Bitvec **fontbits;
extern double H, V, W, X, Y, Z;
extern void init_globals();
extern void fini_globals();

// util.C
extern void debug(int, char *, ...);
extern void mesg(char *, ...);
extern void warn(char *, ...);
extern void error(char *, ...);
extern void quit(char *, ...);
extern long getuval(int, FILE *);
extern long getsval(int, FILE *);
extern void skipbytes(long num, FILE *fp);
extern FILE *fopenp(char *path, char *file, char *type);

// stack.C
extern void pushdvi();
extern void popdvi();
extern void cleardvi();

// fonts.C
extern void clearfonts();
extern void definefont(FILE*, long, long);
extern void newfont(long);
extern void makecurrent(boolean force = FALSE);
extern void special(FILE*, long);
extern void typeset(long, boolean, double);
extern void typerule(FILE*, boolean, double);

// dirs.C
extern Pathlist pathlist;
extern void setupdirs(char *path);

// readfont.C
extern void setupfont(font &);
extern void downchar(int ch, boolean toomany);
extern void dumpbits(int);

// gffont.C
extern void setupgffont(font &f, FILE *fp);
extern void getgfchar(font &f, fontchar &g, int);
extern char *gfmagdir(Dirlist &, long mag);

// pkfont.C
extern void setuppkfont(font &f, FILE *fp);
extern void getpkchar(font &f, fontchar &g, int);
extern char *pkmagdir(Dirlist &, long mag);

// dvi.C
extern void dodvi(FILE *, Pagespec&);


// convienient inlines - these would otherwise would have to go elsewhere

inline char *strnew(size_t len) { return (char*)malloc(len + 1); }
#if FREE_TAKES_CHAR
inline void  strfree(const char *s) { if (s != NULL) free((char *)s); }
#else
inline void  strfree(const char *s) { if (s != NULL) free((const void *)s); }
#endif
inline char *strdup(const char *s)
	{ return s != NULL ? strcpy((char*)malloc(strlen(s) + 1), s) : NULL; }
inline boolean streq(const char *s1, const char *s2)
	{ return (strcmp(s1, s2) == 0) ? TRUE: FALSE; }

inline double Getsval(int n, FILE *fp)
{
    return double(getsval(n, fp));
}

inline double Getuval(int n, FILE *fp)
{
    return double(getuval(n, fp));
}

inline void movedown(double m)
{
    V += m;
}

inline void moveright(double m)
{
    H += m;
}
