// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: font.h,v 1.13 91/02/22 15:59:11 hmgr Exp $

// describe fonts
//
// by Parag Patel


// X and Y are cartesian coordinates
// sp == scaled points == points * 2^16
// si == scaled integer == num * 2^16
// spx == scaled pixels == pixels * 2^16
// pix == pixels (whatever they are for a device)


// This is what a character in a METAFONT file should look like.
// 
class fontchar
{
public:
    boolean downloaded;		// is char currently in printer?
    boolean charbig;		// is char too big for printer?
    long dx;			// X spx displacement for typesetting
    long dy;			// Y spx delta
    double width;		// sp width to move after typesetting
    long minm;			// start X pix coord for char
    long maxm;			// end X   - these describe the box
    long minn;			// start Y - that this character should
    long maxn;			// end Y   - fit within
    long floc;			// file pointer to start of char data
};


// this describes a particular font that TeX wishes to use - it is
// information from the DVI file and the GF file
// 
class font
{
public:
    int type;			// GF or PK ID value
    long checksum;		// in both DVI and font files
    long scaledsize;		// scaled font size in sp
    long designsize;		// design size in sp (DVI & font)
    long mag;			// magnification calculated from above
    char *path;			// path name to font file
    char *basename;		// basename of above for messages
    boolean onpage;		// is font on the current page?
    boolean toomany;		// too many fonts on page - reload this one
    boolean downloaded;		// is font currently downloaded?
    boolean setup;		// is font setup in memory?
    long use;			// use count - least recently used 
    long num;			// number of this font
    long hppp;			// horizontal pixels per point (si)
    long vppp;			// vertical pixels per point
    long minm;			// smallest X in this font
    long maxm;			// largest X  - used to for gross char sizing
    long minn;			// smallest Y - when allocating memory for
    long maxn;			// largest Y  - building bitmap images
    FILE *fp;
    fontchar *chr;

    font();
    ~font();
};


// current GF ID byte and FILLER byte values
const int GFID		= 131;
const int GFILLER	= 223;

// opcodes in a GF file
// 
enum gfcodes
{
	PAINT0 = 0,		// range of paint commands
	PAINT63 = 63,

	PAINT1 = 64,		// paint a row of pixels
	PAINT2 = 65,
	PAINT3 = 66,

	BOC = 67,		// Beginning Of a Character description
	BOC1 = 68,
	EOC = 69,		// End Of Character

	SKIP0 = 70,		// vertical skip
	SKIP1 = 71,
	SKIP2 = 72,
	SKIP3 = 73,

	NEWROW0 = 74,		// another vertical skip (range)
	NEWROW164 = 238,

	FXXX1 = 239,		// special (user definable)
	FXXX2 = 240,
	FXXX3 = 241,
	FXXX4 = 242,

	YYY = 243,		// also special

	FNOOP = 244,		// noop!

	CHARLOC = 245,		// character locators
	CHARLOC0 = 246,

	FPRE = 247,		// preamble
	FPOST = 248,		// start of postamble
	FPOSTPOST = 249,	// end of postamble
};


// current PK identification byte value
const int PKID	= 89;

// PK font file opcodes & special values
enum pkcodes
{
	PKCHAR = 239,

	PKXXX1 = 240,
	PKXXX2 = 241,
	PKXXX3 = 242,
	PKXXX4 = 243,
	PKYYY = 244,
	PKPOST = 245,
	PKNOOP = 246,
	PKPRE = 247,

	PKREPEAT = 14,
	PKREPEAT1 = 15,
	PKRUNLARGE = 0,
	PKRUNBEGIN = 1,
	PKRUNEND = 13,
};
