#ifndef USEPXL
/* modified by Peter Damron 1987 University of Washington */
/*---------------------------------------------------------------------*/
/* $Header: gf.h,v 2.0 88/06/07 15:02:17 peterd Rel2 $ */
/*---------------------------------------------------------------------*/
/* This file contains routines for reading character descriptions from
   GF files (the output of Metafont).  The following functions are defined:
   gf_gettochar() finds the next character, returns its code (reduced modulo
		256 if necessary), and sets global variables gf_min_m, gf_max_m,
		gf_min_n, gf_max_n.  A result of -1 indicates that there are no
		more characters and the postamble has been found.
   gf_readbits() After a character is found, this routine fills array gf_bits[]
		with the character image.  The image is represented in
		Postscript format: the bits are packed into bytes
		(most significant bit first), and the bytes scan the image
		left-to-right, bottom-to-top.
		Set globals gf_num_cols, gf_num_rows, gf_x_offset, gf_y_offset
		(the latter give the offset of the origin from the upper
		bottom corner of the image, up being a positive gf_y_offset).
   gf_readpost() After the postamble is found, this routine reads it and
		sets the remaining global variables declared below.
   gf_seekpost() rapidly finds the postamble by random accessing the file.
   gf_seekchar(c) uses fseek() to find a character with code c (modulo 256),
		returning a nonzero result if successful.  Global variables
		are set as they are by gf_gettochar.  GF files may contain
		many characters with the same code, in which case subsequent
		calls to gf_seekchar(c) with the same c will find the other
		versions.  This routine should only be called after gf_readpost().
   No random access is attempted if gf_seekpost() and gf_seekchar() are not used.
*/
/*---------------------------------------------------------------------*/
/* forward declarations */

extern int  gf_gettochar();
extern void gf_readbits();
extern void gf_readpost();
extern void gf_seekpost();
extern int  gf_seekchar();

/* these should be supplied by the main routine */
extern void Fatal();
extern void Warning();

/*---------------------------------------------------------------------*/

#ifndef MAXCHARS
/* maximum characters per font file */
#define MAXCHARS	256
#endif MAXCHARS

#define int32 long

/*---------------------------------------------------------------------*/
/* these variables initialized by gf_gettochar() and gf_seekchar() */

extern int gf_min_m;		/* bounding box for character */
extern int gf_max_m;		/* bounding box for character */
extern int gf_min_n;		/* bounding box for character */
extern int gf_max_n;		/* bounding box for character */
extern int32 gf_charfam;	/* high order bytes of character code */

/*---------------------------------------------------------------------*/
/* these variables initialized by gf_readpost() */

extern int gf_font_min_m;		/* overall bounds */
extern int gf_font_max_m;		/* overall bounds */
extern int gf_font_min_n;		/* overall bounds */
extern int gf_font_max_n;		/* overall bounds */
extern int32 designsize;	/* font size in points scaled by 1<<20 */
extern int32 gf_checksum;	/* should match TFM file and DVI file */
extern int32 gf_hppp;		/* horizontal pixels/point scaled 1<<16 */
extern int32 gf_vppp;		/* vertical pixels/point scaled 1<<16 */

extern int gf_char_wd[MAXCHARS];	/* char width in pixels, rounded if necessary */
extern int32 gf_tfm_wd[MAXCHARS];	/* width as a fraction of designsize scaled 1<<20 */
extern char gf_char_exists[MAXCHARS];	/* nonzero indicates presence of a char_loc */
extern int gf_bc;	/* first and last nonzero gf_char_exists entries */
extern int gf_ec;	/* first and last nonzero gf_char_exists entries */

extern int32 gf_char_pointer[MAXCHARS];	/* used by gf_seekchar() */

/*---------------------------------------------------------------------*/

extern void bad_gf();	/* aborts the program if the gf file is invalid */ 
extern FILE *gf_infile;	/* change this externally if necessary */
extern char *gf_filename;	/* name of current gf file */

/*---------------------------------------------------------------------*/
/* these variables initialized by gf_readbits() */

#define BITBUFSIZE 20000

extern unsigned char gf_bits[BITBUFSIZE];	/* the char bitmap */
extern int gf_num_cols;				/* columns in bitmap */
extern int gf_num_rows;				/* rows in bitmap */
extern int gf_num_bytes;			/* bytes in bitmap */
extern int gf_x_offset;				/* char offset in bitmap */
extern int gf_y_offset;				/* char offset in bitmap */

extern int gf_rowbytes;				/* bytes/row in bitmap */

/*---------------------------------------------------------------------*/
#endif USEPXL

