/* @(#)defs.h	3.1	11/16/89 */

/**********************************************************************/
/************************  Global Definitions  ************************/
/**********************************************************************/
#define  PSTYPE		1
#define	 PKTYPE		2
#define  GFTYPE		3
#define  PXLTYPE	4

#define FIRST_DEF	-10000
#define FIRST_ODD	-9999
#define LAST_DEF	 10000

#define  READ             4  /* for access() */
				/* make resolution a switch option */
#define  DEFAULTRESOLUTION 300 /* can be changed with [-d integer] */
#define  DEFAULThconvRES 300 /* usually the same, but you can get */
#define  DEFAULTvconvRES 300 /* interesting effects if they are not */
			     /* should be yet another switch option (?) */

#define  MAXREFLECTIONS	8	/* Limit on reflections in a single line */
#define	 MAXPUSHES	100	/* Maximum number of pushes */
#define  STACKSIZE      (MAXREFLECTIONS+MAXPUSHES)
#define  NONEXISTENT     -1   /* offset for PXL files not found */
#define  NO_FILE        (FILE *)-1


#define  IVDFORMAT        3
#define  DVIFORMAT        2
#define  TRUE             1
#define  FALSE            0

#define EQ(a,b) (strcmp(a,b)==0)

                        /* output a formatted string */
#define EMIT      (void) fprintf
                        /* output a simple string */
#define EMITS(s)  fputs(s,outfp)
                        /* output an escaped octal number */
#define EMITO(c)  PutOct(c)
                        /* output a decimal integer */
#define EMITN(n)  PutInt(n)
                        /* output a byte value in Hex */
#define EMITH(h)  (void) putc(*(digit+((h>>4)&0xF)),outfp),\
                  (void) putc(*(digit+(h&0xF)),outfp)
                        /* output a single character */
#define EMITC(c)  (void) putc(c,outfp)
                        /* output a scaled X dimension */
#define EMITX(x)  PutInt(PixRound(x,hconv))
                        /* output a scaled Y dimension */
#define EMITY(y)  PutInt(PixRound(y,vconv))

#define NEW(A) ((A *) malloc(sizeof(A)))

#ifdef BUDGET
#define fontcost(p) 2372
#define charcost(ptr) (((ptr->width + 7) >> 3) * ptr->height+70)
#define BIGCHAR(ptr) (charcost(ptr)>budget/100)
#endif


#ifdef BUILTIN
#define  NONFONT        -1
#define  NONCHAR        -1
#define  DUMMYCHAR      0
#define MINPACKPSFONT   256     /* > MAXDVIFONT */
#define NPACKPSCHARS    256
#endif /* BUILTIN */
