/* -*-C-*- */
#include "texsgi.h"
#include "externs.h"
#include "proto.h"
char *getenv(char *s);

BYTE            bit_weight;  /* weight of current bit in next_byte */
BYTE            dyn_f;    /* dynamic packing flag */
UNSIGN16        repeat_count;  /* how many times to repeat next row */
BYTE            next_byte;  /* current input byte */
BYTE            word_weight;  /* weight of current bit in *pword */

/**********************************************************************/

int
  readpk()
{        /* return 0 on success, EOF on failure */
  UNSIGN32        checksum;
  long            end_of_packet;  /* pointer to byte following
				   * character packet */
  register BYTE   flag_byte;
  UNSIGN32        packet_length;
  long            start_of_packet;  /* pointer to start of
				     * character packet */
  register struct char_entry *tcharptr;  /* temporary char_entry
					  * pointer */
  register UNSIGN32 the_char;
  
  /*
   * read a PK file, extracting character metrics and raster locations.
   */
  
  /******************************************************************/
  
  /* Process the preamble parameters */
  
  (void) rewind(fontfp);  /* start at beginning of file */
  if ((BYTE) nosignex(fontfp, (BYTE) 1) != PKPRE) {
    (void) warning("readpk():  PK font file does not start with PRE byte");
    return (EOF);
  }
  if ((BYTE) nosignex(fontfp, (BYTE) 1) != PKID) {
    (void) warning(
		   "readpk():  PK font file PRE byte not followed by ID byte");
    return (EOF);
  }
  if (fseek(fontfp, (long) nosignex(fontfp, (BYTE) 1), 1)) {
    (void) warning("readpk():  PK font file has garbled comment string");
    return (EOF);  /* skip comment string */
  }
  fontptr->designsize = nosignex(fontfp, (BYTE) 4);
  
  checksum = nosignex(fontfp, (BYTE) 4);  /* checksum */
  if ((fontptr->c != 0L) && (checksum != 0L) && (fontptr->c != checksum)) {
    (void) sprintf(message,
		   "readpk():  font [%s] has checksum = 10#%010lu [16#%08lx] [8#%011lo] \
different from DVI checksum = 10#%010lu [16#%08lx] [8#%011lo].  \
TeX preloaded .fmt file is probably out-of-date with respect to new fonts.",
		   fontptr->name, fontptr->c, fontptr->c, fontptr->c,
		   checksum, checksum, checksum);
    (void) warning(message);
  }
  fontptr->hppp = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
  fontptr->vppp = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
  
  fontptr->min_m = 0L;  /* these are unused in PK format */
  fontptr->max_m = 0L;
  fontptr->min_n = 0L;
  fontptr->max_n = 0L;
  
  /* from GFtoPXL Section 53 */
  fontptr->magnification = (UNSIGN32) (0.5 + 5.0 * 72.27 *
				       (float) (fontptr->hppp) / 65536.0);
  
  /******************************************************************/
  /* Process the characters until the POST byte is reached */
  
  (void) skpkspec();  /* skip any PK specials */
  
  start_of_packet = (long) ftell(fontfp);
  while ((flag_byte = (BYTE) nosignex(fontfp, (BYTE) 1)) != PKPOST) {
    flag_byte &= 0x07;
    switch (flag_byte) {  /* flag_byte is in 0..7 */
    case 0:
    case 1:
    case 2:
    case 3:  /* short character preamble */
      packet_length = (UNSIGN32) flag_byte;
      packet_length <<= 8;
      packet_length += (UNSIGN32) nosignex(fontfp, (BYTE) 1);
      the_char = (UNSIGN32) nosignex(fontfp, (BYTE) 1);
      if (the_char >= NPXLCHARS) {
        (void) warning(
		       "readpk():  PK font file character number is too big for me");
        return (EOF);
      }
      tcharptr = &(fontptr->ch[the_char]);
      end_of_packet = (long) ftell(fontfp) + (long) packet_length;
      tcharptr->tfmw = (UNSIGN32) (((float) nosignex(fontfp, (BYTE) 3) *
				    (float) fontptr->s) / (float) (1L << 20));
      tcharptr->dx = (INT32) nosignex(fontfp, (BYTE) 1) << 16;
      tcharptr->dy = 0L;
      tcharptr->pxlw = (UNSIGN16) PIXROUND(tcharptr->dx, 1.0 / 65536.0);
      tcharptr->wp = (COORDINATE) nosignex(fontfp, (BYTE) 1);
      tcharptr->hp = (COORDINATE) nosignex(fontfp, (BYTE) 1);
      tcharptr->xoffp = (COORDINATE) signex(fontfp, (BYTE) 1);
      tcharptr->yoffp = (COORDINATE) signex(fontfp, (BYTE) 1);
      break;
      
    case 4:
    case 5:
    case 6:  /* extended short character preamble */
      packet_length = (UNSIGN32) (flag_byte & 0x03);
      packet_length <<= 16;
      packet_length += (UNSIGN32) nosignex(fontfp, (BYTE) 2);
      the_char = (UNSIGN32) nosignex(fontfp, (BYTE) 1);
      if (the_char >= NPXLCHARS) {
        (void) warning(
		       "readpk():  PK font file character number is too big for me");
        return (EOF);
      }
      tcharptr = &(fontptr->ch[the_char]);
      end_of_packet = (long) ftell(fontfp) + (long) packet_length;
      tcharptr->tfmw = (UNSIGN32) (((float) nosignex(fontfp, (BYTE) 3) *
				    (float) fontptr->s) / (float) (1L << 20));
      tcharptr->dx = (INT32) nosignex(fontfp, (BYTE) 2) << 16;
      tcharptr->dy = 0L;
      tcharptr->pxlw = (UNSIGN16) PIXROUND(tcharptr->dx, 1.0 / 65536.0);
      tcharptr->wp = (COORDINATE) nosignex(fontfp, (BYTE) 2);
      tcharptr->hp = (COORDINATE) nosignex(fontfp, (BYTE) 2);
      tcharptr->xoffp = (COORDINATE) signex(fontfp, (BYTE) 2);
      tcharptr->yoffp = (COORDINATE) signex(fontfp, (BYTE) 2);
      break;
      
    case 7:  /* long character preamble */
      packet_length = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
      the_char = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
      if (the_char >= NPXLCHARS) {
        (void) warning(
		       "readpk():  PK font file character number is too big for me");
        return (EOF);
      }
      tcharptr = &(fontptr->ch[the_char]);
      end_of_packet = (long) ftell(fontfp) + (long) packet_length;
      tcharptr->tfmw = (UNSIGN32) (((float) nosignex(fontfp, (BYTE) 4) *
				    (float) fontptr->s) / (float) (1L << 20));
      tcharptr->dx = (INT32) signex(fontfp, (BYTE) 4);
      tcharptr->dy = (INT32) signex(fontfp, (BYTE) 4);
      tcharptr->pxlw = (UNSIGN16) PIXROUND(tcharptr->dx, 1.0 / 65536.0);
      tcharptr->wp = (COORDINATE) nosignex(fontfp, (BYTE) 4);
      tcharptr->hp = (COORDINATE) nosignex(fontfp, (BYTE) 4);
      tcharptr->xoffp = (COORDINATE) signex(fontfp, (BYTE) 4);
      tcharptr->yoffp = (COORDINATE) signex(fontfp, (BYTE) 4);
      break;
    }    /* end switch */
    tcharptr->fontrp = start_of_packet;
    (void) fseek(fontfp, end_of_packet, 0);  /* position to end of
					      * packet */
    (void) skpkspec();  /* skip any PK specials */
    start_of_packet = (long) ftell(fontfp);
  }      /* end while */
  
  (void) newfont();
  
  return (0);
}

void
  skpkspec()
{        /* Skip PK font file specials */
  BYTE            the_byte;
  
  the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  while ((the_byte >= (BYTE) PKXXX1) && (the_byte != PKPOST)) {
    switch (the_byte) {
    case PKXXX1:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 1), 1);
      break;
      
    case PKXXX2:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 2), 1);
      break;
      
    case PKXXX3:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 3), 1);
      break;
      
    case PKXXX4:
      (void) fseek(fontfp, (long) nosignex(fontfp, (BYTE) 4), 1);
      break;
      
    case PKYYY:
      (void) nosignex(fontfp, (BYTE) 4);
      break;
      
    case PKNOOP:
      break;
      
    default:
      (void) sprintf(message, "skpkspec():  Bad PK font file [%s]",
		     fontptr->name);
      (void) fatal(message);
    }
    the_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
  }
  (void) ungetc((char) the_byte, fontfp);  /* put back lookahead byte */
}

int
  charpk(c, outfcn)    /* return 0 on success, and EOF on failure */
BYTE            c;  /* current character value */
void            (*outfcn) ();  /* (possibly NULL) function to output
				* current row */
{
  INT16           count;  /* how many bits of current color left */
  UNSIGN16        c_width;/* character width in dots */
  UNSIGN16        c_height;  /* character height in dots */
  COORDINATE      ox, oy;    /* reference pixel position */
  BOOLEAN         do_output;  /* FALSE if outfcn is NULL */
  register BYTE   flag_byte;  /* current file flag byte */
  UNSIGN16        h_bit;  /* horizontal position in row */
  register UNSIGN16 i;  /* loop index */
  register UNSIGN16 k;  /* loop index */
  long            offset;  /* offset into font file */
  long            p;  /* pointer into font file */
  UNSIGN32        packet_length;  /* packet length */
  UNSIGN32       *pword;  /* pointer into img_row[] */
  INT16           rows_left;  /* how many rows left */
  struct char_entry *tcharptr;  /* temporary char_entry pointer */
  BYTE            turn_on;/* initial black/white flag */
  
  /*******************************************************************
    This function is called to process a single character description in
    the  PK  font  file.   The   character  packet  is  pointed  to   by
    fontptr->ch[c].fontrp, and was set by readpk(), which moved past any
    special commands that precede the packet.
    
    The PK  raster description  is encoded  in a  complex form,  but  is
    guaranteed to step across raster rows  from left to right, and  down
    from the  top  row  to  bottom  row,  such  that  in  references  to
    image[n][m], m never decreases in a row, and n never increases in  a
    character.  This means that we  only require enough memory space  to
    hold one row, provided that outfcn(c,yoff) is called each time a row
    is   completed.    This   is   an  important   economization    for
    high-resolution output  devices --  e.g. a  10pt character  at  2400
    dots/inch would require about  8Kb for the  entire image, but  fewer
    than 25 bytes for a  single row.  A 72pt  character (such as in  the
    aminch font) would need  about 430Kb for the  image, but only  about
    200 bytes for a row.
    
    The code  follows  PKtoPX  quite closely,  particular  the  latter's
    sections 37-43  for  preamble  processing, and  sections  44-51  for
    raster decoding.
    
    Access to bit m in the current row is controlled through the  macros
    SETBIT(m) and  TESTBIT(m) so  we  need not  be concerned  about  the
    details of bit masking.  Too bad C does not have a bit data type!
    
    The row image is recorded in such a way that bits min_m .. max_m are
    mapped onto  bits  0  ..  (max_m -  min_m)  in  img_row[],  so  that
    outfcn(c,yoff) should be relieved of any shifting operations.
    
    outfcn(c,yoff) is NEVER called if either of hp or wp is <= 0, or  if
    it is NULL.
    *******************************************************************/
  
  if ((c < FIRSTPXLCHAR) || (LASTPXLCHAR < c)) {
    (void) warning(
		   "charpk():  Character value out of range for PK font file");
    return (EOF);
  }
  tcharptr = &(fontptr->ch[c]);
  
  if (!VISIBLE(tcharptr))
    return (0);  /* empty character raster -- nothing to
		  * output */
  
  c_width = (UNSIGN16) tcharptr->wp;  /* local copies of these to
				       * save */
  c_height = (UNSIGN16) tcharptr->hp;  /* pointer dereferencing in
					* loops */
  ox = (COORDINATE) tcharptr->xoffp;
  oy = (COORDINATE) tcharptr->yoffp;

  p = (long) tcharptr->fontrp;  /* font file raster pointer */
  if (p < 0L) {
    (void) warning(
		   "charpk():  Requested character not found in PK font file");
    return (EOF);
  }
  if (fseek(fontfp, p, 0)) {
    (void) warning(
		   "charpk():  fseek() failure for PK font file character raster");
    return (EOF);
  }
  /*
   * Since readpk() has already done error checking on the file, and
   * recorded the character metrics, we need not repeat that work, and
   * concentrate instead on getting to the encoded raster description
   * which follows the character packet.
   */
  
  img_words = (UNSIGN16) (c_width + 31) >> 5;
  flag_byte = (BYTE) nosignex(fontfp, (BYTE) 1);  /* get packet flag byte */
  dyn_f = flag_byte >> 4;  /* dyn_f is high 4 bits from flag_byte */
  turn_on = (BYTE) (flag_byte & 0x08);  /* turn_on is 8-bit from
					 * flag_byte */
  flag_byte &= 0x07;  /* final flag_byte is low 3 bits */
  do_output = (BOOLEAN) (outfcn != (void (*) ()) NULL);
  
  switch (flag_byte) {  /* flag_byte is in 0..7 */
  case 0:
  case 1:
  case 2:
  case 3:    /* short character preamble */
    packet_length = (UNSIGN32) flag_byte;
    packet_length <<= 8;
    packet_length += (UNSIGN32) nosignex(fontfp, (BYTE) 1);
    packet_length -= 8L;
    offset = 9L;
    break;
    
  case 4:
  case 5:
  case 6:    /* extended short character preamble */
    packet_length = (UNSIGN32) (flag_byte & 0x03);
    packet_length <<= 16;
    packet_length += (UNSIGN32) nosignex(fontfp, (BYTE) 2);
    packet_length -= 13L;
    offset = 14L;
    break;
    
  case 7:    /* long character preamble */
    packet_length = (UNSIGN32) nosignex(fontfp, (BYTE) 4);
    packet_length -= 28L;
    offset = 32L;
    break;
    
  }      /* end switch */
  
  if (fseek(fontfp, offset, 1)) {  /* position to start of raster data */
    (void) warning(
		   "charpk():  fseek() failure for PK font file character raster");
    return (EOF);
  }
  bit_weight = 0;
  clrparr(parray, c_height, c_width);
  
  if (dyn_f == (BYTE) 14) {  /* <PKtoPX: Get raster by bits> 
			      * uncompressed character image */
    /*
     * MG's version -- no need for bit-twiddling
     */

    for (i = 0; i < c_height; ++i) {
      for (k = 0; k < c_width; ++k) {
        if (get_bit())
	  SETPKBIT(i, k);
      }  /* end for (k) */
    }    /* end for (i) */
  } else {    /* <PKtoPX: Create normally packed raster> 
	       * run-length encoded character image */
    /*
     * MG's version -- no need for bit-twiddling
     */
    int curr_x, curr_y, remainder, j;

    rows_left = (INT16) c_height;
    repeat_count = curr_x = curr_y = remainder = 0;

    while (rows_left > 0) {
      if (remainder > 0) {
	count = remainder;
	remainder = 0;
      } else {
	turn_on = (BYTE) (!turn_on);
	count = (INT16) pk_packed_num();
/*	fprintf(stderr,"w: %d, h: %d, count: %d, repeat: %d\n",
		c_width, c_height, count, repeat_count); */
      }
      if (curr_x + count > c_width) {
	remainder = curr_x + count - c_width;
	count = c_width - curr_x;
      }
      while (count-- > 0) {
	if (!turn_on) {
	  SETPKBIT(curr_y, curr_x);
/*	  putchar('*'); */
	} else {
/*	  putchar(' '); */
	}
	curr_x++;
      }
      if (curr_x >= c_width) {
	rows_left--;
/*	putchar('\n');*/
	curr_y++;
	curr_x = 0;
	for (i=0;i < repeat_count;i++) {
	  for (j=0;j < c_width;j++) {
	    int prev_y;

	    prev_y = curr_y - 1;
	    PKBIT(curr_y, j) = PKBIT(prev_y, j);
	  }
	  curr_y++;
	  rows_left--;
	}
	repeat_count = 0;
      }
    }
  }      /* end if (run-length encoded image) */
  
  return (0);
}

BYTE  get_bit()
{        /* return 0, or non-zero (not necessarily 1) */
  register BYTE   temp;
  
  bit_weight >>= 1;
  if (bit_weight == 0) {  /* then must get new byte from font file */
    next_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
    bit_weight = (BYTE) 128;
  }
  temp = next_byte & bit_weight;
  next_byte &= ~bit_weight;  /* clear the just-read bit */
  
  return (temp);
}

BYTE  get_nybble()
{
  register BYTE   temp;
  
  if (bit_weight == 0) {  /* get high nybble */
    next_byte = (BYTE) nosignex(fontfp, (BYTE) 1);
    temp = next_byte >> 4;
    next_byte &= 0x0f;
    bit_weight = (BYTE) 1;
  } else {    /* get low nybble */
    temp = next_byte;  /* this has only 4 bits in it */
    bit_weight = (BYTE) 0;
  }
  return (temp);
}

UNSIGN16
  pk_packed_num()
{        /* return a (non-negative) packed number from
	  * the font file this function is recursive to one level only */
  INT16           i, j;
  
  i = (INT16) get_nybble();
  if (i == 0) {
    do {
      j = (INT16) get_nybble();
      ++i;
    } while (j == 0);
    while (i > 0) {
      j <<= 4;
      j += (INT16) get_nybble();
      --i;
    }
    return ((UNSIGN16) (j - 15 + ((13 - dyn_f) << 4) + dyn_f));
  } else if (i <= (INT16) dyn_f)
    return ((UNSIGN16) i);
  else if (i < 14)
    return ((UNSIGN16) (((i - dyn_f - 1) << 4) + get_nybble() + dyn_f + 1));
  else if (i == 14) {
    repeat_count = pk_packed_num();
    return (pk_packed_num());
  } else {
    repeat_count = 1;
    return (pk_packed_num());
  }
}

