/*
 * dviOps.h --
 *
 *	DVI machine opcodes and definitions.
 *
 * Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>
 * See file COPYING for conditions on use and distribution.
 *
 * $Id: dviOps.h,v 1.2 2000/02/15 10:21:14 lingnau Exp $
 */
 
#if !DVIOPS_H

enum {
	D_ID = 2,		/* Format ID byte */
	D_PAD =	223,		/* Padding at end of DVI file */

	D_SETCHAR0 = 0,		/* Typeset character numbers 0 ... 127 */
	D_SET1     = 128,	/* Typeset character */
	D_SET2	   = 129,
	D_SET3	   = 130,
	D_SET4     = 131,
	D_SETRULE  = 132,	/* Typeset rule */
	D_PUT1	   = 133,	/* Typeset character, don't move */
	D_PUT2	   = 134,
	D_PUT3	   = 135,
	D_PUT4	   = 136,
	D_PUTRULE  = 137,	/* Typeset rule, don't move */
	D_NOP	   = 138,	/* No operation */
	D_BOP	   = 139,	/* Beginning of page */
	D_EOP	   = 140,	/* End of page */
	D_PUSH	   = 141,	/* Push current position, movements and font */
	D_POP	   = 142,	/* Pop current position, movements and font */
	D_RIGHT1   = 143,	/* Move sideways */
	D_RIGHT2   = 144,
	D_RIGHT3   = 145,
	D_RIGHT4   = 146,
	D_W0	   = 147,	/* Move sideways by content of W register */
	D_W1	   = 148,	/* Move sideways and set W register */
	D_W2	   = 149,
	D_W3	   = 150,
	D_W4	   = 151,
	D_X0	   = 152,	/* Move sideways by content of X register */
	D_X1	   = 153,	/* Move sideways and set X register */
	D_X2	   = 154,
	D_X3	   = 155,
	D_X4	   = 156,
	D_DOWN1	   = 157,	/* Move vertically */
	D_DOWN2	   = 158,
	D_DOWN3	   = 159,
	D_DOWN4	   = 160,
	D_Y0	   = 161,	/* Move vertically by content of Y register */
	D_Y1	   = 162,	/* Move vertically and set Y register */
	D_Y2	   = 163,
	D_Y3	   = 164,
	D_Y4	   = 165,
	D_Z0	   = 166,	/* Move vertically by content of Z register */
	D_Z1	   = 167,	/* Move vertically and set Z register */
	D_Z2	   = 168,
	D_Z3	   = 169,
	D_Z4	   = 170,
	D_FNTNUM0  = 171,	/* Set current font to one of 0 ... 64 */
	D_FNT1	   = 235,	/* Set current font to argument */
	D_FNT2	   = 236,
	D_FNT3	   = 237,
	D_FNT4	   = 238,
	D_XXX1	   = 239,	/* Special command */
	D_XXX2	   = 240,
	D_XXX3	   = 241,
	D_XXX4	   = 242,
	D_FNTDEF1  = 243,	/* Define font */
	D_FNTDEF2  = 244,
	D_FNTDEF3  = 245,
	D_FNTDEF4  = 246,
	D_PRE	   = 247,	/* Start of preamble */
	D_POST	   = 248,	/* Start of postamble */
	D_POSTPOST = 249	/* End of postamble */
};

#define DVIOPS_H 1
#endif
